/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmFactory;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Feature;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.Metamodel;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.Operation;
import org.eclipse.m2m.atl.emftvm.OutputRuleElement;
import org.eclipse.m2m.atl.emftvm.Parameter;
import org.eclipse.m2m.atl.emftvm.Rule;
import org.eclipse.m2m.atl.emftvm.RuleElement;
import org.eclipse.m2m.atl.emftvm.trace.TraceFactory;
import org.eclipse.m2m.atl.emftvm.trace.TracePackage;
import org.eclipse.m2m.atl.emftvm.util.DuplicateEntryException;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.FieldContainer;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.Matcher;
import org.eclipse.m2m.atl.emftvm.util.ModuleNotFoundException;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolver;
import org.eclipse.m2m.atl.emftvm.util.NativeCodeBlock;
import org.eclipse.m2m.atl.emftvm.util.NativeTypes;
import org.eclipse.m2m.atl.emftvm.util.OCLOperations;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.TimingData;
import org.eclipse.m2m.atl.emftvm.util.TypeHashMap;
import org.eclipse.m2m.atl.emftvm.util.TypeMap;
import org.eclipse.m2m.atl.emftvm.util.VMException;
import org.eclipse.m2m.atl.emftvm.util.VMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecEnvImpl
extends EObjectImpl
implements ExecEnv {
    public static final String[] EXEC_ENV_TYPE = new String[]{"EMFTVM", "ExecEnv"};
    public static final String[] TRACE_LINK_SET_TYPE = new String[]{"TRACE", "TraceLinkSet"};
    protected Map<String, Metamodel> metaModels;
    protected Map<String, Model> inputModels;
    protected Map<String, Model> inoutModels;
    protected Map<String, Model> outputModels;
    protected Map<String, Module> modules;
    protected EList<Operation> mainChain = new BasicEList();
    protected final FieldContainer fieldContainer = new FieldContainer();
    protected final Map<String, Map<Integer, TypeMap<Object, Object>>> operations = new HashMap<String, Map<Integer, TypeMap<Object, Object>>>();
    protected final Map<String, Map<Integer, TypeMap<Object, Object>>> staticOperations = new HashMap<String, Map<Integer, TypeMap<Object, Object>>>();
    protected Map<String, Rule> rules = new LinkedHashMap<String, Rule>();
    protected Map<Resource, Model> modelOf = new HashMap<Resource, Model>();
    protected Map<Resource, Model> inputModelOf = new HashMap<Resource, Model>();
    protected Map<Resource, Model> inoutModelOf = new HashMap<Resource, Model>();
    protected Map<Resource, Model> outputModelOf = new HashMap<Resource, Model>();
    protected Map<Model, String> modelId = new HashMap<Model, String>();
    protected boolean modelCacheInit;
    protected VMMonitor monitor;
    protected final Queue<DeletionEntry> deletionQueue = new LinkedList<DeletionEntry>();

    protected ExecEnvImpl() {
        Map<String, Metamodel> mms = this.getMetaModels();
        mms.put("ecore".toUpperCase(), EMFTVMUtil.getEcoreMetamodel());
        mms.put("emftvm".toUpperCase(), EMFTVMUtil.getEmfTvmMetamodel());
        mms.put("trace".toUpperCase(), EMFTVMUtil.getTraceMetamodel());
        this.createField("matches", true, EXEC_ENV_TYPE, TRACE_LINK_SET_TYPE, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Map<String, Model> oms = frame.getEnv().getOutputModels();
                if (oms.containsKey("match")) {
                    frame.push(oms.get("match").newElement(TracePackage.eINSTANCE.getTraceLinkSet()));
                } else {
                    frame.push(TraceFactory.eINSTANCE.createTraceLinkSet());
                }
                return frame;
            }
        });
        this.createField("traces", true, EXEC_ENV_TYPE, TRACE_LINK_SET_TYPE, new NativeCodeBlock(){

            public StackFrame execute(StackFrame frame) {
                Map<String, Model> oms = frame.getEnv().getOutputModels();
                if (oms.containsKey("trace")) {
                    frame.push(oms.get("trace").newElement(TracePackage.eINSTANCE.getTraceLinkSet()));
                } else {
                    frame.push(TraceFactory.eINSTANCE.createTraceLinkSet());
                }
                return frame;
            }
        });
        final Module oclModule = OCLOperations.getInstance().getOclModule();
        this.loadModule(new ModuleResolver(){

            public Module resolveModule(String name) throws ModuleNotFoundException {
                return oclModule;
            }
        }, oclModule.getName());
    }

    private void createField(String name, boolean isStatic, String[] context, String[] type, CodeBlock initialiser) {
        Field f = EmftvmFactory.eINSTANCE.createField();
        f.setName(name);
        f.setContextModel(context[0]);
        f.setContext(context[1]);
        f.setTypeModel(type[0]);
        f.setType(type[1]);
        f.setInitialiser(initialiser);
        f.setStatic(isStatic);
        this.registerFeature(f);
    }

    protected EClass eStaticClass() {
        return EmftvmPackage.Literals.EXEC_ENV;
    }

    @Override
    public Map<String, Module> getModules() {
        if (this.modules == null) {
            this.modules = Collections.synchronizedMap(new LinkedHashMap());
        }
        return this.modules;
    }

    @Override
    public VMMonitor getMonitor() {
        return this.monitor;
    }

    @Override
    public Map<String, Metamodel> getMetaModels() {
        if (this.metaModels == null) {
            this.metaModels = Collections.synchronizedMap(new HashMap());
        }
        return this.metaModels;
    }

    @Override
    public Map<String, Model> getInputModels() {
        if (this.inputModels == null) {
            this.inputModels = Collections.synchronizedMap(new HashMap());
        }
        return this.inputModels;
    }

    @Override
    public Map<String, Model> getInoutModels() {
        if (this.inoutModels == null) {
            this.inoutModels = Collections.synchronizedMap(new HashMap());
        }
        return this.inoutModels;
    }

    @Override
    public Map<String, Model> getOutputModels() {
        if (this.outputModels == null) {
            this.outputModels = Collections.synchronizedMap(new HashMap());
        }
        return this.outputModels;
    }

    @Override
    public synchronized Module loadModule(ModuleResolver resolver, String name) {
        try {
            Map<String, Module> modules = this.getModules();
            if (modules.containsKey(name)) {
                return modules.get(name);
            }
            Module module = resolver.resolveModule(name);
            if (module.eResource() != null) {
                Model mmodel = EmftvmFactory.eINSTANCE.createModel();
                mmodel.setResource(module.eResource());
                IValidator validator = ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);
                IStatus results = validator.validate(mmodel.allInstancesOf(EmftvmPackage.eINSTANCE.getCodeBlock()));
                if (!results.isOK()) {
                    throw new CoreException(results);
                }
            }
            modules.put(name, module);
            this.resolveImports(module, resolver);
            for (Feature f : module.getFeatures()) {
                this.registerFeature(f);
            }
            for (Rule r : module.getRules()) {
                this.registerRule(r);
            }
            for (Rule r : module.getRules()) {
                this.resolveSuperRules(r);
            }
            return module;
        }
        catch (Exception e) {
            throw new VMException(null, String.format("Error during module loading: %s", e.getMessage()), e);
        }
    }

    private void resolveImports(Module module, ModuleResolver resolver) {
        EList<Module> eImports = module.getEImports();
        for (String imp : module.getImports()) {
            Module impModule = this.getModules().get(imp);
            if (impModule == null) {
                impModule = this.loadModule(resolver, imp);
            }
            eImports.add((Object)impModule);
        }
    }

    @Override
    public synchronized void registerFeature(Feature feature) {
        feature.setEContext(this.findEClassifier(feature.getContextModel(), feature.getContext()));
        feature.setEType(this.findEClassifier(feature.getTypeModel(), feature.getType()));
        switch (feature.eClass().getClassifierID()) {
            case 6: {
                this.fieldContainer.registerField((Field)feature);
                break;
            }
            case 7: {
                this.registerOperation((Operation)feature);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Feature of class %s not supported", feature.eClass()));
            }
        }
    }

    private void registerOperation(Operation op) {
        if (op.isStatic()) {
            if ("main".equals(op.getName()) && op.getParameters().isEmpty()) {
                this.mainChain.add((Object)op);
            } else {
                this.registerOperationIn(op, this.staticOperations);
            }
        } else {
            this.registerOperationIn(op, this.operations);
        }
    }

    private void registerOperationIn(Operation op, Map<String, Map<Integer, TypeMap<Object, Object>>> reg) {
        EList<Parameter> args = op.getParameters();
        Integer argCount = args.size();
        String opname = op.getName();
        Map<Integer, TypeMap<Object, Object>> argcountOpsMap = reg.get(opname);
        if (argcountOpsMap == null) {
            argcountOpsMap = new HashMap<Integer, TypeMap<Object, Object>>();
            reg.put(opname, argcountOpsMap);
        }
        EClassifier ectx = op.getEContext();
        assert (ectx != null);
        Object ctx = EMFTVMUtil.getRegistryType(ectx);
        TypeMap<Object, Object> ctxMap = argcountOpsMap.get(argCount);
        if (ctxMap == null) {
            ctxMap = new TypeHashMap<Object, Object>();
            argcountOpsMap.put(argCount, ctxMap);
        }
        if (argCount == 0) {
            ctxMap.put(ctx, op);
        } else {
            TypeHashMap<Object, Object> opsMap = (TypeHashMap<Object, Object>)ctxMap.get(ctx);
            if (opsMap == null) {
                opsMap = new TypeHashMap<Object, Object>();
                ctxMap.put(ctx, opsMap);
            }
            ExecEnvImpl.registerOperationByArgTypes(op, opsMap, this.getTypesOfParameters(op.getParameters()), 0);
        }
    }

    private Object[] getTypesOfParameters(EList<Parameter> eList) {
        Object[] types = new Object[eList.size()];
        int i = 0;
        while (i < types.length) {
            Parameter par = (Parameter)eList.get(i);
            par.setEType(this.findEClassifier(par.getTypeModel(), par.getType()));
            types[i] = EMFTVMUtil.getRegistryType(par.getEType());
            ++i;
        }
        return types;
    }

    private static void registerOperationByArgTypes(Operation op, TypeMap<Object, Object> reg, Object[] argTypes, int argIndex) {
        int argCount = argTypes.length;
        assert (argIndex >= 0 && argIndex < argCount);
        Object regType = argTypes[argIndex];
        if (argIndex < argCount - 1) {
            TypeHashMap<Object, Object> nestedReg = (TypeHashMap<Object, Object>)reg.get(regType);
            if (nestedReg == null) {
                nestedReg = new TypeHashMap<Object, Object>();
                reg.put(regType, nestedReg);
            }
            ExecEnvImpl.registerOperationByArgTypes(op, nestedReg, argTypes, argIndex + 1);
        } else {
            reg.put(regType, op);
        }
    }

    private static boolean isMoreSpecific(EList<Parameter> first, EList<Parameter> second, int index) {
        Class sCls;
        assert (first.size() == second.size());
        EClassifier f = ((Parameter)first.get(index)).getEType();
        EClassifier s = ((Parameter)second.get(index)).getEType();
        assert (f != null);
        assert (s != null);
        if (f == s && index < first.size() - 1) {
            return ExecEnvImpl.isMoreSpecific(first, second, index + 1);
        }
        if (f instanceof EClass && s instanceof EClass) {
            return ((EClass)s).isSuperTypeOf((EClass)f);
        }
        assert (f instanceof EClass || f.getInstanceClass() != null);
        assert (s instanceof EClass || s.getInstanceClass() != null);
        Class fCls = f.getInstanceClass() == null ? EObject.class : f.getInstanceClass();
        Class clazz = sCls = s.getInstanceClass() == null ? EObject.class : s.getInstanceClass();
        assert (fCls != null);
        assert (sCls != null);
        if (fCls == sCls && index < first.size() - 1) {
            return ExecEnvImpl.isMoreSpecific(first, second, index + 1);
        }
        return sCls.isAssignableFrom(fCls);
    }

    private static boolean isMoreSpecific(Operation first, Operation second) {
        Class sCls;
        EClassifier f = first.getEContext();
        EClassifier s = second.getEContext();
        assert (f != null);
        assert (s != null);
        if (f == s) {
            return ExecEnvImpl.isMoreSpecific(first.getParameters(), second.getParameters(), 0);
        }
        if (f instanceof EClass && s instanceof EClass) {
            return ((EClass)s).isSuperTypeOf((EClass)f);
        }
        assert (f instanceof EClass || f.getInstanceClass() != null);
        assert (s instanceof EClass || s.getInstanceClass() != null);
        Class fCls = f.getInstanceClass() == null ? EObject.class : f.getInstanceClass();
        Class clazz = sCls = s.getInstanceClass() == null ? EObject.class : s.getInstanceClass();
        assert (fCls != null);
        assert (sCls != null);
        if (fCls == sCls) {
            return ExecEnvImpl.isMoreSpecific(first.getParameters(), second.getParameters(), 0);
        }
        return sCls.isAssignableFrom(fCls);
    }

    @Override
    public synchronized void registerRule(Rule r) {
        this.rules.put(r.getName(), r);
        LinkedHashMap<String, Model> inModels = new LinkedHashMap<String, Model>(this.getInputModels());
        inModels.putAll(this.getInoutModels());
        for (RuleElement re : r.getInputElements()) {
            this.resolveRuleElement(re, inModels);
        }
        LinkedHashMap<String, Model> outModels = new LinkedHashMap<String, Model>(this.getOutputModels());
        outModels.putAll(this.getInoutModels());
        for (OutputRuleElement re : r.getOutputElements()) {
            this.resolveRuleElement(re, outModels);
        }
        for (Field field : r.getFields()) {
            field.setEContext(this.findEClassifier(field.getContextModel(), field.getContext()));
            field.setEType(this.findEClassifier(field.getTypeModel(), field.getType()));
            r.registerField(field);
        }
    }

    private void resolveRuleElement(RuleElement re, Map<String, Model> models) {
        re.setEType(this.findEClassifier(re.getTypeModel(), re.getType()));
        EList<Model> eModels = re.getEModels();
        eModels.clear();
        for (String modelName : re.getModels()) {
            Model model = models.get(modelName);
            if (model == null) {
                throw new IllegalArgumentException(String.format("Model %s not found", modelName));
            }
            eModels.add((Object)model);
        }
    }

    private void resolveSuperRules(Rule rule) {
        EList<Rule> eSuperRules = rule.getESuperRules();
        eSuperRules.clear();
        for (String superRuleName : rule.getSuperRules()) {
            Rule superRule = this.findRule(superRuleName);
            if (!this.moduleIsImported(superRule.getModule(), rule.getModule())) {
                throw new IllegalArgumentException(String.format("Super-rule %s of %s is not contained in any module imported by %s", superRuleName, rule.getName(), rule.getModule()));
            }
            eSuperRules.add((Object)superRule);
        }
    }

    private boolean moduleIsImported(Module imported, Module module) {
        if (module == imported) {
            return true;
        }
        for (Module eImport : module.getEImports()) {
            if (!this.moduleIsImported(imported, eImport)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Operation findOperation(Object context, String name, Object[] parameterTypes) {
        int argCount;
        TypeMap<Object, Object> ctxMap;
        Operation op = null;
        Map<Integer, TypeMap<Object, Object>> argcountOpsMap = this.operations.get(name);
        if (argcountOpsMap != null && (ctxMap = argcountOpsMap.get(argCount = parameterTypes.length)) != null) {
            if (argCount == 0) {
                Object ctxKey;
                op = (Operation)ctxMap.get(context);
                if (op == null && (ctxKey = ctxMap.findKey(context)) != null) {
                    op = (Operation)ctxMap.get(ctxKey);
                    assert (op != null);
                    ctxMap.put(context, op);
                }
            } else {
                TypeMap<Object, Object> argMap = (TypeHashMap<Object, Object>)ctxMap.get(context);
                if (argMap != null) {
                    op = ExecEnvImpl.findOperationDirect(argMap, parameterTypes, 0);
                }
                if (op == null) {
                    HashSet<Object> ctxKeys = new HashSet<Object>();
                    ctxMap.findAllKeys(context, ctxKeys);
                    LinkedHashSet<Operation> ops = new LinkedHashSet<Operation>();
                    for (Object e : ctxKeys) {
                        argMap = (TypeMap)ctxMap.get(e);
                        ExecEnvImpl.findOperations(argMap, parameterTypes, ops, 0);
                    }
                    op = ExecEnvImpl.findMostSpecificOperation(ops);
                    if (op != null) {
                        argMap = (TypeMap)ctxMap.get(context);
                        if (argMap == null) {
                            argMap = new TypeHashMap<Object, Object>();
                            ctxMap.put(context, argMap);
                        }
                        ExecEnvImpl.registerOperationByArgTypes(op, argMap, parameterTypes, 0);
                    }
                }
            }
        }
        return op;
    }

    @Override
    public Operation findStaticOperation(Object context, String name, Object[] parameterTypes) {
        int argCount;
        TypeMap<Object, Object> ctxMap;
        Operation op = null;
        Map<Integer, TypeMap<Object, Object>> argcountOpsMap = this.staticOperations.get(name);
        if (argcountOpsMap != null && (ctxMap = argcountOpsMap.get(argCount = parameterTypes.length)) != null) {
            if (argCount == 0) {
                op = (Operation)ctxMap.get(context);
            } else {
                TypeMap argMap = (TypeMap)ctxMap.get(context);
                if (argMap != null && (op = ExecEnvImpl.findOperationDirect(argMap, parameterTypes, 0)) == null) {
                    LinkedHashSet<Operation> ops = new LinkedHashSet<Operation>();
                    ExecEnvImpl.findOperations(argMap, parameterTypes, ops, 0);
                    op = ExecEnvImpl.findMostSpecificOperation(ops);
                    if (op != null) {
                        ExecEnvImpl.registerOperationByArgTypes(op, argMap, parameterTypes, 0);
                    }
                }
            }
        }
        return op;
    }

    private static Operation findOperationDirect(TypeMap<Object, Object> typeMap, Object[] parameterTypes, int argIndex) {
        int argCount = parameterTypes.length;
        assert (argIndex >= 0 && argIndex < argCount);
        Object argType = parameterTypes[argIndex];
        if (argIndex < argCount - 1) {
            TypeMap nestedTypeMap = (TypeMap)typeMap.get(argType);
            if (nestedTypeMap != null) {
                return ExecEnvImpl.findOperationDirect(nestedTypeMap, parameterTypes, argIndex + 1);
            }
            return null;
        }
        return (Operation)typeMap.get(argType);
    }

    private static void findOperations(TypeMap<Object, Object> typeMap, Object[] parameterTypes, Set<Operation> ops, int argIndex) {
        int argCount = parameterTypes.length;
        assert (argIndex >= 0 && argIndex < argCount);
        Object argType = parameterTypes[argIndex];
        HashSet<Object> argTypeKeys = new HashSet<Object>();
        typeMap.findAllKeys(argType, argTypeKeys);
        if (argIndex < argCount - 1) {
            for (Object e : argTypeKeys) {
                TypeMap nestedTypeMap = (TypeMap)typeMap.get(e);
                ExecEnvImpl.findOperations(nestedTypeMap, parameterTypes, ops, argIndex + 1);
            }
        } else {
            for (Object e : argTypeKeys) {
                ops.add((Operation)typeMap.get(e));
            }
        }
    }

    private static Operation findMostSpecificOperation(Collection<Operation> ops) {
        Operation msOp = null;
        HashSet<Operation> conflicts = new HashSet<Operation>();
        for (Operation op : ops) {
            if (msOp == null || ExecEnvImpl.isMoreSpecific(op, msOp)) {
                msOp = op;
                continue;
            }
            if (ExecEnvImpl.isMoreSpecific(msOp, op)) continue;
            conflicts.add(op);
        }
        assert (msOp != null || ops.isEmpty() && conflicts.isEmpty());
        for (Operation op : conflicts) {
            if (ExecEnvImpl.isMoreSpecific(msOp, op)) continue;
            throw new DuplicateEntryException(String.format("More than one operation found for given context/arguments: %s and %s", msOp, op));
        }
        return msOp;
    }

    @Override
    public Field findField(Object context, String name) {
        return this.fieldContainer.findField(context, name);
    }

    @Override
    public Field findStaticField(Object context, String name) {
        return this.fieldContainer.findStaticField(context, name);
    }

    @Override
    public Rule findRule(String name) {
        return this.rules.get(name);
    }

    @Override
    public Object findType(String modelName, String typeName) throws ClassNotFoundException {
        if ("#native".equals(modelName)) {
            return NativeTypes.findType(typeName);
        }
        Metamodel mm = this.getMetaModels().get(modelName);
        if (mm == null) {
            throw new IllegalArgumentException(String.format("Metamodel %s not found", modelName));
        }
        return mm.findType(typeName);
    }

    private EClassifier findEClassifier(String modelName, String typeName) {
        try {
            Object type = this.findType(modelName, typeName);
            if (type instanceof Class) {
                EDataType dt = EcoreFactory.eINSTANCE.createEDataType();
                dt.setName(typeName);
                dt.setInstanceClass((Class)type);
                return dt;
            }
            return (EClassifier)type;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public synchronized Object run(TimingData timingData, VMMonitor monitor) {
        this.monitor = monitor;
        Object result = null;
        try {
            try {
                assert (this.deletionQueue.isEmpty());
                this.clearModelCaches();
                Iterator mains = this.mainChain.iterator();
                if (!mains.hasNext()) {
                    throw new UnsupportedOperationException(String.format("Operation %s not found", "main"));
                }
                StackFrame rootFrame = new StackFrame(this, ((Operation)this.mainChain.get(this.mainChain.size() - 1)).getBody());
                Matcher.matchAll(rootFrame, timingData);
                while (mains.hasNext()) {
                    CodeBlock cb = ((Operation)mains.next()).getBody();
                    StackFrame rFrame = cb.execute(new StackFrame(this, cb));
                    if (rFrame.stackEmpty()) continue;
                    result = rFrame.pop();
                }
                this.deleteQueue();
                if (monitor != null) {
                    monitor.terminated();
                }
            }
            catch (VMException e) {
                if (monitor != null) {
                    monitor.error(e.getFrame(), e.getLocalizedMessage(), e);
                    monitor.terminated();
                }
                throw e;
            }
        }
        finally {
            this.monitor = null;
        }
        return result;
    }

    protected synchronized void cacheModels() {
        this.cacheModels(this.getInputModels(), this.inputModelOf);
        this.cacheModels(this.getOutputModels(), this.outputModelOf);
        this.cacheModels(this.getInoutModels(), this.inoutModelOf);
        this.cacheModels(this.getMetaModels(), null);
        this.modelCacheInit = true;
    }

    protected synchronized void clearModelCaches() {
        this.modelOf.clear();
        this.inputModelOf.clear();
        this.inoutModelOf.clear();
        this.outputModelOf.clear();
        this.modelId.clear();
        this.modelCacheInit = false;
    }

    private void cacheModels(Map<String, ? extends Model> models, Map<Resource, Model> thisModelOf) {
        for (Map.Entry<String, ? extends Model> entry : models.entrySet()) {
            String id = entry.getKey();
            Model model = entry.getValue();
            this.modelOf.put(model.getResource(), model);
            if (thisModelOf != null) {
                thisModelOf.put(model.getResource(), model);
            }
            this.modelId.put(model, id);
        }
    }

    @Override
    public LazyList<Rule> getRules() {
        return new LazyList<Rule>(this.rules.values());
    }

    @Override
    public Model getModelOf(EObject object) {
        Resource r;
        if (!this.modelCacheInit) {
            this.cacheModels();
        }
        return (r = object.eResource()) == null ? null : this.modelOf.get(r);
    }

    @Override
    public String getModelID(Model model) {
        if (!this.modelCacheInit) {
            this.cacheModels();
        }
        return model == null ? null : this.modelId.get(model);
    }

    @Override
    public void queueForDelete(EObject element, StackFrame frame) {
        this.deletionQueue.offer(new DeletionEntry(element, frame));
    }

    @Override
    public void deleteQueue() {
        while (!this.deletionQueue.isEmpty()) {
            this.deletionQueue.poll().delete();
        }
    }

    @Override
    public Model getInputModelOf(EObject object) {
        Resource r;
        if (!this.modelCacheInit) {
            this.cacheModels();
        }
        return (r = object.eResource()) == null ? null : this.inputModelOf.get(r);
    }

    @Override
    public Model getInoutModelOf(EObject object) {
        Resource r;
        if (!this.modelCacheInit) {
            this.cacheModels();
        }
        return (r = object.eResource()) == null ? null : this.inoutModelOf.get(r);
    }

    @Override
    public Model getOutputModelOf(EObject object) {
        Resource r;
        if (!this.modelCacheInit) {
            this.cacheModels();
        }
        return (r = object.eResource()) == null ? null : this.outputModelOf.get(r);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getMetaModels();
            }
            case 1: {
                return this.getInputModels();
            }
            case 2: {
                return this.getInoutModels();
            }
            case 3: {
                return this.getOutputModels();
            }
            case 4: {
                return this.getModules();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.metaModels != null;
            }
            case 1: {
                return this.inputModels != null;
            }
            case 2: {
                return this.inoutModels != null;
            }
            case 3: {
                return this.outputModels != null;
            }
            case 4: {
                return this.modules != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (metaModels: ");
        result.append(this.metaModels);
        result.append(", inputModels: ");
        result.append(this.inputModels);
        result.append(", inoutModels: ");
        result.append(this.inoutModels);
        result.append(", outputModels: ");
        result.append(this.outputModels);
        result.append(", modules: ");
        result.append(this.modules);
        result.append(')');
        return result.toString();
    }

    final class DeletionEntry {
        protected EObject element;
        protected StackFrame frame;

        public DeletionEntry(EObject element, StackFrame frame) {
            this.element = element;
            this.frame = frame;
        }

        public void delete() {
            assert (ExecEnvImpl.this.getInputModelOf(this.element) == null);
            Model m = ExecEnvImpl.this.getModelOf(this.element);
            try {
                m.deleteElement(this.element);
            }
            catch (Exception e) {
                throw new VMException(this.frame, String.format("Error while deleting element %s from %s: %s", EMFTVMUtil.toPrettyString(this.element, (ExecEnv)ExecEnvImpl.this), ExecEnvImpl.this.getModelID(m), e.getLocalizedMessage()), e);
            }
        }
    }
}

