/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.BooleanType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Feature;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.IntegerType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclAnyType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Operation;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.RealType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.StringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelElementType
extends OclAnyType {
    public ModelElementType(OclType oclType) {
        super(oclType);
    }

    @Override
    public List<Operation> getTypeOperations() {
        ArrayList<Operation> elementOperations = new ArrayList<Operation>();
        if (this.oclType.getClassifier() != null && this.oclType.getClassifier() instanceof EClass) {
            for (EOperation eOperation : ((EClass)this.oclType.getClassifier()).getEAllOperations()) {
                elementOperations.add(new Operation(eOperation, this.oclType.getMetamodelName()));
            }
        }
        return elementOperations;
    }

    public boolean isAbstract() {
        if (this.oclType.getClassifier() != null && this.oclType.getClassifier() instanceof EClass) {
            return ((EClass)this.oclType.getClassifier()).isAbstract();
        }
        return false;
    }

    @Override
    public List<Feature> getFeatures() {
        ArrayList<Feature> features = new ArrayList<Feature>();
        if (this.oclType.getClassifier() != null && this.oclType.getClassifier() instanceof EClass) {
            for (EStructuralFeature eFeature : ((EClass)this.oclType.getClassifier()).getEAllStructuralFeatures()) {
                features.add(new Feature(null, eFeature, this.oclType.getMetamodelName()));
            }
        }
        Collections.sort(features);
        return features;
    }

    @Override
    public OclAnyType[] getSupertypes() {
        ArrayList<OclAnyType> res = new ArrayList<OclAnyType>();
        res.add(OclAnyType.getInstance());
        if (this.oclType.getClassifier() instanceof EClass) {
            EList supertypes = ((EClass)this.oclType.getClassifier()).getESuperTypes();
            for (EClass supertype : supertypes) {
                OclAnyType atlSupertype = ModelElementType.create((EClassifier)supertype, this.oclType.getMetamodelName());
                if (atlSupertype == null) continue;
                res.add(atlSupertype);
            }
        }
        return res.toArray(new OclAnyType[res.size()]);
    }

    public static OclAnyType create(EClassifier classifier, String metamodelName) {
        if (classifier != null) {
            if (classifier instanceof EEnum) {
                return new ModelElementType(new OclType(metamodelName, classifier));
            }
            if (classifier instanceof EDataType) {
                return ModelElementType.create((EDataType)classifier);
            }
            return new ModelElementType(new OclType(metamodelName, classifier));
        }
        return OclAnyType.getInstance();
    }

    private static OclAnyType create(EDataType dataType) {
        if (dataType.getInstanceClass() != null) {
            if (dataType.getInstanceClass().equals(String.class)) {
                return StringType.getInstance();
            }
            if (dataType.getInstanceClass().equals(Integer.TYPE) || dataType.getInstanceClass().equals(Integer.class)) {
                return IntegerType.getInstance();
            }
            if (dataType.getInstanceClass().equals(Boolean.TYPE) || dataType.getInstanceClass().equals(Boolean.class)) {
                return BooleanType.getInstance();
            }
            if (dataType.getInstanceClass().equals(Double.TYPE) || dataType.getInstanceClass().equals(Double.class) || dataType.getInstanceClass().equals(Float.class)) {
                return RealType.getInstance();
            }
        } else {
            if (dataType.getName().equals("String")) {
                return StringType.getInstance();
            }
            if (dataType.getName().equals("Boolean")) {
                return BooleanType.getInstance();
            }
            if (dataType.getName().equals("Integer")) {
                return IntegerType.getInstance();
            }
            if (dataType.getName().equals("Float") || dataType.getName().equals("Real") || dataType.getName().equals("Double")) {
                return RealType.getInstance();
            }
        }
        return OclAnyType.getInstance();
    }

    public String getInformation() {
        StringBuffer information = new StringBuffer();
        if (this.isAbstract()) {
            information.append("abstract ");
        }
        information.append("class ");
        information.append(this.getOclType().getClassifier().getName());
        boolean first = true;
        int i = 0;
        while (i < this.getSupertypes().length) {
            OclAnyType st = this.getSupertypes()[i];
            if (!OclAnyType.getInstance().equals(st)) {
                if (first) {
                    information.append(" extends\n\t");
                    first = false;
                } else {
                    information.append(",\n\t");
                }
                information.append(st);
            }
            ++i;
        }
        return information.toString();
    }
}

