/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm;

import java.io.PrintWriter;
import java.util.Iterator;
import org.eclipse.m2m.atl.engine.vm.ASM;
import org.eclipse.m2m.atl.engine.vm.ASMField;
import org.eclipse.m2m.atl.engine.vm.ASMInstruction;
import org.eclipse.m2m.atl.engine.vm.ASMInstructionWithOperand;
import org.eclipse.m2m.atl.engine.vm.ASMOperation;
import org.eclipse.m2m.atl.engine.vm.ASMParameter;
import org.eclipse.m2m.atl.engine.vm.ASMWriter;

public class ASMXMLWriter
extends ASMWriter {
    private PrintWriter out;
    private boolean debug;
    private boolean dummy;

    public ASMXMLWriter(PrintWriter out, boolean debug) {
        this.out = out;
        this.debug = debug;
    }

    public void print(ASM asm) {
        this.dummy = true;
        this.printASM(asm);
        this.dummy = false;
        this.printASM(asm);
    }

    private void printASM(ASM asm) {
        String name = asm.getName();
        this.println("<?xml version = '1.0' encoding = 'ISO-8859-1' ?>");
        this.println("<asm name=\"" + this.getCPIndex(name) + "\">", "<!-- " + name + " -->");
        this.println("\t<cp>");
        int k = 0;
        Iterator i = this.getConstantPool().iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            s = s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("\n", "&#10;").replaceAll("\r", "&#13;").replaceAll("\t", "&#9;");
            this.println("\t\t<constant value=\"" + s + "\"/>", "<!-- " + k++ + " -->");
        }
        this.println("\t</cp>");
        i = asm.getFields().iterator();
        while (i.hasNext()) {
            this.printField((ASMField)i.next());
        }
        i = asm.getOperations().iterator();
        while (i.hasNext()) {
            this.printOperation((ASMOperation)i.next());
        }
        this.println("</asm>");
    }

    private void println(String s, String d) {
        if (!this.dummy) {
            if (this.debug) {
                String tabs = "";
                switch ((64 - s.replaceAll("\t", "        ").length() - 1) / 8) {
                    case 8: {
                        tabs = String.valueOf(tabs) + "\t";
                    }
                    case 7: {
                        tabs = String.valueOf(tabs) + "\t";
                    }
                    case 6: {
                        tabs = String.valueOf(tabs) + "\t";
                    }
                    case 5: {
                        tabs = String.valueOf(tabs) + "\t";
                    }
                    case 4: {
                        tabs = String.valueOf(tabs) + "\t";
                    }
                    case 3: {
                        tabs = String.valueOf(tabs) + "\t";
                    }
                    case 2: {
                        tabs = String.valueOf(tabs) + "\t";
                    }
                    case 1: {
                        tabs = String.valueOf(tabs) + "\t";
                    }
                }
                this.out.println(String.valueOf(s) + tabs + d);
            } else {
                this.out.println(s);
            }
        }
    }

    private void println(String s) {
        if (!this.dummy) {
            this.out.println(s);
        }
    }

    private void printField(ASMField f) {
        String name = f.getName();
        String type = f.getType();
        this.println("\t<field name=\"" + this.getCPIndex(name) + "\" type=\"" + this.getCPIndex(type) + "\"/>", "<!-- " + name + " : " + type + " -->");
    }

    private void printOperation(ASMOperation op) {
        String name = op.getName();
        String context = op.getContextSignature();
        this.println("\t<operation name=\"" + this.getCPIndex(name) + "\">", "<!-- " + name + " -->");
        this.println("\t\t<context type=\"" + this.getCPIndex(context) + "\"/>", "<!-- " + context + " -->");
        this.println("\t\t<parameters>");
        Iterator i = op.getParameters().iterator();
        while (i.hasNext()) {
            this.printParameter((ASMParameter)i.next());
        }
        this.println("\t\t</parameters>");
        this.println("\t\t<code>");
        i = op.getInstructions().iterator();
        while (i.hasNext()) {
            this.printInstruction((ASMInstruction)i.next());
        }
        this.println("\t\t</code>");
        this.println("\t\t<linenumbertable>");
        i = op.getLineNumberTable().iterator();
        while (i.hasNext()) {
            this.printLineNumberEntry((ASMOperation.LineNumberEntry)i.next());
        }
        this.println("\t\t</linenumbertable>");
        this.println("\t\t<localvariabletable>");
        i = op.getLocalVariableTable().iterator();
        while (i.hasNext()) {
            this.printLocalVariableEntry((ASMOperation.LocalVariableEntry)i.next());
        }
        this.println("\t\t</localvariabletable>");
        this.println("\t</operation>");
    }

    private void printParameter(ASMParameter param) {
        String name = param.getName();
        String type = param.getType();
        this.println("\t\t\t<parameter name=\"" + this.getCPIndex(name) + "\" type=\"" + this.getCPIndex(type) + "\"/>", "<!-- " + name + " : " + type + " -->");
    }

    private void printInstruction(ASMInstruction instr) {
        if (instr instanceof ASMInstructionWithOperand) {
            String mn = instr.getMnemonic();
            String operand = ((ASMInstructionWithOperand)instr).getOperand();
            this.println("\t\t\t<" + mn + " arg=\"" + this.getCPIndex(operand) + "\"/>", "<!-- " + operand + " -->");
        } else {
            this.println("\t\t\t<" + instr.getMnemonic() + "/>");
        }
    }

    private void printLineNumberEntry(ASMOperation.LineNumberEntry lne) {
        this.println("\t\t\t<lne id=\"" + this.getCPIndex(lne.id) + "\" begin=\"" + lne.begin + "\" end=\"" + lne.end + "\"/>", "<!-- " + lne.id + " -->");
    }

    private void printLocalVariableEntry(ASMOperation.LocalVariableEntry lve) {
        this.println("\t\t\t<lve slot=\"" + lve.slot + "\" name=\"" + this.getCPIndex(lve.name) + "\" begin=\"" + lve.begin + "\" end=\"" + lve.end + "\"/>", "<!-- " + lve.name + " -->");
    }
}

