/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.editor.Messages;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionDataSource;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionHelper;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionProposal;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionProposalComparator;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlEditorUI;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlInstalledTemplateProposal;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlModelAnalyser;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlParameterListValidator;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlTemplateProposal;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.AtlTypesProcessor;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Feature;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.ModelElementType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.ModuleType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclAnyType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.Operation;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlCompletionProcessor
extends TemplateCompletionProcessor
implements IContentAssistProcessor,
ICompletionListener {
    private static final String[] PREFIX_TEMPLATES_NAMES = new String[]{"using", "do", "collect", "select", "reject", "iterate", "let", "exists", "forAll", "isUnique", "any", "one", "sortedBy", "if", "for"};
    private static final HashMap<String, String[]> PREFIX_KEYWORDS_NAMES = new HashMap<String, String[]>(){
        {
            this.put("rule_context", new String[]{"true", "false", "not", "and", "or", "xor", "implies", "from", "to", "mapsTo", "distinct", "foreach", "in", "do", "if", "then", "else", "endif", "let", "for", "div", "refining", "entrypoint", "endpoint", "extends", "unique", "lazy", "super"});
            this.put("helper_context", new String[]{"def", "context", "using", "distinct", "foreach", "do", "if", "then", "else", "endif", "let", "in", "for"});
            this.put("query_context", new String[]{"let", "in", "do", "for", "if", "then", "else", "endif"});
            this.put("module_context", new String[]{"rule", "helper", "query", "library", "create", "from", "uses"});
            this.put("atl_context", new String[0]);
            this.put("library_context", new String[0]);
            this.put("", new String[0]);
        }
    };
    private static final String URI_TAG_REGEX = "^\\p{Space}*--\\p{Space}*@nsURI.*";
    private static final String PATH_TAG_REGEX = "^\\p{Space}*--\\p{Space}*@path.*";
    private static final String COMPILER_TAG_REGEX = "^\\p{Space}*--\\p{Space}*@atlcompiler.*";
    private AtlCompletionProposalComparator fComparator;
    private AtlParameterListValidator fValidator;
    private AtlEditor fEditor;
    private char[] fProposalAutoActivationSet = new char[]{' '};
    private IATLCompletionRecorder recorder;
    private AtlTypesProcessor typeProcessor;
    private ITextViewer viewer;
    private IDocument document;
    private AtlSourceManager manager;
    private String atlContext;
    private int proposalMode = 0;
    private static final int DEFAULT_PROPOSALS = 0;
    private static final int TEMPLATE_PROPOSALS = 1;
    private static final int GLOBAL_PROPOSALS = 2;
    protected IContentAssistantExtension2 fContentAssistant;

    public AtlCompletionProcessor(IEditorPart editor) {
        this.fEditor = (AtlEditor)editor;
        this.fComparator = new AtlCompletionProposalComparator();
        this.typeProcessor = new AtlTypesProcessor();
    }

    public AtlSourceManager getSourceManager() {
        if (this.manager == null && this.fEditor != null) {
            this.manager = this.fEditor.getSourceManager();
        }
        return this.manager;
    }

    public void setRecorder(IATLCompletionRecorder recorder) {
        this.recorder = recorder;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer refViewer, int documentOffset) {
        try {
            ITextSelection selection = (ITextSelection)refViewer.getSelectionProvider().getSelection();
            int offset = selection.getOffset() + selection.getLength();
            if (this.proposalMode == 0) {
                this.fContentAssistant.setStatusMessage("Default proposals");
                this.fContentAssistant.setEmptyMessage("No default proposals");
            } else if (this.proposalMode == 2) {
                this.fContentAssistant.setStatusMessage("Global proposals");
                this.fContentAssistant.setEmptyMessage("No global proposals");
            } else if (this.proposalMode == 1) {
                this.fContentAssistant.setStatusMessage("Template proposals");
                this.fContentAssistant.setEmptyMessage("No template proposals");
            }
            ICompletionProposal[] iCompletionProposalArray = this.computeCompletionProposals(refViewer, refViewer.getDocument(), offset);
            return iCompletionProposalArray;
        }
        catch (BadLocationException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        finally {
            this.proposalMode = (this.proposalMode + 1) % 3;
        }
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, IDocument document, int offset) throws BadLocationException {
        this.viewer = viewer;
        this.document = document;
        String prefix = AtlCompletionProcessor.extractPrefix(document, offset);
        AtlCompletionDataSource datasource = new AtlCompletionDataSource(this.getSourceManager());
        AtlModelAnalyser currentAnalyser = null;
        currentAnalyser = new AtlCompletionHelper(document.get()).computeModelAnalyser(offset, prefix, datasource.getATLFileContext());
        IFileEditorInput editorInput = (IFileEditorInput)this.fEditor.getEditorInput();
        this.typeProcessor.update(editorInput.getFile(), currentAnalyser, this.manager);
        ArrayList<ICompletionProposal> listProposals = new ArrayList<ICompletionProposal>();
        String line = AtlEditor.getCurrentLine(this.document, offset);
        this.atlContext = currentAnalyser.getContext(offset);
        if ("atl_context".equals(this.atlContext)) {
            if (this.proposalMode == 0) {
                listProposals.addAll(this.getTagProposals(offset, line, prefix, datasource));
            }
        } else if (line.indexOf("--") == -1) {
            if (this.proposalMode == 0) {
                listProposals.addAll(this.getAtlModelProposals(prefix, offset, datasource, currentAnalyser));
            } else if (this.proposalMode == 2) {
                listProposals.addAll(this.getGlobalProposals(prefix, offset, datasource, currentAnalyser));
            }
        }
        if (line.indexOf("--") == -1 && (this.proposalMode == 0 || this.proposalMode == 1)) {
            listProposals.addAll(this.getInstalledTemplates(prefix, offset));
        }
        ICompletionProposal[] proposals = listProposals.toArray(new ICompletionProposal[listProposals.size()]);
        if (this.recorder != null) {
            this.recorder.record(offset, line, proposals);
        }
        return proposals;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new AtlParameterListValidator();
        }
        return this.fValidator;
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    public void restrictProposalsToVisibility(boolean restrict) {
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public String getErrorMessage() {
        return "AtlEditor.codeassist.noCompletions";
    }

    protected Template[] getTemplates(String contextTypeId) {
        return AtlEditorUI.getDefault().getTemplateStore().getTemplates();
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        return AtlEditorUI.getDefault().getContextTypeRegistry().getContextType(this.atlContext);
    }

    protected Image getImage(Template template) {
        return AtlEditorUI.getDefault().getTemplateImage(template.getName());
    }

    protected String extractPrefix(ITextViewer viewer, int offset) {
        return AtlCompletionProcessor.extractPrefix(viewer.getDocument(), offset);
    }

    /*
     * Unable to fully structure code
     */
    public static String extractPrefix(IDocument document, int offset) {
        block2: {
            i = offset;
            if (document == null) break block2;
            if (i <= document.getLength()) ** GOTO lbl7
            return "";
            {
                while (AtlCompletionHelper.isAtlIdentifierPart(ch = document.getChar(i - 1))) {
                    --i;
lbl7:
                    // 2 sources

                    if (i > 0) continue;
                }
                return document.get(i, offset - i);
            }
        }
        return "";
    }

    private Collection<ICompletionProposal> getGlobalProposals(String prefix, int offset, AtlCompletionDataSource datasource, AtlModelAnalyser currentAnalyser) throws BadLocationException {
        OclAnyType type;
        EObject locatedElement;
        EObject source;
        ArrayList<ICompletionProposal> res = new ArrayList<ICompletionProposal>();
        if (this.atlContext.equals("rule_context") && (source = (EObject)AtlTypesProcessor.eGet(locatedElement = currentAnalyser.getLocatedElement(offset), "source")) != null && ((type = this.typeProcessor.getType(source)).getClass().equals(OclAnyType.class) || type.getClass().equals(ModuleType.class))) {
            res.addAll(this.createFeatureProposals(prefix, offset, this.typeProcessor.getUnit().getAllAttributes()));
            res.addAll(this.createOperationProposals(prefix, offset, type, this.typeProcessor.getUnit().getAllHelpers(), currentAnalyser));
        }
        return res;
    }

    private Collection<ICompletionProposal> getAtlModelProposals(String prefix, int offset, AtlCompletionDataSource datasource, AtlModelAnalyser currentAnalyser) throws BadLocationException {
        ArrayList<ICompletionProposal> res = new ArrayList<ICompletionProposal>();
        EObject locatedElement = currentAnalyser.getLocatedElement(offset);
        res.addAll(this.createKeywordProposals(prefix, offset, PREFIX_KEYWORDS_NAMES.get("")));
        String context = this.atlContext;
        res.addAll(this.createKeywordProposals(prefix, offset, PREFIX_KEYWORDS_NAMES.get(context)));
        if (locatedElement != null) {
            EObject source;
            EObject container = currentAnalyser.getContainer(locatedElement);
            if (AtlTypesProcessor.oclIsKindOf(locatedElement, "OclModel") || AtlTypesProcessor.oclIsKindOf(locatedElement, "OclModelElement") || AtlTypesProcessor.oclIsKindOf(locatedElement, "OclFeatureDefinition") || AtlTypesProcessor.oclIsKindOf(locatedElement, "OclType")) {
                if (this.atlContext.equals("rule_context")) {
                    if (container != null && (AtlTypesProcessor.oclIsKindOf(container, "InPatternElement") || AtlTypesProcessor.oclIsKindOf(container, "InPattern"))) {
                        res.addAll(this.createTypeProposals(prefix, offset, datasource.getClassifiers(1)));
                    } else if (container != null && AtlTypesProcessor.oclIsKindOf(container, "OutPatternElement")) {
                        res.addAll(this.createTypeProposals(prefix, offset, datasource.getClassifiers(2)));
                    } else {
                        res.addAll(this.createTypeProposals(prefix, offset, datasource.getClassifiers(0)));
                        res.addAll(this.createTypeProposals(prefix, offset, datasource.getAtlPrimitiveTypes()));
                        res.addAll(this.createComplexTypeProposals(prefix, offset, currentAnalyser));
                    }
                } else if (this.atlContext.equals("helper_context")) {
                    res.addAll(this.createTypeProposals(prefix, offset, datasource.getClassifiers(0)));
                    res.addAll(this.createTypeProposals(prefix, offset, datasource.getAtlPrimitiveTypes()));
                    if (container != null && !AtlTypesProcessor.oclIsKindOf(container, "OclContextDefinition") && !AtlTypesProcessor.oclIsKindOf(container, "OclFeatureDefinition")) {
                        res.addAll(this.createComplexTypeProposals(prefix, offset, currentAnalyser));
                    }
                } else if (this.atlContext.equals("query_context")) {
                    res.addAll(this.createTypeProposals(prefix, offset, datasource.getClassifiers(0)));
                    res.addAll(this.createTypeProposals(prefix, offset, datasource.getAtlPrimitiveTypes()));
                }
            } else if (AtlTypesProcessor.oclIsKindOf(locatedElement, "OutPattern")) {
                if (currentAnalyser.getLostTypesNames().contains("Binding")) {
                    EObject oclModelElement;
                    EObject simpleOutPatternElement = currentAnalyser.getLastLostElementByType("SimpleOutPatternElement");
                    if (simpleOutPatternElement != null && (oclModelElement = (EObject)AtlTypesProcessor.eGet(simpleOutPatternElement, "type")) != null) {
                        OclAnyType type = OclAnyType.create(this.getSourceManager(), oclModelElement);
                        res.addAll(this.createBindingProposals(prefix, offset, type.getFeatures()));
                    }
                } else {
                    String templateName = Messages.getString("AtlCompletionProcessor.OUTPUT_PATTERN_NAME");
                    String pattern = "${variable} : ${type} (\n\t\t${cursor}\t\n)";
                    String description = Messages.getString("AtlCompletionProcessor.OUTPUT_PATTERN_DESCRIPTION");
                    String information = "variable : type (\n\t\t\t\n)";
                    Template template = new Template(templateName.toString(), description, this.atlContext, pattern.toString(), false);
                    AtlTemplateProposal proposal = this.convertToProposal(template, prefix, offset, AtlUIPlugin.getDefault().getImage("$nl$/icons/templateprop_co.gif"), true, information);
                    if (proposal != null) {
                        res.add((ICompletionProposal)proposal);
                    }
                }
            } else if (AtlTypesProcessor.oclIsKindOf(locatedElement, "VariableExp") || AtlTypesProcessor.oclIsKindOf(locatedElement, "VariableDeclaration")) {
                res.addAll(this.createVariablesProposals(prefix, offset, this.typeProcessor.getVariables(locatedElement)));
            } else if ((AtlTypesProcessor.oclIsKindOf(locatedElement, "NavigationOrAttributeCallExp") || AtlTypesProcessor.oclIsKindOf(locatedElement, "CollectionOperationCallExp")) && (source = (EObject)AtlTypesProcessor.eGet(locatedElement, "source")) != null) {
                OclAnyType type = this.typeProcessor.getType(source);
                res.addAll(this.createFeatureProposals(prefix, offset, type.getFeatures()));
                res.addAll(this.createFeatureProposals(prefix, offset, this.typeProcessor.getUnit().getAttributes(type)));
                res.addAll(this.createOperationProposals(prefix, offset, type, this.typeProcessor.getUnit().getHelpers(type), currentAnalyser));
                res.addAll(this.createOperationProposals(prefix, offset, type, type.getOperations(), currentAnalyser));
            }
        }
        return res;
    }

    private Collection<ICompletionProposal> getInstalledTemplates(String prefix, int offset) {
        Region region = new Region(offset - prefix.length(), prefix.length());
        DocumentTemplateContext context = new DocumentTemplateContext(this.getContextType(this.viewer, (IRegion)region), this.document, region.getOffset(), region.getLength());
        if (this.viewer != null) {
            ITextSelection selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
            context.setVariable("selection", selection.getText());
        }
        Template[] templates = this.getTemplates(context.getContextType().getId());
        ArrayList<ICompletionProposal> matches = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < templates.length) {
            block5: {
                Template template = templates[i];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    break block5;
                }
                if (template.matches(prefix, context.getContextType().getId()) && (!this.needPrefix(template) || this.needPrefix(template) && !"".equals(prefix) && template.getPattern().startsWith(prefix))) {
                    matches.add((ICompletionProposal)new AtlInstalledTemplateProposal(template, (TemplateContext)context, (IRegion)region, this.getImage(template), this.getRelevance(template, prefix), template.getDescription()));
                }
            }
            ++i;
        }
        return matches;
    }

    private AtlTemplateProposal convertToProposal(Template template, String prefix, int offset, Image image, boolean needPrefix, String information) {
        Region region = new Region(offset - prefix.length(), prefix.length());
        DocumentTemplateContext context = new DocumentTemplateContext(this.getContextType(this.viewer, (IRegion)region), this.document, region.getOffset(), region.getLength());
        if (this.viewer != null) {
            ITextSelection selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
            context.setVariable("selection", selection.getText());
        }
        if (template.matches(prefix, context.getContextType().getId()) && ("".equals(prefix) || !needPrefix || needPrefix && template.getPattern().startsWith(prefix))) {
            AtlTemplateProposal res = new AtlTemplateProposal(template, (TemplateContext)context, (IRegion)region, image, this.getRelevance(template, prefix), information);
            return res;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Collection<ICompletionProposal> getTagProposals(int offset, String line, String prefix, AtlCompletionDataSource datasource) {
        if (line.matches(COMPILER_TAG_REGEX)) {
            ArrayList<String> compilersNames = new ArrayList<String>();
            IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.m2m.atl.engine.atlcompiler").getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    compilersNames.add(elements[j].getAttribute("name"));
                    ++j;
                }
                ++i;
            }
            return AtlCompletionProcessor.createProposalsFromList(prefix, offset, compilersNames.toArray(), null);
        }
        if (line.matches(URI_TAG_REGEX)) {
            if (line.indexOf("=") <= -1) return AtlCompletionProcessor.createProposalsFromList(prefix, offset, datasource.getMetamodels(), AtlUIPlugin.getDefault().getImage("$nl$/icons/oclModel.gif"));
            if (line.split("=").length == 2) {
                String uriPrefix = line.split("=")[1];
                return AtlCompletionProcessor.createProposalsFromList(uriPrefix, offset, AtlCompletionDataSource.getURIs(), AtlUIPlugin.getDefault().getImage("$nl$/icons/EPackage.gif"));
            }
            if (!line.endsWith("=")) return Collections.emptyList();
            return AtlCompletionProcessor.createProposalsFromList("", offset, AtlCompletionDataSource.getURIs(), AtlUIPlugin.getDefault().getImage("$nl$/icons/EPackage.gif"));
        }
        if (line.matches(PATH_TAG_REGEX)) {
            if (line.indexOf("=") <= -1) return AtlCompletionProcessor.createProposalsFromList(prefix, offset, datasource.getMetamodels(), AtlUIPlugin.getDefault().getImage("$nl$/icons/oclModel.gif"));
            if (line.split("=").length == 2) {
                String uriPrefix = line.split("=")[1];
                return AtlCompletionProcessor.createProposalsFromList(uriPrefix, offset, AtlCompletionDataSource.getPaths(), AtlUIPlugin.getDefault().getImage("$nl$/icons/EcoreModelFile.gif"));
            }
            if (!line.endsWith("=")) return Collections.emptyList();
            return AtlCompletionProcessor.createProposalsFromList("", offset, AtlCompletionDataSource.getPaths(), AtlUIPlugin.getDefault().getImage("$nl$/icons/EcoreModelFile.gif"));
        }
        String pathTemplate = "-- @path";
        String uriTemplate = "-- @nsURI";
        String libTemplate = "-- @lib";
        String compilerTemplate = "-- @atlcompiler";
        return AtlCompletionProcessor.createProposalsFromList(line, offset, new String[]{pathTemplate, uriTemplate, libTemplate, compilerTemplate}, AtlUIPlugin.getDefault().getImage("$nl$/icons/EAnnotation.gif"));
    }

    private boolean needPrefix(Template template) {
        boolean res = false;
        String[] stringArray = PREFIX_TEMPLATES_NAMES;
        int n = PREFIX_TEMPLATES_NAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            res = res || name.equals(template.getName());
            ++n2;
        }
        return res;
    }

    private static boolean startsWithIgnoreCase(String prefix, String replacementString) {
        if (replacementString.length() >= prefix.length()) {
            String tmp = replacementString.substring(0, prefix.length());
            return tmp.equalsIgnoreCase(prefix);
        }
        return false;
    }

    private static List<ICompletionProposal> createProposalsFromList(String prefix, int offset, Object[] proposals, Image image) {
        ArrayList<ICompletionProposal> res = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < proposals.length) {
            AtlCompletionProposal proposal;
            String replacementString = proposals[i].toString();
            if ((AtlCompletionProcessor.startsWithIgnoreCase(prefix, replacementString) || replacementString.contains(prefix)) && (proposal = new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), image, replacementString, 0, null)) != null) {
                res.add(proposal);
            }
            ++i;
        }
        return res;
    }

    private List<ICompletionProposal> createTypeProposals(String prefix, int offset, Map<String, OclAnyType[]> types) {
        ArrayList<ICompletionProposal> res = new ArrayList<ICompletionProposal>();
        for (String metamodelName : types.keySet()) {
            OclAnyType[] metamodelTypes;
            OclAnyType[] oclAnyTypeArray = metamodelTypes = types.get(metamodelName);
            int n = metamodelTypes.length;
            int n2 = 0;
            while (n2 < n) {
                OclAnyType oclAnyType = oclAnyTypeArray[n2];
                AtlCompletionProposal proposal = this.createTypeProposal(prefix, offset, metamodelName, oclAnyType);
                if (proposal != null) {
                    res.add(proposal);
                }
                ++n2;
            }
        }
        return res;
    }

    private List<AtlCompletionProposal> createVariablesProposals(String prefix, int offset, Map<String, OclAnyType> variables) {
        ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
        for (Map.Entry<String, OclAnyType> entry : variables.entrySet()) {
            String replacementString = entry.getKey().toString();
            String displayString = String.valueOf(replacementString) + " : " + entry.getValue();
            if (!AtlCompletionProcessor.startsWithIgnoreCase(prefix, replacementString) || prefix.equals(replacementString)) continue;
            AtlCompletionProposal proposal = new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), AtlUIPlugin.getDefault().getImage("$nl$/icons/localvariable_obj.gif"), displayString, 0, null);
            res.add(proposal);
        }
        Collections.sort(res);
        return res;
    }

    private List<AtlCompletionProposal> createFeatureProposals(String prefix, int offset, Collection<Feature> features) {
        ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
        if (features != null) {
            for (Feature feature : features) {
                String replacementString = feature.getName();
                if (!AtlCompletionProcessor.startsWithIgnoreCase(prefix, replacementString) || prefix.equals(replacementString)) continue;
                String displayString = feature.getInformation();
                AtlCompletionProposal proposal = new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), AtlUIPlugin.getDefault().getImage(feature.getImagePath()), displayString.toString(), 0, feature.getDocumentation());
                res.add(proposal);
            }
        }
        return res;
    }

    private List<AtlCompletionProposal> createBindingProposals(String prefix, int offset, Collection<Feature> features) {
        ArrayList<AtlCompletionProposal> res = new ArrayList<AtlCompletionProposal>();
        if (features != null) {
            for (Feature feature : features) {
                String replacementString = String.valueOf(feature.getName()) + " <- ";
                if (!AtlCompletionProcessor.startsWithIgnoreCase(prefix, replacementString) || prefix.equals(replacementString)) continue;
                String displayString = feature.getInformation();
                AtlCompletionProposal proposal = new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), AtlUIPlugin.getDefault().getImage(feature.getImagePath()), displayString.toString(), 0, feature.getDocumentation());
                res.add(proposal);
            }
        }
        return res;
    }

    private List<AtlTemplateProposal> createOperationProposals(String prefix, int offset, OclAnyType context, Collection<Operation> operations, AtlModelAnalyser analyser) {
        ArrayList<AtlTemplateProposal> res = new ArrayList<AtlTemplateProposal>();
        if (operations != null) {
            for (Operation operation : operations) {
                Template template;
                AtlTemplateProposal proposal;
                StringBuffer pattern = new StringBuffer();
                pattern.append(operation.getName());
                pattern.append('(');
                Iterator<Map.Entry<String, OclAnyType>> iterator = operation.getParameters().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, OclAnyType> parameter = iterator.next();
                    pattern.append("${" + parameter.getKey() + '}');
                    if (!iterator.hasNext()) continue;
                    pattern.append(", ");
                }
                pattern.append(')');
                operation.getType(context, new Object[0]);
                String description = "";
                if (operation.getContextType() != null) {
                    description = operation.getContextType().toString();
                }
                if ((proposal = this.convertToProposal(template = new Template(operation.getInformation(context), description, this.atlContext, pattern.toString(), false), prefix, offset, AtlUIPlugin.getDefault().getImage(operation.getImagePath()), true, operation.getDocumentation(context, new Object[0]))) == null) continue;
                res.add(proposal);
            }
        }
        return res;
    }

    private AtlCompletionProposal createTypeProposal(String prefix, int offset, String metamodelName, OclAnyType type) {
        if (type instanceof ModelElementType) {
            ModelElementType meType = (ModelElementType)type;
            String replacementString = String.valueOf(metamodelName) + "!" + meType.getOclType().getClassifier().getName();
            if (AtlCompletionProcessor.startsWithIgnoreCase(prefix, replacementString) && !prefix.equals(replacementString)) {
                Image image = AtlUIPlugin.getDefault().getImage("$nl$/icons/model_class.gif");
                return new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), image, replacementString, 0, meType.getInformation().toString());
            }
        } else {
            String replacementString = type.toString();
            if (AtlCompletionProcessor.startsWithIgnoreCase(prefix, replacementString) && !prefix.equals(replacementString)) {
                return new AtlCompletionProposal(replacementString, offset - prefix.length(), replacementString.length(), null, replacementString, 0, "");
            }
        }
        return null;
    }

    private Collection<AtlTemplateProposal> createComplexTypeProposals(String prefix, int offset, AtlModelAnalyser analyser) {
        AtlTemplateProposal tupleProposal;
        AtlTemplateProposal mapProposal;
        AtlTemplateProposal orderedSetProposal;
        AtlTemplateProposal setProposal;
        AtlTemplateProposal bagProposal;
        AtlTemplateProposal sequenceProposal;
        ArrayList<AtlTemplateProposal> res = new ArrayList<AtlTemplateProposal>();
        AtlTemplateProposal collectionProposal = this.createComplexTypeProposal(prefix, offset, analyser, "Collection", "OclAny");
        if (collectionProposal != null) {
            res.add(collectionProposal);
        }
        if ((sequenceProposal = this.createComplexTypeProposal(prefix, offset, analyser, "Sequence", "OclAny")) != null) {
            res.add(sequenceProposal);
        }
        if ((bagProposal = this.createComplexTypeProposal(prefix, offset, analyser, "Bag", "OclAny")) != null) {
            res.add(bagProposal);
        }
        if ((setProposal = this.createComplexTypeProposal(prefix, offset, analyser, "Set", "OclAny")) != null) {
            res.add(setProposal);
        }
        if ((orderedSetProposal = this.createComplexTypeProposal(prefix, offset, analyser, "OrderedSet", "OclAny")) != null) {
            res.add(orderedSetProposal);
        }
        if ((mapProposal = this.createComplexTypeProposal(prefix, offset, analyser, "Map", "OclAny", "OclAny")) != null) {
            res.add(mapProposal);
        }
        if ((tupleProposal = this.createComplexTypeProposal(prefix, offset, analyser, "TupleType", "var1: Type1", "var2: Type2")) != null) {
            res.add(tupleProposal);
        }
        return res;
    }

    private AtlTemplateProposal createComplexTypeProposal(String prefix, int offset, AtlModelAnalyser analyser, String typeName, String ... parameters) {
        StringBuffer templateName = new StringBuffer();
        StringBuffer pattern = new StringBuffer();
        templateName.append(typeName);
        pattern.append(typeName);
        templateName.append('(');
        pattern.append('(');
        int i = 0;
        while (i < parameters.length) {
            String parameter = parameters[i];
            if (parameter.contains(": ")) {
                String[] params = parameter.split("\\: ");
                templateName.append(params[0]);
                pattern.append("${" + params[0] + '}');
                templateName.append(": ");
                pattern.append(": ");
                templateName.append(params[1]);
                pattern.append("${" + params[1] + '}');
            } else {
                templateName.append(parameter);
                pattern.append("${" + parameter + '}');
            }
            if (i < parameters.length - 1) {
                templateName.append(", ");
                pattern.append(", ");
            }
            ++i;
        }
        templateName.append(')');
        pattern.append(')');
        Template template = new Template(templateName.toString(), String.valueOf(typeName) + " declaration", this.atlContext, pattern.toString(), false);
        return this.convertToProposal(template, prefix, offset, null, true, null);
    }

    private List<ICompletionProposal> createKeywordProposals(String prefix, int offset, String[] keywords) {
        ArrayList<ICompletionProposal> res = new ArrayList<ICompletionProposal>();
        if (keywords == null) {
            return res;
        }
        Collections.sort(Arrays.asList(keywords));
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            AtlCompletionProposal proposal;
            String keyword = stringArray[n2];
            if (!prefix.trim().equals("") && AtlCompletionProcessor.startsWithIgnoreCase(prefix, keyword) && !prefix.equals(keyword) && (proposal = new AtlCompletionProposal(keyword, offset - prefix.length(), keyword.length(), null, keyword, 0, "")) != null) {
                res.add(proposal);
            }
            ++n2;
        }
        return res;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        IContentAssistant assistant = event.assistant;
        if (assistant instanceof IContentAssistantExtension2) {
            this.fContentAssistant = (IContentAssistantExtension2)assistant;
        }
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.fContentAssistant = null;
        this.proposalMode = 0;
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public static interface IATLCompletionRecorder {
        public void record(int var1, String var2, ICompletionProposal[] var3);
    }
}

