/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.EMFModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFReferenceModel;
import org.eclipse.m2m.atl.dsls.core.EMFTCSInjector;
import org.eclipse.m2m.atl.engine.parser.AtlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlResourceImpl
extends ResourceImpl {
    protected final AtlParser parser = AtlParser.getDefault();
    protected final EMFModelWrapper modelWrapper = new EMFModelWrapper();
    protected final EMFModelFactory modelFactory = new EMFModelFactory();
    private byte[] rawContent;

    public AtlResourceImpl() {
        this.setTrackingModification(true);
    }

    public AtlResourceImpl(URI uri) {
        super(uri);
        this.setTrackingModification(true);
    }

    protected byte[] getRawContent() {
        return this.rawContent;
    }

    protected void setRawContent(byte[] rawContent) {
        this.rawContent = rawContent;
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        int read;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((read = inputStream.read(buf)) > 0) {
            bos.write(buf, 0, read);
        }
        this.setRawContent(bos.toByteArray());
        EMFTCSInjector ebnfi = new EMFTCSInjector();
        IModel pbs = this.modelFactory.newModel(this.parser.getProblemMetamodel());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", "ATL");
        params.put("problems", (String)pbs);
        if (options != null) {
            params.putAll(options);
        }
        ebnfi.inject((EMFModel)this.modelWrapper, (InputStream)new ByteArrayInputStream(this.getRawContent()), params);
        int nbErrors = 0;
        for (EObject ame : pbs.getElementsByType(this.parser.getProblemMetamodel().getMetaElementByName("Problem"))) {
            Enumerator severity = (Enumerator)ame.eGet(ame.eClass().getEStructuralFeature("severity"));
            EList list = null;
            if (severity.getName().equals("error")) {
                list = this.getErrors();
                ++nbErrors;
            } else if (severity.getName().equals("warning")) {
                list = this.getWarnings();
            }
            if (list == null) continue;
            final String message = (String)ame.eGet(ame.eClass().getEStructuralFeature("description"));
            String location = (String)ame.eGet(ame.eClass().getEStructuralFeature("location"));
            String[] parts = location.split("-")[0].split(":");
            final int line = Integer.parseInt(parts[0]);
            final int column = Integer.parseInt(parts[1]);
            list.add(new Resource.Diagnostic(){

                public int getColumn() {
                    return column;
                }

                public int getLine() {
                    return line;
                }

                public String getLocation() {
                    return AtlResourceImpl.this.getURI().toString();
                }

                public String getMessage() {
                    return message;
                }

                public String toString() {
                    StringBuffer buf = new StringBuffer(this.getMessage());
                    buf.append(" (");
                    buf.append(this.getLocation());
                    buf.append(':');
                    buf.append(this.getLine());
                    buf.append(')');
                    return buf.toString();
                }
            });
        }
        if (nbErrors == 0) {
            this.getWarnings().clear();
        }
        this.registerEPackages(this.modelWrapper.getReferenceModel().getResource());
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        byte[] rawContent = this.getRawContent();
        if (!this.isModified() && rawContent != null) {
            ATLLogger.fine((String)"Content not modified - saving original content.");
            outputStream.write(rawContent);
            outputStream.close();
        } else {
            try {
                this.parser.extract((IModel)this.modelWrapper, outputStream, options);
            }
            catch (ATLCoreException e) {
                throw new ATLIOException(e);
            }
        }
    }

    protected void registerEPackages(Resource res) throws IOException {
        ResourceSet rs = this.getResourceSet();
        EPackage.Registry r = rs.getPackageRegistry();
        for (EObject o : res.getContents()) {
            if (!(o instanceof EPackage)) continue;
            EPackage p = (EPackage)o;
            if (r.containsKey((Object)p.getNsURI()) && r.get((Object)p.getNsURI()) != p) {
                throw new IOException(String.format("EPackage with URI \"%s\" already registered by another EPackage instance", p.getNsURI()));
            }
            r.put((Object)p.getNsURI(), (Object)p);
        }
    }

    public static class ATLIOException
    extends IOException {
        private static final long serialVersionUID = -6673120460005697460L;

        public ATLIOException() {
        }

        public ATLIOException(String message, Throwable cause) {
            super(message);
            this.initCause(cause);
        }

        public ATLIOException(String message) {
            super(message);
        }

        public ATLIOException(Throwable cause) {
            this.initCause(cause);
        }
    }

    public class EMFModelWrapper
    extends EMFModel {
        public EMFModelWrapper() {
            super((EMFReferenceModel)AtlResourceImpl.this.parser.getAtlMetamodel(), (EMFModelFactory)AtlResourceImpl.this.parser.getModelFactory());
            this.setResource((Resource)AtlResourceImpl.this);
        }
    }
}

