/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.jit;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.emftvm.Add;
import org.eclipse.m2m.atl.emftvm.Allinst;
import org.eclipse.m2m.atl.emftvm.AllinstIn;
import org.eclipse.m2m.atl.emftvm.And;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.Delete;
import org.eclipse.m2m.atl.emftvm.Dup;
import org.eclipse.m2m.atl.emftvm.DupX1;
import org.eclipse.m2m.atl.emftvm.Enditerate;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.Findtype;
import org.eclipse.m2m.atl.emftvm.FindtypeS;
import org.eclipse.m2m.atl.emftvm.Get;
import org.eclipse.m2m.atl.emftvm.GetStatic;
import org.eclipse.m2m.atl.emftvm.GetSuper;
import org.eclipse.m2m.atl.emftvm.GetTrans;
import org.eclipse.m2m.atl.emftvm.Getcb;
import org.eclipse.m2m.atl.emftvm.Getenv;
import org.eclipse.m2m.atl.emftvm.Getenvtype;
import org.eclipse.m2m.atl.emftvm.Goto;
import org.eclipse.m2m.atl.emftvm.If;
import org.eclipse.m2m.atl.emftvm.Ifn;
import org.eclipse.m2m.atl.emftvm.Ifte;
import org.eclipse.m2m.atl.emftvm.Implies;
import org.eclipse.m2m.atl.emftvm.Insert;
import org.eclipse.m2m.atl.emftvm.Instruction;
import org.eclipse.m2m.atl.emftvm.Invoke;
import org.eclipse.m2m.atl.emftvm.InvokeAllCbs;
import org.eclipse.m2m.atl.emftvm.InvokeCb;
import org.eclipse.m2m.atl.emftvm.InvokeCbS;
import org.eclipse.m2m.atl.emftvm.InvokeStatic;
import org.eclipse.m2m.atl.emftvm.InvokeSuper;
import org.eclipse.m2m.atl.emftvm.Isnull;
import org.eclipse.m2m.atl.emftvm.Iterate;
import org.eclipse.m2m.atl.emftvm.Load;
import org.eclipse.m2m.atl.emftvm.Match;
import org.eclipse.m2m.atl.emftvm.MatchS;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.New;
import org.eclipse.m2m.atl.emftvm.NewS;
import org.eclipse.m2m.atl.emftvm.Not;
import org.eclipse.m2m.atl.emftvm.Operation;
import org.eclipse.m2m.atl.emftvm.Or;
import org.eclipse.m2m.atl.emftvm.Pop;
import org.eclipse.m2m.atl.emftvm.Push;
import org.eclipse.m2m.atl.emftvm.Pushf;
import org.eclipse.m2m.atl.emftvm.Pusht;
import org.eclipse.m2m.atl.emftvm.Remove;
import org.eclipse.m2m.atl.emftvm.Return;
import org.eclipse.m2m.atl.emftvm.Rule;
import org.eclipse.m2m.atl.emftvm.Set;
import org.eclipse.m2m.atl.emftvm.SetStatic;
import org.eclipse.m2m.atl.emftvm.Store;
import org.eclipse.m2m.atl.emftvm.Swap;
import org.eclipse.m2m.atl.emftvm.SwapX1;
import org.eclipse.m2m.atl.emftvm.Xor;
import org.eclipse.m2m.atl.emftvm.jit.CodeBlockJIT;
import org.eclipse.m2m.atl.emftvm.jit.JITCodeBlock;
import org.eclipse.m2m.atl.emftvm.jit.LabelSwitch;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.EmftvmSwitch;
import org.eclipse.m2m.atl.emftvm.util.EnumConversionList;
import org.eclipse.m2m.atl.emftvm.util.EnumConversionListOnList;
import org.eclipse.m2m.atl.emftvm.util.EnumConversionSetOnSet;
import org.eclipse.m2m.atl.emftvm.util.EnumLiteral;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.LazyListOnList;
import org.eclipse.m2m.atl.emftvm.util.NativeTypes;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.VMException;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteCodeSwitch
extends EmftvmSwitch<MethodVisitor>
implements Opcodes {
    public static final Map<Class<?>, Class<?>> BOXED_CLASSES = new HashMap();
    protected final MethodVisitor mv;
    protected final LabelSwitch ls;
    protected final CodeBlockJIT jit;
    protected final boolean hasMonitor;
    protected final java.util.Set<Instruction> skipInstructions = new HashSet<Instruction>();

    static {
        BOXED_CLASSES.put(Void.TYPE, Void.class);
        BOXED_CLASSES.put(Boolean.TYPE, Boolean.class);
        BOXED_CLASSES.put(Character.TYPE, Character.class);
        BOXED_CLASSES.put(Byte.TYPE, Byte.class);
        BOXED_CLASSES.put(Short.TYPE, Short.class);
        BOXED_CLASSES.put(Integer.TYPE, Integer.class);
        BOXED_CLASSES.put(Long.TYPE, Long.class);
        BOXED_CLASSES.put(Float.TYPE, Float.class);
        BOXED_CLASSES.put(Double.TYPE, Double.class);
    }

    public static Class<?> boxed(Class<?> type) {
        if (BOXED_CLASSES.containsKey(type)) {
            return BOXED_CLASSES.get(type);
        }
        return type;
    }

    public ByteCodeSwitch(CodeBlockJIT jit, MethodVisitor mv, LabelSwitch ls) {
        this.jit = jit;
        this.mv = mv;
        this.ls = ls;
        this.hasMonitor = jit.getEnv().getMonitor() != null;
    }

    @Override
    public MethodVisitor caseInstruction(Instruction object) {
        if (this.ls.hasWithTarget(object)) {
            this.label(this.ls.getFromTarget(object));
        }
        return this.mv;
    }

    @Override
    public MethodVisitor casePush(Push object) {
        if (object.getIntValue() != null) {
            this.generatePushInt(object.getIntValue());
            this.invokeStat(Integer.class, "valueOf", Integer.class, Type.INT_TYPE);
        } else if (object.getByteValue() != null) {
            this.generatePushInt(object.getByteValue().byteValue());
            this.invokeStat(Byte.class, "valueOf", Byte.class, Type.BYTE_TYPE);
        } else if (object.getCharValue() != null) {
            this.generatePushInt(object.getCharValue().charValue());
            this.invokeStat(Character.class, "valueOf", Character.class, Type.CHAR_TYPE);
        } else if (object.getShortValue() != null) {
            this.generatePushInt(object.getShortValue().shortValue());
            this.invokeStat(Short.class, "valueOf", Short.class, Type.SHORT_TYPE);
        } else if (object.getLongValue() != null) {
            this.mv.visitLdcInsn((Object)object.getLongValue());
            this.invokeStat(Long.class, "valueOf", Long.class, Type.LONG_TYPE);
        } else if (object.getDoubleValue() != null) {
            this.mv.visitLdcInsn((Object)object.getDoubleValue());
            this.invokeStat(Double.class, "valueOf", Double.class, Type.DOUBLE_TYPE);
        } else if (object.getFloatValue() != null) {
            this.mv.visitLdcInsn((Object)object.getFloatValue());
            this.invokeStat(Float.class, "valueOf", Float.class, Type.FLOAT_TYPE);
        } else if (object.getEnumValue() != null) {
            this.new_(EnumLiteral.class);
            this.dup();
            this.ldc(object.getEnumValue());
            this.invokeCons(EnumLiteral.class, String.class);
        } else if (object.getValue() != null) {
            this.ldc(object.getValue());
        } else {
            this.aconst_null();
        }
        return (MethodVisitor)super.casePush(object);
    }

    @Override
    public MethodVisitor casePusht(Pusht object) {
        this.iconst_1();
        this.invokeStat(Boolean.class, "valueOf", Boolean.class, Type.BOOLEAN_TYPE);
        return (MethodVisitor)super.casePusht(object);
    }

    @Override
    public MethodVisitor casePushf(Pushf object) {
        this.iconst_0();
        this.invokeStat(Boolean.class, "valueOf", Boolean.class, Type.BOOLEAN_TYPE);
        return (MethodVisitor)super.casePushf(object);
    }

    @Override
    public MethodVisitor casePop(Pop object) {
        this.pop();
        return (MethodVisitor)super.casePop(object);
    }

    @Override
    public MethodVisitor caseLoad(Load object) {
        this.aload(1);
        if (object.getCbOffset() > 0) {
            this.generatePushInt(object.getCbOffset());
            this.generatePushInt(object.getSlot());
            this.invokeVirt(StackFrame.class, "getLocal", Object.class, Type.INT_TYPE, Type.INT_TYPE);
        } else {
            this.generatePushInt(object.getSlot());
            this.invokeVirt(StackFrame.class, "getLocal", Object.class, Type.INT_TYPE);
        }
        return (MethodVisitor)super.caseLoad(object);
    }

    @Override
    public MethodVisitor caseStore(Store object) {
        this.aload(1);
        this.swap();
        if (object.getCbOffset() > 0) {
            this.generatePushInt(object.getCbOffset());
            this.generatePushInt(object.getSlot());
            this.invokeVirt(StackFrame.class, "setLocal", Type.VOID_TYPE, Object.class, Type.INT_TYPE, Type.INT_TYPE);
        } else {
            this.generatePushInt(object.getSlot());
            this.invokeVirt(StackFrame.class, "setLocal", Type.VOID_TYPE, Object.class, Type.INT_TYPE);
        }
        return (MethodVisitor)super.caseStore(object);
    }

    @Override
    public MethodVisitor caseSet(Set object) {
        this.aload(0);
        this.getField(JITCodeBlock.class, "cb", CodeBlock.class);
        this.aload(1);
        this.ldc(object.getFieldname());
        this.invokeStat(JITCodeBlock.class, "set", Type.VOID_TYPE, Object.class, Object.class, CodeBlock.class, StackFrame.class, String.class);
        return (MethodVisitor)super.caseSet(object);
    }

    @Override
    public MethodVisitor caseGet(Get object) {
        this.generateSetPc(object);
        Rule rule = object.getOwningBlock().getRule();
        boolean hasRuleField = rule != null && rule.hasField(object.getFieldname());
        boolean hasField = this.jit.getEnv().hasField(object.getFieldname());
        if (hasRuleField) {
            this.aload(0);
            this.getField(JITCodeBlock.class, "cb", CodeBlock.class);
            this.aload(1);
            this.ldc(object.getFieldname());
            this.invokeStat(JITCodeBlock.class, "get", Object.class, Object.class, CodeBlock.class, StackFrame.class, String.class);
        } else if (hasField) {
            this.aload(1);
            this.ldc(object.getFieldname());
            this.invokeStat(JITCodeBlock.class, "get", Object.class, Object.class, StackFrame.class, String.class);
        } else {
            this.aload(2);
            this.ldc(object.getFieldname());
            this.invokeStat(JITCodeBlock.class, "get", Object.class, Object.class, ExecEnv.class, String.class);
        }
        return (MethodVisitor)super.caseGet(object);
    }

    @Override
    public MethodVisitor caseGetTrans(GetTrans object) {
        this.generateSetPc(object);
        this.aload(0);
        this.getField(JITCodeBlock.class, "cb", CodeBlock.class);
        this.aload(1);
        this.ldc(object.getFieldname());
        this.invokeStat(JITCodeBlock.class, "getTrans", Object.class, Object.class, CodeBlock.class, StackFrame.class, String.class);
        return (MethodVisitor)super.caseGetTrans(object);
    }

    @Override
    public MethodVisitor caseSetStatic(SetStatic object) {
        this.aload(0);
        this.getField(JITCodeBlock.class, "cb", CodeBlock.class);
        this.aload(2);
        this.ldc(object.getFieldname());
        this.invokeStat(JITCodeBlock.class, "setStatic", Type.VOID_TYPE, Object.class, Object.class, CodeBlock.class, ExecEnv.class, String.class);
        return (MethodVisitor)super.caseSetStatic(object);
    }

    @Override
    public MethodVisitor caseGetStatic(GetStatic object) {
        this.generateSetPc(object);
        this.aload(0);
        this.getField(JITCodeBlock.class, "cb", CodeBlock.class);
        this.aload(1);
        this.ldc(object.getFieldname());
        this.invokeStat(JITCodeBlock.class, "getStatic", Object.class, Object.class, CodeBlock.class, StackFrame.class, String.class);
        return (MethodVisitor)super.caseGetStatic(object);
    }

    @Override
    public MethodVisitor caseFindtype(Findtype object) {
        if ("#native".equals(object.getModelname())) {
            try {
                Class<?> type = NativeTypes.findType(object.getTypename());
                Instruction nextInstr = this.nextInstruction(object);
                if (nextInstr instanceof New) {
                    this.new_(type);
                    this.dup();
                    this.invokeSpec(type, "<init>", Void.TYPE, new Object[0]);
                    this.skipInstructions.add(nextInstr);
                } else {
                    this.ldc(Type.getType(type));
                }
                return (MethodVisitor)super.caseFindtype(object);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        this.aload(2);
        this.ldc(object.getModelname());
        this.ldc(object.getTypename());
        this.invokeIface(ExecEnv.class, "findType", Object.class, String.class, String.class);
        return (MethodVisitor)super.caseFindtype(object);
    }

    @Override
    public MethodVisitor caseFindtypeS(FindtypeS object) {
        this.aload(2);
        this.invokeStat(JITCodeBlock.class, "findTypeS", Object.class, String.class, String.class, ExecEnv.class);
        return (MethodVisitor)super.caseFindtypeS(object);
    }

    @Override
    public MethodVisitor caseNew(New object) {
        if (!this.skipInstructions.contains(object)) {
            String modelName = object.getModelname();
            if (modelName == null) {
                this.aconst_null();
            } else {
                this.ldc(object.getModelname());
            }
            this.aload(2);
            this.invokeStat(JITCodeBlock.class, "newInstance", Object.class, Object.class, String.class, ExecEnv.class);
        }
        return (MethodVisitor)super.caseNew(object);
    }

    @Override
    public MethodVisitor caseNewS(NewS object) {
        this.checkcast(String.class);
        this.aload(2);
        this.invokeStat(JITCodeBlock.class, "newInstance", Object.class, Object.class, String.class, ExecEnv.class);
        return (MethodVisitor)super.caseNewS(object);
    }

    @Override
    public MethodVisitor caseDelete(Delete object) {
        this.checkcast(EObject.class);
        this.aload(1);
        this.invokeStat(JITCodeBlock.class, "delete", Type.VOID_TYPE, EObject.class, StackFrame.class);
        return (MethodVisitor)super.caseDelete(object);
    }

    @Override
    public MethodVisitor caseDup(Dup object) {
        this.dup();
        return (MethodVisitor)super.caseDup(object);
    }

    @Override
    public MethodVisitor caseDupX1(DupX1 object) {
        this.dup_x1();
        return (MethodVisitor)super.caseDupX1(object);
    }

    @Override
    public MethodVisitor caseSwap(Swap object) {
        this.swap();
        return (MethodVisitor)super.caseSwap(object);
    }

    @Override
    public MethodVisitor caseSwapX1(SwapX1 object) {
        this.dup_x2();
        this.pop();
        this.swap();
        return (MethodVisitor)super.caseSwapX1(object);
    }

    @Override
    public MethodVisitor caseIf(If object) {
        assert (this.ls.hasWithSource(object));
        this.checkcast(Boolean.class);
        this.invokeVirt(Boolean.class, "booleanValue", Type.BOOLEAN_TYPE, new Object[0]);
        this.ifne(this.ls.getFromSource(object));
        return (MethodVisitor)super.caseIf(object);
    }

    @Override
    public MethodVisitor caseIfn(Ifn object) {
        assert (this.ls.hasWithSource(object));
        this.checkcast(Boolean.class);
        this.invokeVirt(Boolean.class, "booleanValue", Type.BOOLEAN_TYPE, new Object[0]);
        this.ifeq(this.ls.getFromSource(object));
        return (MethodVisitor)super.caseIfn(object);
    }

    @Override
    public MethodVisitor caseGoto(Goto object) {
        assert (this.ls.hasWithSource(object));
        this.goto_(this.ls.getFromSource(object));
        return (MethodVisitor)super.caseGoto(object);
    }

    @Override
    public MethodVisitor caseIterate(Iterate object) {
        assert (this.ls.hasWithSource(object));
        Label hasNext = new Label();
        this.checkcast(Collection.class);
        this.invokeIface(Collection.class, "iterator", Iterator.class, new Object[0]);
        this.dup();
        this.invokeIface(Iterator.class, "hasNext", Type.BOOLEAN_TYPE, new Object[0]);
        this.ifne(hasNext);
        this.pop();
        this.goto_(this.ls.getFromSource(object));
        this.label(hasNext);
        this.dup();
        this.invokeIface(Iterator.class, "next", Object.class, new Object[0]);
        return (MethodVisitor)super.caseIterate(object);
    }

    @Override
    public MethodVisitor caseEnditerate(Enditerate object) {
        assert (this.ls.hasWithSource(object));
        Label hasNoNext = new Label();
        this.dup();
        this.invokeIface(Iterator.class, "hasNext", Type.BOOLEAN_TYPE, new Object[0]);
        this.ifeq(hasNoNext);
        this.dup();
        this.invokeIface(Iterator.class, "next", Object.class, new Object[0]);
        this.goto_(this.ls.getFromSource(object));
        this.label(hasNoNext);
        this.pop();
        return (MethodVisitor)super.caseEnditerate(object);
    }

    @Override
    public MethodVisitor caseInvoke(Invoke object) {
        this.generateSetPc(object);
        int argcount = object.getArgcount();
        switch (argcount) {
            case 0: {
                this.generateInvoke0(object);
                break;
            }
            case 1: {
                this.generateInvoke1(object);
                break;
            }
            default: {
                this.generateInvokeN(object, argcount);
            }
        }
        return (MethodVisitor)super.caseInvoke(object);
    }

    private void generateInvoke0(Invoke object) {
        Method method;
        int vmExceptionIdx;
        boolean hasOp = this.jit.getEnv().hasOperation(object.getOpname(), object.getArgcount());
        Label selfStart = new Label();
        Label selfEnd = new Label();
        int subframeIdx = hasOp ? 6 : 5;
        int exceptionIdx = vmExceptionIdx = subframeIdx + 1;
        this.label(selfStart);
        this.astore(4);
        if (hasOp) {
            Label ifOpNull = new Label();
            Label bodyStart = new Label();
            this.aload(2);
            this.aload(4);
            this.invokeStat(EMFTVMUtil.class, "getArgumentType", Object.class, Object.class);
            this.ldc(object.getOpname());
            this.invokeIface(ExecEnv.class, "findOperation", Operation.class, Object.class, String.class);
            this.dup();
            this.aload(4);
            this.ldc(object.getOpname());
            this.invokeStat(EMFTVMUtil.class, "findNativeMethod", Method.class, Operation.class, Object.class, String.class);
            this.astore(5);
            this.aload(5);
            this.ifnonnull(ifOpNull);
            this.dup();
            this.ifnull(ifOpNull);
            this.invokeIface(Operation.class, "getBody", CodeBlock.class, new Object[0]);
            this.label(bodyStart);
            this.astore(6);
            this.aload(6);
            this.aload(1);
            this.aload(6);
            this.aload(4);
            this.invokeVirt(StackFrame.class, "getSubFrame", StackFrame.class, CodeBlock.class, Object.class);
            this.invokeIface(CodeBlock.class, "execute", Object.class, StackFrame.class);
            this.goto_(selfEnd);
            this.label(ifOpNull);
            this.pop();
            this.localVariable("body", CodeBlock.class, bodyStart, ifOpNull, 6);
        }
        if ((method = EMFTVMUtil.findRootMethod(object.getNativeMethod())) != null) {
            Label subframeStart = new Label();
            Label tryStart = new Label();
            Label tryEnd = new Label();
            Label vmExceptionHandler = new Label();
            Label exceptionHandler = new Label();
            Label subframeNonNull = new Label();
            this.tryCatchBlock(tryStart, vmExceptionHandler, vmExceptionHandler, VMException.class);
            this.tryCatchBlock(tryStart, vmExceptionHandler, exceptionHandler, Exception.class);
            this.label(subframeStart);
            this.aconst_null();
            this.astore(subframeIdx);
            Class<?> dc = method.getDeclaringClass();
            if (!dc.equals(Object.class)) {
                this.aload(4);
                this.instanceof_(dc);
                this.ifeq(tryEnd);
            }
            this.label(tryStart);
            int opcode = dc.isInterface() ? 185 : 182;
            this.aload(4);
            if (!dc.equals(Object.class)) {
                this.checkcast(dc);
                if (CodeBlock.class.isAssignableFrom(dc)) {
                    this.generateSubFrame(method.toString());
                    this.astore(subframeIdx);
                    this.dup();
                    this.aload(subframeIdx);
                    this.invokeIface(CodeBlock.class, "setParentFrame", Type.VOID_TYPE, StackFrame.class);
                }
            }
            this.mv.visitMethodInsn(opcode, Type.getInternalName(dc), method.getName(), Type.getMethodDescriptor((Method)method));
            Class<?> rt = method.getReturnType();
            this.generateBoxing(rt, dc);
            this.goto_(selfEnd);
            this.label(vmExceptionHandler);
            this.astore(vmExceptionIdx);
            this.aload(vmExceptionIdx);
            this.athrow();
            this.label(exceptionHandler);
            this.astore(exceptionIdx);
            this.new_(VMException.class);
            this.dup();
            this.aload(subframeIdx);
            this.dup();
            this.ifnonnull(subframeNonNull);
            this.pop();
            this.generateSubFrame(method.toString());
            this.label(subframeNonNull);
            this.aload(exceptionIdx);
            this.invokeCons(VMException.class, StackFrame.class, Throwable.class);
            this.athrow();
            this.label(tryEnd);
            if (!dc.equals(Object.class)) {
                this.ldc("JIT miss for " + method.toString());
                this.invokeStat(ATLLogger.class, "info", Type.VOID_TYPE, String.class);
                this.aload(1);
                this.aload(4);
                this.ldc(object.getOpname());
                if (hasOp) {
                    this.aload(5);
                    this.invokeStat(JITCodeBlock.class, "invokeNative", Object.class, StackFrame.class, Object.class, String.class, Method.class);
                } else {
                    this.invokeStat(EMFTVMUtil.class, "invokeNative", Object.class, StackFrame.class, Object.class, String.class);
                }
            }
            this.label(selfEnd);
            this.localVariable("self", Object.class, selfStart, selfEnd, 4);
            if (hasOp) {
                this.localVariable("method", Method.class, selfStart, selfEnd, 5);
            }
            this.localVariable("subframe", StackFrame.class, subframeStart, selfEnd, subframeIdx);
            this.localVariable("e", VMException.class, vmExceptionHandler, exceptionHandler, vmExceptionIdx);
            this.localVariable("e", Exception.class, exceptionHandler, selfEnd, exceptionIdx);
        } else {
            this.aload(1);
            this.aload(4);
            this.ldc(object.getOpname());
            if (hasOp) {
                this.aload(5);
                this.invokeStat(JITCodeBlock.class, "invokeNative", Object.class, StackFrame.class, Object.class, String.class, Method.class);
            } else {
                this.invokeStat(EMFTVMUtil.class, "invokeNative", Object.class, StackFrame.class, Object.class, String.class);
            }
            this.label(selfEnd);
            this.localVariable("self", Object.class, selfStart, selfEnd, 4);
            if (hasOp) {
                this.localVariable("method", Method.class, selfStart, selfEnd, 5);
            }
        }
    }

    private void generateInvoke1(Invoke object) {
        Method method;
        int vmExceptionIdx;
        boolean hasOp = this.jit.getEnv().hasOperation(object.getOpname(), object.getArgcount());
        Label selfStart = new Label();
        Label selfEnd = new Label();
        int subframeIdx = hasOp ? 7 : 6;
        int exceptionIdx = vmExceptionIdx = subframeIdx + 1;
        this.label(selfStart);
        this.astore(5);
        this.astore(4);
        if (hasOp) {
            Label ifOpNull = new Label();
            Label bodyStart = new Label();
            this.aload(2);
            this.aload(4);
            this.invokeStat(EMFTVMUtil.class, "getArgumentType", Object.class, Object.class);
            this.ldc(object.getOpname());
            this.aload(5);
            this.invokeStat(EMFTVMUtil.class, "getArgumentType", Object.class, Object.class);
            this.invokeIface(ExecEnv.class, "findOperation", Operation.class, Object.class, String.class, Object.class);
            this.dup();
            this.aload(4);
            this.ldc(object.getOpname());
            this.aload(5);
            this.invokeStat(EMFTVMUtil.class, "findNativeMethod", Method.class, Operation.class, Object.class, String.class, Object.class);
            this.astore(6);
            this.aload(6);
            this.ifnonnull(ifOpNull);
            this.dup();
            this.ifnull(ifOpNull);
            this.invokeIface(Operation.class, "getBody", CodeBlock.class, new Object[0]);
            this.label(bodyStart);
            this.astore(7);
            this.aload(7);
            this.aload(1);
            this.aload(7);
            this.aload(4);
            this.aload(5);
            this.invokeVirt(StackFrame.class, "getSubFrame", StackFrame.class, CodeBlock.class, Object.class, Object.class);
            this.invokeIface(CodeBlock.class, "execute", Object.class, StackFrame.class);
            this.goto_(selfEnd);
            this.label(ifOpNull);
            this.pop();
            this.localVariable("body", CodeBlock.class, bodyStart, ifOpNull, 7);
        }
        if ((method = EMFTVMUtil.findRootMethod(object.getNativeMethod())) != null) {
            Class<?> pc;
            Label subframeStart = new Label();
            Label tryStart = new Label();
            Label tryEnd = new Label();
            Label vmExceptionHandler = new Label();
            Label exceptionHandler = new Label();
            Label subframeNonNull = new Label();
            this.tryCatchBlock(tryStart, vmExceptionHandler, vmExceptionHandler, VMException.class);
            this.tryCatchBlock(tryStart, vmExceptionHandler, exceptionHandler, Exception.class);
            this.label(subframeStart);
            this.aconst_null();
            this.astore(subframeIdx);
            Class<?> dc = method.getDeclaringClass();
            if (!dc.equals(Object.class)) {
                this.aload(4);
                this.instanceof_(dc);
                this.ifeq(tryEnd);
            }
            if (!(pc = method.getParameterTypes()[0]).equals(Object.class)) {
                this.aload(5);
                this.instanceof_(ByteCodeSwitch.boxed(pc));
                this.ifeq(tryEnd);
            }
            this.label(tryStart);
            int opcode = dc.isInterface() ? 185 : 182;
            if (CodeBlock.class.isAssignableFrom(dc) || CodeBlock.class.isAssignableFrom(pc)) {
                this.generateSubFrame(method.toString());
                this.astore(subframeIdx);
            }
            this.aload(4);
            if (!dc.equals(Object.class)) {
                this.checkcast(dc);
                if (CodeBlock.class.isAssignableFrom(dc)) {
                    this.dup();
                    this.aload(subframeIdx);
                    this.invokeIface(CodeBlock.class, "setParentFrame", Type.VOID_TYPE, StackFrame.class);
                }
            }
            this.aload(5);
            if (!pc.equals(Object.class)) {
                this.generateUnboxing(pc);
                if (CodeBlock.class.isAssignableFrom(pc)) {
                    this.dup();
                    this.aload(subframeIdx);
                    this.invokeIface(CodeBlock.class, "setParentFrame", Type.VOID_TYPE, StackFrame.class);
                }
            }
            this.mv.visitMethodInsn(opcode, Type.getInternalName(dc), method.getName(), Type.getMethodDescriptor((Method)method));
            Class<?> rt = method.getReturnType();
            this.generateBoxing(rt, dc);
            this.goto_(selfEnd);
            this.label(vmExceptionHandler);
            this.astore(vmExceptionIdx);
            this.aload(vmExceptionIdx);
            this.athrow();
            this.label(exceptionHandler);
            this.astore(exceptionIdx);
            this.new_(VMException.class);
            this.dup();
            this.aload(subframeIdx);
            this.dup();
            this.ifnonnull(subframeNonNull);
            this.pop();
            this.generateSubFrame(method.toString());
            this.label(subframeNonNull);
            this.aload(exceptionIdx);
            this.invokeCons(VMException.class, StackFrame.class, Throwable.class);
            this.athrow();
            this.label(tryEnd);
            if (!dc.equals(Object.class) || !pc.equals(Object.class)) {
                this.ldc("JIT miss for " + method.toString());
                this.invokeStat(ATLLogger.class, "info", Type.VOID_TYPE, String.class);
                this.aload(1);
                this.aload(4);
                this.ldc(object.getOpname());
                this.aload(5);
                if (hasOp) {
                    this.aload(6);
                    this.invokeStat(JITCodeBlock.class, "invokeNative", Object.class, StackFrame.class, Object.class, String.class, Object.class, Method.class);
                } else {
                    this.invokeStat(EMFTVMUtil.class, "invokeNative", Object.class, StackFrame.class, Object.class, String.class, Object.class);
                }
            }
            this.label(selfEnd);
            this.localVariable("self", Object.class, selfStart, selfEnd, 4);
            this.localVariable("arg", Object.class, selfStart, selfEnd, 5);
            if (hasOp) {
                this.localVariable("method", Method.class, selfStart, selfEnd, 6);
            }
            this.localVariable("subframe", StackFrame.class, subframeStart, selfEnd, subframeIdx);
            this.localVariable("e", VMException.class, vmExceptionHandler, exceptionHandler, vmExceptionIdx);
            this.localVariable("e", Exception.class, exceptionHandler, selfEnd, exceptionIdx);
        } else {
            this.aload(1);
            this.aload(4);
            this.ldc(object.getOpname());
            this.aload(5);
            if (hasOp) {
                this.aload(6);
                this.invokeStat(JITCodeBlock.class, "invokeNative", Object.class, StackFrame.class, Object.class, String.class, Object.class, Method.class);
            } else {
                this.invokeStat(EMFTVMUtil.class, "invokeNative", Object.class, StackFrame.class, Object.class, String.class, Object.class);
            }
            this.label(selfEnd);
            this.localVariable("self", Object.class, selfStart, selfEnd, 4);
            this.localVariable("arg", Object.class, selfStart, selfEnd, 5);
            if (hasOp) {
                this.localVariable("method", Method.class, selfStart, selfEnd, 6);
            }
        }
    }

    private void generateInvokeN(Invoke object, int argcount) {
        boolean hasOp = this.jit.getEnv().hasOperation(object.getOpname(), object.getArgcount());
        Label selfStart = new Label();
        Label selfEnd = new Label();
        this.generatePushInt(argcount);
        this.anewarray(Object.class);
        int i = 0;
        while (i < argcount) {
            this.dup_x1();
            this.swap();
            this.generatePushInt(argcount - 1 - i);
            this.swap();
            this.aastore();
            ++i;
        }
        this.label(selfStart);
        this.astore(5);
        this.astore(4);
        if (hasOp) {
            Label ifOpNull = new Label();
            Label bodyStart = new Label();
            this.aload(2);
            this.aload(4);
            this.invokeStat(EMFTVMUtil.class, "getArgumentType", Object.class, Object.class);
            this.ldc(object.getOpname());
            this.aload(5);
            this.invokeStat(EMFTVMUtil.class, "getArgumentTypes", Object[].class, Object[].class);
            this.invokeIface(ExecEnv.class, "findOperation", Operation.class, Object.class, String.class, Object[].class);
            this.dup();
            this.aload(4);
            this.ldc(object.getOpname());
            this.aload(5);
            this.invokeStat(EMFTVMUtil.class, "findNativeMethod", Method.class, Operation.class, Object.class, String.class, Object[].class);
            this.astore(6);
            this.aload(6);
            this.ifnonnull(ifOpNull);
            this.dup();
            this.ifnull(ifOpNull);
            this.invokeIface(Operation.class, "getBody", CodeBlock.class, new Object[0]);
            this.label(bodyStart);
            this.astore(7);
            this.aload(7);
            this.aload(1);
            this.aload(7);
            this.aload(4);
            this.aload(5);
            this.invokeVirt(StackFrame.class, "getSubFrame", StackFrame.class, CodeBlock.class, Object.class, Object[].class);
            this.invokeIface(CodeBlock.class, "execute", Object.class, StackFrame.class);
            this.goto_(selfEnd);
            this.label(ifOpNull);
            this.pop();
            this.localVariable("body", CodeBlock.class, bodyStart, ifOpNull, 7);
        }
        this.aload(1);
        this.aload(4);
        this.ldc(object.getOpname());
        this.aload(5);
        if (hasOp) {
            this.aload(6);
            this.invokeStat(JITCodeBlock.class, "invokeNative", Object.class, StackFrame.class, Object.class, String.class, Object[].class, Method.class);
        } else {
            this.invokeStat(EMFTVMUtil.class, "invokeNative", Object.class, StackFrame.class, Object.class, String.class, Object[].class);
        }
        this.label(selfEnd);
        this.localVariable("self", Object.class, selfStart, selfEnd, 4);
        this.localVariable("args", Object[].class, selfStart, selfEnd, 5);
        if (hasOp) {
            this.localVariable("method", Method.class, selfStart, selfEnd, 6);
        }
    }

    @Override
    public MethodVisitor caseInvokeSuper(InvokeSuper object) {
        Operation op = object.getOwningBlock().getOperation();
        if (op == null) {
            throw new IllegalArgumentException("INVOKE_SUPER can only be used in operations");
        }
        EClassifier context = op.getEContext();
        if (context == null) {
            throw new IllegalArgumentException(String.format("Operation misses context type: %s", op));
        }
        if (!(context instanceof EClass) && context.getInstanceClass() == null) {
            throw new IllegalArgumentException(String.format("Primitive EMF type without instance class %s", context));
        }
        this.generateSetPc(object);
        int argcount = object.getArgcount();
        switch (argcount) {
            case 0: {
                this.aload(0);
                if (!(context instanceof EClass)) {
                    this.getField(JITCodeBlock.class, "context", Class.class);
                    this.aload(1);
                    this.ldc(object.getOpname());
                    this.invokeStat(JITCodeBlock.class, "invokeSuper", Object.class, Object.class, Class.class, StackFrame.class, String.class);
                    break;
                }
                this.getField(JITCodeBlock.class, "eContext", EClass.class);
                this.aload(1);
                this.ldc(object.getOpname());
                this.invokeStat(JITCodeBlock.class, "invokeSuper", Object.class, Object.class, EClass.class, StackFrame.class, String.class);
                break;
            }
            case 1: {
                this.aload(0);
                if (!(context instanceof EClass)) {
                    this.getField(JITCodeBlock.class, "context", Class.class);
                    this.aload(1);
                    this.ldc(object.getOpname());
                    this.invokeStat(JITCodeBlock.class, "invokeSuper", Object.class, Object.class, Object.class, Class.class, StackFrame.class, String.class);
                    break;
                }
                this.getField(JITCodeBlock.class, "eContext", EClass.class);
                this.aload(1);
                this.ldc(object.getOpname());
                this.invokeStat(JITCodeBlock.class, "invokeSuper", Object.class, Object.class, Object.class, EClass.class, StackFrame.class, String.class);
                break;
            }
            default: {
                this.generatePushInt(argcount);
                this.anewarray(Object.class);
                int i = 0;
                while (i < argcount) {
                    this.dup_x1();
                    this.swap();
                    this.generatePushInt(argcount - 1 - i);
                    this.swap();
                    this.aastore();
                    ++i;
                }
                this.aload(0);
                if (!(context instanceof EClass)) {
                    this.getField(JITCodeBlock.class, "context", Class.class);
                    this.aload(1);
                    this.ldc(object.getOpname());
                    this.invokeStat(JITCodeBlock.class, "invokeSuper", Object.class, Object.class, Object[].class, Class.class, StackFrame.class, String.class);
                    break;
                }
                this.getField(JITCodeBlock.class, "eContext", EClass.class);
                this.aload(1);
                this.ldc(object.getOpname());
                this.invokeStat(JITCodeBlock.class, "invokeSuper", Object.class, Object.class, Object[].class, EClass.class, StackFrame.class, String.class);
            }
        }
        return (MethodVisitor)super.caseInvokeSuper(object);
    }

    @Override
    public MethodVisitor caseInvokeStatic(InvokeStatic object) {
        this.generateSetPc(object);
        int argcount = object.getArgcount();
        switch (argcount) {
            case 0: {
                this.aload(1);
                this.ldc(object.getOpname());
                this.invokeStat(JITCodeBlock.class, "invokeStatic", Object.class, Object.class, StackFrame.class, String.class);
                break;
            }
            case 1: {
                this.aload(1);
                this.ldc(object.getOpname());
                this.invokeStat(JITCodeBlock.class, "invokeStatic", Object.class, Object.class, Object.class, StackFrame.class, String.class);
                break;
            }
            default: {
                this.generatePushInt(argcount);
                this.anewarray(Object.class);
                int i = 0;
                while (i < argcount) {
                    this.dup_x1();
                    this.swap();
                    this.generatePushInt(argcount - 1 - i);
                    this.swap();
                    this.aastore();
                    ++i;
                }
                this.aload(1);
                this.ldc(object.getOpname());
                this.invokeStat(JITCodeBlock.class, "invokeStatic", Object.class, Object.class, Object[].class, StackFrame.class, String.class);
            }
        }
        return (MethodVisitor)super.caseInvokeStatic(object);
    }

    @Override
    public MethodVisitor caseAllinst(Allinst object) {
        this.checkcast(EClass.class);
        this.aload(2);
        this.invokeStat(EMFTVMUtil.class, "findAllInstances", LazyList.class, EClass.class, ExecEnv.class);
        return (MethodVisitor)super.caseAllinst(object);
    }

    @Override
    public MethodVisitor caseAllinstIn(AllinstIn object) {
        this.swap();
        this.checkcast(EClass.class);
        this.aload(2);
        this.invokeStat(EMFTVMUtil.class, "findAllInstIn", LazyList.class, Object.class, EClass.class, ExecEnv.class);
        return (MethodVisitor)super.caseAllinstIn(object);
    }

    @Override
    public MethodVisitor caseMatch(Match object) {
        this.generateSetPc(object);
        int argcount = object.getArgcount();
        switch (argcount) {
            case 0: {
                this.aload(1);
                this.ldc(object.getRulename());
                this.invokeStat(JITCodeBlock.class, "matchOne", Object.class, StackFrame.class, String.class);
                break;
            }
            default: {
                this.generatePushInt(argcount);
                this.anewarray(EObject.class);
                int i = 0;
                while (i < argcount) {
                    this.dup_x1();
                    this.swap();
                    this.checkcast(EObject.class);
                    this.generatePushInt(argcount - 1 - i);
                    this.swap();
                    this.aastore();
                    ++i;
                }
                this.aload(1);
                this.ldc(object.getRulename());
                this.invokeStat(JITCodeBlock.class, "matchOne", Object.class, Object[].class, StackFrame.class, String.class);
            }
        }
        return (MethodVisitor)super.caseMatch(object);
    }

    @Override
    public MethodVisitor caseMatchS(MatchS object) {
        this.generateSetPc(object);
        this.checkcast(Rule.class);
        int argcount = object.getArgcount();
        switch (argcount) {
            case 0: {
                this.aload(1);
                this.invokeStat(JITCodeBlock.class, "matchOne", Object.class, Rule.class, StackFrame.class);
                break;
            }
            default: {
                this.generatePushInt(argcount);
                this.anewarray(EObject.class);
                this.swap();
                int i = 0;
                while (i < argcount) {
                    this.dup_x2();
                    this.pop();
                    this.dup_x2();
                    this.swap();
                    this.checkcast(EObject.class);
                    this.generatePushInt(argcount - 1 - i);
                    this.swap();
                    this.aastore();
                    ++i;
                }
                this.aload(1);
                this.invokeStat(JITCodeBlock.class, "matchOne", Object.class, Object[].class, Rule.class, StackFrame.class);
            }
        }
        return (MethodVisitor)super.caseMatchS(object);
    }

    @Override
    public MethodVisitor caseAdd(Add object) {
        this.generatePushInt(-1);
        this.ldc(object.getFieldname());
        this.aload(0);
        this.getField(JITCodeBlock.class, "cb", CodeBlock.class);
        this.aload(1);
        this.invokeStat(JITCodeBlock.class, "add", Type.VOID_TYPE, Object.class, Object.class, Type.INT_TYPE, String.class, CodeBlock.class, StackFrame.class);
        return (MethodVisitor)super.caseAdd(object);
    }

    @Override
    public MethodVisitor caseRemove(Remove object) {
        this.ldc(object.getFieldname());
        this.aload(0);
        this.getField(JITCodeBlock.class, "cb", CodeBlock.class);
        this.aload(1);
        this.invokeStat(JITCodeBlock.class, "remove", Type.VOID_TYPE, Object.class, Object.class, String.class, CodeBlock.class, StackFrame.class);
        return (MethodVisitor)super.caseRemove(object);
    }

    @Override
    public MethodVisitor caseInsert(Insert object) {
        this.checkcast(Integer.class);
        this.invokeVirt(Integer.class, "intValue", Type.INT_TYPE, new Object[0]);
        this.ldc(object.getFieldname());
        this.getField(JITCodeBlock.class, "cb", CodeBlock.class);
        this.aload(1);
        this.invokeStat(JITCodeBlock.class, "add", Type.VOID_TYPE, Object.class, Object.class, Type.INT_TYPE, String.class, CodeBlock.class, StackFrame.class);
        return (MethodVisitor)super.caseInsert(object);
    }

    @Override
    public MethodVisitor caseGetSuper(GetSuper object) {
        Field fieldCtx = object.getOwningBlock().getField();
        if (fieldCtx == null) {
            throw new IllegalArgumentException("GET_SUPER can only be used in fields");
        }
        EClassifier context = fieldCtx.getEContext();
        if (context == null) {
            throw new IllegalArgumentException(String.format("Field misses context type: %s", fieldCtx));
        }
        if (!(context instanceof EClass) && context.getInstanceClass() == null) {
            throw new IllegalArgumentException(String.format("Primitive EMF type without instance class %s", context));
        }
        this.generateSetPc(object);
        this.aload(0);
        if (!(context instanceof EClass)) {
            this.getField(JITCodeBlock.class, "context", Class.class);
            this.ldc(object.getFieldname());
            this.aload(1);
            this.invokeStat(JITCodeBlock.class, "getSuper", Object.class, Object.class, Class.class, String.class, StackFrame.class);
        } else {
            this.getField(JITCodeBlock.class, "eContext", EClass.class);
            this.ldc(object.getFieldname());
            this.aload(1);
            this.invokeStat(JITCodeBlock.class, "getSuper", Object.class, Object.class, EClass.class, String.class, StackFrame.class);
        }
        return (MethodVisitor)super.caseGetSuper(object);
    }

    @Override
    public MethodVisitor caseGetenv(Getenv object) {
        this.aload(2);
        return (MethodVisitor)super.caseGetenv(object);
    }

    @Override
    public MethodVisitor caseReturn(Return object) {
        this.aload(1);
        this.areturn();
        return (MethodVisitor)super.caseReturn(object);
    }

    @Override
    public MethodVisitor caseGetcb(Getcb object) {
        this.aload(0);
        this.getField(JITCodeBlock.class, "cb", CodeBlock.class);
        this.invokeIface(CodeBlock.class, "getNested", EList.class, new Object[0]);
        this.generatePushInt(object.getCbIndex());
        this.invokeIface(EList.class, "get", Object.class, Type.INT_TYPE);
        return (MethodVisitor)super.caseGetcb(object);
    }

    @Override
    public MethodVisitor caseInvokeAllCbs(InvokeAllCbs object) {
        EList<CodeBlock> nested = object.getOwningBlock().getNested();
        Label argStart = new Label();
        Label loopStart = new Label();
        Label loopEnd = new Label();
        this.generateSetPc(object);
        int argcount = object.getArgcount();
        switch (argcount) {
            case 0: {
                this.aload(0);
                this.getField(JITCodeBlock.class, "nested", EList.class);
                this.label(loopStart);
                int i = 0;
                while (i < nested.size()) {
                    this.dup();
                    this.generatePushInt(i);
                    this.invokeIface(EList.class, "get", Object.class, Type.INT_TYPE);
                    this.checkcast(CodeBlock.class);
                    this.astore(4);
                    this.aload(4);
                    this.new_(StackFrame.class);
                    this.dup();
                    this.aload(1);
                    this.aload(4);
                    this.invokeCons(StackFrame.class, StackFrame.class, CodeBlock.class);
                    this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
                    if (((CodeBlock)nested.get(i)).getStackLevel() > 0) {
                        this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
                        this.swap();
                    } else {
                        this.pop();
                    }
                    ++i;
                }
                this.label(loopEnd);
                this.pop();
                break;
            }
            case 1: {
                this.label(argStart);
                this.astore(5);
                this.aload(0);
                this.getField(JITCodeBlock.class, "nested", EList.class);
                this.label(loopStart);
                int i = 0;
                while (i < nested.size()) {
                    this.dup();
                    this.generatePushInt(i);
                    this.invokeIface(EList.class, "get", Object.class, Type.INT_TYPE);
                    this.checkcast(CodeBlock.class);
                    this.astore(4);
                    this.aload(4);
                    this.aload(1);
                    this.aload(4);
                    this.aload(5);
                    this.invokeVirt(StackFrame.class, "getSubFrame", StackFrame.class, CodeBlock.class, Object.class);
                    this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
                    if (((CodeBlock)nested.get(i)).getStackLevel() > 0) {
                        this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
                        this.swap();
                    } else {
                        this.pop();
                    }
                    ++i;
                }
                this.label(loopEnd);
                this.pop();
                this.localVariable("arg", Object.class, argStart, loopEnd, 5);
                break;
            }
            default: {
                this.generatePushInt(argcount);
                this.anewarray(Object.class);
                int i = 0;
                while (i < argcount) {
                    this.dup_x1();
                    this.swap();
                    this.generatePushInt(argcount - 1 - i);
                    this.swap();
                    this.aastore();
                    ++i;
                }
                this.label(argStart);
                this.astore(5);
                this.aload(0);
                this.getField(JITCodeBlock.class, "nested", EList.class);
                this.label(loopStart);
                i = 0;
                while (i < nested.size()) {
                    this.dup();
                    this.generatePushInt(i);
                    this.invokeIface(EList.class, "get", Object.class, Type.INT_TYPE);
                    this.checkcast(CodeBlock.class);
                    this.astore(4);
                    this.aload(4);
                    this.aload(1);
                    this.aload(4);
                    this.aload(5);
                    this.invokeVirt(StackFrame.class, "getSubFrame", StackFrame.class, CodeBlock.class, Object[].class);
                    this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
                    if (((CodeBlock)nested.get(i)).getStackLevel() > 0) {
                        this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
                        this.swap();
                    } else {
                        this.pop();
                    }
                    ++i;
                }
                this.label(loopEnd);
                this.pop();
                this.localVariable("args", Object[].class, argStart, loopEnd, 5);
            }
        }
        this.localVariable("ncb", CodeBlock.class, loopStart, loopEnd, 4);
        return (MethodVisitor)super.caseInvokeAllCbs(object);
    }

    @Override
    public MethodVisitor caseInvokeCb(InvokeCb object) {
        Label argStart = new Label();
        Label ncbStart = new Label();
        Label ncbEnd = new Label();
        this.generateSetPc(object);
        int argcount = object.getArgcount();
        switch (argcount) {
            case 0: {
                this.aload(0);
                this.getField(JITCodeBlock.class, "nested", EList.class);
                this.generatePushInt(object.getCbIndex());
                this.invokeIface(EList.class, "get", Object.class, Type.INT_TYPE);
                this.checkcast(CodeBlock.class);
                this.label(ncbStart);
                this.astore(4);
                this.aload(4);
                this.new_(StackFrame.class);
                this.dup();
                this.aload(1);
                this.aload(4);
                this.invokeCons(StackFrame.class, StackFrame.class, CodeBlock.class);
                this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
                if (object.getCodeBlock().getStackLevel() > 0) {
                    this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
                } else {
                    this.pop();
                }
                this.label(ncbEnd);
                break;
            }
            case 1: {
                this.label(argStart);
                this.astore(5);
                this.aload(0);
                this.getField(JITCodeBlock.class, "nested", EList.class);
                this.generatePushInt(object.getCbIndex());
                this.invokeIface(EList.class, "get", Object.class, Type.INT_TYPE);
                this.checkcast(CodeBlock.class);
                this.label(ncbStart);
                this.astore(4);
                this.aload(4);
                this.aload(1);
                this.aload(4);
                this.aload(5);
                this.invokeVirt(StackFrame.class, "getSubFrame", StackFrame.class, CodeBlock.class, Object.class);
                this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
                if (object.getCodeBlock().getStackLevel() > 0) {
                    this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
                } else {
                    this.pop();
                }
                this.label(ncbEnd);
                this.localVariable("arg", Object.class, argStart, ncbEnd, 5);
                break;
            }
            default: {
                this.generatePushInt(argcount);
                this.anewarray(Object.class);
                int i = 0;
                while (i < argcount) {
                    this.dup_x1();
                    this.swap();
                    this.generatePushInt(argcount - 1 - i);
                    this.swap();
                    this.aastore();
                    ++i;
                }
                this.label(argStart);
                this.astore(5);
                this.aload(0);
                this.getField(JITCodeBlock.class, "nested", EList.class);
                this.generatePushInt(object.getCbIndex());
                this.invokeIface(EList.class, "get", Object.class, Type.INT_TYPE);
                this.checkcast(CodeBlock.class);
                this.label(ncbStart);
                this.astore(4);
                this.aload(4);
                this.aload(1);
                this.aload(4);
                this.aload(5);
                this.invokeVirt(StackFrame.class, "getSubFrame", StackFrame.class, CodeBlock.class, Object[].class);
                this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
                if (object.getCodeBlock().getStackLevel() > 0) {
                    this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
                } else {
                    this.pop();
                }
                this.label(ncbEnd);
                this.localVariable("args", Object[].class, argStart, ncbEnd, 5);
            }
        }
        this.localVariable("ncb", CodeBlock.class, ncbStart, ncbEnd, 4);
        return this.caseInvokeCb(object);
    }

    @Override
    public MethodVisitor caseInvokeCbS(InvokeCbS object) {
        Label argStart = new Label();
        Label ncbStart = new Label();
        Label ncbEnd = new Label();
        Label stackEmpty = new Label();
        this.generateSetPc(object);
        int argcount = object.getArgcount();
        switch (argcount) {
            case 0: {
                this.checkcast(CodeBlock.class);
                this.label(ncbStart);
                this.astore(4);
                this.aload(4);
                this.new_(StackFrame.class);
                this.dup();
                this.aload(1);
                this.aload(4);
                this.invokeCons(StackFrame.class, StackFrame.class, CodeBlock.class);
                this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
                this.dup();
                this.invokeVirt(StackFrame.class, "stackEmpty", Type.BOOLEAN_TYPE, new Object[0]);
                this.ifne(stackEmpty);
                this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
                this.goto_(ncbEnd);
                this.label(stackEmpty);
                this.pop();
                this.aconst_null();
                this.label(ncbEnd);
                break;
            }
            case 1: {
                this.checkcast(CodeBlock.class);
                this.label(ncbStart);
                this.astore(4);
                this.label(argStart);
                this.astore(5);
                this.aload(4);
                this.aload(1);
                this.aload(4);
                this.aload(5);
                this.invokeVirt(StackFrame.class, "getSubFrame", StackFrame.class, CodeBlock.class, Object.class);
                this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
                this.dup();
                this.invokeVirt(StackFrame.class, "stackEmpty", Type.BOOLEAN_TYPE, new Object[0]);
                this.ifne(stackEmpty);
                this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
                this.goto_(ncbEnd);
                this.label(stackEmpty);
                this.pop();
                this.aconst_null();
                this.label(ncbEnd);
                this.localVariable("arg", Object.class, argStart, ncbEnd, 5);
                break;
            }
            default: {
                this.checkcast(CodeBlock.class);
                this.label(ncbStart);
                this.astore(4);
                this.generatePushInt(argcount);
                this.anewarray(Object.class);
                int i = 0;
                while (i < argcount) {
                    this.dup_x1();
                    this.swap();
                    this.generatePushInt(argcount - 1 - i);
                    this.swap();
                    this.aastore();
                    ++i;
                }
                this.label(argStart);
                this.astore(5);
                this.aload(4);
                this.aload(1);
                this.aload(4);
                this.aload(5);
                this.invokeVirt(StackFrame.class, "getSubFrame", StackFrame.class, CodeBlock.class, Object[].class);
                this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
                this.dup();
                this.invokeVirt(StackFrame.class, "stackEmpty", Type.BOOLEAN_TYPE, new Object[0]);
                this.ifne(stackEmpty);
                this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
                this.goto_(ncbEnd);
                this.label(stackEmpty);
                this.pop();
                this.aconst_null();
                this.label(ncbEnd);
                this.localVariable("args", Object[].class, argStart, ncbEnd, 5);
            }
        }
        this.localVariable("ncb", CodeBlock.class, ncbStart, ncbEnd, 4);
        return this.caseInvokeCbS(object);
    }

    @Override
    public MethodVisitor caseNot(Not object) {
        Label ifFalse = new Label();
        Label ifEnd = new Label();
        this.checkcast(Boolean.class);
        this.invokeVirt(Boolean.class, "booleanValue", Type.BOOLEAN_TYPE, new Object[0]);
        this.ifeq(ifFalse);
        this.iconst_0();
        this.goto_(ifEnd);
        this.label(ifFalse);
        this.iconst_1();
        this.label(ifEnd);
        this.invokeStat(Boolean.class, "valueOf", Boolean.class, Type.BOOLEAN_TYPE);
        return (MethodVisitor)super.caseNot(object);
    }

    @Override
    public MethodVisitor caseAnd(And object) {
        Label ifFalse = new Label();
        Label ncbStart = new Label();
        Label ncbEnd = new Label();
        Label ifEnd = new Label();
        this.checkcast(Boolean.class);
        this.invokeVirt(Boolean.class, "booleanValue", Type.BOOLEAN_TYPE, new Object[0]);
        this.ifeq(ifFalse);
        this.generateSetPc(object);
        this.aload(0);
        this.getField(JITCodeBlock.class, "nested", EList.class);
        this.generatePushInt(object.getCbIndex());
        this.invokeIface(EList.class, "get", Object.class, Type.INT_TYPE);
        this.checkcast(CodeBlock.class);
        this.label(ncbStart);
        this.astore(4);
        this.aload(4);
        this.new_(StackFrame.class);
        this.dup();
        this.aload(1);
        this.aload(4);
        this.invokeCons(StackFrame.class, StackFrame.class, CodeBlock.class);
        this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
        this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
        this.label(ncbEnd);
        this.goto_(ifEnd);
        this.label(ifFalse);
        this.iconst_0();
        this.invokeStat(Boolean.class, "valueOf", Boolean.class, Type.BOOLEAN_TYPE);
        this.label(ifEnd);
        this.localVariable("ncb", CodeBlock.class, ncbStart, ncbEnd, 4);
        return this.caseAnd(object);
    }

    @Override
    public MethodVisitor caseOr(Or object) {
        Label ifTrue = new Label();
        Label ncbStart = new Label();
        Label ncbEnd = new Label();
        Label ifEnd = new Label();
        this.checkcast(Boolean.class);
        this.invokeVirt(Boolean.class, "booleanValue", Type.BOOLEAN_TYPE, new Object[0]);
        this.ifne(ifTrue);
        this.generateSetPc(object);
        this.aload(0);
        this.getField(JITCodeBlock.class, "nested", EList.class);
        this.generatePushInt(object.getCbIndex());
        this.invokeIface(EList.class, "get", Object.class, Type.INT_TYPE);
        this.checkcast(CodeBlock.class);
        this.label(ncbStart);
        this.astore(4);
        this.aload(4);
        this.new_(StackFrame.class);
        this.dup();
        this.aload(1);
        this.aload(4);
        this.invokeCons(StackFrame.class, StackFrame.class, CodeBlock.class);
        this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
        this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
        this.label(ncbEnd);
        this.goto_(ifEnd);
        this.label(ifTrue);
        this.iconst_1();
        this.invokeStat(Boolean.class, "valueOf", Boolean.class, Type.BOOLEAN_TYPE);
        this.label(ifEnd);
        this.localVariable("ncb", CodeBlock.class, ncbStart, ncbEnd, 4);
        return (MethodVisitor)super.caseOr(object);
    }

    @Override
    public MethodVisitor caseXor(Xor object) {
        Label ifFirstFalse = new Label();
        Label ifFalse = new Label();
        Label ifEnd = new Label();
        this.checkcast(Boolean.class);
        this.invokeVirt(Boolean.class, "booleanValue", Type.BOOLEAN_TYPE, new Object[0]);
        this.ifeq(ifFirstFalse);
        this.checkcast(Boolean.class);
        this.invokeVirt(Boolean.class, "booleanValue", Type.BOOLEAN_TYPE, new Object[0]);
        this.ifeq(ifFalse);
        this.iconst_0();
        this.goto_(ifEnd);
        this.label(ifFalse);
        this.iconst_1();
        this.label(ifEnd);
        this.invokeStat(Boolean.class, "valueOf", Boolean.class, Type.BOOLEAN_TYPE);
        this.label(ifFirstFalse);
        return (MethodVisitor)super.caseXor(object);
    }

    @Override
    public MethodVisitor caseImplies(Implies object) {
        Label ifFalse = new Label();
        Label ncbStart = new Label();
        Label ncbEnd = new Label();
        Label ifEnd = new Label();
        this.checkcast(Boolean.class);
        this.invokeVirt(Boolean.class, "booleanValue", Type.BOOLEAN_TYPE, new Object[0]);
        this.ifeq(ifFalse);
        this.generateSetPc(object);
        this.aload(0);
        this.getField(JITCodeBlock.class, "nested", EList.class);
        this.generatePushInt(object.getCbIndex());
        this.invokeIface(EList.class, "get", Object.class, Type.INT_TYPE);
        this.checkcast(CodeBlock.class);
        this.label(ncbStart);
        this.astore(4);
        this.aload(4);
        this.new_(StackFrame.class);
        this.dup();
        this.aload(1);
        this.aload(4);
        this.invokeCons(StackFrame.class, StackFrame.class, CodeBlock.class);
        this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
        this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
        this.label(ncbEnd);
        this.goto_(ifEnd);
        this.label(ifFalse);
        this.iconst_1();
        this.invokeStat(Boolean.class, "valueOf", Boolean.class, Type.BOOLEAN_TYPE);
        this.label(ifEnd);
        this.localVariable("ncb", CodeBlock.class, ncbStart, ncbEnd, 4);
        return (MethodVisitor)super.caseImplies(object);
    }

    @Override
    public MethodVisitor caseIfte(Ifte object) {
        Label thenCbStart = new Label();
        Label thenCbEnd = new Label();
        Label ifFalse = new Label();
        Label elseCbStart = new Label();
        Label elseCbEnd = new Label();
        Label ifEnd = new Label();
        this.generateSetPc(object);
        this.checkcast(Boolean.class);
        this.invokeVirt(Boolean.class, "booleanValue", Type.BOOLEAN_TYPE, new Object[0]);
        this.ifeq(ifFalse);
        this.aload(0);
        this.getField(JITCodeBlock.class, "nested", EList.class);
        this.generatePushInt(object.getThenCbIndex());
        this.invokeIface(EList.class, "get", Object.class, Type.INT_TYPE);
        this.checkcast(CodeBlock.class);
        this.label(thenCbStart);
        this.astore(4);
        this.aload(4);
        this.new_(StackFrame.class);
        this.dup();
        this.aload(1);
        this.aload(4);
        this.invokeCons(StackFrame.class, StackFrame.class, CodeBlock.class);
        this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
        this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
        this.label(thenCbEnd);
        this.goto_(ifEnd);
        this.label(ifFalse);
        this.aload(0);
        this.getField(JITCodeBlock.class, "nested", EList.class);
        this.generatePushInt(object.getElseCbIndex());
        this.invokeIface(EList.class, "get", Object.class, Type.INT_TYPE);
        this.checkcast(CodeBlock.class);
        this.label(elseCbStart);
        this.astore(4);
        this.aload(4);
        this.new_(StackFrame.class);
        this.dup();
        this.aload(1);
        this.aload(4);
        this.invokeCons(StackFrame.class, StackFrame.class, CodeBlock.class);
        this.invokeIface(CodeBlock.class, "execute", StackFrame.class, StackFrame.class);
        this.invokeVirt(StackFrame.class, "pop", Object.class, new Object[0]);
        this.label(elseCbEnd);
        this.label(ifEnd);
        this.localVariable("thenCb", CodeBlock.class, thenCbStart, thenCbEnd, 4);
        this.localVariable("elseCb", CodeBlock.class, elseCbStart, elseCbEnd, 4);
        return (MethodVisitor)super.caseIfte(object);
    }

    @Override
    public MethodVisitor caseIsnull(Isnull object) {
        Label ifNull = new Label();
        Label ifEnd = new Label();
        this.ifnull(ifNull);
        this.iconst_0();
        this.goto_(ifEnd);
        this.label(ifNull);
        this.iconst_1();
        this.label(ifEnd);
        this.invokeStat(Boolean.class, "valueOf", Boolean.class, Type.BOOLEAN_TYPE);
        return (MethodVisitor)super.caseIsnull(object);
    }

    @Override
    public MethodVisitor caseGetenvtype(Getenvtype object) {
        this.getStatic(JITCodeBlock.class, "EXEC_ENV", EClass.class);
        return (MethodVisitor)super.caseGetenvtype(object);
    }

    protected void generateSetPc(Instruction object) {
        if (!this.hasMonitor) {
            this.aload(1);
            int pc = object.getOwningBlock().getCode().indexOf((Object)object) + 1;
            this.generatePushInt(pc);
            this.invokeVirt(StackFrame.class, "setPc", Type.VOID_TYPE, Type.INT_TYPE);
        }
    }

    protected void generateSubFrame(String opname) {
        this.new_(StackFrame.class);
        this.dup();
        this.aload(1);
        this.ldc(opname);
        this.invokeCons(StackFrame.class, StackFrame.class, String.class);
    }

    protected void generateBoxing(Class<?> cls, Class<?> selfCls) {
        Class<?> cType;
        if (cls == Void.TYPE) {
            this.mv.visitInsn(1);
        } else if (cls == Boolean.TYPE) {
            this.invokeStat(Boolean.class, "valueOf", Boolean.class, Type.BOOLEAN_TYPE);
        } else if (cls == Character.TYPE) {
            this.invokeStat(Character.class, "valueOf", Character.class, Type.CHAR_TYPE);
        } else if (cls == Byte.TYPE) {
            this.invokeStat(Byte.class, "valueOf", Byte.class, Type.BYTE_TYPE);
        } else if (cls == Short.TYPE) {
            this.invokeStat(Short.class, "valueOf", Short.class, Type.SHORT_TYPE);
        } else if (cls == Integer.TYPE) {
            this.invokeStat(Integer.class, "valueOf", Integer.class, Type.INT_TYPE);
        } else if (cls == Long.TYPE) {
            this.invokeStat(Long.class, "valueOf", Long.class, Type.LONG_TYPE);
        } else if (cls == Float.TYPE) {
            this.invokeStat(Float.class, "valueOf", Float.class, Type.FLOAT_TYPE);
        } else if (cls == Double.TYPE) {
            this.invokeStat(Double.class, "valueOf", Double.class, Type.DOUBLE_TYPE);
        } else if (Enumerator.class.isAssignableFrom(cls)) {
            this.invokeVirt(Object.class, "toString", String.class, new Object[0]);
            this.new_(EnumLiteral.class);
            this.dup_x1();
            this.swap();
            this.invokeCons(EnumLiteral.class, String.class);
        } else if (Collection.class.isAssignableFrom(cls)) {
            if (!LazyCollection.class.isAssignableFrom(cls)) {
                if (List.class.isAssignableFrom(cls)) {
                    this.new_(EnumConversionListOnList.class);
                    this.dup_x1();
                    this.swap();
                    this.invokeCons(EnumConversionListOnList.class, List.class);
                    if (EObject.class.isAssignableFrom(selfCls)) {
                        Label ifModelNull = new Label();
                        this.aload(2);
                        this.aload(4);
                        this.invokeIface(ExecEnv.class, "getInoutModelOf", Model.class, EObject.class);
                        this.ifnull(ifModelNull);
                        this.invokeVirt(EnumConversionList.class, "cache", EnumConversionList.class, new Object[0]);
                        this.label(ifModelNull);
                    }
                } else if (java.util.Set.class.isAssignableFrom(cls)) {
                    this.new_(EnumConversionSetOnSet.class);
                    this.dup_x1();
                    this.swap();
                    this.invokeCons(EnumConversionSetOnSet.class, java.util.Set.class);
                    if (EObject.class.isAssignableFrom(selfCls)) {
                        Label ifModelNull = new Label();
                        this.aload(2);
                        this.aload(4);
                        this.invokeIface(ExecEnv.class, "getInoutModelOf", Model.class, EObject.class);
                        this.ifnull(ifModelNull);
                        this.invokeVirt(EnumConversionSetOnSet.class, "cache", EnumConversionSetOnSet.class, new Object[0]);
                        this.label(ifModelNull);
                    }
                } else {
                    this.new_(EnumConversionList.class);
                    this.dup_x1();
                    this.swap();
                    this.invokeCons(EnumConversionList.class, Collection.class);
                    if (EObject.class.isAssignableFrom(selfCls)) {
                        Label ifModelNull = new Label();
                        this.aload(2);
                        this.aload(4);
                        this.invokeIface(ExecEnv.class, "getInoutModelOf", Model.class, EObject.class);
                        this.ifnull(ifModelNull);
                        this.invokeVirt(EnumConversionList.class, "cache", EnumConversionList.class, new Object[0]);
                        this.label(ifModelNull);
                    }
                }
            }
        } else if (cls.isArray() && Object.class.isAssignableFrom(cType = cls.getComponentType())) {
            Label ifNull = new Label();
            this.dup();
            this.ifnull(ifNull);
            this.invokeStat(Arrays.class, "asList", List.class, Object[].class);
            this.new_(LazyListOnList.class);
            this.dup_x1();
            this.swap();
            this.invokeCons(LazyListOnList.class, List.class);
            this.label(ifNull);
        }
    }

    protected void generateUnboxing(Class<?> cls) {
        if (cls == Boolean.TYPE) {
            this.checkcast(Boolean.class);
            this.invokeVirt(Boolean.class, "booleanValue", Type.BOOLEAN_TYPE, new Object[0]);
        } else if (cls == Character.TYPE) {
            this.checkcast(Character.class);
            this.invokeVirt(Character.class, "charValue", Type.CHAR_TYPE, new Object[0]);
        } else if (cls == Byte.TYPE) {
            this.checkcast(Byte.class);
            this.invokeVirt(Byte.class, "byteValue", Type.BYTE_TYPE, new Object[0]);
        } else if (cls == Short.TYPE) {
            this.checkcast(Short.class);
            this.invokeVirt(Short.class, "shortValue", Type.SHORT_TYPE, new Object[0]);
        } else if (cls == Integer.TYPE) {
            this.checkcast(Integer.class);
            this.invokeVirt(Integer.class, "intValue", Type.INT_TYPE, new Object[0]);
        } else if (cls == Long.TYPE) {
            this.checkcast(Long.class);
            this.invokeVirt(Long.class, "longValue", Type.LONG_TYPE, new Object[0]);
        } else if (cls == Float.TYPE) {
            this.checkcast(Float.class);
            this.invokeVirt(Float.class, "floatValue", Type.FLOAT_TYPE, new Object[0]);
        } else if (cls == Double.TYPE) {
            this.checkcast(Double.class);
            this.invokeVirt(Double.class, "doubleValue", Type.DOUBLE_TYPE, new Object[0]);
        } else if (Enumerator.class.isAssignableFrom(cls)) {
            this.checkcast(EnumLiteral.class);
            this.invokeVirt(EnumLiteral.class, "getName", String.class, new Object[0]);
            this.invokeStat(cls, "getByName", cls, String.class);
        } else {
            this.checkcast(cls);
        }
    }

    protected void generatePushInt(int value) {
        CodeBlockJIT.generatePushInt(this.mv, value);
    }

    protected void label(Label label) {
        this.mv.visitLabel(label);
    }

    protected void aload(int var) {
        this.mv.visitVarInsn(25, var);
    }

    protected void astore(int var) {
        this.mv.visitVarInsn(58, var);
    }

    protected void new_(Class<?> cls) {
        this.mv.visitTypeInsn(187, Type.getInternalName(cls));
    }

    protected void checkcast(Class<?> cls) {
        this.mv.visitTypeInsn(192, Type.getInternalName(cls));
    }

    protected void instanceof_(Class<?> cls) {
        this.mv.visitTypeInsn(193, Type.getInternalName(cls));
    }

    protected void anewarray(Class<?> cls) {
        this.mv.visitTypeInsn(189, Type.getInternalName(cls));
    }

    protected void dup() {
        this.mv.visitInsn(89);
    }

    protected void dup_x1() {
        this.mv.visitInsn(90);
    }

    protected void dup_x2() {
        this.mv.visitInsn(91);
    }

    protected void pop() {
        this.mv.visitInsn(87);
    }

    protected void swap() {
        this.mv.visitInsn(95);
    }

    protected void ldc(Object object) {
        this.mv.visitLdcInsn(object);
    }

    protected void aconst_null() {
        this.mv.visitInsn(1);
    }

    protected void aastore() {
        this.mv.visitInsn(83);
    }

    protected void areturn() {
        this.mv.visitInsn(176);
    }

    protected void iconst_1() {
        this.mv.visitInsn(4);
    }

    protected void iconst_0() {
        this.mv.visitInsn(3);
    }

    protected void invoke(int opcode, Class<?> owner, String name, Object retType, Object ... argTypes) {
        Type[] ats = new Type[argTypes.length];
        int i = 0;
        while (i < argTypes.length) {
            ats[i] = argTypes[i] instanceof Type ? (Type)argTypes[i] : Type.getType((Class)((Class)argTypes[i]));
            ++i;
        }
        this.mv.visitMethodInsn(opcode, Type.getInternalName(owner), name, Type.getMethodDescriptor((Type)(retType instanceof Type ? (Type)retType : Type.getType((Class)((Class)retType))), (Type[])ats));
    }

    protected void invokeIface(Class<?> owner, String name, Object retType, Object ... argTypes) {
        this.invoke(185, owner, name, retType, argTypes);
    }

    protected void invokeVirt(Class<?> owner, String name, Object retType, Object ... argTypes) {
        this.invoke(182, owner, name, retType, argTypes);
    }

    protected void invokeStat(Class<?> owner, String name, Object retType, Object ... argTypes) {
        this.invoke(184, owner, name, retType, argTypes);
    }

    protected void invokeSpec(Class<?> owner, String name, Object retClass, Object ... argClasses) {
        this.invoke(183, owner, name, retClass, argClasses);
    }

    protected void invokeCons(Class<?> owner, Object ... argTypes) {
        this.invoke(183, owner, "<init>", Type.VOID_TYPE, argTypes);
    }

    protected void field(int opcode, Class<?> owner, String name, Object type) {
        this.mv.visitFieldInsn(opcode, Type.getInternalName(owner), name, type instanceof Type ? ((Type)type).getDescriptor() : Type.getDescriptor((Class)((Class)type)));
    }

    protected void getField(Class<?> owner, String name, Object type) {
        this.field(180, owner, name, type);
    }

    protected void putField(Class<?> owner, String name, Object type) {
        this.field(181, owner, name, type);
    }

    protected void getStatic(Class<?> owner, String name, Object type) {
        this.field(178, owner, name, type);
    }

    protected void putStatic(Class<?> owner, String name, Object type) {
        this.field(179, owner, name, type);
    }

    protected void ifne(Label label) {
        this.mv.visitJumpInsn(154, label);
    }

    protected void ifeq(Label label) {
        this.mv.visitJumpInsn(153, label);
    }

    protected void goto_(Label label) {
        this.mv.visitJumpInsn(167, label);
    }

    protected void ifnull(Label label) {
        this.mv.visitJumpInsn(198, label);
    }

    protected void ifnonnull(Label label) {
        this.mv.visitJumpInsn(199, label);
    }

    protected void athrow() {
        this.mv.visitInsn(191);
    }

    protected void localVariable(String name, Class<?> type, Label start, Label end, int index) {
        this.mv.visitLocalVariable(name, Type.getDescriptor(type), null, start, end, index);
    }

    protected void tryCatchBlock(Label start, Label end, Label handler, Class<?> type) {
        this.mv.visitTryCatchBlock(start, end, handler, Type.getInternalName(type));
    }

    protected Instruction nextInstruction(Instruction instruction) {
        EList<Instruction> code = instruction.getOwningBlock().getCode();
        int index = code.indexOf(instruction);
        if (index < code.size() - 1) {
            return (Instruction)code.get(index + 1);
        }
        return null;
    }
}

