/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.jit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.Operation;
import org.eclipse.m2m.atl.emftvm.Rule;
import org.eclipse.m2m.atl.emftvm.RuleMode;
import org.eclipse.m2m.atl.emftvm.util.DuplicateEntryException;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.LazyBagOnCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.LazyListOnList;
import org.eclipse.m2m.atl.emftvm.util.LazySetOnSet;
import org.eclipse.m2m.atl.emftvm.util.NativeTypes;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.Tuple;
import org.eclipse.m2m.atl.emftvm.util.VMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JITCodeBlock {
    protected static final EClass EXEC_ENV = EmftvmPackage.eINSTANCE.getExecEnv();
    private static final Object[] EMPTY = new Object[0];
    protected final CodeBlock cb;
    protected final EList<CodeBlock> nested;
    protected final EClass eContext;
    protected final Class<?> context;

    public JITCodeBlock(CodeBlock cb) {
        Field f;
        this.cb = cb;
        this.nested = cb.getNested();
        Operation op = cb.getOperation();
        Object ec = op != null ? op.getEContext() : ((f = cb.getField()) != null ? f.getEContext() : null);
        this.eContext = ec instanceof EClass ? (EClass)ec : null;
        this.context = ec != null ? ec.getInstanceClass() : null;
    }

    public abstract Object execute(StackFrame var1);

    protected static void set(Object o, Object v, CodeBlock cb, StackFrame frame, String propname) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ExecEnv env = frame.getEnv();
        Rule rule = cb.getRule();
        if (o instanceof EObject) {
            EObject eo = (EObject)o;
            EClass type = eo.eClass();
            boolean queueSet = env.getCurrentPhase() == RuleMode.AUTOMATIC_SINGLE && env.getInoutModelOf(eo) != null;
            Field field = null;
            if (rule != null) {
                field = rule.findField(type, propname);
            }
            if (field == null) {
                field = env.findField(type, propname);
                if (field != null) {
                    if (queueSet) {
                        env.queueForSet(field, o, v, frame);
                    } else {
                        if (env.getInputModelOf(eo) != null) {
                            throw new IllegalArgumentException(String.format("Cannot set properties of %s, as it is contained in an input model", EMFTVMUtil.toPrettyString(eo, env)));
                        }
                        if (env.getOutputModelOf(eo) != null) {
                            throw new IllegalArgumentException(String.format("Setting transient field %s of %s, which cannot be read back as %1s is contained in an output model", propname, EMFTVMUtil.toPrettyString(eo, env)));
                        }
                        field.setValue(o, v);
                    }
                    return;
                }
            } else {
                field.setValue(o, v);
                return;
            }
            EStructuralFeature sf = type.getEStructuralFeature(propname);
            if (sf != null) {
                if (queueSet) {
                    env.queueForSet(sf, eo, v, frame);
                } else {
                    EMFTVMUtil.set(env, eo, sf, v);
                }
                return;
            }
            Resource resource = eo.eResource();
            if ("__xmiID__".equals(propname) && resource instanceof XMIResource) {
                if (queueSet) {
                    env.queueXmiIDForSet(eo, v, frame);
                } else {
                    ((XMIResource)resource).setID(eo, v.toString());
                }
                return;
            }
            throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
        }
        Class<Void> type = o == null ? Void.TYPE : o.getClass();
        Field field = null;
        if (rule != null) {
            field = rule.findField(type, propname);
        }
        if (field == null) {
            field = env.findField(type, propname);
        }
        if (field != null) {
            field.setValue(o, v);
            return;
        }
        try {
            java.lang.reflect.Field f = type.getField(propname);
            f.set(o, v);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
        }
    }

    protected static Object get(Object o, CodeBlock cb, StackFrame frame, String propname) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ExecEnv env = frame.getEnv();
        Rule rule = cb.getRule();
        if (o instanceof EObject) {
            EObject eo = (EObject)o;
            EClass type = eo.eClass();
            Field field = null;
            if (rule != null) {
                field = rule.findField(type, propname);
            }
            if (field == null) {
                field = env.findField(type, propname);
                if (field != null) {
                    if (env.getOutputModelOf(eo) != null) {
                        throw new IllegalArgumentException(String.format("Cannot read properties of %s, as it is contained in an output model", EMFTVMUtil.toPrettyString(eo, env)));
                    }
                    return field.getValue(o, frame);
                }
            } else {
                return field.getValue(o, frame);
            }
            EStructuralFeature sf = type.getEStructuralFeature(propname);
            if (sf != null) {
                return EMFTVMUtil.get(env, eo, sf);
            }
            Resource resource = eo.eResource();
            if ("__xmiID__".equals(propname) && resource instanceof XMIResource) {
                return ((XMIResource)resource).getID(eo);
            }
            throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
        }
        Class<Void> type = o == null ? Void.TYPE : o.getClass();
        Field field = null;
        if (rule != null) {
            field = rule.findField(type, propname);
        }
        if (field == null) {
            field = env.findField(type, propname);
        }
        if (field != null) {
            return field.getValue(o, frame);
        }
        if (o instanceof Tuple && ((Tuple)o).asMap().containsKey(propname)) {
            return ((Tuple)o).get(propname);
        }
        try {
            java.lang.reflect.Field f = type.getField(propname);
            Object result = f.get(o);
            if (result instanceof List) {
                return new LazyListOnList((List)result);
            }
            if (result instanceof Set) {
                return new LazySetOnSet((Set)result);
            }
            if (result instanceof Collection) {
                return new LazyBagOnCollection((Collection)result);
            }
            return result;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
        }
    }

    protected static Object get(Object o, StackFrame frame, String propname) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ExecEnv env = frame.getEnv();
        if (o instanceof EObject) {
            EObject eo = (EObject)o;
            EClass type = eo.eClass();
            Field field = env.findField(type, propname);
            if (field != null) {
                if (env.getOutputModelOf(eo) != null) {
                    throw new IllegalArgumentException(String.format("Cannot read properties of %s, as it is contained in an output model", EMFTVMUtil.toPrettyString(eo, env)));
                }
                return field.getValue(o, frame);
            }
            EStructuralFeature sf = type.getEStructuralFeature(propname);
            if (sf != null) {
                return EMFTVMUtil.get(env, eo, sf);
            }
            Resource resource = eo.eResource();
            if ("__xmiID__".equals(propname) && resource instanceof XMIResource) {
                return ((XMIResource)resource).getID(eo);
            }
            throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
        }
        Class<Void> type = o == null ? Void.TYPE : o.getClass();
        Field field = env.findField(type, propname);
        if (field != null) {
            return field.getValue(o, frame);
        }
        if (o instanceof Tuple && ((Tuple)o).asMap().containsKey(propname)) {
            return ((Tuple)o).get(propname);
        }
        try {
            java.lang.reflect.Field f = type.getField(propname);
            Object result = f.get(o);
            if (result instanceof List) {
                return new LazyListOnList((List)result);
            }
            if (result instanceof Set) {
                return new LazySetOnSet((Set)result);
            }
            if (result instanceof Collection) {
                return new LazyBagOnCollection((Collection)result);
            }
            return result;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
        }
    }

    protected static Object get(Object o, ExecEnv env, String propname) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (o instanceof EObject) {
            EObject eo = (EObject)o;
            EClass type = eo.eClass();
            EStructuralFeature sf = type.getEStructuralFeature(propname);
            if (sf != null) {
                return EMFTVMUtil.get(env, eo, sf);
            }
            Resource resource = eo.eResource();
            if ("__xmiID__".equals(propname) && resource instanceof XMIResource) {
                return ((XMIResource)resource).getID(eo);
            }
            throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
        }
        if (o instanceof Tuple && ((Tuple)o).asMap().containsKey(propname)) {
            return ((Tuple)o).get(propname);
        }
        Class<Void> type = o == null ? Void.TYPE : o.getClass();
        try {
            java.lang.reflect.Field f = type.getField(propname);
            Object result = f.get(o);
            if (result instanceof List) {
                return new LazyListOnList((List)result);
            }
            if (result instanceof Set) {
                return new LazySetOnSet((Set)result);
            }
            if (result instanceof Collection) {
                return new LazyBagOnCollection((Collection)result);
            }
            return result;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
        }
    }

    protected static Collection<Object> getTrans(Object o, CodeBlock cb, StackFrame frame, String propname) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ExecEnv env = frame.getEnv();
        Rule rule = cb.getRule();
        if (o instanceof EObject) {
            EObject eo = (EObject)o;
            EClass type = eo.eClass();
            Field field = null;
            if (rule != null) {
                field = rule.findField(type, propname);
            }
            if (field == null) {
                field = env.findField(type, propname);
                if (field != null) {
                    if (env.getOutputModelOf(eo) != null) {
                        throw new IllegalArgumentException(String.format("Cannot read properties of %s, as it is contained in an output model", EMFTVMUtil.toPrettyString(eo, env)));
                    }
                    return EMFTVMUtil.getTrans(o, field, frame, new LazyList<Object>());
                }
            } else {
                return EMFTVMUtil.getTrans(o, field, frame, new LazyList<Object>());
            }
            EStructuralFeature sf = type.getEStructuralFeature(propname);
            if (sf == null) {
                throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
            }
            return EMFTVMUtil.getTrans(eo, sf, env, new LazyList<Object>());
        }
        Class<?> type = o.getClass();
        Field field = null;
        if (rule != null) {
            field = rule.findField(type, propname);
        }
        if (field == null) {
            field = env.findField(type, propname);
        }
        if (field != null) {
            return EMFTVMUtil.getTrans(o, field, frame, new LazyList<Object>());
        }
        java.lang.reflect.Field f = type.getField(propname);
        return EMFTVMUtil.getTrans(o, f, new LazyList<Object>());
    }

    protected static Object getSuper(Object o, EClass context, String propname, StackFrame frame) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Object superF;
        ExecEnv env = frame.getEnv();
        EList superTypes = context.getESuperTypes();
        LinkedHashSet<Object> superFs = new LinkedHashSet<Object>();
        if (o instanceof EObject) {
            for (EClass superType : superTypes) {
                superF = env.findField(superType, propname);
                if (superF != null) {
                    superFs.add(superF);
                    continue;
                }
                superF = superType.getEStructuralFeature(propname);
                if (superF != null) {
                    superFs.add(superF);
                    continue;
                }
                if (superType.getInstanceClass() == null) continue;
                try {
                    superF = superType.getInstanceClass().getField(propname);
                    assert (superF != null);
                    superFs.add(superF);
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
        } else {
            for (EClass superType : superTypes) {
                superF = env.findField(superType, propname);
                if (superF != null) {
                    superFs.add(superF);
                    continue;
                }
                if (superType.getInstanceClass() == null) continue;
                try {
                    superF = superType.getInstanceClass().getField(propname);
                    assert (superF != null);
                    superFs.add(superF);
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
        }
        if (superFs.size() > 1) {
            throw new DuplicateEntryException(String.format("More than one super-field found for context %s: %s", context, superFs));
        }
        if (!superFs.isEmpty()) {
            Object superF2 = superFs.iterator().next();
            if (superF2 instanceof Field) {
                Field field = (Field)superF2;
                if (o instanceof EObject) {
                    EObject eo = (EObject)o;
                    if (field.getRule() == null && env.getOutputModelOf(eo) != null) {
                        throw new IllegalArgumentException(String.format("Cannot read properties of %s, as it is contained in an output model", EMFTVMUtil.toPrettyString(eo, env)));
                    }
                }
                return field.getValue(o, frame);
            }
            if (superF2 instanceof EStructuralFeature) {
                return EMFTVMUtil.get(env, (EObject)o, (EStructuralFeature)superF2);
            }
            Object result = ((java.lang.reflect.Field)superF2).get(o);
            if (result instanceof List) {
                return new LazyListOnList((List)result);
            }
            if (result instanceof Set) {
                return new LazySetOnSet((Set)result);
            }
            if (result instanceof Collection) {
                return new LazyBagOnCollection((Collection)result);
            }
            return result;
        }
        throw new NoSuchFieldException(String.format("Super-field of %s::%s not found", EMFTVMUtil.toPrettyString(context, env), propname));
    }

    protected static Object getSuper(Object o, Class<?> context, String propname, StackFrame frame) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Object superF;
        ExecEnv env = frame.getEnv();
        Class<?> superType = context.getSuperclass();
        LinkedHashSet<Object> superFs = new LinkedHashSet<Object>();
        if (o instanceof EObject) {
            superF = env.findField(superType, propname);
            if (superF != null) {
                superFs.add(superF);
            } else {
                try {
                    superF = superType.getField(propname);
                    assert (superF != null);
                    superFs.add(superF);
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
        } else {
            superF = env.findField(superType, propname);
            if (superF != null) {
                superFs.add(superF);
            } else {
                try {
                    superF = superType.getField(propname);
                    assert (superF != null);
                    superFs.add(superF);
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            }
        }
        if (superFs.size() > 1) {
            throw new DuplicateEntryException(String.format("More than one super-field found for context %s: %s", context, superFs));
        }
        if (!superFs.isEmpty()) {
            superF = superFs.iterator().next();
            if (superF instanceof Field) {
                return ((Field)superF).getValue(o, frame);
            }
            if (superF instanceof EStructuralFeature) {
                return EMFTVMUtil.get(env, (EObject)o, (EStructuralFeature)superF);
            }
            Object result = ((java.lang.reflect.Field)superF).get(o);
            if (result instanceof List) {
                return new LazyListOnList((List)result);
            }
            if (result instanceof Set) {
                return new LazySetOnSet((Set)result);
            }
            if (result instanceof Collection) {
                return new LazyBagOnCollection((Collection)result);
            }
            return result;
        }
        throw new NoSuchFieldException(String.format("Super-field of %s::%s not found", EMFTVMUtil.toPrettyString(context, env), propname));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void setStatic(Object o, Object v, CodeBlock cb, ExecEnv env, String propname) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Object ort = EMFTVMUtil.getRegistryType(o);
        Rule rule = cb.getRule();
        if (ort instanceof EClass) {
            EClass type = (EClass)ort;
            Field field = null;
            if (rule != null) {
                field = rule.findStaticField(type, propname);
            }
            if (field == null) {
                field = env.findStaticField(type, propname);
            }
            if (field == null) throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
            field.setStaticValue(v);
            return;
        } else {
            if (!(ort instanceof Class)) throw new IllegalArgumentException(String.format("%s is not a type", EMFTVMUtil.toPrettyString(ort, env)));
            Class type = (Class)ort;
            Field field = null;
            if (rule != null) {
                field = rule.findStaticField(type, propname);
            }
            if (field == null) {
                field = env.findStaticField(type, propname);
            }
            if (field != null) {
                field.setValue(ort, v);
                return;
            } else {
                java.lang.reflect.Field f = type.getField(propname);
                if (!Modifier.isStatic(f.getModifiers())) throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
                f.set(null, v);
            }
        }
    }

    protected static Object getStatic(Object o, CodeBlock cb, StackFrame frame, String propname) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ExecEnv env = frame.getEnv();
        Object ort = EMFTVMUtil.getRegistryType(o);
        Rule rule = cb.getRule();
        if (ort instanceof EClass) {
            EClass type = (EClass)ort;
            Field field = null;
            if (rule != null) {
                field = rule.findStaticField(type, propname);
            }
            if (field == null) {
                field = env.findStaticField(type, propname);
            }
            if (field != null) {
                return field.getStaticValue(frame);
            }
            throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
        }
        if (ort instanceof Class) {
            Class type = (Class)ort;
            Field field = null;
            if (rule != null) {
                field = rule.findStaticField(type, propname);
            }
            if (field == null) {
                field = env.findStaticField(type, propname);
            }
            if (field != null) {
                return field.getStaticValue(frame);
            }
            java.lang.reflect.Field f = type.getField(propname);
            if (Modifier.isStatic(f.getModifiers())) {
                return f.get(null);
            }
            throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
        }
        throw new IllegalArgumentException(String.format("%s is not a type", ort));
    }

    protected static Object findTypeS(String modelName, String typeName, ExecEnv env) throws ClassNotFoundException {
        return env.findType(modelName, typeName);
    }

    protected static Object newInstance(Object type, String modelname, ExecEnv env) {
        if (type instanceof EClass) {
            EClass eType = (EClass)type;
            Model model = env.getOutputModels().get(modelname);
            if (model == null) {
                model = env.getInoutModels().get(modelname);
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Inout/output model %s not found", modelname));
            }
            return model.newElement(eType);
        }
        try {
            return NativeTypes.newInstance((Class)type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected static void delete(EObject element, StackFrame frame) {
        ExecEnv env = frame.getEnv();
        Resource res = element.eResource();
        if (res == null) {
            throw new IllegalArgumentException(String.format("Element %s is cannot be deleted; not contained in a model", EMFTVMUtil.toPrettyString(element, env)));
        }
        Model model = env.getInputModelOf(element);
        if (model != null) {
            throw new IllegalArgumentException(String.format("Element %s is cannot be deleted; contained in input model %s", EMFTVMUtil.toPrettyString(element, env), env.getModelID(model)));
        }
        env.queueForDelete(element, frame);
    }

    protected static Object invokeNative(StackFrame frame, Object self, String opname, Method method) {
        if (method != null) {
            return EMFTVMUtil.invokeNative(frame, self, method);
        }
        throw new UnsupportedOperationException(String.format("%s::%s()", EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(self)), opname));
    }

    protected static Object invokeNative(StackFrame frame, Object self, String opname, Object arg, Method method) {
        if (method != null) {
            return EMFTVMUtil.invokeNative(frame, self, method, arg);
        }
        throw new UnsupportedOperationException(String.format("%s::%s(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(self)), opname, EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(arg))));
    }

    protected static Object invokeNative(StackFrame frame, Object self, String opname, Object[] args, Method method) {
        if (method != null) {
            return EMFTVMUtil.invokeNative(frame, self, method, args);
        }
        throw new UnsupportedOperationException(String.format("%s::%s(%s)", EMFTVMUtil.getTypeName(frame.getEnv(), EMFTVMUtil.getArgumentType(self)), opname, EMFTVMUtil.getTypeNames(frame.getEnv(), EMFTVMUtil.getArgumentTypes(args))));
    }

    protected static Object invokeSuper(Object self, EClass context, StackFrame frame, String opname) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method;
        LinkedHashSet<Operation> ops = new LinkedHashSet<Operation>();
        EList superTypes = context.getESuperTypes();
        ExecEnv env = frame.getEnv();
        Operation superOp = null;
        for (EClass superType : superTypes) {
            superOp = env.findOperation(superType, opname);
            if (superOp == null) continue;
            ops.add(superOp);
        }
        if (ops.size() > 1) {
            throw new DuplicateEntryException(String.format("More than one super-operation found for context %s: %s", context, ops));
        }
        if (!ops.isEmpty()) {
            superOp = (Operation)ops.iterator().next();
        }
        if ((method = EMFTVMUtil.findNativeSuperMethod(superOp, context.getInstanceClass(), opname)) != null) {
            return EMFTVMUtil.invokeNative(frame, self, method);
        }
        if (superOp != null) {
            CodeBlock body = superOp.getBody();
            return body.execute(frame.getSubFrame(body, self));
        }
        throw new UnsupportedOperationException(String.format("super %s::%s()", EMFTVMUtil.getTypeName(env, context), opname));
    }

    protected static Object invokeSuper(Object self, Class<?> context, StackFrame frame, String opname) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ExecEnv env = frame.getEnv();
        Operation superOp = env.findOperation(context.getSuperclass(), opname);
        Method method = EMFTVMUtil.findNativeSuperMethod(superOp, context, opname);
        if (method != null) {
            return EMFTVMUtil.invokeNative(frame, self, method);
        }
        if (superOp != null) {
            CodeBlock body = superOp.getBody();
            return body.execute(frame.getSubFrame(body, self));
        }
        throw new UnsupportedOperationException(String.format("super %s::%s()", EMFTVMUtil.getTypeName(env, context), opname));
    }

    protected static Object invokeSuper(Object self, Object arg, EClass context, StackFrame frame, String opname) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method;
        LinkedHashSet<Operation> ops = new LinkedHashSet<Operation>();
        EList superTypes = context.getESuperTypes();
        ExecEnv env = frame.getEnv();
        Operation superOp = null;
        for (Object superType : superTypes) {
            superOp = env.findOperation(superType, opname, EMFTVMUtil.getArgumentType(arg));
            if (superOp == null) continue;
            ops.add(superOp);
        }
        if (ops.size() > 1) {
            throw new DuplicateEntryException(String.format("More than one super-operation found for context %s: %s", context, ops));
        }
        if (!ops.isEmpty()) {
            superOp = (Operation)ops.iterator().next();
        }
        if ((method = EMFTVMUtil.findNativeSuperMethod(superOp, context.getInstanceClass(), opname, arg)) != null) {
            return EMFTVMUtil.invokeNative(frame, self, method, arg);
        }
        if (superOp != null) {
            CodeBlock body = superOp.getBody();
            return body.execute(frame.getSubFrame(body, self, arg));
        }
        throw new UnsupportedOperationException(String.format("super %s::%s(%s)", EMFTVMUtil.getTypeName(env, context), opname, EMFTVMUtil.getTypeName(env, EMFTVMUtil.getArgumentType(arg))));
    }

    protected static Object invokeSuper(Object self, Object arg, Class<?> context, StackFrame frame, String opname) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ExecEnv env = frame.getEnv();
        Operation superOp = env.findOperation(context.getSuperclass(), opname, EMFTVMUtil.getArgumentType(arg));
        Method method = EMFTVMUtil.findNativeSuperMethod(superOp, context, opname, arg);
        if (method != null) {
            return EMFTVMUtil.invokeNative(frame, self, method, arg);
        }
        if (superOp != null) {
            CodeBlock body = superOp.getBody();
            return body.execute(frame.getSubFrame(body, self, arg));
        }
        throw new UnsupportedOperationException(String.format("super %s::%s(%s)", EMFTVMUtil.getTypeName(env, context), opname, EMFTVMUtil.getTypeName(env, EMFTVMUtil.getArgumentType(arg))));
    }

    protected static Object invokeSuper(Object self, Object[] args, EClass context, StackFrame frame, String opname) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method;
        LinkedHashSet<Operation> ops = new LinkedHashSet<Operation>();
        EList superTypes = context.getESuperTypes();
        ExecEnv env = frame.getEnv();
        Operation superOp = null;
        for (Object superType : superTypes) {
            superOp = env.findOperation(superType, opname, EMFTVMUtil.getArgumentTypes(args));
            if (superOp == null) continue;
            ops.add(superOp);
        }
        if (ops.size() > 1) {
            throw new DuplicateEntryException(String.format("More than one super-operation found for context %s: %s", context, ops));
        }
        if (!ops.isEmpty()) {
            superOp = (Operation)ops.iterator().next();
        }
        if ((method = EMFTVMUtil.findNativeSuperMethod(superOp, context.getInstanceClass(), opname, args)) != null) {
            return EMFTVMUtil.invokeNative(frame, self, method, args);
        }
        if (superOp != null) {
            CodeBlock body = superOp.getBody();
            return body.execute(frame.getSubFrame(body, self, args));
        }
        throw new UnsupportedOperationException(String.format("super %s::%s(%s)", EMFTVMUtil.getTypeName(env, context), opname, EMFTVMUtil.getTypeNames(env, EMFTVMUtil.getArgumentTypes(args))));
    }

    protected static Object invokeSuper(Object self, Object[] args, Class<?> context, StackFrame frame, String opname) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ExecEnv env = frame.getEnv();
        Operation superOp = env.findOperation((Object)context.getSuperclass(), opname, EMFTVMUtil.getArgumentTypes(args));
        Method method = EMFTVMUtil.findNativeSuperMethod(superOp, context, opname, args);
        if (method != null) {
            return EMFTVMUtil.invokeNative(frame, self, method, args);
        }
        if (superOp != null) {
            CodeBlock body = superOp.getBody();
            return body.execute(frame.getSubFrame(body, self, args));
        }
        throw new UnsupportedOperationException(String.format("super %s::%s(%s)", EMFTVMUtil.getTypeName(env, context), opname, EMFTVMUtil.getTypeNames(env, EMFTVMUtil.getArgumentTypes(args))));
    }

    protected static Object invokeStatic(Object type, StackFrame frame, String opname) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Rule rule;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Cannot invoke static operation %s on null type", opname));
        }
        ExecEnv env = frame.getEnv();
        if (type == env.eClass() && (rule = env.findRule(opname)) != null && rule.getMode() == RuleMode.MANUAL) {
            return JITCodeBlock.matchOne(rule, frame);
        }
        Operation op = frame.getEnv().findStaticOperation(type, opname);
        if (op != null) {
            CodeBlock body = op.getBody();
            return body.execute(new StackFrame(frame, body));
        }
        if (type instanceof Class) {
            return EMFTVMUtil.invokeNativeStatic(frame, (Class)type, opname);
        }
        throw new UnsupportedOperationException(String.format("static %s::%s()", EMFTVMUtil.getTypeName(env, type), opname));
    }

    protected static Object invokeStatic(Object type, Object arg, StackFrame frame, String opname) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Rule rule;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Cannot invoke static operation %s on null type", opname));
        }
        ExecEnv env = frame.getEnv();
        if (type == env.eClass() && (rule = env.findRule(opname)) != null && rule.getMode() == RuleMode.MANUAL) {
            return JITCodeBlock.matchOne(new Object[]{arg}, rule, frame);
        }
        Operation op = frame.getEnv().findStaticOperation(type, opname, EMFTVMUtil.getArgumentType(arg));
        if (op != null) {
            CodeBlock body = op.getBody();
            return body.execute(frame.getSubFrame(body, arg));
        }
        if (type instanceof Class) {
            return EMFTVMUtil.invokeNativeStatic(frame, (Class)type, opname, arg);
        }
        throw new UnsupportedOperationException(String.format("static %s::%s(%s)", EMFTVMUtil.getTypeName(env, type), opname, EMFTVMUtil.getTypeName(env, EMFTVMUtil.getArgumentType(arg))));
    }

    protected static Object invokeStatic(Object type, Object[] args, StackFrame frame, String opname) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Rule rule;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Cannot invoke static operation %s on null type", opname));
        }
        ExecEnv env = frame.getEnv();
        if (type == env.eClass() && (rule = env.findRule(opname)) != null && rule.getMode() == RuleMode.MANUAL) {
            return JITCodeBlock.matchOne(args, rule, frame);
        }
        Operation op = frame.getEnv().findStaticOperation(type, opname, EMFTVMUtil.getArgumentTypes(args));
        if (op != null) {
            CodeBlock body = op.getBody();
            return body.execute(frame.getSubFrame(body, args));
        }
        if (type instanceof Class) {
            return EMFTVMUtil.invokeNativeStatic(frame, (Class)type, opname, args);
        }
        throw new UnsupportedOperationException(String.format("static %s::%s(%s)", EMFTVMUtil.getTypeName(env, type), opname, EMFTVMUtil.getTypeNames(env, EMFTVMUtil.getArgumentTypes(args))));
    }

    protected static Object matchOne(Object[] args, Rule rule, StackFrame frame) {
        int argcount = args.length;
        if (argcount != rule.getInputElements().size()) {
            throw new VMException(frame, String.format("Rule %s has different amount of input elements than expected: %d instead of %d", rule.getName(), rule.getInputElements().size(), argcount));
        }
        return rule.matchManual(frame, args);
    }

    protected static Object matchOne(Rule rule, StackFrame frame) {
        if (rule.getInputElements().size() != 0) {
            throw new VMException(frame, String.format("Rule %s has different amount of input elements than expected: %d instead of %d", rule.getName(), rule.getInputElements().size(), 0));
        }
        return rule.matchManual(frame, EMPTY);
    }

    protected static Object matchOne(Object[] args, StackFrame frame, String rulename) {
        ExecEnv env = frame.getEnv();
        Rule rule = env.findRule(rulename);
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Rule %s not found", rulename));
        }
        int argcount = args.length;
        if (argcount != rule.getInputElements().size()) {
            throw new VMException(frame, String.format("Rule %s has different amount of input elements than expected: %d instead of %d", rule.getName(), rule.getInputElements().size(), argcount));
        }
        return rule.matchManual(frame, args);
    }

    protected static Object matchOne(StackFrame frame, String rulename) {
        ExecEnv env = frame.getEnv();
        Rule rule = env.findRule(rulename);
        if (rule == null) {
            throw new IllegalArgumentException(String.format("Rule %s not found", rulename));
        }
        if (rule.getInputElements().size() != 0) {
            throw new VMException(frame, String.format("Rule %s has different amount of input elements than expected: %d instead of %d", rule.getName(), rule.getInputElements().size(), 0));
        }
        return rule.matchManual(frame, EMPTY);
    }

    protected static void add(Object o, Object v, int index, String propname, CodeBlock cb, StackFrame frame) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ExecEnv env = frame.getEnv();
        Rule rule = cb.getRule();
        if (o instanceof EObject) {
            EObject eo = (EObject)o;
            EClass type = eo.eClass();
            boolean queueSet = env.getCurrentPhase() == RuleMode.AUTOMATIC_SINGLE && env.getInoutModelOf(eo) != null;
            Field field = null;
            if (rule != null) {
                field = rule.findField(type, propname);
            }
            if (field == null) {
                field = env.findField(type, propname);
                if (field != null) {
                    if (queueSet) {
                        env.queueForAdd(field, o, v, index, frame);
                    } else {
                        if (env.getInputModelOf(eo) != null) {
                            throw new IllegalArgumentException(String.format("Cannot add to properties of %s, as it is contained in an input model", EMFTVMUtil.toPrettyString(eo, env)));
                        }
                        if (env.getOutputModelOf(eo) != null) {
                            throw new IllegalArgumentException(String.format("Adding to transient field %s of %s, which cannot be read back as %1s is contained in an output model", propname, EMFTVMUtil.toPrettyString(eo, env)));
                        }
                        field.addValue(o, v, index, frame);
                    }
                    return;
                }
            } else {
                field.addValue(o, v, index, frame);
                return;
            }
            EStructuralFeature sf = type.getEStructuralFeature(propname);
            if (sf != null) {
                if (queueSet) {
                    env.queueForAdd(sf, eo, v, index, frame);
                } else {
                    EMFTVMUtil.add(env, eo, sf, v, index);
                }
                return;
            }
            Resource resource = eo.eResource();
            if ("__xmiID__".equals(propname) && resource instanceof XMIResource) {
                if (queueSet) {
                    env.queueXmiIDForAdd(eo, v, index, frame);
                } else {
                    if (((XMIResource)resource).getID(eo) != null) {
                        throw new IllegalArgumentException(String.format("Cannot add %s to field %s::%s: maximum multiplicity of 1 reached", v, EMFTVMUtil.toPrettyString(eo, env), propname));
                    }
                    if (index > 0) {
                        throw new IndexOutOfBoundsException(String.valueOf(index));
                    }
                    ((XMIResource)resource).setID(eo, v.toString());
                }
                return;
            }
            throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
        }
        Class<Void> type = o == null ? Void.TYPE : o.getClass();
        Field field = null;
        if (rule != null) {
            field = rule.findField(type, propname);
        }
        if (field == null) {
            field = env.findField(type, propname);
        }
        if (field != null) {
            field.addValue(o, v, index, frame);
            return;
        }
        throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
    }

    protected static void remove(Object o, Object v, String propname, CodeBlock cb, StackFrame frame) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        ExecEnv env = frame.getEnv();
        Rule rule = cb.getRule();
        if (o instanceof EObject) {
            EObject eo = (EObject)o;
            EClass type = eo.eClass();
            boolean queueSet = env.getCurrentPhase() == RuleMode.AUTOMATIC_SINGLE && env.getInoutModelOf(eo) != null;
            Field field = null;
            if (rule != null) {
                field = rule.findField(type, propname);
            }
            if (field == null) {
                field = env.findField(type, propname);
                if (field != null) {
                    if (queueSet) {
                        env.queueForRemove(field, o, v, frame);
                    } else {
                        if (env.getInputModelOf(eo) != null) {
                            throw new IllegalArgumentException(String.format("Cannot remove from properties of %s, as it is contained in an input model", EMFTVMUtil.toPrettyString(eo, env)));
                        }
                        if (env.getOutputModelOf(eo) != null) {
                            throw new IllegalArgumentException(String.format("Removing from transient field %s of %s, which cannot be read back as %1s is contained in an output model", propname, EMFTVMUtil.toPrettyString(eo, env)));
                        }
                        field.removeValue(o, v, frame);
                    }
                    return;
                }
            } else {
                field.removeValue(o, v, frame);
                return;
            }
            EStructuralFeature sf = type.getEStructuralFeature(propname);
            if (sf != null) {
                if (queueSet) {
                    env.queueForRemove(sf, eo, v, frame);
                } else {
                    EMFTVMUtil.remove(env, eo, sf, v);
                }
                return;
            }
            Resource resource = eo.eResource();
            if ("__xmiID__".equals(propname) && resource instanceof XMIResource) {
                if (queueSet) {
                    env.queueXmiIDForRemove(eo, v, frame);
                } else {
                    XMIResource xmiRes = (XMIResource)resource;
                    String xmiID = xmiRes.getID(eo);
                    if (xmiID == null ? v == null : xmiID.equals(v)) {
                        xmiRes.setID(eo, null);
                    }
                }
                return;
            }
            throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
        }
        Class<Void> type = o == null ? Void.TYPE : o.getClass();
        Field field = null;
        if (rule != null) {
            field = rule.findField(type, propname);
        }
        if (field == null) {
            field = env.findField(type, propname);
        }
        if (field != null) {
            field.removeValue(o, v, frame);
            return;
        }
        throw new NoSuchFieldException(String.format("Field %s::%s not found", EMFTVMUtil.toPrettyString(type, env), propname));
    }
}

