/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.preferences;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.preferences.ProfileManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileStore {
    public static final String ENCODING = "UTF-8";
    protected static final String VERSION_KEY_SUFFIX = ".version";
    private static final String XML_NODE_ROOT = "profiles";
    private static final String XML_NODE_PROFILE = "profile";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private final String fProfilesKey;

    public ProfileStore(String profilesKey) {
        this.fProfilesKey = profilesKey;
    }

    public List<ProfileManager.Profile> readProfiles(IScopeContext scope) throws CoreException {
        return this.readProfilesFromString(scope.getNode(AtlUIPlugin.getPluginId()).get(this.fProfilesKey, null));
    }

    public void writeProfiles(Collection<ProfileManager.Profile> profiles, IScopeContext instanceScope) throws CoreException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(2000);
        try {
            String val;
            ProfileStore.writeProfilesToStream(profiles, stream, ENCODING);
            try {
                val = stream.toString(ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                val = stream.toString();
            }
            IEclipsePreferences uiPreferences = instanceScope.getNode(AtlUIPlugin.getPluginId());
            uiPreferences.put(this.fProfilesKey, val);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
    }

    public List<ProfileManager.Profile> readProfilesFromString(String profiles) throws CoreException {
        if (profiles != null && profiles.length() > 0) {
            List<ProfileManager.Profile> list;
            byte[] bytes;
            try {
                bytes = profiles.getBytes(ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = profiles.getBytes();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try {
                List<ProfileManager.Profile> res;
                list = res = ProfileStore.readProfilesFromStream(new InputSource(is));
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)is).close();
            }
            catch (IOException iOException) {}
            return list;
        }
        return null;
    }

    public List<ProfileManager.Profile> readProfilesFromFile(File file) throws CoreException {
        List<ProfileManager.Profile> list;
        FileInputStream reader = new FileInputStream(file);
        try {
            list = ProfileStore.readProfilesFromStream(new InputSource(reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {}
        return list;
    }

    public static List<ProfileManager.Profile> readProfilesFromStream(InputSource inputSource) throws CoreException {
        ProfileDefaultHandler handler = new ProfileDefaultHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        return handler.getProfiles();
    }

    public void writeProfilesToFile(Collection<ProfileManager.Profile> profiles, File file, String encoding) throws CoreException {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                ProfileStore.writeProfilesToStream(profiles, stream, encoding);
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((OutputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {}
    }

    public static void writeProfilesToStream(Collection<ProfileManager.Profile> profiles, OutputStream stream, String encoding) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(XML_NODE_ROOT);
            document.appendChild(rootElement);
            for (ProfileManager.Profile profile : profiles) {
                if (!profile.isProfileToSave()) continue;
                Element profileElement = ProfileStore.createProfileElement(profile, document);
                rootElement.appendChild(profileElement);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", encoding);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(stream));
        }
        catch (TransformerException transformerException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {}
    }

    private static Element createProfileElement(ProfileManager.Profile profile, Document document) {
        Element element = document.createElement(XML_NODE_PROFILE);
        element.setAttribute(XML_ATTRIBUTE_NAME, profile.getName());
        for (String key : profile.getSettings().keySet()) {
            String value = profile.getSettings().get(key);
            if (value == null) continue;
            Element setting = document.createElement(XML_NODE_SETTING);
            setting.setAttribute(XML_ATTRIBUTE_ID, key);
            setting.setAttribute(XML_ATTRIBUTE_VALUE, value);
            element.appendChild(setting);
        }
        return element;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProfileDefaultHandler
    extends DefaultHandler {
        private List<ProfileManager.Profile> fProfiles;
        private String fName;
        private Map<String, String> fSettings;

        private ProfileDefaultHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(ProfileStore.XML_NODE_SETTING)) {
                String key = attributes.getValue(ProfileStore.XML_ATTRIBUTE_ID);
                String value = attributes.getValue(ProfileStore.XML_ATTRIBUTE_VALUE);
                this.fSettings.put(key, value);
            } else if (qName.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fName = attributes.getValue(ProfileStore.XML_ATTRIBUTE_NAME);
                this.fSettings = new HashMap<String, String>(200);
            } else if (qName.equals(ProfileStore.XML_NODE_ROOT)) {
                this.fProfiles = new ArrayList<ProfileManager.Profile>();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fProfiles.add(new ProfileManager.CustomProfile(this.fName, this.fSettings));
                this.fName = null;
                this.fSettings = null;
            }
        }

        public List<ProfileManager.Profile> getProfiles() {
            return this.fProfiles;
        }
    }
}

