/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.trace.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.m2m.atl.emftvm.trace.SourceElement;
import org.eclipse.m2m.atl.emftvm.trace.SourceElementList;
import org.eclipse.m2m.atl.emftvm.trace.TraceFactory;
import org.eclipse.m2m.atl.emftvm.trace.TraceLinkSet;
import org.eclipse.m2m.atl.emftvm.trace.TracePackage;
import org.eclipse.m2m.atl.emftvm.trace.TracedRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraceLinkSetImpl
extends EObjectImpl
implements TraceLinkSet {
    protected EList<TracedRule> rules;
    protected EList<SourceElement> defaultSourceElements;
    protected EList<SourceElementList> defaultSourceElementLists;
    protected final Map<EObject, SourceElement> defaultSourceObjects = new HashMap<EObject, SourceElement>();
    protected final Map<List<Object>, SourceElementList> defaultSourceObjectLists = new HashMap<List<Object>, SourceElementList>();
    protected final Map<String, TracedRule> linksByRuleName = new HashMap<String, TracedRule>();

    protected TraceLinkSetImpl() {
    }

    protected EClass eStaticClass() {
        return TracePackage.Literals.TRACE_LINK_SET;
    }

    @Override
    public EList<TracedRule> getRules() {
        if (this.rules == null) {
            this.rules = new EObjectContainmentWithInverseEList(TracedRule.class, (InternalEObject)this, 0, 2);
        }
        return this.rules;
    }

    @Override
    public EList<SourceElement> getDefaultSourceElements() {
        if (this.defaultSourceElements == null) {
            this.defaultSourceElements = new EObjectWithInverseResolvingEList(SourceElement.class, (InternalEObject)this, 1, 5);
        }
        return this.defaultSourceElements;
    }

    @Override
    public EList<SourceElementList> getDefaultSourceElementLists() {
        if (this.defaultSourceElementLists == null) {
            this.defaultSourceElementLists = new EObjectContainmentWithInverseEList(SourceElementList.class, (InternalEObject)this, 2, 1);
        }
        return this.defaultSourceElementLists;
    }

    @Override
    public SourceElement getDefaultSourceElement(Object sourceElement) {
        return this.defaultSourceObjects.get(sourceElement);
    }

    @Override
    public SourceElementList getDefaultSourceElements(List<?> sourceElements) {
        return this.defaultSourceObjectLists.get(sourceElements);
    }

    @Override
    public TracedRule getLinksByRule(String rule, boolean create) {
        if (this.linksByRuleName.containsKey(rule)) {
            return this.linksByRuleName.get(rule);
        }
        if (create) {
            TracedRule tr = TraceFactory.eINSTANCE.createTracedRule();
            tr.setRule(rule);
            this.getRules().add((Object)tr);
            return tr;
        }
        return null;
    }

    @Override
    public void clear() {
        this.getDefaultSourceElements().clear();
        this.getDefaultSourceElementLists().clear();
        this.defaultSourceObjects.clear();
        this.defaultSourceObjectLists.clear();
        this.linksByRuleName.clear();
        this.getRules().clear();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getRules()).basicAdd((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getDefaultSourceElements()).basicAdd((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getDefaultSourceElementLists()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getRules()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getDefaultSourceElements()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return ((InternalEList)this.getDefaultSourceElementLists()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getRules();
            }
            case 1: {
                return this.getDefaultSourceElements();
            }
            case 2: {
                return this.getDefaultSourceElementLists();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getRules().clear();
                this.getRules().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getDefaultSourceElements().clear();
                this.getDefaultSourceElements().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getDefaultSourceElementLists().clear();
                this.getDefaultSourceElementLists().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getRules().clear();
                return;
            }
            case 1: {
                this.getDefaultSourceElements().clear();
                return;
            }
            case 2: {
                this.getDefaultSourceElementLists().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.rules != null && !this.rules.isEmpty();
            }
            case 1: {
                return this.defaultSourceElements != null && !this.defaultSourceElements.isEmpty();
            }
            case 2: {
                return this.defaultSourceElementLists != null && !this.defaultSourceElementLists.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer("TraceLinkSet [");
        boolean notFirst = false;
        for (TracedRule tr : this.getRules()) {
            if (notFirst) {
                result.append(", ");
            }
            result.append(tr.toString());
            notFirst = true;
        }
        result.append(']');
        return result.toString();
    }

    public boolean eNotificationRequired() {
        return true;
    }

    public void eNotify(Notification notification) {
        block29: {
            super.eNotify(notification);
            block0 : switch (notification.getFeatureID(null)) {
                case 0: {
                    switch (notification.getEventType()) {
                        case 3: {
                            this.tracedRuleAdded((TracedRule)notification.getNewValue());
                            break;
                        }
                        case 5: {
                            for (TracedRule tr : (Collection)notification.getNewValue()) {
                                this.tracedRuleAdded(tr);
                            }
                            break block0;
                        }
                        case 4: {
                            this.tracedRuleRemoved((TracedRule)notification.getOldValue());
                            break;
                        }
                        case 6: {
                            for (TracedRule tr : (Collection)notification.getOldValue()) {
                                this.tracedRuleRemoved(tr);
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    switch (notification.getEventType()) {
                        case 3: {
                            this.defaultSourceElementAdded((SourceElement)notification.getNewValue());
                            break;
                        }
                        case 5: {
                            for (SourceElement se : (Collection)notification.getNewValue()) {
                                this.defaultSourceElementAdded(se);
                            }
                            break block0;
                        }
                        case 4: {
                            this.defaultSourceElementRemoved((SourceElement)notification.getOldValue());
                            break;
                        }
                        case 6: {
                            for (SourceElement se : (Collection)notification.getOldValue()) {
                                this.defaultSourceElementRemoved(se);
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    switch (notification.getEventType()) {
                        case 3: {
                            this.defaultSourceElementListAdded((SourceElementList)notification.getNewValue());
                            break block0;
                        }
                        case 5: {
                            for (SourceElementList sel : (Collection)notification.getNewValue()) {
                                this.defaultSourceElementListAdded(sel);
                            }
                            break block29;
                        }
                        case 4: {
                            this.defaultSourceElementListRemoved((SourceElementList)notification.getOldValue());
                            break block0;
                        }
                        case 6: {
                            for (SourceElementList sel : (Collection)notification.getOldValue()) {
                                this.defaultSourceElementListRemoved(sel);
                            }
                        }
                    }
                }
            }
        }
    }

    private void tracedRuleAdded(TracedRule tr) {
        String rule = tr.getRule();
        if (this.linksByRuleName.containsKey(rule)) {
            throw new IllegalArgumentException(String.format("Traced rule with name %s already exists", rule));
        }
        this.linksByRuleName.put(rule, tr);
    }

    private void tracedRuleRemoved(TracedRule tr) {
        this.linksByRuleName.remove(tr.getRule());
    }

    private void defaultSourceElementAdded(SourceElement se) {
        EObject object = se.getObject();
        if (this.defaultSourceObjects.containsKey(object)) {
            SourceElement eSe = this.defaultSourceObjects.get(object);
            throw new IllegalArgumentException(String.format("Default trace already exists for source element %s::%s: %s::%s", se.getSourceOf().getRule(), se, eSe.getSourceOf().getRule(), eSe));
        }
        this.defaultSourceObjects.put(object, se);
    }

    private void defaultSourceElementRemoved(SourceElement se) {
        this.defaultSourceObjects.remove(se.getObject());
    }

    private void defaultSourceElementListAdded(SourceElementList sel) {
        EList<Object> objects = sel.getSourceObjects();
        if (this.defaultSourceObjectLists.containsKey(objects)) {
            assert (!sel.getSourceElements().isEmpty());
            TracedRule selRule = ((SourceElement)sel.getSourceElements().get(0)).getSourceOf().getRule();
            SourceElementList eSel = this.defaultSourceObjectLists.get(objects);
            assert (!eSel.getSourceElements().isEmpty());
            TracedRule eSelRule = ((SourceElement)eSel.getSourceElements().get(0)).getSourceOf().getRule();
            throw new IllegalArgumentException(String.format("Default trace already exists for source element list %s::%s: %s::%s", selRule, sel, eSelRule, eSel));
        }
        this.defaultSourceObjectLists.put((List<Object>)objects, sel);
    }

    private void defaultSourceElementListRemoved(SourceElementList sel) {
        this.defaultSourceObjectLists.remove(sel.getSourceObjects());
    }
}

