/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.wizard.atlfile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.m2m.atl.adt.ui.wizard.atlfile.AtlFileScreen;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlFileWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String DEFAULT_VM_NAME = "EMF-specific VM";
    private IConfigurationElement configElement;
    private WizardNewFileCreationPage simplePage;
    private AtlFileScreen advancedPage;
    private IStructuredSelection selection;
    private IWorkbench workbench;

    public AtlFileWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.getString("AtlFileWizard.Title"));
    }

    public void addPages() {
        this.simplePage = new WizardNewFileCreationPage(Messages.getString("AtlFileWizard.Page.Name"), this.selection);
        this.simplePage.setImageDescriptor(AtlUIPlugin.getImageDescriptor("ATLWizard.png"));
        this.simplePage.setTitle(Messages.getString("AtlFileWizard.Title"));
        this.simplePage.setDescription(Messages.getString("AtlFileWizard.Page.Description"));
        this.simplePage.setFileExtension("atl");
        this.addPage((IWizardPage)this.simplePage);
        this.advancedPage = new AtlFileScreen((ISelection)this.selection);
        this.addPage((IWizardPage)this.advancedPage);
    }

    public boolean performFinish() {
        try {
            final IFile file = this.simplePage.createNewFile();
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        try {
                            AtlFileWizard.this.buildFile(file);
                            AtlFileWizard.this.buildConfiguration(file);
                            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)AtlFileWizard.this.configElement);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            progressMonitor.done();
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = workbenchWindow.getActivePage();
            final IWorkbenchPart activePart = page.getActivePart();
            if (activePart instanceof ISetSelectionTarget) {
                StructuredSelection targetSelection = new StructuredSelection((Object)file);
                this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                    private final /* synthetic */ ISelection val$targetSelection;
                    {
                        this.val$targetSelection = iSelection;
                    }

                    public void run() {
                        ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    }
                });
            }
            IWorkbenchWindow dw = this.workbench.getActiveWorkbenchWindow();
            try {
                if (dw != null && page != null) {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
            }
            catch (PartInitException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof WizardNewFileCreationPage) {
            this.advancedPage.setModuleName(this.getModuleNameFromFile());
        }
        return super.getNextPage(page);
    }

    private void buildFile(IFile file) throws IOException, CoreException {
        Map<String, String> paths;
        StringBuffer fileContent = new StringBuffer();
        if (this.getContainer().getCurrentPage() == this.advancedPage && !(paths = this.advancedPage.getPaths()).isEmpty()) {
            for (String metamodelName : paths.keySet()) {
                String tag;
                String path = paths.get(metamodelName);
                if (path.startsWith("platform:/resource")) {
                    path = path.replaceFirst("platform:/resource", "");
                    tag = "-- @path ";
                } else {
                    tag = path.startsWith("file:/") || path.startsWith("platform:/plugin") ? "-- @path " : "-- @nsURI ";
                }
                fileContent.append(String.valueOf(tag) + metamodelName + "=" + path + "\n");
            }
            fileContent.append("\n");
        }
        String unitType = this.advancedPage.getUnitType();
        String unitName = this.advancedPage.getUnitName();
        if (unitType.equals("refining module")) {
            fileContent.append("module " + unitName + ";\n");
        } else if (unitType.equals("query")) {
            fileContent.append("query " + unitName + " = true;\n");
        } else {
            fileContent.append(String.valueOf(unitType) + " " + unitName + ";\n");
        }
        if (this.getContainer().getCurrentPage() == this.advancedPage) {
            if (unitType.equals("module") || unitType.equals("refining module")) {
                Map<String, String> inputModels = this.advancedPage.getInput();
                Map<String, String> outputModels = this.advancedPage.getOutput();
                if (!inputModels.isEmpty() && !outputModels.isEmpty()) {
                    fileContent.append("create ");
                    fileContent.append(this.createModelDeclarationFromMap(outputModels));
                    if (unitType.equals("module")) {
                        fileContent.append(" from ");
                    } else {
                        fileContent.append(" refining ");
                    }
                    fileContent.append(this.createModelDeclarationFromMap(inputModels));
                    fileContent.append(";\n");
                }
            }
            fileContent.append("\n");
            Map<String, String> libraries = this.advancedPage.getLibraries();
            if (!libraries.isEmpty()) {
                for (String library : libraries.keySet()) {
                    fileContent.append("uses " + library + ";\n");
                }
                fileContent.append("\n");
            }
        }
        InputStream stream = this.openContentStream(fileContent.toString());
        if (file.exists()) {
            file.setContents(stream, true, true, null);
        } else {
            file.create(stream, true, null);
        }
        stream.close();
    }

    private void buildConfiguration(IFile file) throws CoreException {
        if (this.getContainer().getCurrentPage() == this.advancedPage && this.advancedPage.generateLaunchConfig()) {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            String unitName = this.advancedPage.getUnitName();
            String name = manager.generateLaunchConfigurationName(unitName);
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.m2m.atl.adt.launching.atlTransformation");
            ILaunchConfigurationWorkingCopy editableConfiguration = type.newInstance(null, name);
            editableConfiguration.setAttribute("ATL VM", DEFAULT_VM_NAME);
            editableConfiguration.setAttribute("ATL File Name", file.getFullPath().toString());
            editableConfiguration.setAttribute("IS_REFINING", this.advancedPage.getUnitType().equals("refining module"));
            editableConfiguration.setAttribute("Input", this.advancedPage.getInput());
            editableConfiguration.setAttribute("Output", this.advancedPage.getOutput());
            editableConfiguration.setAttribute("Libs", this.advancedPage.getLibraries());
            editableConfiguration.setAttribute("Path", AtlFileWizard.convertPaths(this.advancedPage.getPaths()));
            editableConfiguration.doSave();
        }
    }

    private StringBuffer createModelDeclarationFromMap(Map<String, String> models) {
        StringBuffer declaration = new StringBuffer();
        Iterator<String> iterator = models.keySet().iterator();
        while (iterator.hasNext()) {
            String modelName = iterator.next();
            declaration.append(String.valueOf(modelName) + " : " + models.get(modelName));
            if (!iterator.hasNext()) continue;
            declaration.append(", ");
        }
        return declaration;
    }

    private InputStream openContentStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes());
    }

    public String getModuleNameFromFile() {
        String fileName = this.simplePage.getFileName();
        if (fileName.endsWith(".atl")) {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        return fileName;
    }

    public void init(IWorkbench currentWorkbench, IStructuredSelection structuredSelection) {
        this.workbench = currentWorkbench;
        this.selection = structuredSelection;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.configElement = config;
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.advancedPage) {
            return this.advancedPage.isPageComplete();
        }
        return this.simplePage.isPageComplete();
    }

    private static Map<String, String> convertPaths(Map<String, String> modelPaths) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String modelName : modelPaths.keySet()) {
            String modelPath = modelPaths.get(modelName);
            result.put(modelName, AtlFileWizard.convertPath(modelPath));
        }
        return result;
    }

    private static String convertPath(String path) {
        if (path.startsWith("file:/")) {
            return path.replaceFirst("file:/", "ext:");
        }
        if (path.startsWith("platform:/resource")) {
            return path.substring(18);
        }
        if (path.startsWith("platform:/plugin") || path.startsWith("pathmap")) {
            return path;
        }
        return "uri:" + path;
    }
}

