/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.qvtd.codegen.qvti.QVTiCodeGenOptions;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCodeGenerator;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtc2qvtu.QVTc2QVTu;
import org.eclipse.qvtd.compiler.internal.qvtc2qvtu.QVTuConfiguration;
import org.eclipse.qvtd.compiler.internal.qvtm2qvtp.QVTm2QVTp;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.ClassRelationships;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.QVTp2QVTg;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.RootScheduledRegion;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Scheduler;
import org.eclipse.qvtd.compiler.internal.qvtu2qvtm.QVTu2QVTm;
import org.eclipse.qvtd.compiler.internal.utilities.JavaSourceFileObject;
import org.eclipse.qvtd.pivot.qvtbase.BaseModel;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtcorebase.analysis.RootDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.schedule.Schedule;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public abstract class AbstractCompilerChain
implements CompilerChain {
    private static final @NonNull Map<@NonNull String, @NonNull String> step2extension = new HashMap<String, String>();
    protected final @NonNull QVTiEnvironmentFactory environmentFactory;
    protected final @NonNull ResourceSet asResourceSet;
    protected final @NonNull Map<@NonNull String, @NonNull Map<@NonNull CompilerChain.Key<?>, @Nullable Object>> options;
    protected final @NonNull URI txURI;
    protected final @NonNull URI prefixURI;
    private @Nullable List<@NonNull CompilerChain.Listener> listeners = null;

    static {
        step2extension.put("QVTr", "qvtras");
        step2extension.put("Trace", "ecore");
        step2extension.put("GenModel", "genmodel");
        step2extension.put("QVTc", "qvtcas");
        step2extension.put("QVTu", "qvtu.qvtcas");
        step2extension.put("QVTm", "qvtm.qvtcas");
        step2extension.put("QVTp", "qvtp.qvtcas");
        step2extension.put("QVTs", "qvts.xmi");
        step2extension.put("QVTi", "qvtias");
        step2extension.put("Java", "java");
        step2extension.put("Class", "class");
    }

    public static void assertNoResourceErrors(@NonNull String prefix, @NonNull Resource resource) {
        String message = PivotUtil.formatResourceDiagnostics((List)resource.getErrors(), (String)prefix, (String)"\n\t");
        if (message != null) assert (false) : message;
    }

    public static void assertNoValidationErrors(@NonNull String prefix, @NonNull Resource resource) {
        for (EObject eObject : resource.getContents()) {
            AbstractCompilerChain.assertNoValidationErrors(prefix, eObject);
        }
    }

    public static void assertNoValidationErrors(@NonNull String string, EObject eObject) {
        Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject, validationContext);
        List children = diagnostic.getChildren();
        if (children.size() <= 0) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(children.size()) + " validation errors");
        for (Diagnostic child : children) {
            Object data;
            s.append("\n\t");
            if (child.getData().size() > 0 && (data = child.getData().get(0)) instanceof Element) {
                Element eScope = (Element)data;
                while (eScope instanceof Element) {
                    ModelElementCS csElement = ElementUtil.getCsElement((Element)eScope);
                    if (csElement != null) {
                        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
                        if (node != null) {
                            Resource eResource = csElement.eResource();
                            if (eResource != null) {
                                s.append(String.valueOf(eResource.getURI().lastSegment()) + ":");
                            }
                            int startLine = node.getStartLine();
                            s.append(String.valueOf(startLine) + ":");
                        }
                        s.append(String.valueOf(((Element)data).eClass().getName()) + ": ");
                        break;
                    }
                    eScope = eScope.eContainer();
                }
            }
            s.append(child.getMessage());
        }
        assert (false) : s.toString();
    }

    public static @Nullable String getDefaultExtension(@NonNull String key) {
        return step2extension.get(key);
    }

    protected AbstractCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @Nullable Map<@NonNull String, @NonNull Map<@NonNull CompilerChain.Key<?>, @Nullable Object>> options) {
        this.environmentFactory = environmentFactory;
        this.asResourceSet = environmentFactory.getMetamodelManager().getASResourceSet();
        this.txURI = txURI;
        this.prefixURI = txURI.trimSegments(1).appendSegment("temp").appendSegment(txURI.trimFileExtension().lastSegment());
        this.options = options != null ? options : new HashMap();
    }

    @Override
    public void addListener(@NonNull CompilerChain.Listener listener) {
        List<@NonNull CompilerChain.Listener> listeners2 = this.listeners;
        if (listeners2 == null) {
            this.listeners = listeners2 = new ArrayList<CompilerChain.Listener>();
        }
        if (!listeners2.contains(listener)) {
            listeners2.add(listener);
        }
    }

    @Override
    public @NonNull Class<? extends Transformer> build(@NonNull String enforcedOutputName, String ... genModelFiles) throws Exception {
        Transformation asTransformation = this.compile(enforcedOutputName);
        JavaResult javaResult = this.qvti2java(asTransformation, genModelFiles);
        Class<? extends Transformer> txClass = this.java2class(javaResult);
        return txClass;
    }

    @Override
    public abstract @NonNull Transformation compile(@NonNull String var1) throws IOException;

    protected void compiled(@NonNull String stepKey, @NonNull Object object) {
        List<@NonNull CompilerChain.Listener> listeners2 = this.listeners;
        if (listeners2 != null) {
            for (CompilerChain.Listener listener : listeners2) {
                listener.compiled(stepKey, object);
            }
        }
    }

    protected @NonNull QVTuConfiguration createQVTuConfiguration(@NonNull Resource cResource, QVTuConfiguration.Mode mode, @NonNull String enforcedOutputName) throws IOException {
        Transformation transformation = this.getTransformation(cResource);
        ArrayList<@NonNull String> inputNames = new ArrayList<String>();
        boolean gotOutput = false;
        for (TypedModel typedModel : transformation.getModelParameter()) {
            String modelName = typedModel.getName();
            if (modelName == null) continue;
            if (modelName.equals(enforcedOutputName)) {
                if (gotOutput) {
                    throw new CompilerChainException("Ambiguous output domain ''{0}''", enforcedOutputName);
                }
                gotOutput = true;
                continue;
            }
            inputNames.add(modelName);
        }
        if (!gotOutput) {
            throw new CompilerChainException("Unknown output domain ''{0}''", enforcedOutputName);
        }
        return new QVTuConfiguration(QVTuConfiguration.Mode.ENFORCE, inputNames, Collections.singletonList(enforcedOutputName));
    }

    protected @NonNull Resource createResource(@NonNull URI uri) throws IOException {
        Resource resource = this.asResourceSet.createResource(uri);
        if (resource == null) {
            throw new IOException("Failed to create " + uri);
        }
        return resource;
    }

    @Override
    public void dispose() {
    }

    public <T> @Nullable T getOption(@NonNull String stepKey, @NonNull CompilerChain.Key<T> optionKey) {
        Map<CompilerChain.Key<?>, Object> defaultOptions;
        Map<@NonNull CompilerChain.Key<?>, @Nullable Object> stepOptions = this.options.get(stepKey);
        if (stepOptions == null && !this.options.containsKey(stepOptions)) {
            stepOptions = this.options.get("default");
        }
        Object saveOptions = null;
        if (stepOptions != null && (saveOptions = stepOptions.get(optionKey)) == null && !this.options.containsKey(optionKey) && (defaultOptions = this.options.get("default")) != null) {
            saveOptions = defaultOptions.get(optionKey);
        }
        Object castSaveOptions = saveOptions;
        return (T)castSaveOptions;
    }

    protected @NonNull Resource getResource(@NonNull URI uri) throws IOException {
        Resource resource = this.asResourceSet.getResource(uri, true);
        if (resource == null) {
            throw new IOException("Failed to get " + uri);
        }
        AbstractCompilerChain.assertNoResourceErrors("get", resource);
        AbstractCompilerChain.assertNoValidationErrors("get validation", resource);
        return resource;
    }

    private @NonNull Schedule getSchedule(@NonNull Resource gResource) throws IOException {
        for (EObject eContent : gResource.getContents()) {
            if (!(eContent instanceof Schedule)) continue;
            return (Schedule)eContent;
        }
        throw new IOException("No Schedule element in " + gResource.getURI());
    }

    public @NonNull Transformation getTransformation(Resource resource) throws IOException {
        ArrayList<@NonNull E> asTransformations = new ArrayList();
        for (EObject eContent : resource.getContents()) {
            if (!(eContent instanceof BaseModel)) continue;
            QVTbaseUtil.getAllTransformations((List)ClassUtil.nullFree((List)((BaseModel)eContent).getOwnedPackages()), asTransformations);
        }
        if (asTransformations.size() == 1) {
            return (Transformation)asTransformations.get(0);
        }
        if (asTransformations.size() == 1) {
            throw new IOException("No Transformation element in " + resource.getURI());
        }
        throw new IOException("Multiple Transformation elements in " + resource.getURI());
    }

    public @NonNull URI getURI(@NonNull String stepKey, @NonNull CompilerChain.Key<URI> uriKey) {
        URI uri = (URI)this.getOption(stepKey, URI_KEY);
        return uri != null ? uri : this.prefixURI.appendFileExtension(step2extension.get(stepKey));
    }

    protected @NonNull Class<? extends Transformer> java2class(@NonNull JavaResult javaResult) throws Exception {
        List<String> classpathProjects;
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            String projectName = this.txURI.segment(1);
            classpathProjects = JavaSourceFileObject.createClasspathProjectList(projectName, "org.eclipse.emf.common", "org.eclipse.emf.ecore", "org.eclipse.jdt.annotation", "org.eclipse.ocl.pivot", "org.eclipse.osgi", "org.eclipse.qvtd.runtime");
        } else {
            classpathProjects = null;
        }
        JavaSourceFileObject.saveClass(javaResult.classPath, javaResult.qualifiedClassName, javaResult.code, classpathProjects);
        File explicitClassPath = new File(javaResult.classPath);
        Class<?> txClass = JavaSourceFileObject.loadExplicitClass(explicitClassPath, javaResult.qualifiedClassName);
        assert (txClass != null);
        this.compiled("Class", txClass);
        return txClass;
    }

    private void loadGenModel(@NonNull URI genModelURI) {
        ResourceSet resourceSet = this.environmentFactory.getResourceSet();
        PivotMetamodelManager metamodelManager = this.environmentFactory.getMetamodelManager();
        Resource csGenResource = resourceSet.getResource(genModelURI, true);
        for (EObject eObject : csGenResource.getContents()) {
            if (!(eObject instanceof GenModel)) continue;
            GenModel genModel = (GenModel)eObject;
            genModel.reconcile();
            metamodelManager.addGenModel(genModel);
        }
    }

    protected @NonNull Resource qvtc2qvtp(@NonNull Resource cResource, @NonNull QVTuConfiguration qvtuConfiguration) throws IOException {
        Resource uResource = this.qvtc2qvtu(cResource, qvtuConfiguration);
        Resource mResource = this.qvtu2qvtm(uResource);
        Resource pResource = this.qvtm2qvtp(mResource);
        return pResource;
    }

    protected @NonNull Resource qvtc2qvtu(@NonNull Resource cResource, @NonNull QVTuConfiguration qvtuConfiguration) throws IOException {
        URI qvtuURI = this.getURI("QVTu", URI_KEY);
        Resource uResource = this.createResource(qvtuURI);
        QVTc2QVTu qvtc2qvtu = new QVTc2QVTu((EnvironmentFactory)this.environmentFactory, qvtuConfiguration);
        qvtc2qvtu.transform(cResource, uResource);
        this.saveResource(uResource, "QVTu");
        return uResource;
    }

    protected @NonNull Resource qvtg2qvti(@NonNull Resource pResource, @NonNull Resource gResource, @NonNull QVTp2QVTg qvtp2qvtg) throws IOException {
        URI qvtiURI = this.getURI("QVTi", URI_KEY);
        Schedule schedule = this.getSchedule(gResource);
        Scheduler scheduler = new Scheduler((EnvironmentFactory)this.environmentFactory, schedule, qvtp2qvtg);
        RootScheduledRegion rootRegion = scheduler.qvtp2qvts();
        this.compiled("QVTs", gResource);
        Resource iResource = scheduler.qvts2qvti(rootRegion, qvtiURI, scheduler.getSymbolNameReservation());
        this.saveResource(iResource, "QVTi");
        return iResource;
    }

    protected @NonNull JavaResult qvti2java(@NonNull Transformation asTransformation, String ... genModelFiles) throws IOException {
        File explicitClassPath;
        String javaFileName;
        URI javaURI = this.getURI("Java", URI_KEY);
        URI classURI = this.getURI("Class", URI_KEY);
        ResourceSet resourceSet = this.environmentFactory.getResourceSet();
        resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)GenModelPackage.eINSTANCE);
        if (genModelFiles != null) {
            String[] stringArray = genModelFiles;
            int n = genModelFiles.length;
            int n2 = 0;
            while (n2 < n) {
                String genModelFile = stringArray[n2];
                URI genModelURI = URI.createURI((String)genModelFile).resolve(this.txURI);
                this.loadGenModel(genModelURI);
                ++n2;
            }
        }
        QVTiCodeGenerator cg = new QVTiCodeGenerator(this.environmentFactory, asTransformation);
        QVTiCodeGenOptions options = cg.getOptions();
        options.setUseNullAnnotations(true);
        String javaExtraPrefix = (String)this.getOption("Java", JAVA_EXTRA_PREFIX_KEY);
        if (javaExtraPrefix != null) {
            options.setPackagePrefix(javaExtraPrefix);
        }
        String javaCodeSource = cg.generateClassFile();
        URI normalizedURI = resourceSet.getURIConverter().normalize(javaURI);
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            File binFolder;
            URI createPlatformResourceURI = URI.createPlatformResourceURI((String)"", (boolean)false);
            URI dURI = normalizedURI.deresolve(createPlatformResourceURI);
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(dURI.toString()));
            File file = URIUtil.toFile((java.net.URI)iFile.getLocationURI());
            javaFileName = (String)ClassUtil.nonNullState((Object)file.toString());
            IFile iBinFolder = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(classURI.deresolve(createPlatformResourceURI).toString()));
            explicitClassPath = binFolder = URIUtil.toFile((java.net.URI)iBinFolder.getLocationURI());
        } else {
            javaFileName = (String)ClassUtil.nonNullState((Object)normalizedURI.toFileString());
            URI normalizedClassURI = resourceSet.getURIConverter().normalize(classURI);
            explicitClassPath = new File(normalizedClassURI.toFileString());
        }
        File javaFile = cg.saveSourceFile(javaFileName);
        this.compiled("Java", javaFile);
        return new JavaResult(javaFile, javaCodeSource, cg.getQualifiedName(), String.valueOf(explicitClassPath));
    }

    protected @NonNull Resource qvtm2qvtp(@NonNull Resource mResource) throws IOException {
        URI qvtpURI = this.getURI("QVTp", URI_KEY);
        Resource pResource = this.createResource(qvtpURI);
        QVTm2QVTp tx = new QVTm2QVTp((EnvironmentFactory)this.environmentFactory);
        tx.transform(mResource, pResource);
        this.saveResource(pResource, "QVTp");
        return pResource;
    }

    protected @NonNull Resource qvtp2qvtg(@NonNull Resource pResource, @NonNull QVTp2QVTg qvtp2qvtg) throws IOException {
        URI qvtgURI = this.getURI("QVTs", URI_KEY);
        RootDomainUsageAnalysis domainUsageAnalysis = qvtp2qvtg.getDomainUsageAnalysis();
        Resource gResource = this.createResource(qvtgURI);
        Transformation asTransformation = this.getTransformation(pResource);
        domainUsageAnalysis.analyzeTransformation(asTransformation);
        qvtp2qvtg.run(pResource, gResource);
        gResource.getContents().add((Object)domainUsageAnalysis.getPrimitiveTypeModel());
        this.saveResource(gResource, "QVTg");
        return gResource;
    }

    protected @NonNull Transformation qvtp2qvti(@NonNull Resource pResource) throws IOException {
        QVTcoreDomainUsageAnalysis domainAnalysis = new QVTcoreDomainUsageAnalysis((EnvironmentFactory)this.environmentFactory);
        ClassRelationships classRelationships = new ClassRelationships((EnvironmentFactory)this.environmentFactory);
        QVTp2QVTg qvtp2qvtg = new QVTp2QVTg((RootDomainUsageAnalysis)domainAnalysis, classRelationships);
        Resource gResource = this.qvtp2qvtg(pResource, qvtp2qvtg);
        Resource iResource = this.qvtg2qvti(pResource, gResource, qvtp2qvtg);
        return this.getTransformation(iResource);
    }

    protected @NonNull Resource qvtu2qvtm(@NonNull Resource uResource) throws IOException {
        URI qvtmURI = this.getURI("QVTm", URI_KEY);
        Resource mResource = this.createResource(qvtmURI);
        QVTu2QVTm qvtu2qvtm = new QVTu2QVTm((EnvironmentFactory)this.environmentFactory);
        qvtu2qvtm.transform(uResource, mResource);
        this.saveResource(mResource, "QVTm");
        return mResource;
    }

    @Override
    public void removeListener(@NonNull CompilerChain.Listener listener) {
        List<@NonNull CompilerChain.Listener> listeners2 = this.listeners;
        if (listeners2 != null) {
            listeners2.remove(listener);
        }
    }

    protected void saveResource(@NonNull Resource resource, @NonNull String stepKey) throws IOException {
        Map saveOptions = (Map)this.getOption(stepKey, SAVE_OPTIONS_KEY);
        if (saveOptions != null) {
            resource.save(saveOptions);
        }
        AbstractCompilerChain.assertNoResourceErrors(stepKey, resource);
        if (this.getOption(stepKey, VALIDATE_KEY) == Boolean.TRUE) {
            AbstractCompilerChain.assertNoValidationErrors(stepKey, resource);
        }
        this.compiled(stepKey, resource);
    }

    @Override
    public <T> void setOption(@NonNull String stepKey, @NonNull CompilerChain.Key<T> optionKey, @Nullable T object) {
        Map<@NonNull CompilerChain.Key<?>, @Nullable Object> stepOptions = this.options.get(stepKey);
        if (stepOptions == null) {
            stepOptions = new HashMap();
            this.options.put(stepKey, stepOptions);
        }
        stepOptions.put(optionKey, object);
    }

    protected static class JavaResult {
        @NonNull File file;
        @NonNull String code;
        @NonNull String qualifiedClassName;
        @NonNull String classPath;

        public JavaResult(@NonNull File file, @NonNull String code, @NonNull String qualifiedClassName, @NonNull String classPath) {
            this.file = file;
            this.code = code;
            this.qualifiedClassName = qualifiedClassName;
            this.classPath = classPath;
        }
    }
}

