/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.doc.exe2016.tests.manual;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.qvtd.doc.exe2016.tests.AbstractEXE2016CGTests;
import org.eclipse.qvtd.doc.exe2016.tests.DoublyLinkedListGenerator;
import org.eclipse.qvtd.doc.exe2016.tests.PrintAndLog;
import org.eclipse.qvtd.doc.exe2016.tests.qvtc.doublylinkedlist.DoublyLinkedList;
import org.eclipse.qvtd.doc.exe2016.tests.qvtc.doublylinkedlist.DoublylinkedlistFactory;
import org.eclipse.qvtd.doc.exe2016.tests.qvtc.doublylinkedlist.Element;
import org.eclipse.qvtd.pivot.qvtimperative.QVTimperativePivotStandaloneSetup;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class EXE2016_Manual_Tests
extends AbstractEXE2016CGTests {
    @Before
    public void setUp() throws Exception {
        super.setUp();
        QVTimperativePivotStandaloneSetup.doSetup();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testQVTcCompiler_Families2Persons_EcoreUtil() throws Exception {
        DoublyLinkedListGenerator doublyLinkedListGenerator = new DoublyLinkedListGenerator();
        PrintAndLog logger = new PrintAndLog(this.getName());
        logger.printf("%s\n", this.getName());
        QVTiEnvironmentFactory environmentFactory = new QVTiEnvironmentFactory(ProjectManager.NO_PROJECTS, null);
        try {
            int[] tests;
            int[] nArray = tests = PrintAndLog.getTestSizes();
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                int testSize = nArray[n2];
                List<@NonNull EObject> rootObjects = doublyLinkedListGenerator.createDoublyLinkedListModel(testSize);
                EXE2016_Manual_Tests.garbageCollect();
                logger.printf("%9d, ", testSize);
                long startTime = System.nanoTime();
                DoublyLinkedList oldList = (DoublyLinkedList)rootObjects.iterator().next();
                EcoreUtil.Copier copier = new EcoreUtil.Copier();
                DoublyLinkedList newList = (DoublyLinkedList)copier.copy((EObject)oldList);
                for (Element oldElement : oldList.getOwnedElements()) {
                    Element newElement = (Element)copier.get((Object)oldElement);
                    assert (newElement != null);
                    Element oldTarget = oldElement.getTarget();
                    Element newSource = (Element)copier.get((Object)oldTarget);
                    assert (newSource != null);
                    newElement.setSource(newSource);
                }
                newList.setHeadElement((Element)copier.get((Object)oldList.getHeadElement()));
                long endTime = System.nanoTime();
                logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
                doublyLinkedListGenerator.checkModel(newList, testSize);
                ++n2;
            }
        }
        finally {
            environmentFactory.dispose();
            logger.dispose();
        }
    }

    @Test
    public void testQVTcCompiler_Families2Persons_Manual() throws Exception {
        DoublyLinkedListGenerator doublyLinkedListGenerator = new DoublyLinkedListGenerator();
        PrintAndLog logger = new PrintAndLog(this.getName());
        logger.printf("%s\n", this.getName());
        QVTiEnvironmentFactory environmentFactory = new QVTiEnvironmentFactory(ProjectManager.NO_PROJECTS, null);
        try {
            int[] tests;
            int[] nArray = tests = PrintAndLog.getTestSizes();
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                int testSize = nArray[n2];
                List<@NonNull EObject> rootObjects = doublyLinkedListGenerator.createDoublyLinkedListModel(testSize);
                EXE2016_Manual_Tests.garbageCollect();
                logger.printf("%9d, ", testSize);
                long startTime = System.nanoTime();
                DoublyLinkedList oldList = (DoublyLinkedList)rootObjects.iterator().next();
                EList<Element> oldElements = oldList.getOwnedElements();
                DoublyLinkedList newList = DoublylinkedlistFactory.eINSTANCE.createDoublyLinkedList();
                int iSize = oldElements.size();
                ArrayList<Element> newElements = new ArrayList<Element>(iSize);
                newList.setName(oldList.getName());
                Element prevElement = null;
                for (Element oldElement : oldElements) {
                    Element newElement = DoublylinkedlistFactory.eINSTANCE.createElement();
                    newElement.setName(oldElement.getName());
                    newElement.setTarget(prevElement);
                    newElements.add(newElement);
                    prevElement = newElement;
                }
                if (prevElement != null) {
                    Element firstElement = (Element)newElements.get(0);
                    firstElement.setTarget(prevElement);
                    newList.setHeadElement(firstElement);
                }
                newList.getOwnedElements().addAll(newElements);
                long endTime = System.nanoTime();
                logger.printf("%9.6f\n", (double)(endTime - startTime) / 1.0E9);
                doublyLinkedListGenerator.checkModel(newList, testSize);
                ++n2;
            }
        }
        finally {
            environmentFactory.dispose();
            logger.dispose();
        }
    }
}

