/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionsAnalysis;

public class Concurrency
implements Iterable<PartialRegionAnalysis<PartitionsAnalysis>> {
    protected final @NonNull List<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> partitionAnalyses = new ArrayList<PartialRegionAnalysis<PartitionsAnalysis>>();
    private boolean isCycleStart = false;
    private boolean isCycleEnd = false;
    private @Nullable Integer passNumber = null;

    public boolean add(@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis> partitionAnalysis) {
        assert (!this.partitionAnalyses.contains(partitionAnalysis));
        return this.partitionAnalyses.add(partitionAnalysis);
    }

    public void addPass(int cyclePass) {
        for (PartialRegionAnalysis<PartitionsAnalysis> partitionAnalysis : this.partitionAnalyses) {
            partitionAnalysis.getPartition().addPass(cyclePass);
        }
    }

    public @NonNull Iterable<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> getPartitionAnalyses() {
        return this.partitionAnalyses;
    }

    public boolean isCycleEnd() {
        return this.isCycleEnd;
    }

    public boolean isCycleStart() {
        return this.isCycleStart;
    }

    @Override
    public @NonNull Iterator<@NonNull PartialRegionAnalysis<@NonNull PartitionsAnalysis>> iterator() {
        return this.partitionAnalyses.iterator();
    }

    void setPass(int passNumber) {
        assert (this.passNumber == null);
        this.passNumber = passNumber;
        for (PartialRegionAnalysis<PartitionsAnalysis> partitionAnalysis : this.partitionAnalyses) {
            partitionAnalysis.getPartition().setPass(passNumber);
        }
    }

    public int size() {
        return this.partitionAnalyses.size();
    }

    public void setCycleStart() {
        this.isCycleStart = true;
    }

    public void setCycleEnd() {
        this.isCycleEnd = true;
    }

    public @NonNull String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        s.append(this.passNumber);
        this.toString(s);
        s.append("]");
        return s.toString();
    }

    public void toString(@NonNull StringBuilder s) {
        if (this.isCycleStart) {
            s.append(", \u00abstart\u00bb");
        }
        for (PartialRegionAnalysis<PartitionsAnalysis> partitionAnalysis : this.partitionAnalyses) {
            s.append(", ");
            s.append(partitionAnalysis);
        }
        if (this.isCycleEnd) {
            s.append(", \u00abend\u00bb");
        }
    }
}

