/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtcore.tests;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.tests.XtextTestCase;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.xtext.qvtbase.tests.ModelNormalizer;

public class SimpleRDBMSNormalizer
implements ModelNormalizer {
    public static final @NonNull SimpleRDBMSNormalizer INSTANCE = new SimpleRDBMSNormalizer();

    public @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull XtextTestCase.Normalizer> normalize(@NonNull Resource resource) {
        EObject eRoot = (EObject)resource.getContents().get(0);
        EPackage ePackage = eRoot.eClass().getEPackage();
        EClass schemaClass = (EClass)ePackage.getEClassifier("Schema");
        assert (schemaClass != null);
        EClass tableClass = (EClass)ePackage.getEClassifier("Table");
        assert (tableClass != null);
        EClass rModelElementClass = (EClass)ePackage.getEClassifier("RModelElement");
        assert (rModelElementClass != null);
        EClass columnClass = (EClass)ePackage.getEClassifier("Column");
        assert (columnClass != null);
        EReference schemaTables = (EReference)schemaClass.getEStructuralFeature("tables");
        assert (schemaTables != null);
        EReference tableColumn = (EReference)tableClass.getEStructuralFeature("columns");
        assert (tableColumn != null);
        EAttribute rmodelElementName = (EAttribute)tableClass.getEStructuralFeature("name");
        assert (rmodelElementName != null);
        EReference tableForeignKeys = (EReference)tableClass.getEStructuralFeature("foreignKeys");
        assert (tableForeignKeys != null);
        RModelElementNameComparator rmodelElementNameComparator = new RModelElementNameComparator(rmodelElementName);
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull XtextTestCase.Normalizer> normalizers = new ArrayList<XtextTestCase.Normalizer>();
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            EObject eObject = (EObject)tit.next();
            EClass eClass = eObject.eClass();
            if (schemaClass.isSuperTypeOf(eClass)) {
                normalizers.add(new SchemaNormalizer(eObject, schemaTables, rmodelElementNameComparator));
                continue;
            }
            if (!tableClass.isSuperTypeOf(eClass)) continue;
            normalizers.add(new TableNormalizer(eObject, tableColumn, tableForeignKeys, rmodelElementNameComparator));
        }
        for (XtextTestCase.Normalizer normalizer : normalizers) {
            normalizer.normalize();
        }
        return normalizers;
    }

    protected static class RModelElementNameComparator
    implements Comparator<EObject> {
        private final @NonNull EAttribute rmodelElementName;

        public RModelElementNameComparator(@NonNull EAttribute rmodelElementName) {
            this.rmodelElementName = rmodelElementName;
        }

        @Override
        public int compare(EObject o1, EObject o2) {
            String n1 = (String)o1.eGet((EStructuralFeature)this.rmodelElementName);
            String n2 = (String)o2.eGet((EStructuralFeature)this.rmodelElementName);
            return ClassUtil.safeCompareTo((Comparable)((Object)n1), (Comparable)((Object)n2));
        }
    }

    protected class SchemaNormalizer
    implements XtextTestCase.Normalizer {
        protected final @NonNull EObject schema;
        protected final @NonNull EReference schemaTables;
        protected final @NonNull RModelElementNameComparator rmodelElementNameComparator;

        public SchemaNormalizer(@NonNull EObject schema, @NonNull EReference schemaTables, RModelElementNameComparator rmodelElementNameComparator) {
            this.schema = schema;
            this.schemaTables = schemaTables;
            this.rmodelElementNameComparator = rmodelElementNameComparator;
        }

        public void denormalize() {
            throw new UnsupportedOperationException();
        }

        public void normalize() {
            EList tables = (EList)this.schema.eGet((EStructuralFeature)this.schemaTables);
            ECollections.sort((EList)tables, (Comparator)this.rmodelElementNameComparator);
        }
    }

    protected class TableNormalizer
    implements XtextTestCase.Normalizer {
        protected final @NonNull EObject table;
        protected final @NonNull EReference tableColumn;
        protected final @NonNull EReference tableForeignKeys;
        protected final @NonNull RModelElementNameComparator rmodelElementNameComparator;

        public TableNormalizer(@NonNull EObject table, @NonNull EReference tableColumn, @NonNull EReference tableForeignKeys, RModelElementNameComparator rmodelElementNameComparator) {
            this.table = table;
            this.tableColumn = tableColumn;
            this.tableForeignKeys = tableForeignKeys;
            this.rmodelElementNameComparator = rmodelElementNameComparator;
        }

        public void denormalize() {
            throw new UnsupportedOperationException();
        }

        public void normalize() {
            EList columns = (EList)this.table.eGet((EStructuralFeature)this.tableColumn);
            ECollections.sort((EList)columns, (Comparator)this.rmodelElementNameComparator);
            EList foreignKeys = (EList)this.table.eGet((EStructuralFeature)this.tableForeignKeys);
            ECollections.sort((EList)foreignKeys, (Comparator)this.rmodelElementNameComparator);
        }
    }
}

