/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.cs2as.compiler.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.IfExp;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.ShadowExp;
import org.eclipse.ocl.pivot.ShadowPart;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.PivotHelper;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.UniqueList;
import org.eclipse.qvtd.cs2as.compiler.internal.OCL2QVTmUtil;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseHelper;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtcore.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcore.GuardVariable;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;
import org.eclipse.qvtd.pivot.qvtcore.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcore.QVTcoreFactory;
import org.eclipse.qvtd.pivot.qvtcore.RealizedVariable;

public class OCL2QVTm {
    private @NonNull EnvironmentFactory envFact;
    private @NonNull String traceabilityPropName;
    public static final @NonNull String RIGHT_MODEL_TYPE_NAME = "rightAS";
    public static final @NonNull String LEFT_MODEL_TYPE_NAME = "leftCS";
    public static final @NonNull String OTHER_MODEL_TYPE_NAME = "$other$";
    private @NonNull TypedModel leftTypedModel = QVTbaseFactory.eINSTANCE.createTypedModel();
    private @NonNull TypedModel rightTypedModel = QVTbaseFactory.eINSTANCE.createTypedModel();

    public OCL2QVTm(@NonNull EnvironmentFactory envFact, @NonNull String traceabilityPropName) {
        this.envFact = envFact;
        this.traceabilityPropName = traceabilityPropName;
    }

    public @NonNull Resource run(@NonNull ResourceSet resourceSet, @NonNull URI oclDocURI, @NonNull URI outputURI) {
        if (!"oclas".equals(oclDocURI.fileExtension())) {
            throw new IllegalArgumentException(String.valueOf(oclDocURI.toString()) + " is not an .oclas URI");
        }
        Resource input = resourceSet.getResource(oclDocURI, true);
        EObject rootModel = (EObject)input.getContents().get(0);
        if (rootModel instanceof Model) {
            Model model = (Model)rootModel;
            CoreModel outputModel = this.oclModelToImperativeModel().apply(model);
            Resource outputResource = resourceSet.createResource(outputURI);
            outputResource.getContents().add((Object)outputModel);
            return outputResource;
        }
        throw new IllegalArgumentException(String.valueOf(oclDocURI.toString()) + " doesn't contain an OCL Model");
    }

    public Function<Model, CoreModel> oclModelToImperativeModel() {
        return oclModel -> {
            Object importedCompletePackage;
            CoreModel iModel = QVTcoreFactory.eINSTANCE.createCoreModel();
            List allAstOps = OCL2QVTmUtil.getAllContents().apply((EObject)oclModel).filter(this.isAstOp()).map(Operation.class::cast).collect(Collectors.toList());
            List shadowExps = allAstOps.stream().flatMap(OCL2QVTmUtil.getAllContents()).filter(ShadowExp.class::isInstance).map(ShadowExp.class::cast).collect(Collectors.toList());
            List shadowParts = allAstOps.stream().flatMap(OCL2QVTmUtil.getAllContents()).filter(ShadowPart.class::isInstance).map(ShadowPart.class::cast).collect(Collectors.toList());
            iModel.setExternalURI(oclModel.getExternalURI().replace(".ocl", ".qvtm.qvtcas"));
            iModel.getOwnedImports().addAll(oclModel.getOwnedImports().stream().map(this.importToImport()).collect(Collectors.toList()));
            Package pPackage = PivotFactory.eINSTANCE.createPackage();
            pPackage.setName("");
            iModel.getOwnedPackages().add(pPackage);
            Transformation pTx = QVTbaseFactory.eINSTANCE.createTransformation();
            pTx.setName(iModel.getName().replace('.', '_'));
            pPackage.getOwnedClasses().add(pTx);
            pTx.getModelParameter().add((Object)new QVTbaseHelper(this.envFact).createPrimitiveTypedModel());
            this.leftTypedModel.setName(LEFT_MODEL_TYPE_NAME);
            this.leftTypedModel.getUsedPackage().addAll((Collection)shadowExps.stream().map(OCL2QVTmUtil.getExpressionContextType()).map(OCL2QVTmUtil.getOwningPackage()).collect(Collectors.toSet()));
            pTx.getModelParameter().add((Object)this.leftTypedModel);
            this.rightTypedModel.setName(RIGHT_MODEL_TYPE_NAME);
            this.rightTypedModel.getUsedPackage().addAll((Collection)shadowExps.stream().map(x -> x.getType()).map(OCL2QVTmUtil.getOwningPackage()).collect(Collectors.toSet()));
            pTx.getModelParameter().add((Object)this.rightTypedModel);
            CompleteModel completeModel = this.envFact.getCompleteModel();
            HashSet<@NonNull CompletePackage> allKnownCompletePackages = new HashSet<CompletePackage>();
            HashSet<@NonNull CompleteClass> allKnownCompleteClasses = new HashSet<CompleteClass>();
            for (Package importedPackage : QVTbaseUtil.getUsedPackages((TypedModel)this.leftTypedModel)) {
                importedCompletePackage = completeModel.getCompletePackage(importedPackage);
                this.accumulateUsedPackages(allKnownCompletePackages, allKnownCompleteClasses, (CompletePackage)importedCompletePackage);
            }
            for (Package importedPackage : QVTbaseUtil.getUsedPackages((TypedModel)this.rightTypedModel)) {
                importedCompletePackage = completeModel.getCompletePackage(importedPackage);
                this.accumulateUsedPackages(allKnownCompletePackages, allKnownCompleteClasses, (CompletePackage)importedCompletePackage);
            }
            HashSet<@NonNull CompletePackage> allUsedCompletePackages = new HashSet<CompletePackage>();
            for (Import anImport : PivotUtil.getOwnedImports((Model)oclModel)) {
                Namespace importedNamespace = anImport.getImportedNamespace();
                if (!(importedNamespace instanceof Model)) continue;
                for (Package importedPackage : PivotUtil.getOwnedPackages((Model)((Model)importedNamespace))) {
                    CompletePackage importedCompletePackage2 = completeModel.getCompletePackage(importedPackage);
                    this.accumulateUsedPackages(allUsedCompletePackages, new HashSet<CompleteClass>(), importedCompletePackage2);
                }
            }
            CompletePackage libraryCompletePackage = completeModel.getCompletePackage(this.envFact.getStandardLibrary().getOclAnyType().getOwningPackage());
            HashSet otherUsedCompletePackages = new HashSet(allUsedCompletePackages);
            otherUsedCompletePackages.removeAll(allKnownCompletePackages);
            otherUsedCompletePackages.remove(libraryCompletePackage);
            if (otherUsedCompletePackages.size() > 0) {
                TypedModel otherTypedModel = QVTbaseFactory.eINSTANCE.createTypedModel();
                otherTypedModel.setName(OTHER_MODEL_TYPE_NAME);
                EList otherUsedPackages = otherTypedModel.getUsedPackage();
                for (CompletePackage otherUsedCompletePackage : otherUsedCompletePackages) {
                    otherUsedPackages.add(otherUsedCompletePackage.getPrimaryPackage());
                }
                pTx.getModelParameter().add((Object)otherTypedModel);
            }
            pTx.getRule().addAll((Collection)shadowExps.stream().filter(this.shadowExpToCreationMappingGuard()).map(this.shadowExpToCreationMapping()).collect(Collectors.toList()));
            pTx.getRule().addAll((Collection)shadowParts.stream().filter(this.shadowPartToUpdateMappingGuard()).map(this.shadowPartToUpdateMapping()).collect(Collectors.toList()));
            pTx.getRule().addAll((Collection)allAstOps.stream().filter(this.astOpWithNoShadowExps2UpdateMappingGuard()).map(this.astOpWithNoShadowExps2UpdateMapping()).collect(Collectors.toList()));
            return iModel;
        };
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void accumulateUsedPackages(@NonNull Set<@NonNull CompletePackage> allUsedCompletePackages, @NonNull Set<@NonNull CompleteClass> allUsedCompleteClasses, @NonNull CompletePackage completePackage) {
        if (allUsedCompletePackages.add(completePackage)) {
            @NonNull UniqueList moreCompletePackages = new UniqueList();
            for (CompleteClass completeClass : PivotUtil.getOwnedCompleteClasses((CompletePackage)completePackage)) {
                if (!allUsedCompleteClasses.add(completeClass)) continue;
                for (CompleteClass superCompleteClass : completeClass.getProperSuperCompleteClasses()) {
                    if (!allUsedCompleteClasses.add(superCompleteClass)) continue;
                    CompletePackage superCompletePackage = superCompleteClass.getOwningCompletePackage();
                    assert (superCompletePackage != null);
                    moreCompletePackages.add(superCompletePackage);
                }
            }
            for (CompletePackage nestedCompletePackage : moreCompletePackages) {
                this.accumulateUsedPackages(allUsedCompletePackages, allUsedCompleteClasses, nestedCompletePackage);
            }
        }
    }

    public Function<@NonNull Import, @NonNull Import> importToImport() {
        return oclImport -> {
            Import pImport = PivotFactory.eINSTANCE.createImport();
            pImport.setName(oclImport.getName());
            pImport.setImportedNamespace(oclImport.getImportedNamespace());
            return pImport;
        };
    }

    protected Predicate<@NonNull ShadowExp> shadowExpToCreationMappingGuard() {
        return shadowExp -> !OCL2QVTmUtil.getAllContainers().apply((EObject)shadowExp).anyMatch(ShadowExp.class::isInstance);
    }

    public Function<@NonNull ShadowExp, @NonNull Mapping> shadowExpToCreationMapping() {
        return shadowExp -> {
            Mapping mapping = QVTcoreFactory.eINSTANCE.createMapping();
            mapping.setName(OCL2QVTmUtil.getCreationMappingName().apply((ShadowExp)shadowExp));
            CoreDomain leftDomain = this.createCreationMapping_LeftDomain((ShadowExp)shadowExp);
            CoreDomain rightDomain = this.createCreationMapping_RightDomain((ShadowExp)shadowExp);
            mapping.getDomain().add((Object)leftDomain);
            mapping.getDomain().add((Object)rightDomain);
            VariableDeclaration leftVar = (VariableDeclaration)leftDomain.getGuardPattern().getOwnedVariables().get(0);
            GuardPattern guardPattern = QVTcoreFactory.eINSTANCE.createGuardPattern();
            BottomPattern bottomPattern = QVTcoreFactory.eINSTANCE.createBottomPattern();
            mapping.setGuardPattern(guardPattern);
            mapping.setBottomPattern(bottomPattern);
            PropertyAssignment pAssignment = QVTcoreFactory.eINSTANCE.createPropertyAssignment();
            VariableExp value = PivotUtil.createVariableExp((Variable)((Variable)rightDomain.getBottomPattern().getRealizedVariable().get(0)));
            VariableExp slotExpression = PivotUtil.createVariableExp((VariableDeclaration)leftVar);
            pAssignment.setValue((OCLExpression)value);
            pAssignment.setSlotExpression((OCLExpression)slotExpression);
            pAssignment.setTargetProperty(this.getTraceabilityProperty(slotExpression.getType()));
            bottomPattern.getAssignment().add((Object)pAssignment);
            this.updateGuardPattern((ShadowExp)shadowExp, guardPattern, leftVar);
            this.workaround495327(OCL2QVTmUtil.getAllContainers().apply((EObject)shadowExp).filter(Operation.class::isInstance).map(Operation.class::cast).findFirst().get(), mapping, leftDomain);
            return mapping;
        };
    }

    protected Predicate<@NonNull ShadowPart> shadowPartToUpdateMappingGuard() {
        return shadowPart -> {
            ShadowExp containingShadowExp = (ShadowExp)shadowPart.eContainer();
            return this.shadowExpToCreationMappingGuard().test(containingShadowExp);
        };
    }

    public Function<@NonNull ShadowPart, @NonNull Mapping> shadowPartToUpdateMapping() {
        return shadowPart -> {
            Mapping mapping = QVTcoreFactory.eINSTANCE.createMapping();
            mapping.setName(OCL2QVTmUtil.getUpdateMappingName().apply((ShadowPart)shadowPart));
            ShadowExp shadowExp = (ShadowExp)shadowPart.eContainer();
            Property refProp = shadowPart.getReferredProperty();
            CoreDomain leftDomain = this.createUpdateMapping_LeftDomain(shadowExp);
            CoreDomain rightDomain = this.createUpdateMapping_RightDomain();
            mapping.getDomain().add((Object)leftDomain);
            mapping.getDomain().add((Object)rightDomain);
            VariableDeclaration leftVar = (VariableDeclaration)leftDomain.getGuardPattern().getOwnedVariables().get(0);
            VariableExp varExp = PivotFactory.eINSTANCE.createVariableExp();
            varExp.setReferredVariable(leftVar);
            varExp.setType(varExp.getReferredVariable().getType());
            Property tracebilityProperty = this.getTraceabilityProperty(varExp.getType());
            PropertyCallExp astPropCallExp = PivotFactory.eINSTANCE.createPropertyCallExp();
            astPropCallExp.setOwnedSource((OCLExpression)varExp);
            astPropCallExp.setReferredProperty(tracebilityProperty);
            astPropCallExp.setType(astPropCallExp.getReferredProperty().getType());
            OperationCallExp asTypeOpCallExp = PivotFactory.eINSTANCE.createOperationCallExp();
            asTypeOpCallExp.setOwnedSource((OCLExpression)astPropCallExp);
            asTypeOpCallExp.setReferredOperation(this.getOclAnyOclAsTypeOp());
            asTypeOpCallExp.setType((Type)shadowExp.getType());
            TypeExp argTypeExp = this.createTypeExp((Type)shadowExp.getType());
            argTypeExp.setType((Type)this.getOclMetaClass());
            asTypeOpCallExp.getOwnedArguments().add(argTypeExp);
            PropertyAssignment pAssignment = QVTcoreFactory.eINSTANCE.createPropertyAssignment();
            pAssignment.setTargetProperty(refProp);
            pAssignment.setValue(this.createPropertyAssignmentValue(shadowPart.getOwnedInit(), leftVar));
            pAssignment.setSlotExpression((OCLExpression)asTypeOpCallExp);
            GuardPattern guardPattern = QVTcoreFactory.eINSTANCE.createGuardPattern();
            BottomPattern bottomPattern = QVTcoreFactory.eINSTANCE.createBottomPattern();
            mapping.setGuardPattern(guardPattern);
            mapping.setBottomPattern(bottomPattern);
            bottomPattern.getAssignment().add((Object)pAssignment);
            this.updateGuardPattern(shadowExp, guardPattern, leftVar);
            this.workaround495327(OCL2QVTmUtil.getAllContainers().apply((EObject)shadowExp).filter(Operation.class::isInstance).map(Operation.class::cast).findFirst().get(), mapping, leftDomain);
            return mapping;
        };
    }

    protected Predicate<@NonNull Operation> astOpWithNoShadowExps2UpdateMappingGuard() {
        return operation -> this.isAstOp().test((EObject)operation) && !this.isInvalidOp().test((EObject)operation) && !OCL2QVTmUtil.getAllContents().apply((EObject)operation).anyMatch(x -> x instanceof ShadowExp);
    }

    public Function<@NonNull Operation, @NonNull Mapping> astOpWithNoShadowExps2UpdateMapping() {
        return operation -> {
            Mapping mapping = QVTcoreFactory.eINSTANCE.createMapping();
            mapping.setName(this.getAstPropUpdateMappingName().apply((Operation)operation));
            CoreDomain leftDomain = this.createUpdateMapping_LeftDomain((Operation)operation);
            CoreDomain rightDomain = this.createUpdateMapping_RightDomain();
            mapping.getDomain().add((Object)leftDomain);
            mapping.getDomain().add((Object)rightDomain);
            VariableDeclaration leftVar = (VariableDeclaration)leftDomain.getGuardPattern().getOwnedVariables().get(0);
            GuardPattern guardPattern = QVTcoreFactory.eINSTANCE.createGuardPattern();
            BottomPattern bottomPattern = QVTcoreFactory.eINSTANCE.createBottomPattern();
            mapping.setGuardPattern(guardPattern);
            mapping.setBottomPattern(bottomPattern);
            VariableExp varExp = PivotFactory.eINSTANCE.createVariableExp();
            varExp.setReferredVariable(leftVar);
            varExp.setType(leftVar.getType());
            PropertyAssignment pAssignment = QVTcoreFactory.eINSTANCE.createPropertyAssignment();
            ExpressionInOCL bodyExp = (ExpressionInOCL)operation.getBodyExpression();
            pAssignment.setTargetProperty(this.getTraceabilityProperty(varExp.getType()));
            pAssignment.setValue(this.createPropertyAssignmentValue(bodyExp.getOwnedBody(), leftVar));
            pAssignment.setSlotExpression((OCLExpression)varExp);
            bottomPattern.getAssignment().add((Object)pAssignment);
            this.workaround495327((Operation)operation, mapping, leftDomain);
            return mapping;
        };
    }

    private CoreDomain createDomain() {
        CoreDomain domain = QVTcoreFactory.eINSTANCE.createCoreDomain();
        GuardPattern guardPattern = QVTcoreFactory.eINSTANCE.createGuardPattern();
        BottomPattern bottomPattern = QVTcoreFactory.eINSTANCE.createBottomPattern();
        domain.setGuardPattern(guardPattern);
        domain.setBottomPattern(bottomPattern);
        return domain;
    }

    private CoreDomain createLeftDomain(Type type) {
        CoreDomain domain = this.createDomain();
        domain.setTypedModel(this.leftTypedModel);
        domain.setIsCheckable(true);
        GuardVariable variable = QVTcoreFactory.eINSTANCE.createGuardVariable();
        variable.setName("l" + OCL2QVTmUtil.firstToUpperCase().apply(type.getName()));
        variable.setType(type);
        domain.getGuardPattern().getOwnedVariables().add((Object)variable);
        return domain;
    }

    private CoreDomain createRightDomain() {
        CoreDomain domain = this.createDomain();
        domain.setTypedModel(this.rightTypedModel);
        domain.setIsEnforceable(true);
        return domain;
    }

    private CoreDomain createRightDomain(Type type) {
        CoreDomain domain = this.createRightDomain();
        RealizedVariable variable = QVTcoreFactory.eINSTANCE.createRealizedVariable();
        variable.setName("r" + OCL2QVTmUtil.firstToUpperCase().apply(type.getName()));
        variable.setType(type);
        domain.getBottomPattern().getRealizedVariable().add((Object)variable);
        return domain;
    }

    private CoreDomain createCreationMapping_LeftDomain(ShadowExp shadowExp) {
        return this.createLeftDomain((Type)OCL2QVTmUtil.getExpressionContextType().apply(shadowExp));
    }

    private CoreDomain createCreationMapping_RightDomain(ShadowExp shadowExp) {
        return this.createRightDomain((Type)shadowExp.getType());
    }

    private CoreDomain createUpdateMapping_LeftDomain(ShadowExp shadowExp) {
        return this.createLeftDomain((Type)OCL2QVTmUtil.getExpressionContextType().apply(shadowExp));
    }

    private CoreDomain createUpdateMapping_RightDomain() {
        return this.createRightDomain();
    }

    private CoreDomain createUpdateMapping_LeftDomain(Operation operation) {
        return this.createLeftDomain((Type)operation.getOwningClass());
    }

    private OCLExpression createPropertyAssignmentValue(OCLExpression exp, VariableDeclaration leftVar) {
        OCLExpression newInitExp = (OCLExpression)EcoreUtil.copy((EObject)exp);
        return this.doReplacements(newInitExp, leftVar);
    }

    private OCLExpression doReplacements(OCLExpression oclExp, VariableDeclaration leftVar) {
        ArrayList<OCLExpression> result = new ArrayList<OCLExpression>();
        result.add(oclExp);
        OCL2QVTmUtil.getAllContentsIncludingSelf().apply((EObject)oclExp).forEach(x -> {
            if (this.isSelfVarExp().test((EObject)x)) {
                ((VariableExp)x).setReferredVariable(leftVar);
            } else if (this.isAstOpCallExp().test((EObject)x)) {
                OperationCallExp exp = (OperationCallExp)x;
                PropertyCallExp astPropCallExp = PivotFactory.eINSTANCE.createPropertyCallExp();
                astPropCallExp.setOwnedSource(exp.getOwnedSource());
                astPropCallExp.setReferredProperty(this.getTraceabilityProperty(astPropCallExp.getOwnedSource().getType()));
                astPropCallExp.setType(astPropCallExp.getReferredProperty().getType());
                astPropCallExp.setTypeValue(exp.getTypeValue());
                astPropCallExp.getOwnedComments().addAll(exp.getOwnedComments());
                astPropCallExp.getOwnedExtensions().addAll(exp.getOwnedExtensions());
                astPropCallExp.setName(exp.getName());
                astPropCallExp.setIsSafe(exp.isIsSafe());
                astPropCallExp.setIsRequired(exp.isIsRequired());
                astPropCallExp.setIsImplicit(exp.isIsImplicit());
                astPropCallExp.setIsPre(exp.isIsPre());
                Type castType = exp.getType();
                OperationCallExp asTypeOpCallExp = PivotFactory.eINSTANCE.createOperationCallExp();
                asTypeOpCallExp.setOwnedSource((OCLExpression)astPropCallExp);
                asTypeOpCallExp.setReferredOperation(this.getOclAnyOclAsTypeOp());
                asTypeOpCallExp.setType(castType);
                asTypeOpCallExp.setIsSafe(astPropCallExp.isIsSafe());
                TypeExp argTypeExp = this.createTypeExp(castType);
                asTypeOpCallExp.getOwnedArguments().add(argTypeExp);
                if (result.contains(exp)) {
                    result.remove(exp);
                    result.add((OCLExpression)asTypeOpCallExp);
                } else {
                    EcoreUtil.replace((EObject)exp, (EObject)asTypeOpCallExp);
                }
                EcoreUtil.delete((EObject)exp);
            }
        });
        return (OCLExpression)result.get(0);
    }

    private void updateGuardPattern(ShadowExp shadowExp, GuardPattern guardPattern, VariableDeclaration leftVar) {
        EObject container = shadowExp.eContainer();
        if (container instanceof IfExp) {
            IfExp ifExp = (IfExp)container;
            OCLExpression condition = ifExp.getOwnedCondition();
            ArrayList<OCLExpression> guardPredicates = new ArrayList<OCLExpression>();
            if (ifExp.getOwnedThen() == shadowExp) {
                guardPredicates.add((OCLExpression)EcoreUtil.copy((EObject)condition));
            } else {
                guardPredicates.add(this.createNegatedExpression(condition));
            }
            container = container.eContainer();
            while (container instanceof IfExp) {
                ifExp = (IfExp)container;
                guardPredicates.add(this.createNegatedExpression(ifExp.getOwnedCondition()));
                container = container.eContainer();
            }
            Collections.reverse(guardPredicates);
            for (OCLExpression guardPredicate : guardPredicates) {
                org.eclipse.qvtd.pivot.qvtbase.Predicate predicate = QVTbaseFactory.eINSTANCE.createPredicate();
                predicate.setConditionExpression(this.doReplacements(guardPredicate, leftVar));
                guardPattern.getPredicate().add((Object)predicate);
            }
        }
    }

    private OCLExpression createNegatedExpression(OCLExpression oclExp) {
        if (this.isBooleanNotOpCallExp().test(oclExp)) {
            OperationCallExp notOpCallExp = (OperationCallExp)oclExp;
            return (OCLExpression)EcoreUtil.copy((EObject)notOpCallExp.getOwnedSource());
        }
        OperationCallExp notOpCallExp = PivotFactory.eINSTANCE.createOperationCallExp();
        notOpCallExp.setName("not");
        notOpCallExp.setReferredOperation(this.getBooleanNotOp());
        notOpCallExp.setType((Type)this.getBooleanPrimitiveType());
        notOpCallExp.setOwnedSource((OCLExpression)EcoreUtil.copy((EObject)oclExp));
        return notOpCallExp;
    }

    private Predicate<EObject> isSelfVarExp() {
        return element -> element instanceof VariableExp && "self".equals(((VariableExp)element).getReferredVariable().getName());
    }

    private Predicate<EObject> isAstOpCallExp() {
        return element -> element instanceof OperationCallExp && this.isAstOp().test((EObject)((OperationCallExp)element).getReferredOperation());
    }

    private Predicate<EObject> isAstOp() {
        return element -> element instanceof Operation && "ast".equals(((Operation)element).getName());
    }

    private Predicate<EObject> isInvalidOp() {
        return element -> {
            LanguageExpression exp;
            if (element instanceof Operation && (exp = ((Operation)element).getBodyExpression()) instanceof ExpressionInOCL) {
                OCLExpression bodyExp = ((ExpressionInOCL)exp).getOwnedBody();
                return bodyExp.getType() == this.envFact.getStandardLibrary().getOclInvalidType();
            }
            return false;
        };
    }

    private @NonNull Property getTraceabilityProperty(Type type) {
        Class aClass = type.isClass();
        assert (aClass != null);
        Class pClass = this.envFact.getMetamodelManager().getPrimaryClass(aClass);
        Set<Class> allClasses = OCL2QVTmUtil.getSuperClasses().apply(pClass);
        allClasses.add(pClass);
        return allClasses.stream().flatMap(x -> x.getOwnedProperties().stream()).filter(x -> this.traceabilityPropName.equals(x.getName())).findFirst().get();
    }

    private Function<@NonNull Operation, @NonNull String> getAstPropUpdateMappingName() {
        return op -> String.valueOf('u') + op.getOwningClass().getName() + '_' + this.traceabilityPropName;
    }

    private @NonNull Operation getOclAnyEqualsOp() {
        Class oclAny = this.envFact.getStandardLibrary().getOclAnyType();
        return this.envFact.getMetamodelManager().getPrimaryClass(oclAny).getOwnedOperations().stream().filter(x -> "=".equals(x.getName())).findFirst().get();
    }

    private @NonNull Class getOclMetaClass() {
        return this.envFact.getStandardLibrary().getClassType();
    }

    private @NonNull Operation getOclAnyOclAsTypeOp() {
        Class oclAny = this.envFact.getStandardLibrary().getOclAnyType();
        return this.envFact.getMetamodelManager().getPrimaryClass(oclAny).getOwnedOperations().stream().filter(x -> "oclAsType".equals(x.getName())).findFirst().get();
    }

    private @NonNull Operation getOclAnyOclIsTypeOfOp() {
        Class oclAny = this.envFact.getStandardLibrary().getOclAnyType();
        return this.envFact.getMetamodelManager().getPrimaryClass(oclAny).getOwnedOperations().stream().filter(x -> "oclIsTypeOf".equals(x.getName())).findFirst().get();
    }

    private @NonNull Class getBooleanPrimitiveType() {
        return this.envFact.getStandardLibrary().getBooleanType();
    }

    private @NonNull Operation getBooleanNotOp() {
        Class boolType = this.envFact.getStandardLibrary().getBooleanType();
        return this.envFact.getMetamodelManager().getPrimaryClass(boolType).getOwnedOperations().stream().filter(x -> "not".equals(x.getName())).findFirst().get();
    }

    private Predicate<OCLExpression> isBooleanNotOpCallExp() {
        return exp -> exp instanceof OperationCallExp && ((OperationCallExp)exp).getReferredOperation() == this.getBooleanNotOp();
    }

    private TypeExp createTypeExp(Type type) {
        TypeExp argTypeExp = PivotFactory.eINSTANCE.createTypeExp();
        argTypeExp.setReferredType(type);
        argTypeExp.setType((Type)this.getOclMetaClass());
        return argTypeExp;
    }

    private void workaround495327(Operation op, Mapping mapping, CoreDomain leftDomain) {
        PivotMetamodelManager mm = (PivotMetamodelManager)this.envFact.getMetamodelManager();
        if (!mm.getFinalAnalysis().isFinal(op)) {
            GuardPattern guard = mapping.getGuardPattern();
            VariableDeclaration leftVar = (VariableDeclaration)leftDomain.getGuardPattern().getOwnedVariables().get(0);
            org.eclipse.qvtd.pivot.qvtbase.Predicate predicate = QVTbaseFactory.eINSTANCE.createPredicate();
            PivotHelper helper = new PivotHelper(this.envFact);
            VariableExp sourceExp = helper.createVariableExp(leftVar);
            TypeExp argTypeExp = this.createTypeExp(leftVar.getType());
            predicate.setConditionExpression((OCLExpression)helper.createOperationCallExp((OCLExpression)sourceExp, this.getOclAnyOclIsTypeOfOp(), Collections.singletonList(argTypeExp)));
            guard.getPredicate().add((Object)predicate);
        }
    }
}

