/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtbase.tests.utilities;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.validation.ValidationContext;
import org.eclipse.ocl.pivot.validation.ValidationRegistryAdapter;
import org.eclipse.ocl.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.xtext.basecs.ModelElementCS;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcore;
import org.eclipse.qvtd.pivot.qvtcore.utilities.QVTcoreUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtschedule.QVTschedulePivotStandaloneSetup;
import org.eclipse.qvtd.xtext.qvtcore.QVTcoreRuntimeModule;
import org.eclipse.qvtd.xtext.qvtcore.QVTcoreStandaloneSetup;
import org.eclipse.qvtd.xtext.qvtimperative.QVTimperativeRuntimeModule;
import org.eclipse.qvtd.xtext.qvtimperative.QVTimperativeStandaloneSetup;
import org.eclipse.qvtd.xtext.qvtrelation.QVTrelationRuntimeModule;
import org.eclipse.qvtd.xtext.qvtrelation.QVTrelationStandaloneSetup;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;

public class XtextCompilerUtil
extends CompilerUtil {
    public static void assertNoDiagnosticErrors(String message, XtextResource xtextResource) {
        List diagnostics = xtextResource.validateConcreteSyntax();
        if (diagnostics.size() > 0) {
            StringBuilder s = new StringBuilder();
            s.append(message);
            for (Diagnostic diagnostic : diagnostics) {
                s.append("\n");
                s.append(diagnostic.toString());
            }
            assert (false) : s.toString();
        }
    }

    public static void assertNoValidationErrors(@NonNull String string, @NonNull EObject eObject) {
        ValidationRegistryAdapter validationRegistry = ValidationRegistryAdapter.getAdapter((Notifier)eObject);
        ValidationContext validationContext = new ValidationContext((EValidator.Registry)validationRegistry);
        Diagnostician diagnostician = validationContext.getDiagnostician();
        Diagnostic diagnostic = diagnostician.validate(eObject, (Map)validationContext);
        List children = diagnostic.getChildren();
        if (children.size() <= 0) {
            return;
        }
        StringBuilder s = new StringBuilder();
        s.append(String.valueOf(children.size()) + " validation errors");
        for (Diagnostic child : children) {
            Object data;
            s.append("\n\t");
            if (child.getData().size() > 0 && (data = child.getData().get(0)) instanceof Element) {
                Element eScope = (Element)data;
                while (eScope instanceof Element) {
                    ModelElementCS csElement = ElementUtil.getCsElement((Element)eScope);
                    if (csElement != null) {
                        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
                        if (node != null) {
                            Resource eResource = csElement.eResource();
                            if (eResource != null) {
                                s.append(String.valueOf(eResource.getURI().lastSegment()) + ":");
                            }
                            int startLine = node.getStartLine();
                            s.append(String.valueOf(startLine) + ":");
                        }
                        s.append(String.valueOf(((Element)data).eClass().getName()) + ": ");
                        break;
                    }
                    eScope = eScope.eContainer();
                }
            }
            s.append(child.getMessage());
        }
        assert (false) : s.toString();
    }

    public static void doQVTcSerializeAndLoad(@NonNull ProjectManager projectManager, @NonNull URI inputURI, @NonNull URI serializedURI) throws IOException {
        XtextCompilerUtil.doSerialize(projectManager, inputURI, serializedURI);
        QVTcore qvtc = QVTcore.newInstance((ProjectManager)projectManager, null);
        ASResource cResource2 = QVTcoreUtil.loadTransformations((QVTbaseEnvironmentFactory)qvtc.getEnvironmentFactory(), (URI)serializedURI, (boolean)false);
        XtextCompilerUtil.assertNoResourceErrors((String)"Core Load", (Resource)cResource2);
    }

    public static void doQVTcoreSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            QVTcoreStandaloneSetup.doSetup();
            QVTschedulePivotStandaloneSetup.doSetup();
        } else {
            Guice.createInjector((Module[])new Module[]{new QVTcoreRuntimeModule()});
        }
    }

    public static void doQVTiSerializeAndLoad(@NonNull ProjectManager projectManager, @NonNull URI inputURI, @NonNull URI serializedURI) throws IOException {
        XtextCompilerUtil.doSerialize(projectManager, inputURI, serializedURI);
        QVTimperative qvti = QVTimperative.newInstance((ProjectManager)projectManager, null);
        ASResource iResource2 = QVTimperativeUtil.loadTransformations(ImperativeModel.class, (EnvironmentFactory)qvti.getEnvironmentFactory(), (URI)serializedURI, (boolean)false);
        XtextCompilerUtil.assertNoResourceErrors((String)"IMperative Load", (Resource)iResource2);
    }

    public static void doQVTimperativeSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            QVTimperativeStandaloneSetup.doSetup();
        } else {
            Guice.createInjector((Module[])new Module[]{new QVTimperativeRuntimeModule()});
        }
    }

    public static void doQVTrelationSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            QVTrelationStandaloneSetup.doSetup();
        } else {
            Guice.createInjector((Module[])new Module[]{new QVTrelationRuntimeModule()});
        }
    }

    public static void doQVTscheduleSetup() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            QVTschedulePivotStandaloneSetup.doSetup();
        }
    }

    private static XtextResource doSerialize(@NonNull ProjectManager projectManager, @NonNull URI inputURI, @NonNull URI serializedURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        QVTcore ocl = QVTcore.newInstance((ProjectManager)projectManager, null);
        try {
            ASResource asResource = XtextCompilerUtil.loadQVTcAS((OCL)ocl, inputURI);
            XtextCompilerUtil.assertNoResourceErrors((String)"Normalisation failed", (Resource)asResource);
            XtextCompilerUtil.assertNoUnresolvedProxies((String)"Normalisation invalid", (Resource)asResource);
            XtextCompilerUtil.assertNoValidationErrors((String)"Normalisation invalid", (Resource)asResource);
            XtextResource xtextResource = XtextCompilerUtil.pivot2cs((OCL)ocl, (ResourceSet)resourceSet, asResource, serializedURI);
            resourceSet.getResources().clear();
            XtextResource xtextResource2 = xtextResource;
            return xtextResource2;
        }
        finally {
            ocl.dispose();
            ocl = null;
        }
    }

    private static @NonNull ASResource loadQVTcAS(@NonNull OCL ocl, @NonNull URI inputURI) {
        Resource asResource = ocl.getMetamodelManager().getASResourceSet().getResource(inputURI, true);
        assert (asResource != null);
        XtextCompilerUtil.assertNoResourceErrors((String)"Load failed", (Resource)asResource);
        return (ASResource)asResource;
    }

    private static @NonNull XtextResource pivot2cs(@NonNull OCL ocl, @NonNull ResourceSet resourceSet, @NonNull ASResource asResource, @NonNull URI outputURI) throws IOException {
        XtextResource xtextResource;
        block2: {
            xtextResource = (XtextResource)ClassUtil.nonNullState((Object)((XtextResource)resourceSet.createResource(outputURI, null)));
            ocl.as2cs(asResource, (CSResource)xtextResource);
            XtextCompilerUtil.assertNoResourceErrors((String)"Conversion failed", (Resource)xtextResource);
            XtextCompilerUtil.assertNoDiagnosticErrors("Concrete Syntax validation failed", xtextResource);
            try {
                xtextResource.save(defaultSavingOptions);
            }
            catch (Exception e) {
                e.printStackTrace();
                URI xmiURI = outputURI.appendFileExtension(".xmi");
                Resource xmiResource = resourceSet.createResource(xmiURI);
                xmiResource.getContents().addAll((Collection)ClassUtil.nullFree((EList)xtextResource.getContents()));
                xmiResource.save(defaultSavingOptions);
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)e.toString());
            }
        }
        return xtextResource;
    }
}

