/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

import org.eclipse.imp.editor.OutlineInformationControl;
import org.eclipse.imp.language.ILanguageService;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Tree;

public abstract class OutlineContentProviderBase
implements ITreeContentProvider,
ILanguageService {
    private OutlineInformationControl fInfoControl;
    boolean fShowInheritedMembers;

    protected OutlineContentProviderBase(OutlineInformationControl oic) {
        this(oic, false);
    }

    protected OutlineContentProviderBase(OutlineInformationControl oic, boolean showInheritedMembers) {
        this.fShowInheritedMembers = showInheritedMembers;
        this.fInfoControl = oic;
    }

    public void setInfoControl(OutlineInformationControl infoControl) {
        this.fInfoControl = infoControl;
    }

    public boolean isShowingInheritedMembers() {
        return this.fShowInheritedMembers;
    }

    public void toggleShowInheritedMembers() {
        if (this.fInfoControl == null) {
            return;
        }
        Tree tree = this.fInfoControl.getTreeViewer().getTree();
        tree.setRedraw(false);
        this.fShowInheritedMembers = !this.fShowInheritedMembers;
        this.fInfoControl.getTreeViewer().refresh();
        this.fInfoControl.getTreeViewer().expandToLevel(2);
        Object selectedElement = this.fInfoControl.getSelectedElement();
        if (selectedElement != null) {
            this.fInfoControl.getTreeViewer().reveal(selectedElement);
        }
        tree.setRedraw(true);
    }

    public Object[] getChildren(Object element) {
        return OutlineInformationControl.NO_CHILDREN;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.fInfoControl != null) {
            this.fInfoControl.fTypeHierarchies.clear();
        }
    }

    public void dispose() {
        if (this.fInfoControl != null) {
            this.fInfoControl.fTypeHierarchies.clear();
        }
    }

    public boolean hasChildren(Object element) {
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }
}

