/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.codegen.dynamic.JavaFileUtil;
import org.eclipse.ocl.examples.codegen.oclinecore.OCLinEcoreGeneratorAdapterFactory;
import org.eclipse.qvtd.compiler.AbstractCompilerStep;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.QVTrCompilerChain;
import org.eclipse.qvtd.compiler.internal.genmodel.QVTdGenModelGeneratorAdapterFactory;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTr2QVTc;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;

public class GenModelCompilerStep
extends AbstractCompilerStep {
    public GenModelCompilerStep(@NonNull CompilerChain compilerChain) {
        super(compilerChain, "GenModel");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void execute() throws IOException {
        URI genmodelURI = this.compilerChain.getURI("GenModel", QVTrCompilerChain.URI_KEY);
        URI qvtcURI = this.compilerChain.getURI("QVTc", QVTrCompilerChain.URI_KEY);
        Resource cResource = this.environmentFactory.getMetamodelManager().getASResourceSet().getResource(qvtcURI, true);
        assert (cResource != null);
        Resource gResource = this.environmentFactory.getResourceSet().getResource(genmodelURI, true);
        assert (gResource != null);
        GenModel genModel = (GenModel)gResource.getContents().get(0);
        @NonNull List classProjectNames = (List)this.compilerChain.basicGetOption("Class", QVTrCompilerChain.CLASS_PROJECT_NAMES_KEY);
        URI classFileURI = (URI)this.compilerChain.basicGetOption("Class", QVTrCompilerChain.URI_KEY);
        URI traceURI = this.compilerChain.getURI("Trace", QVTrCompilerChain.URI_KEY);
        if (classFileURI != null) {
            List<String> classpathProjects;
            String sourceFilePathPrefix;
            String classFilePath;
            URIConverter uriConverter = this.environmentFactory.getResourceSet().getURIConverter();
            if (EcorePlugin.IS_ECLIPSE_RUNNING) {
                String binProjectName = QVTr2QVTc.getProjectName(traceURI);
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                classFilePath = classFileURI.toFileString();
                assert (classFilePath != null);
                IFile genIFile = root.getFile((IPath)new Path(genModel.getModelDirectory()));
                File genFile = URIUtil.toFile((java.net.URI)genIFile.getLocationURI());
                sourceFilePathPrefix = genFile.getAbsolutePath().replace("\\", "/");
                classpathProjects = CompilerUtil.createClassPathProjectList(uriConverter, binProjectName, classFilePath, classProjectNames);
            } else {
                classFilePath = classFileURI.toFileString();
                URI genModelDirectoryURI = URI.createPlatformResourceURI((String)genModel.getModelDirectory(), (boolean)true);
                sourceFilePathPrefix = String.valueOf(uriConverter.normalize(genModelDirectoryURI).toFileString()) + "/";
                classpathProjects = null;
            }
            assert (classFilePath != null);
            for (GenPackage genPackage : genModel.getGenPackages()) {
                String basePackage = genPackage.getBasePackage();
                String sourcePath = String.valueOf(sourceFilePathPrefix) + (basePackage != null ? "/" + basePackage.replace(".", "/") : "");
                JavaFileUtil.deleteJavaFiles((String)sourcePath);
            }
            this.generateModels(genModel);
            new File(classFilePath).mkdirs();
            HashSet<@NonNull String> basePackages = new HashSet<String>();
            for (GenPackage genPackage : genModel.getGenPackages()) {
                String sourceFilePath;
                String problemMessage;
                String basePackage = genPackage.getBasePackage();
                String string = basePackage = basePackage != null ? "/" + basePackage.replace(".", "/") : "";
                if (!basePackages.add(basePackage) || (problemMessage = JavaFileUtil.compileClasses((String)(sourceFilePath = String.valueOf(sourceFilePathPrefix) + basePackage), (String)classFilePath, classpathProjects)) == null) continue;
                this.addProblem(new CompilerChainException(problemMessage, new Object[0]));
            }
        }
        this.throwCompilerChainExceptionForErrors();
        this.compiled(gResource);
    }

    protected void generateModels(@NonNull GenModel genModel) {
        this.environmentFactory.getMetamodelManager().addGenModel(genModel);
        genModel.setValidateModel(true);
        genModel.setForceOverwrite(false);
        genModel.setCanGenerate(true);
        Diagnostic diagnostic = genModel.diagnose();
        assert (diagnostic != null);
        this.reportDiagnostics(new Issues(), diagnostic);
        Generator generator = new Generator();
        generator.setInput(genModel);
        BasicMonitor monitor = new BasicMonitor();
        diagnostic = generator.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)monitor);
        assert (diagnostic != null);
        this.reportDiagnostics(new Issues(), diagnostic);
    }

    protected void reportDiagnostics(@NonNull Issues issues, @NonNull Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        if (severity != 0) {
            List children = diagnostic.getChildren();
            if (children.size() > 0) {
                for (Diagnostic child : children) {
                    String message;
                    severity = child.getSeverity();
                    List data = child.getData();
                    Throwable throwable = null;
                    if (data.size() == 1 && data.get(0) instanceof Throwable) {
                        throwable = (Throwable)data.get(0);
                        data = null;
                        message = child.getMessage();
                    } else {
                        message = child.toString();
                    }
                    if (severity == 4) {
                        issues.addError(this.compilerChain, message, null, null, throwable, data);
                        continue;
                    }
                    if (severity != 2) continue;
                    issues.addWarning(this.compilerChain, message, null, null, throwable, data);
                }
            } else if (severity == 4) {
                issues.addError(this.compilerChain, diagnostic.toString());
            } else if (severity == 2) {
                issues.addWarning(this.compilerChain, diagnostic.toString());
            }
        }
    }

    private static final class Generator
    extends org.eclipse.emf.codegen.ecore.generator.Generator {
        private final @NonNull Collection<GeneratorAdapterFactory> adapterFactories = new ArrayList<GeneratorAdapterFactory>();

        public Generator() {
            this.addAdapterFactoryDescriptor(QVTdGenModelGeneratorAdapterFactory.DESCRIPTOR);
            this.addAdapterFactoryDescriptor(OCLinEcoreGeneratorAdapterFactory.DESCRIPTOR);
        }

        private void addAdapterFactoryDescriptor(GeneratorAdapterFactory.Descriptor descriptor) {
            GeneratorAdapterFactory adapterFactory = descriptor.createAdapterFactory();
            this.adapterFactories.add(adapterFactory);
            adapterFactory.setGenerator((org.eclipse.emf.codegen.ecore.generator.Generator)this);
        }

        protected Collection<GeneratorAdapterFactory> getAdapterFactories(Object object) {
            return this.adapterFactories;
        }
    }

    private static class Issues {
        private Issues() {
        }

        public void addError(@NonNull CompilerChain compilerChain, String message, Object object, Object object2, Throwable throwable, List<Object> data) {
            System.err.println(message);
        }

        public void addWarning(@NonNull CompilerChain compilerChain, String message, Object object, Object object2, Throwable throwable, List<Object> data) {
            System.out.println(message);
        }

        public void addError(@NonNull CompilerChain compilerChain, String string) {
            System.err.println(string);
        }

        public void addWarning(@NonNull CompilerChain compilerChain, String string) {
            System.out.println(string);
        }
    }
}

