/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Transformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtschedule.RootRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameAdapter;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameBuilder;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.SymbolNameReservation;

public class QVTs2QVTi
extends QVTimperativeHelper {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull ProblemHandler problemHandler;

    public QVTs2QVTi(@NonNull ScheduleManager scheduleManager, @NonNull ProblemHandler problemHandler, @NonNull QVTbaseEnvironmentFactory environmentFactory) {
        super((EnvironmentFactory)environmentFactory);
        this.scheduleManager = scheduleManager;
        this.problemHandler = problemHandler;
        assert (scheduleManager.getEnvironmentFactory() == environmentFactory);
    }

    protected @NonNull Package getPackage(@NonNull ImperativeModel iModel, @NonNull Package asPackage) {
        List iPackages;
        Package asParentPackage = asPackage.getOwningPackage();
        if (asParentPackage != null) {
            @NonNull Package iParentPackage = this.getPackage(iModel, asParentPackage);
            iPackages = QVTbaseUtil.Internal.getOwnedPackagesList((Package)iParentPackage);
        } else {
            iPackages = QVTbaseUtil.Internal.getOwnedPackagesList((Model)iModel);
        }
        String name = PivotUtil.getName((NamedElement)asPackage);
        Package iPackage = (Package)NameUtil.getNameable((Iterable)iPackages, (String)name);
        if (iPackage == null) {
            iPackage = this.createPackage(name, asPackage.getNsPrefix(), asPackage.getURI());
            iPackages.add(iPackage);
        }
        return iPackage;
    }

    public @NonNull ProblemHandler getProblemHandler() {
        return this.problemHandler;
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull ImperativeTransformation getTransformation(@NonNull ImperativeModel iModel, @NonNull Transformation asTransformation) {
        String name;
        Package asParentPackage = (Package)ClassUtil.nonNullState((Object)asTransformation.getOwningPackage());
        @NonNull Package iParentPackage = this.getPackage(iModel, asParentPackage);
        @NonNull List iClasses = QVTbaseUtil.Internal.getOwnedClassesList((Package)iParentPackage);
        Class iTransformation = (Class)NameUtil.getNameable((Iterable)iClasses, (String)(name = PivotUtil.getName((NamedElement)asTransformation)));
        if (iTransformation == null || !(iTransformation instanceof ImperativeTransformation)) {
            iTransformation = this.createTransformation(name);
            iClasses.add(iTransformation);
            Transformation2TracePackage transformation2TracePackage = this.scheduleManager.getTransformation2TracePackage(asTransformation);
            Class transformationTraceClass = transformation2TracePackage.getTransformationTraceClass();
            ((ImperativeTransformation)iTransformation).setContextType(transformationTraceClass);
            for (TypedModel qvtmTypedModel : QVTbaseUtil.getModelParameters((Transformation)asTransformation)) {
                TypedModel qvtiTypedModel = this.createTypedModel(PivotUtil.getName((NamedElement)qvtmTypedModel));
                qvtiTypedModel.getUsedPackage().addAll((Collection)qvtmTypedModel.getUsedPackage());
                qvtiTypedModel.setIsPrimitive(qvtmTypedModel.isIsPrimitive());
                qvtiTypedModel.setIsThis(qvtmTypedModel.isIsThis());
                qvtiTypedModel.setIsTrace(qvtmTypedModel.isIsTrace());
            }
        }
        return (ImperativeTransformation)iTransformation;
    }

    protected @NonNull TypedModel getTypedModel(@NonNull ImperativeTransformation iTransformation, @NonNull TypedModel asTypedModel) {
        TypedModel iTypedModel = (TypedModel)NameUtil.getNameable((Iterable)QVTimperativeUtil.getModelParameters((Transformation)iTransformation), (String)PivotUtil.getName((NamedElement)asTypedModel));
        if (iTypedModel == null) {
            iTypedModel = this.createTypedModel(PivotUtil.getName((NamedElement)asTypedModel));
            iTypedModel.getUsedPackage().addAll((Collection)asTypedModel.getUsedPackage());
            iTypedModel.setIsPrimitive(asTypedModel.isIsPrimitive());
            iTypedModel.setIsThis(asTypedModel.isIsThis());
            iTypedModel.setIsTrace(asTypedModel.isIsTrace());
            iTransformation.getModelParameter().add((Object)iTypedModel);
        }
        return iTypedModel;
    }

    protected @NonNull Map<@NonNull TypedModel, @NonNull TypedModel> getTypedModels(@NonNull ImperativeTransformation iTransformation, @NonNull Transformation asTransformation) {
        @NonNull HashMap<@NonNull TypedModel, @NonNull TypedModel> asTypedModel2qvtiTypedModel = new HashMap<TypedModel, TypedModel>();
        for (TypedModel asTypedModel : QVTbaseUtil.getModelParameters((Transformation)asTransformation)) {
            TypedModel iTypedModel = this.getTypedModel(iTransformation, asTypedModel);
            asTypedModel2qvtiTypedModel.put(asTypedModel, iTypedModel);
        }
        return asTypedModel2qvtiTypedModel;
    }

    public void resolveImports(@NonNull ImperativeModel model) {
        HashSet<@NonNull Object> importedNamespaces = new HashSet<Object>();
        for (EObject eObject : new TreeIterable((EObject)model, false)) {
            Property asProperty;
            Package asPackage;
            Class asClass;
            if (eObject instanceof TypedModel) {
                for (Namespace importedNamespace : ClassUtil.nullFree((EList)((TypedModel)eObject).getUsedPackage())) {
                    if (importedNamespaces.contains(importedNamespace)) continue;
                    importedNamespaces.add(importedNamespace);
                }
                continue;
            }
            if (eObject instanceof OperationCallExp) {
                Operation asOperation = ((OperationCallExp)eObject).getReferredOperation();
                if (asOperation == null || (asClass = asOperation.getOwningClass()) == null || (asPackage = asClass.getOwningPackage()) == null) continue;
                importedNamespaces.add(asPackage);
                continue;
            }
            if (eObject instanceof LoopExp) {
                Iteration asIteration = ((LoopExp)eObject).getReferredIteration();
                if (asIteration == null || (asClass = asIteration.getOwningClass()) == null || (asPackage = asClass.getOwningPackage()) == null) continue;
                importedNamespaces.add(asPackage);
                continue;
            }
            if (eObject instanceof PropertyCallExp) {
                asProperty = ((PropertyCallExp)eObject).getReferredProperty();
                if (asProperty == null || (asClass = asProperty.getOwningClass()) == null || (asPackage = asClass.getOwningPackage()) == null) continue;
                importedNamespaces.add(asPackage);
                continue;
            }
            if (!(eObject instanceof OppositePropertyCallExp) || (asProperty = ((OppositePropertyCallExp)eObject).getReferredProperty()) == null || (asClass = asProperty.getOwningClass()) == null || (asPackage = asClass.getOwningPackage()) == null) continue;
            importedNamespaces.add(asPackage);
        }
        ArrayList<@NonNull E> sortedImportedNamespaces = new ArrayList(importedNamespaces);
        Collections.sort(sortedImportedNamespaces, NameUtil.NAMEABLE_COMPARATOR);
        List ownedImports = model.getOwnedImports();
        for (Namespace importedNamespace : sortedImportedNamespaces) {
            SymbolNameBuilder s = new SymbolNameBuilder();
            s.appendString("mm_");
            s.appendName(importedNamespace.getName());
            s.appendName("MM");
            String name = model.reserveSymbolName(s, (Object)importedNamespace);
            ownedImports.add(this.createImport(name, importedNamespace));
        }
    }

    public @NonNull Model transform(@NonNull ImperativeModel model, @NonNull RootRegion rootRegion) {
        SymbolNameAdapter symbolNameReservation = this.scheduleManager.getScheduleModel().getSymbolNameAdapter();
        Transformation asTransformation = QVTscheduleUtil.getReferredTransformation((RootRegion)rootRegion);
        ImperativeTransformation iTransformation = this.getTransformation(model, asTransformation);
        Map<@NonNull TypedModel, @NonNull TypedModel> asTypedModel2qvtiTypedModel = this.getTypedModels(iTransformation, asTransformation);
        QVTs2QVTiVisitor visitor = new QVTs2QVTiVisitor(this, (SymbolNameReservation)symbolNameReservation, asTypedModel2qvtiTypedModel);
        rootRegion.accept((Visitor)visitor);
        return model;
    }
}

