/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.cs2as.compiler.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.PrimitiveCompletePackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.FeatureFilter;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.QVTbaseFactory;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtcore.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcore.CoreModel;
import org.eclipse.qvtd.pivot.qvtcore.Mapping;

public class QVTmModelsMerger {
    public static void merge(EnvironmentFactory envF, Resource targetQVTmModel, List<Resource> extendedQVTmModels) {
        CoreModel qvtmModel = QVTmModelsMerger.getCoreModel(targetQVTmModel);
        Map<Class, List<Mapping>> inputType2RefiningMapping = QVTmModelsMerger.getRefiningMappingInputTypes(qvtmModel);
        for (Resource extendedQVTmModel : extendedQVTmModels) {
            QVTmModelsMerger.doMerge(envF, qvtmModel, QVTmModelsMerger.getCoreModel(extendedQVTmModel), inputType2RefiningMapping);
        }
    }

    private static Map<Class, List<Mapping>> getRefiningMappingInputTypes(CoreModel qvtmModel) {
        HashMap<Class, List<Mapping>> result = new HashMap<Class, List<Mapping>>();
        Package _package = (Package)qvtmModel.getOwnedPackages().get(0);
        Transformation tx = (Transformation)_package.getOwnedClasses().get(0);
        for (Rule rule : tx.getRule()) {
            Mapping mapping = (Mapping)rule;
            VariableDeclaration inputVar = QVTmModelsMerger.getInputVariable(mapping);
            Class refiningType = (Class)inputVar.getType();
            ArrayList<Mapping> refiningMappings = (ArrayList<Mapping>)result.get(refiningType);
            if (refiningMappings == null) {
                refiningMappings = new ArrayList<Mapping>();
                result.put(refiningType, refiningMappings);
            }
            refiningMappings.add(mapping);
        }
        return result;
    }

    private static void doMerge(EnvironmentFactory envF, CoreModel resultQVTmModel, CoreModel mergedQVTmModel, Map<Class, List<Mapping>> inputType2RefiningMapping) {
        Namespace importedNS;
        HashSet<Namespace> alreadyImportedNamespaces = new HashSet<Namespace>();
        HashSet<Import> importsToRemove = new HashSet<Import>();
        for (Import _import : resultQVTmModel.getOwnedImports()) {
            importedNS = _import.getImportedNamespace();
            alreadyImportedNamespaces.add(importedNS);
            if (!QVTmModelsMerger.doesNamespaceCorrespondToMergedQVTmModel(mergedQVTmModel, importedNS)) continue;
            importsToRemove.add(_import);
        }
        for (Import _import : mergedQVTmModel.getOwnedImports()) {
            importedNS = _import.getImportedNamespace();
            if (alreadyImportedNamespaces.contains(importedNS)) continue;
            resultQVTmModel.getOwnedImports().add((Import)EcoreUtil.copy((EObject)_import));
        }
        for (Import _import : importsToRemove) {
            resultQVTmModel.getOwnedImports().remove(_import);
        }
        Transformation resultTransformation = QVTmModelsMerger.getTransformation(resultQVTmModel);
        Transformation mergedTransformation = QVTmModelsMerger.getTransformation(mergedQVTmModel);
        HashMap<String, EList> tmName2oldUsedPackages = new HashMap<String, EList>();
        for (TypedModel typedModel : mergedTransformation.getModelParameter()) {
            tmName2oldUsedPackages.put(typedModel.getName(), typedModel.getUsedPackage());
        }
        HashMap<String, TypedModel> tmName2newTypedModel = new HashMap<String, TypedModel>();
        for (TypedModel typedModel : resultTransformation.getModelParameter()) {
            typedModel.getUsedPackage().addAll((Collection)tmName2oldUsedPackages.get(typedModel.getName()));
            tmName2newTypedModel.put(typedModel.getName(), typedModel);
        }
        EList resultRules = resultTransformation.getRule();
        for (Rule rule : mergedTransformation.getRule()) {
            Mapping baseRule = (Mapping)EcoreUtil.copy((EObject)rule);
            QVTmModelsMerger.refactorMapping(envF, baseRule, inputType2RefiningMapping, tmName2newTypedModel);
            resultRules.add((Object)baseRule);
        }
    }

    private static boolean doesNamespaceCorrespondToMergedQVTmModel(CoreModel mergedQVTmModel, Namespace ns) {
        if (ns instanceof Model && QVTmModelsMerger.isAnOCLModel(ns)) {
            URI qvtmModelURI = URI.createURI((String)mergedQVTmModel.getExternalURI());
            assert (QVTmModelsMerger.assertCorrectQVTmModelFileExtenion(qvtmModelURI));
            URI importedNSURI = URI.createURI((String)((Model)ns).getExternalURI());
            String fileName1 = qvtmModelURI.trimFragment().trimFileExtension().trimFileExtension().lastSegment();
            String fileName2 = importedNSURI.trimFragment().trimFileExtension().trimFileExtension().lastSegment();
            return ((String)ClassUtil.nonNullState((Object)fileName1)).equals(fileName2);
        }
        return false;
    }

    private static boolean isAnOCLModel(Namespace ns) {
        URI nsURI = URI.createURI((String)((Model)ns).getExternalURI());
        if ("ocl".equals(nsURI.fileExtension())) {
            return true;
        }
        if (!"oclas".equals(nsURI.fileExtension())) {
            return false;
        }
        return "ocl".equals(nsURI.trimFileExtension().fileExtension());
    }

    private static Transformation getTransformation(CoreModel iModel) {
        for (Package aPackage : iModel.getOwnedPackages()) {
            for (Class aClass : aPackage.getOwnedClasses()) {
                if (!(aClass instanceof Transformation)) continue;
                return (Transformation)aClass;
            }
        }
        throw new IllegalStateException(MessageFormat.format("The QVTd model '{0}' does not have a Transformation element.", iModel.getExternalURI()));
    }

    private static CoreModel getCoreModel(Resource qvtmResource) {
        for (EObject eContent : qvtmResource.getContents()) {
            if (!(eContent instanceof CoreModel)) continue;
            return (CoreModel)eContent;
        }
        throw new IllegalStateException(MessageFormat.format("The QVTd model '{0}' does not have an CoreModel element.", qvtmResource.getURI()));
    }

    private static boolean assertCorrectQVTmModelFileExtenion(URI qvtmModelURI) {
        assert (qvtmModelURI.fileExtension().equals("qvtcas"));
        assert (qvtmModelURI.trimFileExtension().fileExtension().equals("qvtm"));
        return true;
    }

    private static void refactorMapping(EnvironmentFactory envF, Mapping mappingToRefactor, Map<Class, List<Mapping>> inputType2extendingMapping, Map<String, TypedModel> tmName2newTypedModel) {
        for (Domain domain : mappingToRefactor.getDomain()) {
            domain.setTypedModel(tmName2newTypedModel.get(domain.getTypedModel().getName()));
        }
        VariableDeclaration inputVar = QVTmModelsMerger.getInputVariable(mappingToRefactor);
        Type refinedType = inputVar.getType();
        for (Map.Entry<Class, List<Mapping>> mEntry : inputType2extendingMapping.entrySet()) {
            Class refiningType = mEntry.getKey();
            for (Mapping refiningMapping : mEntry.getValue()) {
                ArrayList<Class> superClasses = new ArrayList<Class>();
                QVTmModelsMerger.computeAllSuperClasses(refiningType, superClasses);
                if (!superClasses.contains(refinedType)) continue;
                String refinedMappingName = mappingToRefactor.getName();
                String refiningMappingName = refiningMapping.getName();
                if (refinedMappingName.startsWith("c")) {
                    if (!refiningMappingName.startsWith("c")) continue;
                    QVTmModelsMerger.doMappingRefactoring(envF, mappingToRefactor, refiningMapping, inputVar, refiningType);
                    continue;
                }
                if (refinedMappingName.startsWith("u")) {
                    String refiningUMappingFeature;
                    String refinedUMappingFeature;
                    if (!refiningMappingName.startsWith("u") || !(refinedUMappingFeature = refinedMappingName.split("u.*_")[1]).equals(refiningUMappingFeature = refiningMappingName.split("u.*_")[1])) continue;
                    QVTmModelsMerger.doMappingRefactoring(envF, mappingToRefactor, refiningMapping, inputVar, refiningType);
                    continue;
                }
                throw new IllegalStateException("This point should never be reached given the mapping naming convention introduced in OCL2QVTm.");
            }
        }
    }

    private static void doMappingRefactoring(EnvironmentFactory envF, Mapping mappingToRefactor, Mapping refiningMapping, VariableDeclaration inputVar, Class refiningType) {
        Predicate predicate = QVTbaseFactory.eINSTANCE.createPredicate();
        predicate.setConditionExpression(QVTmModelsMerger.createOclIsKindOfOperationCall(envF, inputVar, refiningType));
        mappingToRefactor.getGuardPattern().getPredicate().add((Object)predicate);
        refiningMapping.setOverridden((Rule)mappingToRefactor);
    }

    private static VariableDeclaration getInputVariable(Mapping mapping) {
        CoreDomain inputDomain = (CoreDomain)mapping.getDomain().get(0);
        return (VariableDeclaration)inputDomain.getGuardPattern().getOwnedVariables().get(0);
    }

    private static void computeAllSuperClasses(Class aClass, List<Class> allSuperClasses) {
        for (Class superClass : aClass.getSuperClasses()) {
            if (allSuperClasses.contains(superClass)) continue;
            allSuperClasses.add(superClass);
            QVTmModelsMerger.computeAllSuperClasses(superClass, allSuperClasses);
        }
    }

    private static OCLExpression createOclIsKindOfOperationCall(EnvironmentFactory envF, VariableDeclaration inputVar, Class refiningType) {
        OperationCallExp opCallExp = PivotFactory.eINSTANCE.createOperationCallExp();
        CompletePackage cPackage = envF.getCompleteModel().getCompletePackage(envF.getStandardLibrary().getPackage());
        CompleteClass cClass = cPackage.getCompleteClass(envF.getStandardLibrary().getOclAnyType());
        Operation oclIsKindOfOp = (Operation)cClass.getOperations(FeatureFilter.SELECT_NON_STATIC, "oclIsKindOf").iterator().next();
        opCallExp.setReferredOperation(oclIsKindOfOp);
        opCallExp.setName(oclIsKindOfOp.getName());
        opCallExp.setType(oclIsKindOfOp.getType());
        VariableExp source = PivotFactory.eINSTANCE.createVariableExp();
        source.setReferredVariable(inputVar);
        source.setName(inputVar.getName());
        source.setType(inputVar.getType());
        opCallExp.setOwnedSource((OCLExpression)source);
        TypeExp arg = PivotFactory.eINSTANCE.createTypeExp();
        arg.setType((Type)envF.getStandardLibrary().getClassType());
        arg.setReferredType((Type)refiningType);
        opCallExp.getOwnedArguments().add(arg);
        return QVTmModelsMerger.createNotOperation(envF, (OCLExpression)opCallExp);
    }

    private static OperationCallExp createNotOperation(EnvironmentFactory envF, OCLExpression expToNegate) {
        OperationCallExp opCallExp = PivotFactory.eINSTANCE.createOperationCallExp();
        PrimitiveCompletePackage cPackage = envF.getCompleteModel().getPrimitiveCompletePackage();
        CompleteClass cClass = cPackage.getCompleteClass(envF.getStandardLibrary().getBooleanType());
        Operation oclIsKindOfOp = (Operation)cClass.getOperations(FeatureFilter.SELECT_NON_STATIC, "not").iterator().next();
        opCallExp.setReferredOperation(oclIsKindOfOp);
        opCallExp.setName(oclIsKindOfOp.getName());
        opCallExp.setType(oclIsKindOfOp.getType());
        opCallExp.setOwnedSource(expToNegate);
        return opCallExp;
    }
}

