/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtimperative.tests;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import manualuml2rdbms.rdbms.RDBMSPackage;
import manualuml2rdbms.uml2rdbms.UML2RDBMSPackage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.GenericXMLResourceFactoryImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.codegen.dynamic.JavaClasspath;
import org.eclipse.ocl.examples.codegen.dynamic.JavaFileUtil;
import org.eclipse.ocl.examples.codegen.dynamic.OCL2JavaFileObject;
import org.eclipse.ocl.examples.codegen.utilities.CGUtil;
import org.eclipse.ocl.examples.xtext.tests.TestFolder;
import org.eclipse.ocl.examples.xtext.tests.TestProject;
import org.eclipse.ocl.examples.xtext.tests.TestUtil;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.internal.validation.PivotEObjectValidator;
import org.eclipse.ocl.pivot.oclstdlib.OCLstdlibTables;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.pivot.validation.ComposedEValidator;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.completeocl.validation.CompleteOCLEObjectValidator;
import org.eclipse.qvtd.codegen.qvti.QVTiCodeGenOptions;
import org.eclipse.qvtd.codegen.qvti.java.QVTiCodeGenerator;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.QVTbasePackage;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtcore.QVTcorePackage;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeTransformation;
import org.eclipse.qvtd.pivot.qvtimperative.QVTimperativePackage;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.Execution2GraphVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiTransformationExecutor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperative;
import org.eclipse.qvtd.runtime.evaluation.Connection;
import org.eclipse.qvtd.runtime.evaluation.Interval;
import org.eclipse.qvtd.runtime.evaluation.InvocationManager;
import org.eclipse.qvtd.runtime.evaluation.ObjectManager;
import org.eclipse.qvtd.runtime.evaluation.TransformationExecutor;
import org.eclipse.qvtd.runtime.evaluation.Transformer;
import org.eclipse.qvtd.runtime.evaluation.TypedModelInstance;
import org.eclipse.qvtd.runtime.internal.evaluation.AbstractInvocationManagerInternal;
import org.eclipse.qvtd.runtime.internal.evaluation.ModificationMonitor;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.ModelNormalizer;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.qvtd.xtext.qvtimperative.tests.ManualRDBMSNormalizer;
import org.eclipse.qvtd.xtext.qvtimperative.tests.QVTimperativeTestFileSystemHelper;
import org.eclipse.qvtd.xtext.qvtimperative.tests.SimpleRDBMSNormalizer;
import org.osgi.framework.Bundle;
import simpleuml2rdbms.uml.UMLPackage;
import tree2talltree.tree.TreePackage;

public class QVTiCompilerTests
extends LoadTestCase {
    private static ComposedEValidator makeSureRequiredBundleIsLoaded = null;
    public QVTimperativeTestFileSystemHelper testFileSystemHelper = null;

    public static @NonNull Map<Object, Object> getSaveOptions() {
        return DefaultCompilerOptions.defaultSavingOptions;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void checkCleared(@NonNull TransformationExecutor executor) {
        AbstractInvocationManagerInternal invocationManager = (AbstractInvocationManagerInternal)executor.getTransformer().getInvocationManager();
        @NonNull Iterable allInvocations = invocationManager.debugGetAllInvocations();
        QVTiCompilerTests.assertEquals((String)"All invocations post-clear", (int)1, (int)Iterables.size((Iterable)allInvocations));
        for (Interval interval : invocationManager.getIntervals()) {
            for (Connection connection : interval.getConnections()) {
                QVTiCompilerTests.assertEquals((String)("Connection '" + connection.getName() + "' post-clear"), (int)0, (int)connection.debugGetSize());
            }
        }
        ObjectManager objectManager = executor.getTransformer().getObjectManager();
        @NonNull Iterable allObjects = objectManager.getObjects();
        QVTiCompilerTests.assertEquals((String)"All objects post-clear", (int)0, (int)Iterables.size((Iterable)allObjects));
    }

    protected @NonNull OCLInternal createOCL() {
        return QVTimperative.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    protected @NonNull MyQVT createQVT() throws Exception {
        return new MyQVT(this.getTestProject(), new MyQVTiEnvironmentFactory(this.getTestProjectManager(), null));
    }

    protected @NonNull QVTimperativeTestFileSystemHelper getTestFileSystemHelper() {
        QVTimperativeTestFileSystemHelper testFileSystemHelper2 = this.testFileSystemHelper;
        if (testFileSystemHelper2 == null) {
            this.testFileSystemHelper = testFileSystemHelper2 = new QVTimperativeTestFileSystemHelper();
        }
        return testFileSystemHelper2;
    }

    protected void setUp() throws Exception {
        TestUtil.doCompleteOCLSetup();
        XtextCompilerUtil.doQVTimperativeSetup();
        super.setUp();
    }

    public void testQVTiCompiler_HSV2HLS_CG() throws Exception {
        URI modelsProjectURI = this.getModelsURI("HSV2HSL");
        URI transformURI = modelsProjectURI.appendSegment("HSV2HSL.qvti");
        URI genModelURI = modelsProjectURI.appendSegment("HSV2HSL.genmodel");
        URI inputModelURI = modelsProjectURI.appendSegment("HSVNode.xmi");
        URI referenceModelURI = modelsProjectURI.appendSegment("HSLNodeValidate.xmi");
        URI outputModelURI = this.getTestURI("HSLNode.xmi");
        MyQVT myQVT = this.createQVT();
        ImperativeTransformation iTransformation = myQVT.loadTransformation(transformURI, genModelURI);
        java.lang.Class<? extends Transformer> txClass = myQVT.generateCode(iTransformation, false);
        Transformer tx = myQVT.createTransformer(txClass);
        myQVT.loadInput(tx, "hsv", inputModelURI);
        myQVT.execute(tx);
        myQVT.saveOutput(tx, "hsl", outputModelURI, referenceModelURI, null);
        myQVT.dispose();
        QVTiCompilerTests.cleanup((String[])new String[]{"http://www.eclipse.org/qvt/examples/0.1/HSVTree", "http://www.eclipse.org/qvt/examples/0.1/HSVtoHSL", "http://www.eclipse.org/qvt/examples/0.1/HSLTree"});
    }

    public void testQVTiCompiler_ClassesCS2AS_CG() throws Exception {
        URI transformURI = this.getModelsURI("ClassesCS2AS/ClassesCS2AS.qvti");
        URI genModelURI = this.getModelsURI("ClassesCS2AS/ClassesCS2AS.genmodel");
        MyQVT myQVT = this.createQVT();
        ImperativeTransformation iTransformation = myQVT.loadTransformation(transformURI, genModelURI);
        myQVT.generateCode(iTransformation, false);
        myQVT.dispose();
    }

    public void testQVTiCompiler_ClassesCS2AS_bug459225_CG() throws Exception {
        URI modelsProjectURI = this.getModelsURI("ClassesCS2AS");
        URI submodelsProjectURI = modelsProjectURI.appendSegment("bug459225");
        URI transformURI = submodelsProjectURI.appendSegment("ClassesCS2AS.qvti");
        URI genModelURI = modelsProjectURI.appendSegment("ClassesCS2AS.genmodel");
        URI inputModelURI = submodelsProjectURI.appendSegment("example_input.xmi");
        URI referenceModelURI = submodelsProjectURI.appendSegment("example_output_ref.xmi");
        URI outputModelURI = this.getTestURI("example_output.xmi");
        MyQVT myQVT = this.createQVT();
        ImperativeTransformation iTransformation = myQVT.loadTransformation(transformURI, genModelURI);
        java.lang.Class<? extends Transformer> txClass = myQVT.generateCode(iTransformation, false);
        Transformer tx = myQVT.createTransformer(txClass);
        myQVT.loadInput(tx, "leftCS", inputModelURI);
        myQVT.execute(tx);
        myQVT.saveOutput(tx, "rightAS", outputModelURI, referenceModelURI, null);
        myQVT.dispose();
        QVTiCompilerTests.cleanup((String[])new String[]{"http://tracesmodel/1.0/classescstraces", "http://ocldependencyanalysis/classescs/1.0", "http://ocldependencyanalysis/classes/1.0"});
    }

    public void testQVTiCompiler_ManualUML2RDBMS_CG() throws Exception {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/qvt/examples/0.1/ManualRDBMS", (Object)RDBMSPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/qvt/examples/0.1/ManualUML2RDBMS", (Object)UML2RDBMSPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/qvt/examples/0.1/ManualUML", (Object)manualuml2rdbms.uml.UMLPackage.eINSTANCE);
        URI modelsProjectURI = this.getModelsURI("ManualUML2RDBMS");
        URI transformURI = modelsProjectURI.appendSegment("ManualUML2RDBMS.qvti");
        URI genModelURI = modelsProjectURI.appendSegment("ManualUML2RDBMS.genmodel");
        URI inputModelURI = modelsProjectURI.appendSegment("ManualUMLPeople.xmi");
        URI referenceModelURI = modelsProjectURI.appendSegment("ManualRDBMSPeopleValidate.xmi");
        URI outputModelURI = this.getTestURI("ManualRDBMSPeople.xmi");
        MyQVT myQVT = this.createQVT();
        ImperativeTransformation iTransformation = myQVT.loadTransformation(transformURI, genModelURI);
        java.lang.Class<? extends Transformer> txClass = myQVT.generateCode(iTransformation, false);
        Transformer tx = myQVT.createTransformer(txClass);
        myQVT.loadInput(tx, "uml", inputModelURI);
        myQVT.execute(tx);
        myQVT.saveOutput(tx, "rdbms", outputModelURI, referenceModelURI, ManualRDBMSNormalizer.INSTANCE);
        myQVT.dispose();
        QVTiCompilerTests.cleanup((String[])new String[]{"http://www.eclipse.org/qvt/examples/0.1/ManualUML", "http://www.eclipse.org/qvt/examples/0.1/ManualUML2RDBMS", "http://www.eclipse.org/qvt/examples/0.1/ManualRDBMS"});
    }

    public void testQVTiCompiler_SimpleUML2RDBMS_CG() throws Exception {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/qvt/examples/0.1/SimpleRDBMS", (Object)simpleuml2rdbms.rdbms.RDBMSPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/qvt/examples/0.1/SimpleUML2RDBMS", (Object)simpleuml2rdbms.uml2rdbms.UML2RDBMSPackage.eINSTANCE);
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/qvt/examples/0.1/SimpleUML", (Object)UMLPackage.eINSTANCE);
        URI modelsProjectURI = this.getModelsURI("SimpleUML2RDBMS");
        URI transformURI = modelsProjectURI.appendSegment("SimpleUML2RDBMS.qvti");
        URI genModelURI = modelsProjectURI.appendSegment("SimpleUML2RDBMS.genmodel");
        URI inputModelURI = modelsProjectURI.appendSegment("SimpleUMLPeople.xmi");
        URI referenceModelURI = modelsProjectURI.appendSegment("SimpleRDBMSPeopleValidate.xmi");
        URI outputModelURI = this.getTestURI("SimpleRDBMSPeople.xmi");
        MyQVT myQVT = this.createQVT();
        ImperativeTransformation iTransformation = myQVT.loadTransformation(transformURI, genModelURI);
        java.lang.Class<? extends Transformer> txClass = myQVT.generateCode(iTransformation, false);
        Transformer tx = myQVT.createTransformer(txClass);
        myQVT.loadInput(tx, "uml", inputModelURI);
        myQVT.execute(tx);
        myQVT.saveOutput(tx, "rdbms", outputModelURI, referenceModelURI, SimpleRDBMSNormalizer.INSTANCE);
        myQVT.dispose();
        QVTiCompilerTests.cleanup((String[])new String[]{"http://www.eclipse.org/qvt/examples/0.1/SimpleUML", "http://www.eclipse.org/qvt/examples/0.1/SimpleUML2RDBMS", "http://www.eclipse.org/qvt/examples/0.1/SimpleRDBMS"});
    }

    public void testQVTiCompiler_Tree2TallTree_CG() throws Exception {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/qvt/examples/0.1/Tree", (Object)TreePackage.eINSTANCE);
        URI modelsProjectURI = this.getModelsURI("Tree2TallTree");
        URI samplesProjectURI = modelsProjectURI.appendSegment("samples");
        URI transformURI = modelsProjectURI.appendSegment("Tree2TallTree.qvti");
        URI genModelURI = modelsProjectURI.appendSegment("Tree2TallTree.genmodel");
        URI inputModelURI = samplesProjectURI.appendSegment("Tree.xmi");
        URI referenceModelURI = samplesProjectURI.appendSegment("TallTreeValidate.xmi");
        URI outputModelURI = this.getTestURI("Tree2TallTree.xmi");
        MyQVT myQVT = this.createQVT();
        ImperativeTransformation iTransformation = myQVT.loadTransformation(transformURI, genModelURI);
        java.lang.Class<? extends Transformer> txClass = myQVT.generateCode(iTransformation, false);
        Transformer tx = myQVT.createTransformer(txClass);
        myQVT.loadInput(tx, "tree", inputModelURI);
        myQVT.execute(tx);
        myQVT.saveOutput(tx, "talltree", outputModelURI, referenceModelURI, null);
        Execution2GraphVisitor.writeGraphMLfile((Transformer)tx, (URI)this.getTestURI("Tree2TallTree-execution.graphml"));
        myQVT.dispose();
        QVTiCompilerTests.cleanup((String[])new String[]{"http://www.eclipse.org/qvt/examples/0.1/Tree"});
    }

    public void testQVTiCompiler_Tree2TallTree_Changed_CG() throws Exception {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/qvt/examples/0.1/Tree", (Object)TreePackage.eINSTANCE);
        URI modelsProjectURI = this.getModelsURI("Tree2TallTree");
        URI samplesProjectURI = modelsProjectURI.appendSegment("samples");
        URI transformURI = modelsProjectURI.appendSegment("Tree2TallTree.qvti");
        URI genModelURI = modelsProjectURI.appendSegment("Tree2TallTree.genmodel");
        URI inputModelURI = samplesProjectURI.appendSegment("Tree.xmi");
        URI referenceModelURI = samplesProjectURI.appendSegment("TallTreeValidate.xmi");
        URI changedReferenceModelURI = samplesProjectURI.appendSegment("TallTreeValidateChanged.xmi");
        URI outputModelURI = this.getTestURI("Tree2TallTree.xmi");
        URI changedOutputModelURI = this.getTestURI("samples/Tree2TallTreeChanged.xmi");
        MyQVT myQVT = this.createQVT();
        ImperativeTransformation iTransformation = myQVT.loadTransformation(transformURI, genModelURI);
        java.lang.Class<? extends Transformer> txClass = myQVT.generateCode(iTransformation, true);
        Transformer tx = myQVT.createTransformer(txClass);
        Resource inputResource = myQVT.loadInput(tx, "tree", inputModelURI);
        myQVT.execute(tx);
        Execution2GraphVisitor.writeGraphMLfile((Transformer)tx, (URI)this.getTestURI("Tree2TallTree-inc.graphml"));
        myQVT.saveOutput(tx, "talltree", outputModelURI, referenceModelURI, null);
        TransformationExecutor executor = tx.getExecutor();
        TypedModelInstance treeModel = tx.getTypedModelInstance("tree");
        ModificationMonitor monitor = ModificationMonitor.getModificationMonitor((TypedModelInstance)treeModel, (Resource)inputResource, (TransformationExecutor)executor);
        int gotOne = 0;
        for (EObject eObject : new TreeIterable(inputResource)) {
            EAttribute nameAttribute;
            Object name;
            EClass eClass = eObject.eClass();
            if (!"Node".equals(eClass.getName()) || !"n1.1".equals(name = eObject.eGet((EStructuralFeature)(nameAttribute = (EAttribute)eClass.getEStructuralFeature("name"))))) continue;
            ++gotOne;
            eObject.eSet((EStructuralFeature)nameAttribute, (Object)"x1.1");
        }
        assert (gotOne == 1);
        executor.getTransformer().getInvocationManager().flush();
        Execution2GraphVisitor.writeGraphMLfile((Transformer)tx, (URI)this.getTestURI("Tree2TallTree-incChanged.graphml"));
        myQVT.saveOutput(tx, "talltree", changedOutputModelURI, changedReferenceModelURI, null);
        myQVT.dispose();
        QVTiCompilerTests.cleanup((String[])new String[]{"http://www.eclipse.org/qvt/examples/0.1/Tree"});
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void testQVTiCompiler_Tree2TallTree_Copied_CG() throws Exception {
        URI modelsProjectURI = this.getModelsURI("Tree2TallTree");
        URI samplesProjectURI = modelsProjectURI.appendSegment("samples");
        URI transformURI = modelsProjectURI.appendSegment("Tree2TallTree.qvti");
        URI genModelURI = modelsProjectURI.appendSegment("Tree2TallTree.genmodel");
        URI inputModelURI = samplesProjectURI.appendSegment("Tree.xmi");
        URI referenceModelURI = samplesProjectURI.appendSegment("TallTreeValidate.xmi");
        URI clearedReferenceModelURI = samplesProjectURI.appendSegment("TallTreeValidateCleared.xmi");
        URI outputModelURI = this.getTestURI("Tree2TallTree.xmi");
        URI clearedOutputModelURI = this.getTestURI("Tree2TallTreeCleared.xmi");
        URI copiedOutputModelURI = this.getTestURI("Tree2TallTreeCopied.xmi");
        MyQVT myQVT = this.createQVT();
        ImperativeTransformation iTransformation = myQVT.loadTransformation(transformURI, genModelURI);
        java.lang.Class<? extends Transformer> txClass = myQVT.generateCode(iTransformation, true);
        Transformer tx = myQVT.createTransformer(txClass);
        Resource inputResource = myQVT.loadInput(tx, "tree", inputModelURI);
        myQVT.execute(tx);
        Execution2GraphVisitor.writeGraphMLfile((Transformer)tx, (URI)this.getTestURI("Tree2TallTree-inc.graphml"));
        myQVT.saveOutput(tx, "talltree", outputModelURI, referenceModelURI, null);
        TransformationExecutor executor = tx.getExecutor();
        TypedModelInstance treeModel = tx.getTypedModelInstance("tree");
        ModificationMonitor monitor = ModificationMonitor.getModificationMonitor((TypedModelInstance)treeModel, (Resource)inputResource, (TransformationExecutor)executor);
        @NonNull EList contents = inputResource.getContents();
        ArrayList<@NonNull E> oldContents = new ArrayList(contents);
        @NonNull Collection newContents = EcoreUtil.copyAll(oldContents);
        contents.clear();
        this.checkCleared(executor);
        InvocationManager invocationManager = executor.getTransformer().getInvocationManager();
        invocationManager.flush();
        Execution2GraphVisitor.writeGraphMLfile((Transformer)tx, (URI)this.getTestURI("Tree2TallTree-incCleared.graphml"));
        myQVT.saveOutput(tx, "talltree", clearedOutputModelURI, clearedReferenceModelURI, null);
        contents.addAll(newContents);
        invocationManager.flush();
        Execution2GraphVisitor.writeGraphMLfile((Transformer)tx, (URI)this.getTestURI("Tree2TallTree-incCopied.graphml"));
        myQVT.saveOutput(tx, "talltree", copiedOutputModelURI, referenceModelURI, null);
        myQVT.dispose();
        QVTiCompilerTests.cleanup((String[])new String[]{"http://www.eclipse.org/qvt/examples/0.1/List2List", "http://www.eclipse.org/qvt/examples/0.1/Tree", "http://www.eclipse.org/qvt/examples/0.1/TallTree"});
    }

    public void testQVTiCompiler_Tree2TallTree_Deleted_CG() throws Exception {
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/qvt/examples/0.1/Tree", (Object)TreePackage.eINSTANCE);
        URI modelsProjectURI = this.getModelsURI("Tree2TallTree");
        URI samplesProjectURI = modelsProjectURI.appendSegment("samples");
        URI transformURI = modelsProjectURI.appendSegment("Tree2TallTree.qvti");
        URI genModelURI = modelsProjectURI.appendSegment("Tree2TallTree.genmodel");
        URI inputModelURI = samplesProjectURI.appendSegment("Tree.xmi");
        URI referenceModelURI = samplesProjectURI.appendSegment("TallTreeValidate.xmi");
        URI deletedReferenceModelURI = samplesProjectURI.appendSegment("TallTreeValidateDeleted.xmi");
        URI outputModelURI = this.getTestURI("Tree2TallTree.xmi");
        URI deletedOutputModelURI = this.getTestURI("Tree2TallTreeDeleted.xmi");
        MyQVT myQVT = this.createQVT();
        ImperativeTransformation iTransformation = myQVT.loadTransformation(transformURI, genModelURI);
        java.lang.Class<? extends Transformer> txClass = myQVT.generateCode(iTransformation, true);
        Transformer tx = myQVT.createTransformer(txClass);
        Resource inputResource = myQVT.loadInput(tx, "tree", inputModelURI);
        myQVT.execute(tx);
        Execution2GraphVisitor.writeGraphMLfile((Transformer)tx, (URI)this.getTestURI("Tree2TallTree-inc.graphml"));
        myQVT.saveOutput(tx, "talltree", outputModelURI, referenceModelURI, null);
        TransformationExecutor executor = tx.getExecutor();
        TypedModelInstance treeModel = tx.getTypedModelInstance("tree");
        ModificationMonitor monitor = ModificationMonitor.getModificationMonitor((TypedModelInstance)treeModel, (Resource)inputResource, (TransformationExecutor)executor);
        int gotOne = 0;
        for (EObject eObject : new TreeIterable(inputResource)) {
            EAttribute nameAttribute;
            Object name;
            EClass eClass = eObject.eClass();
            if (!"Node".equals(eClass.getName()) || !"n1.1.1".equals(name = eObject.eGet((EStructuralFeature)(nameAttribute = (EAttribute)eClass.getEStructuralFeature("name"))))) continue;
            ++gotOne;
            PivotUtilInternal.resetContainer((EObject)eObject);
        }
        assert (gotOne == 1);
        executor.getTransformer().getInvocationManager().flush();
        Execution2GraphVisitor.writeGraphMLfile((Transformer)tx, (URI)this.getTestURI("Tree2TallTree-incDeleted.graphml"));
        myQVT.saveOutput(tx, "talltree", deletedOutputModelURI, deletedReferenceModelURI, null);
        monitor.dispose();
        myQVT.dispose();
        QVTiCompilerTests.cleanup((String[])new String[]{"http://www.eclipse.org/qvt/examples/0.1/Tree"});
    }

    protected static class MyQVT
    extends OCLInternal {
        protected final @NonNull TestProject testProject;
        private static final @NonNull String MAVEN_TYCHO_BIN_FOLDER_NAME = "target/classes";
        private static final @NonNull String REGULAR_BIN_FOLDER_NAME = "bin";

        public MyQVT(@NonNull TestProject testProject, @NonNull QVTiEnvironmentFactory environmentFactory) {
            super((EnvironmentFactoryInternal)environmentFactory);
            this.testProject = testProject;
        }

        private java.lang.Class<? extends Transformer> compileTransformation(@NonNull File explicitClassPath, @NonNull QVTiCodeGenerator cg, @NonNull JavaClasspath classpath) throws Exception {
            String qualifiedClassName = cg.getQualifiedName();
            String javaCodeSource = cg.generateClassFile();
            String string = explicitClassPath.toString();
            assert (string != null);
            List<@NonNull OCL2JavaFileObject> compilationUnits = Collections.singletonList(new OCL2JavaFileObject(qualifiedClassName, javaCodeSource));
            String message = JavaFileUtil.compileClasses(compilationUnits, (String)qualifiedClassName, (String)string, (JavaClasspath)classpath);
            if (message != null) {
                QVTiCompilerTests.fail((String)message);
            }
            java.lang.Class txClass = OCL2JavaFileObject.loadExplicitClass((File)explicitClassPath, (String)qualifiedClassName, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            return txClass;
        }

        public @NonNull Transformer createTransformer(@NonNull java.lang.Class<? extends Transformer> txClass) throws ReflectiveOperationException {
            QVTiTransformationExecutor executor = new QVTiTransformationExecutor(this.getEnvironmentFactory(), txClass);
            return executor.getTransformer();
        }

        public @NonNull Resource doLoad_ConcreteWithOCL(@NonNull URI inputURI) throws Exception {
            URI cstURI = this.testProject.getOutputFile((String)ClassUtil.nonNullState((Object)inputURI.appendFileExtension("xmi").lastSegment())).getURI();
            URI pivotURI = this.testProject.getOutputFile((String)ClassUtil.nonNullState((Object)inputURI.appendFileExtension("qvtias").lastSegment())).getURI();
            BaseCSResource xtextResource = (BaseCSResource)this.getResourceSet().getResource(inputURI, true);
            assert (xtextResource != null);
            QVTiCompilerTests.assertNoResourceErrors((String)"Load failed", (Resource)xtextResource);
            ASResource asResource = xtextResource.getASResource();
            QVTiCompilerTests.assertNoValidationErrors((String)"Validation errors", (EObject)((EObject)xtextResource.getContents().get(0)));
            TestUtil.saveAsXMI((Resource)xtextResource, (URI)cstURI, QVTiCompilerTests.getSaveOptions());
            TestUtil.doCompleteOCLSetup();
            URI oclURI = URI.createPlatformResourceURI((String)"/org.eclipse.qvtd.pivot.qvtimperative/model/QVTimperative.ocl", (boolean)true);
            QVTiEnvironmentFactory environmentFactory = this.getEnvironmentFactory();
            CompleteOCLEObjectValidator completeOCLEObjectValidator2 = new CompleteOCLEObjectValidator((EPackage)ClassUtil.nonNullState((Object)QVTimperativePackage.eINSTANCE), oclURI);
            completeOCLEObjectValidator2.initialize((EnvironmentFactoryInternal)environmentFactory);
            PivotEObjectValidator.install((ResourceSet)((ResourceSet)ClassUtil.nonNullState((Object)asResource.getResourceSet())), (EnvironmentFactoryInternal)environmentFactory);
            PivotEObjectValidator.install((EPackage)((EPackage)ClassUtil.nonNullState((Object)QVTbasePackage.eINSTANCE)), null);
            PivotEObjectValidator.install((EPackage)((EPackage)ClassUtil.nonNullState((Object)QVTcorePackage.eINSTANCE)), null);
            PivotEObjectValidator.install((EPackage)((EPackage)ClassUtil.nonNullState((Object)QVTimperativePackage.eINSTANCE)), null);
            QVTiCompilerTests.assertNoValidationErrors((String)"Pivot validation errors", (EObject)((EObject)asResource.getContents().get(0)));
            if (asResource.isSaveable()) {
                asResource.setURI(pivotURI);
                asResource.save(QVTiCompilerTests.getSaveOptions());
            }
            return asResource;
        }

        protected @NonNull java.lang.Class<? extends Transformer> generateCode(@NonNull ImperativeTransformation iTransformation, boolean isIncremental) throws Exception {
            QVTiCodeGenerator cg = new QVTiCodeGenerator((QVTbaseEnvironmentFactory)this.getEnvironmentFactory(), iTransformation);
            QVTiCodeGenOptions options = cg.getOptions();
            options.setIsIncremental(isIncremental);
            options.setUseNullAnnotations(true);
            cg.generateClassFile();
            TestFolder srcPath = this.testProject.getOutputFolder("test-src/");
            TestFolder binPath = this.testProject.getOutputFolder("test-bin/");
            cg.saveSourceFile(srcPath.getFileString());
            JavaClasspath classpath = CompilerUtil.createDefaultQVTiClasspath();
            classpath.addClass(((Object)((Object)this)).getClass());
            java.lang.Class<? extends Transformer> txClass = this.compileTransformation(binPath.getFile(), cg, classpath);
            if (txClass == null) {
                TestCase.fail((String)"Failed to compile transformation");
                throw new UnsupportedOperationException();
            }
            return txClass;
        }

        public static @NonNull List<@NonNull String> my_createClassPathProjectList(@NonNull URIConverter uriConverter, @NonNull List<@NonNull String> projectNames) {
            ArrayList<@NonNull String> classpathProjectList = new ArrayList<String>();
            for (String projectName : projectNames) {
                File path = MyQVT.my_getProjectBinFolder(uriConverter, projectName);
                if (path == null) continue;
                classpathProjectList.add(String.valueOf(path));
            }
            return classpathProjectList;
        }

        public static @Nullable File my_getProjectBinFolder(@NonNull URIConverter uriConverter, @NonNull String projectName) {
            java.lang.Class<QVTiCompilerTests> class1 = QVTiCompilerTests.class;
            String modifiedProjectName = projectName.replace('.', '/');
            URL projectResource = class1.getResource("/" + modifiedProjectName);
            if (projectResource != null) {
                String projectString = projectResource.toString();
                String pathString = projectString.substring(0, projectString.length() - modifiedProjectName.length());
                URI pathURI = URI.createURI((String)pathString);
                return new File(pathURI.isFile() ? pathURI.toFileString() : pathURI.toString());
            }
            String path = null;
            String binDir = CGUtil.isMavenSurefire() || CGUtil.isTychoSurefire() ? MAVEN_TYCHO_BIN_FOLDER_NAME : REGULAR_BIN_FOLDER_NAME;
            URI platformURI = URI.createPlatformResourceURI((String)("/" + projectName + "/"), (boolean)true);
            URI pathURI = uriConverter.normalize(platformURI);
            String location = null;
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                IWorkspaceRoot workspaceRoot;
                IResource project;
                Bundle bundle = Platform.getBundle((String)projectName);
                if (bundle != null) {
                    try {
                        File bundleFilePath = MyQVT.my_getOSGIClassPath(bundle);
                        location = bundle.getLocation();
                        path = bundleFilePath.toString();
                    }
                    catch (IOException bundleFilePath) {
                        // empty catch block
                    }
                }
                if (path == null && (project = (workspaceRoot = ResourcesPlugin.getWorkspace().getRoot()).findMember(projectName)) != null) {
                    location = String.valueOf(project.getLocation());
                    path = String.valueOf(location) + "/" + "test-bin";
                }
            } else if (pathURI.isArchive()) {
                path = pathURI.toString();
                if (path.startsWith("archive:file:") && path.endsWith("!/")) {
                    path = path.substring(13, path.length() - 2);
                }
            } else {
                path = pathURI.toFileString();
                if (path != null) {
                    path = !new File(String.valueOf(path) + "/META-INF").exists() ? String.valueOf(path) + "test-bin" : String.valueOf(path) + binDir;
                }
            }
            if (JavaFileUtil.CLASS_PATH.isActive()) {
                StringBuilder s = new StringBuilder();
                s.append(projectName);
                s.append(" => ");
                s.append(pathURI);
                s.append(" => ");
                if (location != null) {
                    s.append(location);
                    s.append(" => ");
                }
                s.append(path);
                System.out.println(s.toString());
            }
            return path != null ? new File(path) : null;
        }

        public static @NonNull File my_getOSGIClassPath(@NonNull Bundle bundle) throws IOException {
            File outputPath;
            File bundleFile = FileLocator.getBundleFile((Bundle)bundle);
            if (bundleFile.isDirectory() && (outputPath = MyQVT.my_getOutputClassPath(bundleFile)) != null) {
                return outputPath;
            }
            return bundleFile;
        }

        private static @Nullable File my_getOutputClassPath(@NonNull File bundleDirectory) throws IOException {
            if (CGUtil.isMavenSurefire() || CGUtil.isTychoSurefire()) {
                return new File(bundleDirectory, MAVEN_TYCHO_BIN_FOLDER_NAME);
            }
            File classpathEntry = new File(bundleDirectory, ".classpath");
            if (classpathEntry.isFile()) {
                URI uri = URI.createFileURI((String)classpathEntry.toString());
                Resource resource = new GenericXMLResourceFactoryImpl().createResource(uri);
                resource.load(null);
                for (EObject eRoot : resource.getContents()) {
                    EClass eDocumentRoot = eRoot.eClass();
                    EStructuralFeature classpathentryRef = eDocumentRoot.getEStructuralFeature("classpathentry");
                    EStructuralFeature kindRef = eDocumentRoot.getEStructuralFeature("kind");
                    EStructuralFeature pathRef = eDocumentRoot.getEStructuralFeature("path");
                    for (EObject eObject : eRoot.eContents()) {
                        for (EObject eChild : eObject.eContents()) {
                            if (eChild.eContainmentFeature() != classpathentryRef || !"output".equals(eChild.eGet(kindRef))) continue;
                            String outputPath = String.valueOf(eChild.eGet(pathRef));
                            return new File(bundleDirectory, outputPath);
                        }
                    }
                }
            }
            return null;
        }

        public void execute(@NonNull Transformer tx) throws Exception {
            tx.analyzeInputResources();
            tx.run();
        }

        public @NonNull QVTiEnvironmentFactory getEnvironmentFactory() {
            return (QVTiEnvironmentFactory)super.getEnvironmentFactory();
        }

        public @NonNull Resource loadInput(@NonNull Transformer tx, @NonNull String inputModelName, URI inputModelURI) {
            Resource inputResource = (Resource)ClassUtil.nonNullState((Object)this.getResourceSet().getResource(inputModelURI, true));
            tx.getTypedModelInstance(inputModelName).addInputResource(inputResource);
            return inputResource;
        }

        public @NonNull ImperativeTransformation loadTransformation(@NonNull URI transformURI, @NonNull URI genModelURI) throws Exception {
            OCLstdlibTables.LIBRARY.getClass();
            ResourceSet resourceSet = this.getResourceSet();
            resourceSet.getPackageRegistry().put((Object)"http://www.eclipse.org/emf/2002/GenModel", (Object)GenModelPackage.eINSTANCE);
            MetamodelManagerInternal metamodelManager = this.getMetamodelManager();
            this.getEnvironmentFactory().configureLoadFirstStrategy();
            Resource genResource = resourceSet.getResource(genModelURI, true);
            for (EObject eObject : genResource.getContents()) {
                if (!(eObject instanceof GenModel)) continue;
                GenModel genModel = (GenModel)eObject;
                genModel.reconcile();
                metamodelManager.addGenModel(genModel);
            }
            Resource resource = this.doLoad_ConcreteWithOCL(transformURI);
            for (EObject eObject : resource.getContents()) {
                if (!(eObject instanceof ImperativeModel)) continue;
                for (Package asPackage : ((ImperativeModel)eObject).getOwnedPackages()) {
                    for (Class asClass : asPackage.getOwnedClasses()) {
                        if (!(asClass instanceof ImperativeTransformation)) continue;
                        return (ImperativeTransformation)asClass;
                    }
                }
            }
            TestCase.fail((String)("Failed to load '" + transformURI + "', '" + genModelURI + "'"));
            throw new UnsupportedOperationException();
        }

        public void saveOutput(@NonNull Transformer tx, @NonNull String outputModelName, @NonNull URI outputModelURI, @Nullable URI referenceModelURI, @Nullable ModelNormalizer normalizer) throws IOException, InterruptedException {
            ResourceSet resourceSet = this.getResourceSet();
            Resource outputResource = resourceSet.createResource(outputModelURI);
            outputResource.getContents().addAll(tx.getTypedModelInstance(outputModelName).getRootEObjects());
            outputResource.save(QVTiCompilerTests.getSaveOptions());
            Resource referenceResource = resourceSet.getResource(referenceModelURI, true);
            assert (referenceResource != null);
            if (normalizer != null) {
                normalizer.normalize(referenceResource);
                normalizer.normalize(outputResource);
            }
            QVTiCompilerTests.assertSameModel((Resource)referenceResource, (Resource)outputResource);
        }
    }

    protected static class MyQVTiEnvironmentFactory
    extends QVTiEnvironmentFactory {
        public MyQVTiEnvironmentFactory(@NonNull ProjectManager projectMap, @Nullable ResourceSet externalResourceSet) {
            super(projectMap, externalResourceSet);
            this.setEvaluationTracingEnabled(true);
        }
    }
}

