/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.xtext.qvtrelation.tests;

import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelation;
import org.eclipse.qvtd.xtext.qvtbase.tests.AbstractTestQVT;
import org.eclipse.qvtd.xtext.qvtbase.tests.LoadTestCase;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.TestsXMLUtil;
import org.eclipse.qvtd.xtext.qvtbase.tests.utilities.XtextCompilerUtil;
import org.eclipse.xtext.resource.XtextResource;

public class QVTrSerializeTests
extends LoadTestCase {
    protected @NonNull OCLInternal createOCL() {
        return QVTrelation.newInstance((ProjectManager)this.getTestProjectManager(), null);
    }

    protected void doSerializeRoundTripFromAS(@NonNull URI inputURI) throws Exception {
        URI referenceURI = this.getTestURIWithExtension(inputURI, "ref.qvtras");
        URI serializedInputURI = this.getTestURIWithExtension(inputURI, "serialized.qvtr");
        URI serializedPivotURI = this.getTestURIWithExtension(inputURI, "serialized.qvtras");
        QVTrelation ocl1 = QVTrelation.newInstance((ProjectManager)QVTrelation.NO_PROJECTS);
        QVTrelation ocl2 = QVTrelation.newInstance((ProjectManager)QVTrelation.NO_PROJECTS);
        Resource asResource1 = ocl1.getMetamodelManager().getASResourceSet().getResource(inputURI, true);
        this.doSerialize(inputURI, serializedInputURI, referenceURI, null, true, true, null);
        Resource asResource3 = this.doLoad_Concrete((OCL)ocl2, serializedInputURI, serializedPivotURI, NO_MESSAGES);
        ((Model)asResource3.getContents().get(0)).setExternalURI(((Model)asResource1.getContents().get(0)).getExternalURI());
        QVTrSerializeTests.assertSameModel((Resource)asResource1, (Resource)asResource3);
        ocl1.dispose();
        ocl2.dispose();
    }

    protected void doSerializeRoundTripFromCS(@NonNull URI inputURI, @NonNull String @Nullable [] messages) throws Exception {
        URI pivotURI = this.getTestURIWithExtension(inputURI, "qvtras");
        URI referenceURI = this.getTestURIWithExtension(inputURI, "ref.qvtras");
        URI serializedInputURI = this.getTestURIWithExtension(inputURI, "serialized.qvtr");
        URI serializedPivotURI = this.getTestURIWithExtension(inputURI, "serialized.qvtras");
        ProjectManager projectManager = this.getTestProjectManager();
        QVTrelation ocl1 = QVTrelation.newInstance((ProjectManager)projectManager, null);
        Resource asResource1 = this.doLoad_Concrete((OCL)ocl1, inputURI, pivotURI, messages);
        ocl1.deactivate();
        this.doSerialize(pivotURI, serializedInputURI, referenceURI, null, true, true, messages);
        QVTrelation ocl2 = QVTrelation.newInstance((ProjectManager)projectManager, null);
        Resource asResource3 = this.doLoad_Concrete((OCL)ocl2, serializedInputURI, serializedPivotURI, null);
        ((Model)asResource3.getContents().get(0)).setExternalURI(((Model)asResource1.getContents().get(0)).getExternalURI());
        TestsXMLUtil.resetTransients((Resource)asResource1);
        TestsXMLUtil.resetTransients((Resource)asResource3);
        QVTrSerializeTests.assertSameModel((Resource)asResource1, (Resource)asResource3);
        ocl1.dispose();
        ocl2.dispose();
    }

    protected void doSerializeRoundTripFromCS_usingOCL1(@NonNull URI inputURI, @NonNull String @Nullable [] messages) throws Exception {
        URI pivotURI = this.getTestURIWithExtension(inputURI, "qvtras");
        URI referenceURI = this.getTestURIWithExtension(inputURI, "ref.qvtras");
        URI serializedInputURI = this.getTestURIWithExtension(inputURI, "serialized.qvtr");
        URI serializedPivotURI = this.getTestURIWithExtension(inputURI, "serialized.qvtras");
        ProjectManager projectManager = this.getTestProjectManager();
        OCL ocl1 = OCL.newInstance((ProjectManager)projectManager);
        Resource asResource1 = this.doLoad_Concrete(ocl1, inputURI, pivotURI, null);
        ocl1.deactivate();
        this.doSerialize(pivotURI, serializedInputURI, referenceURI, null, true, true, messages);
        QVTrelation ocl2 = QVTrelation.newInstance((ProjectManager)projectManager);
        Resource asResource3 = this.doLoad_Concrete((OCL)ocl2, serializedInputURI, serializedPivotURI, null);
        ((Model)asResource3.getContents().get(0)).setExternalURI(((Model)asResource1.getContents().get(0)).getExternalURI());
        TestsXMLUtil.resetTransients((Resource)asResource1);
        TestsXMLUtil.resetTransients((Resource)asResource3);
        QVTrSerializeTests.assertSameModel((Resource)asResource1, (Resource)asResource3);
        ocl1.dispose();
        ocl2.dispose();
    }

    protected void doSerializeRoundTripFromCS_usingOCL2(@NonNull URI inputURI, @NonNull String @Nullable [] messages) throws Exception {
        URI pivotURI = this.getTestURIWithExtension(inputURI, "qvtras");
        URI referenceURI = this.getTestURIWithExtension(inputURI, "ref.qvtras");
        URI serializedInputURI = this.getTestURIWithExtension(inputURI, "serialized.qvtr");
        URI serializedPivotURI = this.getTestURIWithExtension(inputURI, "serialized.qvtras");
        ProjectManager projectManager = this.getTestProjectManager();
        OCL ocl1 = OCL.newInstance((ProjectManager)projectManager);
        Resource asResource1 = this.doLoad_Concrete(ocl1, inputURI, pivotURI, NO_MESSAGES);
        ocl1.deactivate();
        this.doSerialize(pivotURI, serializedInputURI, referenceURI, null, true, true, messages);
        OCL ocl2 = OCL.newInstance((ProjectManager)projectManager);
        Resource asResource3 = this.doLoad_Concrete(ocl2, serializedInputURI, serializedPivotURI, NO_MESSAGES);
        ((Model)asResource3.getContents().get(0)).setExternalURI(((Model)asResource1.getContents().get(0)).getExternalURI());
        TestsXMLUtil.resetTransients((Resource)asResource1);
        TestsXMLUtil.resetTransients((Resource)asResource3);
        QVTrSerializeTests.assertSameModel((Resource)asResource1, (Resource)asResource3);
        ocl1.dispose();
        ocl2.dispose();
    }

    public XtextResource doSerialize(@NonNull URI inputURI, @NonNull URI serializedInputURI, @NonNull URI referenceURI, @Nullable Map<String, Object> options, boolean doCompare, boolean validateSaved, @NonNull String @Nullable [] messages) throws Exception {
        QVTrelation ocl = QVTrelation.newInstance((ProjectManager)this.getTestProjectManager());
        try {
            ASResource asResource = AbstractTestQVT.loadQVTiAS((OCL)ocl, (URI)inputURI);
            QVTrSerializeTests.assertNoResourceErrors((String)"Normalisation failed", (Resource)asResource);
            QVTrSerializeTests.assertValidationDiagnostics((String)"Pivot validation errors", (Resource)asResource, (String[])messages);
            ResourceSet resourceSet = ocl.getResourceSet();
            XtextResource xtextResource = AbstractTestQVT.as2cs((OCL)ocl, (ResourceSet)resourceSet, (ASResource)asResource, (URI)serializedInputURI, (String)"org.eclipse.qvtd.xtext.qvtrelation");
            resourceSet.getResources().clear();
            XtextResource xtextResource2 = xtextResource;
            return xtextResource2;
        }
        finally {
            ocl.dispose();
            ocl = null;
        }
    }

    public void setUp() throws Exception {
        XtextCompilerUtil.doQVTrelationSetup();
        super.setUp();
    }

    public void testQVTrSerialize_ClassModelToClassModel() throws Exception {
        this.doSerializeRoundTripFromCS(this.getModelsURI("classmodel2classmodel/ClassModelToClassModel.qvtr"), new String[]{"The 'RelationCallExp::WhereInvocationIsANonTopRelation' constraint is violated for 'classToClass(c1, c2)'"});
    }

    public void testQVTrSerialize_HierarchicalStateMachine2FlatStateMachine() throws Exception {
        this.doSerializeRoundTripFromCS(this.getModelsURI("hstm2fstm/HierarchicalStateMachine2FlatStateMachine.qvtr"), null);
    }

    public void testQVTrSerialize_Iterated2Iterated() throws Exception {
        this.doSerializeRoundTripFromCS(this.getModelsURI("iterated2iterated/Iterated2Iterated.qvtr"), null);
    }

    public void testQVTrSerialize_Keys() throws Exception {
        this.doSerializeRoundTripFromCS(this.getModelsURI("misc/Keys.qvtr"), new String[]{"The 'Key::IdentifiesIsUnique' constraint is violated for 'key QVTRelation::Key {QVTRelation::Key::identifies}'", "The 'Key::IdentifiesIsUnique' constraint is violated for 'key QVTRelation::Key {QVTRelation::Key::identifies, QVTRelation::Key::part}'", "The 'Key::NoSuperKeys' constraint is violated for 'key EMOF::Class {EMOF::NamedElement::name}'", "The 'Key::IdentifiesIsNotAbstract' constraint is violated for 'key EMOF::NamedElement {EMOF::NamedElement::name}'"});
    }

    public void testQVTrSerialize_MiToSiSimple() throws Exception {
        this.doSerializeRoundTripFromCS(this.getModelsURI("mitosi/MiToSiSimple.qvtr"), null);
    }

    public void testQVTrSerialize_Packages() throws Exception {
        this.doSerializeRoundTripFromCS(this.getModelsURI("misc/Packages.qvtr"), null);
    }

    public void testQVTrSerialize_Persons2Names2Families_qvtr() throws Exception {
        this.doSerializeRoundTripFromCS(this.getModelsURI("persons2families/Persons2Names2Families.qvtr"), null);
    }

    public void testQVTrSerialize_PetriNet2StateChart() throws Exception {
        this.doSerializeRoundTripFromCS(this.getModelsURI("pn2sc/PetriNet2StateChart.qvtr"), null);
    }

    public void testQVTrSerialize_RelToCore() throws Exception {
        this.doSerializeRoundTripFromCS_usingOCL2(this.getModelsURI("rel2core/RelToCore.qvtr"), null);
    }

    public void testQVTrSerialize_SimplerRelToCore() throws Exception {
        this.doSerializeRoundTripFromCS_usingOCL1(this.getModelsURI("rel2core/SimplerRelToCore.qvtr"), null);
    }

    public void testQVTrSerialize_SeqToStm() throws Exception {
        this.doSerializeRoundTripFromCS(this.getModelsURI("seq2stm/SeqToStm.qvtr"), null);
    }
}

