/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.Property;

class RuntimePropertyShadowHelper {
    private EPackage fPackage;
    private Map<EClass, EClass> fReal2ShadowMap = new IdentityHashMap<EClass, EClass>();

    RuntimePropertyShadowHelper() {
        this.fPackage = EcoreFactory.eINSTANCE.createEPackage();
        this.fPackage.setName("interm_classes");
    }

    public EStructuralFeature createShadowProperty(ContextualProperty property) {
        if (property.getContext() == null) {
            throw new IllegalArgumentException();
        }
        return this.addProperty(property, property.getContext());
    }

    private EStructuralFeature addProperty(Property property, EClass owner) {
        EClass shadowClass = this.getShadow(owner);
        String name = property.getName();
        EClassifier type = property.getEType();
        Object shadowProperty = type instanceof EClass ? EcoreFactory.eINSTANCE.createEReference() : EcoreFactory.eINSTANCE.createEAttribute();
        shadowProperty.setName(name);
        shadowProperty.setEType(type);
        shadowClass.getEStructuralFeatures().add(shadowProperty);
        return shadowProperty;
    }

    private EClass getShadow(EClass realClass) {
        EClass result = this.fReal2ShadowMap.get(realClass);
        if (result == null) {
            result = this.createShadow(realClass);
            this.fReal2ShadowMap.put(realClass, result);
        }
        return result;
    }

    private EClass createShadow(EClass realClass) {
        EClass shadowClass = EcoreFactory.eINSTANCE.createEClass();
        shadowClass.setName(realClass.getName());
        this.fPackage.getEClassifiers().add((Object)shadowClass);
        this.fReal2ShadowMap.put(realClass, shadowClass);
        return shadowClass;
    }
}

