/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.samples;

import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ResLocator
implements ResourceLocator {
    private final Plugin myPlugin;
    private Image myMissingImage;

    public ResLocator(Plugin plugin) {
        this.myPlugin = plugin;
    }

    public URL getBaseURL() {
        return this.myPlugin.getBundle().getEntry("/");
    }

    public Object getImage(String key) {
        try {
            URL url = new URL(this.getBaseURL() + "icons/" + key + ".gif");
            InputStream inputStream = url.openStream();
            inputStream.close();
            return url;
        }
        catch (Exception exception) {
            return this.getMissingImage();
        }
    }

    public String getString(String key) {
        return Platform.getResourceBundle((Bundle)this.myPlugin.getBundle()).getString(key);
    }

    public String getString(String key, Object[] substitutions) {
        return MessageFormat.format(this.getString(key), substitutions);
    }

    public String getString(String key, boolean translate) {
        return this.getString(key);
    }

    public String getString(String key, Object[] substitutions, boolean translate) {
        return MessageFormat.format(this.getString(key, translate), substitutions);
    }

    private Image getMissingImage() {
        if (this.myMissingImage == null) {
            this.myMissingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.myMissingImage;
    }
}

