/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.ColorManager;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.IQVTColors;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.colorer.Messages;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class QVTColorManager
extends IQVTColors {
    ListenerList fColorChangedListeners = new ListenerList();
    private final List<ColorDescriptor> fDescriptors;
    private final Map<String, DefaultColoring> fKey2Default;
    private final Map<String, ColorDescriptor> fKey2Descriptor;
    private IPreferenceStore fStore;
    private ColorManager fColorManager;

    public QVTColorManager(IPreferenceStore store, ColorManager manager) {
        this.fStore = store;
        this.fColorManager = manager;
        this.fDescriptors = new ArrayList<ColorDescriptor>();
        this.fKey2Descriptor = new HashMap<String, ColorDescriptor>();
        this.fKey2Default = new HashMap<String, DefaultColoring>();
        this.initDescriptors();
    }

    void forceInitialize() {
        for (ColorDescriptor next : this.fDescriptors) {
            next.createToken();
        }
    }

    public ColorDescriptor getColor(String id) {
        return this.fKey2Descriptor.get(id);
    }

    private int addDescriptor(String key, String name, boolean canBeDisabled, DefaultColoring defaultSettings) {
        assert (key != null && name != null && defaultSettings != null);
        ColorDescriptor cd = new ColorDescriptor(key, name, canBeDisabled);
        this.fKey2Descriptor.put(key, cd);
        this.fDescriptors.add(cd);
        this.fKey2Default.put(key, defaultSettings);
        return this.fDescriptors.size();
    }

    private void initDescriptors() {
        this.addDescriptor(MULTILINE_COMMENT, Messages.SemanticKey_multiLineComment, false, new DefaultColoring(new RGB(63, 127, 95), false, true, false, false));
        this.addDescriptor(LINE_COMMENT, Messages.SemanticKey_singleLineComment, false, new DefaultColoring(new RGB(63, 127, 95), false, true, false, false));
        this.addDescriptor(TASK_TAG, Messages.SemanticKey_taskTags, false, new DefaultColoring(new RGB(127, 159, 191), true, false, false, false));
        this.addDescriptor(DOC_OTHERS, Messages.SemanticKey_Others, true, new DefaultColoring(new RGB(63, 95, 191), false, false, false, false));
        this.addDescriptor(DOC_TAG, Messages.SemanticKey_DocTags, true, new DefaultColoring(new RGB(63, 95, 191), false, false, false, false));
        this.addDescriptor(FATAL_ASSERT, Messages.SemanticKey_FatalAssertion, true, new DefaultColoring(new RGB(255, 0, 0), false, false, false, false));
        this.addDescriptor(KEYWORD, Messages.SemanticKey_Keywords, false, new DefaultColoring(new RGB(127, 0, 85), true, false, false, false));
        this.addDescriptor(STRING, Messages.SemanticKey_Strings, false, new DefaultColoring(new RGB(42, 0, 255), false, false, false, false));
        this.addDescriptor(NUMBER, Messages.SemanticKey_Numbers, false, new DefaultColoring(new RGB(0, 128, 0), false, false, false, false));
        this.addDescriptor(DEFAULT, Messages.SemanticKey_Others, false, new DefaultColoring(new RGB(0, 0, 0), false, false, false, false));
        this.addDescriptor(MODEL_PARAMETER, Messages.SemanticKey_ModelParameters, true, new DefaultColoring(new RGB(128, 128, 0), false, false, false, false));
        this.addDescriptor(MODULE_ELEMENT, Messages.SemanticKey_ModuleElements, true, new DefaultColoring(new RGB(111, 0, 74), false, false, false, false));
        this.addDescriptor(RESULT_VARIABLE, Messages.SemanticKey_ResultVar, true, new DefaultColoring(new RGB(0, 0, 160), true, false, false, false));
        this.addDescriptor(SELF_VARIABLE, Messages.SemanticKey_SelfVar, true, new DefaultColoring(new RGB(0, 0, 160), true, false, false, false));
        this.addDescriptor(INTERMEDIATE_DATA, Messages.SemanticKey_IntermData, true, new DefaultColoring(new RGB(108, 108, 108), false, false, false, false));
        this.addDescriptor(USER_MODEL_ELEMENT, Messages.SemanticKey_UserModelElements, true, new DefaultColoring(new RGB(0, 0, 192), false, false, false, false));
        this.addDescriptor(STDLIB_ELEMENT, Messages.SemanticKey_StdlibElements, true, new DefaultColoring(new RGB(0, 0, 0), false, true, false, false));
    }

    public void initializeDefaults() {
        for (String nextColorKey : this.fKey2Default.keySet()) {
            DefaultColoring settings = this.fKey2Default.get(nextColorKey);
            this.initDefault(nextColorKey, settings);
        }
    }

    private void initDefault(String id, DefaultColoring defaultSettings) {
        ColorDescriptor cd = this.getColor(id);
        assert (cd != null);
        PreferenceConverter.setDefault((IPreferenceStore)this.fStore, (String)cd.getColorKey(), (RGB)defaultSettings.getRgb());
        this.fStore.setDefault(cd.getBoldKey(), defaultSettings.isBold());
        this.fStore.setDefault(cd.getItalicKey(), defaultSettings.isItalic());
        this.fStore.setDefault(cd.getUnderlineKey(), defaultSettings.isUnderline());
        this.fStore.setDefault(cd.getStrikethroughKey(), defaultSettings.isStrikethrough());
        if (cd.canBeDisabled()) {
            this.fStore.setDefault(cd.getEnabledKey(), true);
        }
    }

    public void dispose() {
        for (ColorDescriptor cd : this.fDescriptors) {
            cd.disposeColor();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fStore == null) {
            return;
        }
        String property = event.getProperty();
        for (ColorDescriptor cd : this.fDescriptors) {
            if (cd.getColorKey().equals(property)) {
                this.adaptToTextForegroundChange(cd, event);
                this.notifyStyleChanged(cd);
                break;
            }
            if (cd.getBoldKey().equals(property)) {
                this.adaptToTextStyleChange(cd, event, 1);
                this.notifyStyleChanged(cd);
                break;
            }
            if (cd.getItalicKey().equals(property)) {
                this.adaptToTextStyleChange(cd, event, 2);
                this.notifyStyleChanged(cd);
                break;
            }
            if (cd.getStrikethroughKey().equals(property)) {
                this.adaptToTextStyleChange(cd, event, 0x20000000);
                this.notifyStyleChanged(cd);
                break;
            }
            if (cd.getUnderlineKey().equals(property)) {
                this.adaptToTextStyleChange(cd, event, 0x40000000);
                this.notifyStyleChanged(cd);
                break;
            }
            if (!cd.canBeDisabled() || !cd.getEnabledKey().equals(property)) continue;
            this.adaptToEnablementChange(cd.getHighlighting(), event);
            this.notifyStyleChanged(cd);
            break;
        }
    }

    public void addHighlightingChangedListener(IHighlightingChanged listener) {
        this.fColorChangedListeners.add((Object)listener);
    }

    public void removeHighlightingChangedListener(IHighlightingChanged listener) {
        this.fColorChangedListeners.remove((Object)listener);
    }

    private void notifyStyleChanged(ColorDescriptor cd) {
        Object[] listeners = this.fColorChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IHighlightingChanged)listeners[i]).highlightingChanged(cd);
            ++i;
        }
    }

    private void adaptToEnablementChange(Highlighting highlighting, PropertyChangeEvent event) {
        if (highlighting == null) {
            return;
        }
        Object value = event.getNewValue();
        boolean eventValue = value instanceof Boolean ? (Boolean)value : "true".equals(value);
        highlighting.setEnabled(eventValue);
    }

    private void adaptToTextForegroundChange(ColorDescriptor descriptor, PropertyChangeEvent event) {
        if (descriptor.getTextAttribute() == null) {
            return;
        }
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            String property = event.getProperty();
            Color color = this.fColorManager.getColor(property);
            if (color == null || !rgb.equals((Object)color.getRGB())) {
                this.fColorManager.unbindColor(property);
                this.fColorManager.bindColor(property, rgb);
                color = this.fColorManager.getColor(property);
            }
            TextAttribute oldAttr = descriptor.getTextAttribute();
            descriptor.setTextAttribute(new TextAttribute(color, oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToTextStyleChange(ColorDescriptor descriptor, PropertyChangeEvent event, int styleAttribute) {
        boolean activeValue;
        if (descriptor.getTextAttribute() == null) {
            return;
        }
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        TextAttribute oldAttr = descriptor.getTextAttribute();
        boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            descriptor.setTextAttribute(new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
        }
    }

    private void addColor(String colorKey) {
        if (this.fColorManager != null && colorKey != null && this.fColorManager.getColor(colorKey) == null) {
            RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fStore, (String)colorKey);
            this.fColorManager.unbindColor(colorKey);
            this.fColorManager.bindColor(colorKey, rgb);
        }
    }

    private void removeColor(String colorKey) {
        this.fColorManager.unbindColor(colorKey);
    }

    public boolean isAffected(PropertyChangeEvent event) {
        String property = event.getProperty();
        for (ColorDescriptor cd : this.fDescriptors) {
            if (!cd.isAffectedBy(property)) continue;
            return true;
        }
        return false;
    }

    public ColorDescriptor[] getSemanticHighlightings() {
        return this.fDescriptors.toArray(new ColorDescriptor[this.fDescriptors.size()]);
    }

    int getDescriptorIndex(ColorDescriptor colorDescriptor) {
        return this.fDescriptors.indexOf(colorDescriptor);
    }

    public class ColorDescriptor {
        private TextAttribute fAttribute;
        private Highlighting fHighlighting;
        private Token fToken;
        private final String fDisplayName;
        private final String fEnabledKey;
        private final String fBoldKey;
        private final String fItalicKey;
        private final String fColorKey;
        private final String fStrikethroughKey;
        private final String fUnderlineKey;
        private final String fKey;

        public ColorDescriptor(String key, String displayName, boolean canBeDisabled) {
            this.fKey = key;
            String baseKey = String.valueOf(BASE_COLORS_KEY_PREFIX) + key;
            this.fDisplayName = displayName;
            this.fBoldKey = String.valueOf(baseKey) + BOLD_SUFFIX;
            this.fItalicKey = String.valueOf(baseKey) + ITALIC_SUFFIX;
            this.fColorKey = String.valueOf(baseKey) + COLOR_SUFFIX;
            this.fStrikethroughKey = String.valueOf(baseKey) + STRIKETHROUGH_SUFFIX;
            this.fUnderlineKey = String.valueOf(baseKey) + UNDERLINE_SUFFIX;
            this.fEnabledKey = canBeDisabled ? String.valueOf(baseKey) + ENABLED_SUFFIX : null;
        }

        public String key() {
            return this.fKey;
        }

        public boolean canBeDisabled() {
            return this.fEnabledKey != null;
        }

        public String getDisplayName() {
            return this.fDisplayName;
        }

        public String getEnabledKey() {
            return this.fEnabledKey;
        }

        public String getBoldKey() {
            return this.fBoldKey;
        }

        public String getItalicKey() {
            return this.fItalicKey;
        }

        public String getStrikethroughKey() {
            return this.fStrikethroughKey;
        }

        public String getUnderlineKey() {
            return this.fUnderlineKey;
        }

        public String getColorKey() {
            return this.fColorKey;
        }

        public Highlighting getHighlighting() {
            return this.fHighlighting;
        }

        public boolean isAffectedBy(String property) {
            return property.equals(this.getColorKey()) || property.equals(this.getBoldKey()) || property.equals(this.getEnabledKey()) || property.equals(this.getItalicKey()) || property.equals(this.getStrikethroughKey()) || property.equals(this.getUnderlineKey());
        }

        public TextAttribute createTextAttribute() {
            int style;
            if (this.fAttribute != null) {
                return this.fAttribute;
            }
            QVTColorManager.this.addColor(this.getColorKey());
            int n = style = QVTColorManager.this.fStore.getBoolean(this.getBoldKey()) ? 1 : 0;
            if (QVTColorManager.this.fStore.getBoolean(this.getItalicKey())) {
                style |= 2;
            }
            if (QVTColorManager.this.fStore.getBoolean(this.getStrikethroughKey())) {
                style |= 0x20000000;
            }
            if (QVTColorManager.this.fStore.getBoolean(this.getUnderlineKey())) {
                style |= 0x40000000;
            }
            Color color = QVTColorManager.this.fColorManager.getColor(PreferenceConverter.getColor((IPreferenceStore)QVTColorManager.this.fStore, (String)this.getColorKey()));
            this.fAttribute = new TextAttribute(color, null, style);
            return this.fAttribute;
        }

        public Highlighting createHighlighting() {
            if (this.fHighlighting != null) {
                return this.fHighlighting;
            }
            boolean isEnabled = this.canBeDisabled() ? QVTColorManager.this.fStore.getBoolean(this.getEnabledKey()) : true;
            this.fHighlighting = new Highlighting(this.createTextAttribute(), isEnabled);
            return this.fHighlighting;
        }

        public Token createToken() {
            if (this.fToken != null) {
                return this.fToken;
            }
            this.fToken = new Token((Object)this.createTextAttribute());
            return this.fToken;
        }

        public void disposeColor() {
            if (this.fAttribute != null) {
                QVTColorManager.this.removeColor(this.getColorKey());
                this.fAttribute = null;
            }
        }

        public TextAttribute getTextAttribute() {
            return this.fAttribute;
        }

        public void setTextAttribute(TextAttribute ta) {
            this.fAttribute = ta;
            if (this.fHighlighting != null) {
                this.fHighlighting.setTextAttribute(ta);
            }
            if (this.fToken != null) {
                this.fToken.setData((Object)ta);
            }
        }
    }

    private static class DefaultColoring {
        private RGB rgb;
        private boolean bold;
        private boolean italic;
        private boolean underline;
        private boolean strikethrough;

        public DefaultColoring(RGB rgb, boolean bold, boolean italic, boolean underline, boolean strikethrough) {
            this.rgb = rgb;
            this.bold = bold;
            this.italic = italic;
            this.underline = underline;
            this.strikethrough = strikethrough;
        }

        public RGB getRgb() {
            return this.rgb;
        }

        public boolean isBold() {
            return this.bold;
        }

        public boolean isItalic() {
            return this.italic;
        }

        public boolean isUnderline() {
            return this.underline;
        }

        public boolean isStrikethrough() {
            return this.strikethrough;
        }
    }

    public class Highlighting {
        private TextAttribute fTextAttribute;
        private boolean fIsEnabled;

        public Highlighting(TextAttribute textAttribute, boolean isEnabled) {
            this.setTextAttribute(textAttribute);
            this.setEnabled(isEnabled);
        }

        public TextAttribute getTextAttribute() {
            return this.fTextAttribute;
        }

        public void setTextAttribute(TextAttribute textAttribute) {
            this.fTextAttribute = textAttribute;
        }

        public boolean isEnabled() {
            return this.fIsEnabled;
        }

        public void setEnabled(boolean isEnabled) {
            this.fIsEnabled = isEnabled;
        }
    }

    public static interface IHighlightingChanged {
        public void highlightingChanged(ColorDescriptor var1);
    }
}

