/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.common.io.CResourceRepositoryContext;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.WorkspaceMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.CFileData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.LightweightParserUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.Messages;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionCompiler;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.IMetamodelRegistryProvider;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.ocl.lpg.AbstractLexer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtCompletionData {
    public static final int[] MAPPING_DECLARATION_TRAILING_TOKEN_KINDS = new int[]{61, 51, 103, 139, 118, 117, 116};
    private final ITextEditor myEditor;
    private final ITextViewer myViewer;
    private final IDocument myDocument;
    private final IMetamodelRegistryProvider myMetamodelProvider;
    private final int myOffset;
    private final Map<String, Object> myUserData = new HashMap<String, Object>();
    private IToken myLeftToken;
    private IToken myCurrentToken;
    private AbstractLexer myLexer;
    private IPrsStream myPrsStream;
    private Exception myException;
    private IFile myIFile;
    private UnitProxy myCFile;
    private String myCharSet;
    private QvtCompletionCompiler myQvtCompiler;
    private IToken myParentImperativeOperation;

    public QvtCompletionData(ITextEditor editor, ITextViewer viewer, UnitProxy unit, int offset) {
        this.myEditor = editor;
        this.myViewer = viewer;
        this.myDocument = viewer.getDocument();
        this.myOffset = offset;
        this.myMetamodelProvider = new WorkspaceMetamodelRegistryProvider();
        try {
            this.myIFile = ((FileEditorInput)this.myEditor.getEditorInput()).getFile();
            this.myCharSet = this.myIFile.getCharset();
            this.myCFile = unit;
            this.myQvtCompiler = this.createQvtCompiler();
            this.myLexer = this.myQvtCompiler.createLexer(unit);
            this.myPrsStream = this.myLexer.getILexStream().getIPrsStream();
            this.getLeftTokenAndCurrentToken();
        }
        catch (Exception ex) {
            this.myException = ex;
            Activator.log(ex);
        }
    }

    public String getCharacterSet() {
        return this.myCharSet;
    }

    public MetamodelRegistry getMetamodelRegistry() {
        return this.myMetamodelProvider.getRegistry((IMetamodelRegistryProvider.IRepositoryContext)new CResourceRepositoryContext(this.myCFile.getURI()));
    }

    public ITextViewer getViewer() {
        return this.myViewer;
    }

    public IDocument getDocument() {
        return this.myDocument;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public IToken getLeftToken() {
        return this.myLeftToken;
    }

    public IToken getCurrentToken() {
        return this.myCurrentToken;
    }

    public AbstractLexer getLexer() {
        return this.myLexer;
    }

    public IPrsStream getPrsStream() {
        return this.myPrsStream;
    }

    public Map<String, Object> getUserData() {
        return this.myUserData;
    }

    public UnitProxy getCFile() {
        return this.myCFile;
    }

    public QvtOperationalEnv getEnvironment() {
        return this.myQvtCompiler.compileAll();
    }

    public QvtCompletionCompiler getQvtCompiler() {
        return this.myQvtCompiler;
    }

    public IToken getLeftToken(int leftOffsetIndex) {
        int leftTokenIndex = this.myLeftToken.getTokenIndex();
        int targetTokenIndex = leftTokenIndex - leftOffsetIndex;
        if (targetTokenIndex >= 1) {
            return this.myPrsStream.getTokenAt(targetTokenIndex);
        }
        return null;
    }

    public boolean isValid() {
        return this.myEditor != null && this.myViewer != null && this.myOffset >= 0 && this.myLexer != null && this.myPrsStream != null && this.myException == null;
    }

    public void showError(String message) {
        ErrorDialog.openError((Shell)this.myViewer.getTextWidget().getShell(), (String)Messages.QvtCompletionData_ErrorPerformingCodeCompletion, null, (IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.editor.ui", message));
    }

    private void getLeftTokenAndCurrentToken() throws BadLocationException {
        if (this.myOffset == 0 || this.myPrsStream.getTokens().isEmpty()) {
            return;
        }
        char previousChar = this.myViewer.getDocument().getChar(this.myOffset - 1);
        if (Character.isJavaIdentifierPart(previousChar)) {
            int tokenIndex = this.myPrsStream.getTokenIndexAtCharacter(this.myOffset - 1);
            this.myLeftToken = tokenIndex == 1 ? null : this.myPrsStream.getTokenAt(tokenIndex - 1);
            this.myCurrentToken = this.myPrsStream.getTokenAt(tokenIndex);
        } else {
            int leftTokenIndex;
            int tokenIndex = this.myPrsStream.getTokenIndexAtCharacter(this.myOffset);
            int n = leftTokenIndex = tokenIndex <= 0 ? -tokenIndex : tokenIndex - 1;
            if (leftTokenIndex != 0) {
                this.myLeftToken = this.myPrsStream.getTokenAt(leftTokenIndex);
            }
            if (this.myPrsStream.getTokens().size() >= leftTokenIndex + 2) {
                IToken next = this.myPrsStream.getTokenAt(leftTokenIndex + 1);
                this.myCurrentToken = next.getStartOffset() < this.myOffset ? next : null;
            }
        }
    }

    public MappingModuleCS[] getAllMappingModulesCS() {
        this.myQvtCompiler.compileAll();
        ArrayList modules = new ArrayList();
        for (CFileData cFileData : this.myQvtCompiler.getCFileDataMap().values()) {
            UnitCS unitCS = cFileData.getUnitCS();
            if (unitCS == null) continue;
            modules.addAll(unitCS.getModules());
        }
        return modules.toArray(new MappingModuleCS[modules.size()]);
    }

    public MappingModuleCS getCurrentMappingModuleCS() {
        this.myQvtCompiler.compileAll();
        CFileData cFileData = this.myQvtCompiler.getCFileDataMap().get(this.myCFile.getURI());
        if (cFileData != null) {
            return cFileData.getMappingModuleCS();
        }
        return null;
    }

    public MappingMethodCS[] getAllImperativeOperationsCS() {
        MappingModuleCS[] allMappingModulesCS = this.getAllMappingModulesCS();
        ArrayList methods = new ArrayList();
        MappingModuleCS[] mappingModuleCSArray = allMappingModulesCS;
        int n = allMappingModulesCS.length;
        int n2 = 0;
        while (n2 < n) {
            MappingModuleCS mappingModuleCS = mappingModuleCSArray[n2];
            methods.addAll(mappingModuleCS.getMethods());
            ++n2;
        }
        return methods.toArray(new MappingMethodCS[methods.size()]);
    }

    public boolean isWithin(int[] keywordTokenKinds, int[] unexpectedTokenKinds) {
        int i = this.myLeftToken.getTokenIndex();
        while (i >= 0) {
            IToken token = this.myPrsStream.getTokenAt(i);
            if (QvtCompletionData.isKindOf(token, keywordTokenKinds)) {
                return true;
            }
            int[] nArray = unexpectedTokenKinds;
            int n = unexpectedTokenKinds.length;
            int n2 = 0;
            while (n2 < n) {
                int unexpectedTokenKind = nArray[n2];
                if (token.getKind() == unexpectedTokenKind) {
                    return false;
                }
                ++n2;
            }
            --i;
        }
        return false;
    }

    public IToken getParentBracingExpression(ITokenQualificator tokenQualif, int leftBraceKind, int rightBraceKind, int maxDepth, int[] zeroDepthTerminatorKinds, int[] unexpectedTokenKinds, int[] ignoredClauses) {
        int depth = 0;
        Stack<Integer> maxCurrentDepthStack = new Stack<Integer>();
        maxCurrentDepthStack.push(Integer.MIN_VALUE);
        if (this.myLeftToken == null) {
            return null;
        }
        int i = this.myLeftToken.getTokenIndex();
        while (i >= 0) {
            IToken nextToken;
            IToken token = this.myPrsStream.getTokenAt(i);
            if (tokenQualif.isSuited(token)) {
                if (depth >= 1 && depth > (Integer)maxCurrentDepthStack.peek()) {
                    return token;
                }
            } else if (token.getKind() == leftBraceKind) {
                if (++depth > maxDepth) {
                    return null;
                }
            } else if (token.getKind() == rightBraceKind) {
                if (depth >= (Integer)maxCurrentDepthStack.peek()) {
                    maxCurrentDepthStack.push(depth);
                }
                --depth;
            } else {
                if (depth == 0 && QvtCompletionData.isKindOf(token, zeroDepthTerminatorKinds)) {
                    return null;
                }
                if (QvtCompletionData.isKindOf(token, unexpectedTokenKinds)) {
                    return null;
                }
            }
            if (QvtCompletionData.isKindOf(token, ignoredClauses) && (nextToken = LightweightParserUtil.getNextToken(token)) != null && QvtCompletionData.isKindOf(nextToken, leftBraceKind) && depth == (Integer)maxCurrentDepthStack.peek()) {
                assert (maxCurrentDepthStack.size() > 1);
                if (maxCurrentDepthStack.size() > 1) {
                    maxCurrentDepthStack.pop();
                }
            }
            --i;
        }
        return null;
    }

    private QvtCompletionCompiler createQvtCompiler() {
        IProject project = this.myIFile.getProject();
        UnitResolverFactory resolverFactory = UnitResolverFactory.Registry.INSTANCE.getFactory((Object)project);
        UnitResolver importResolver = resolverFactory.getResolver(URIUtils.getResourceURI((IResource)project));
        return new QvtCompletionCompiler(importResolver, this.myMetamodelProvider, this);
    }

    public static final boolean isKindOf(IToken token, int ... tokenKinds) {
        if (tokenKinds != null) {
            int[] nArray = tokenKinds;
            int n = tokenKinds.length;
            int n2 = 0;
            while (n2 < n) {
                int tokenKind = nArray[n2];
                if (token.getKind() == tokenKind) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static final boolean isKindOf(IToken token, String ... tokenKinds) {
        if (tokenKinds != null) {
            String[] stringArray = tokenKinds;
            int n = tokenKinds.length;
            int n2 = 0;
            while (n2 < n) {
                String tokenText = stringArray[n2];
                if (tokenText.equals(token.toString())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static final IToken[] extractTokens(IToken startToken, int ... endTokenKinds) {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        IToken currentToken = startToken;
        IPrsStream prsStream = startToken.getIPrsStream();
        while (true) {
            if (QvtCompletionData.isKindOf(currentToken, endTokenKinds)) {
                return tokens.toArray(new IToken[tokens.size()]);
            }
            tokens.add(currentToken);
            int currentTokenIndex = currentToken.getTokenIndex();
            int nextTokenIndex = currentTokenIndex + 1;
            if (nextTokenIndex >= prsStream.getSize()) break;
            currentToken = prsStream.getTokenAt(nextTokenIndex);
        }
        return null;
    }

    public IToken getParentImperativeOperation() {
        if (this.myParentImperativeOperation == null) {
            IToken previousToken;
            this.myParentImperativeOperation = this.getParentBracingExpression(new ITokenQualificator(){

                public boolean isSuited(IToken token) {
                    return QvtCompletionData.isKindOf(token, LightweightParserUtil.IMPERATIVE_OPERATION_TOKENS);
                }
            }, 61, 64, Integer.MAX_VALUE, null, null, LightweightParserUtil.MAPPING_CLAUSE_TOKENS);
            if (this.myParentImperativeOperation != null && QvtCompletionData.isKindOf(this.myParentImperativeOperation, 83) && (previousToken = LightweightParserUtil.getPreviousToken(this.myParentImperativeOperation)) != null && QvtCompletionData.isKindOf(previousToken, 89, 90)) {
                this.myParentImperativeOperation = previousToken;
            }
        }
        return this.myParentImperativeOperation;
    }

    public void setParentImperativeOperation(IToken parentImperativeOperation) {
        this.myParentImperativeOperation = parentImperativeOperation;
    }

    public static interface ITokenQualificator {
        public boolean isSuited(IToken var1);
    }
}

