/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsPackage;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.qvt.oml.debug.core.vm.UnitLocation;
import org.eclipse.m2m.qvt.oml.debug.core.vm.UnitLocationExecutionContext;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMFrameExecutionContext;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMStackFrame;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMVariable;
import org.eclipse.m2m.qvt.oml.debug.core.vm.Value;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMVariableRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMVariableResponse;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableFinder {
    private final VMFrameExecutionContext fFeatureAccessor;
    private final boolean fIsStoreValues;
    private VMVariable fTargetVar;
    private EClassifier fRootDeclaredType;

    public VariableFinder(VMFrameExecutionContext featureAccessor, boolean isStoreValues) {
        this.fFeatureAccessor = featureAccessor;
        this.fIsStoreValues = isStoreValues;
    }

    public static String computeDetail(URI variableURI, UnitLocationExecutionContext frameContext) {
        VariableFinder finder = new VariableFinder(frameContext, false);
        String[] variablePath = VariableFinder.getVariablePath(variableURI);
        Object valueObject = finder.findStackObject(variablePath);
        if (valueObject != null) {
            try {
                return valueObject.toString();
            }
            catch (RuntimeException runtimeException) {}
        }
        return null;
    }

    public static VMResponse process(VMVariableRequest request, List<UnitLocation> stack, UnitLocationExecutionContext frameContext) {
        UnitLocation location = VMStackFrame.lookupEnvironmentByID(request.frameID, stack);
        if (location == null) {
            return VMResponse.createERROR();
        }
        String variableURIStr = request.variableURI;
        URI variableURI = VariableFinder.parseURI(variableURIStr);
        String[] variablePath = VariableFinder.getVariablePath(variableURI);
        VariableFinder variableManager = new VariableFinder(frameContext, false);
        ArrayList<VMVariable> variables = new ArrayList<VMVariable>();
        variableManager.find(variablePath, request.includeChildVars, variables);
        if (variables.isEmpty()) {
            return VMResponse.createERROR();
        }
        VMVariable[] children = null;
        if (variables.size() > 1) {
            children = variables.subList(1, variables.size()).toArray(new VMVariable[variables.size() - 1]);
        }
        return new VMVariableResponse((VMVariable)variables.get(0), children);
    }

    public void find(String[] objectPath, boolean fetchChildVariables, List<VMVariable> result) {
        if (objectPath == null) {
            throw new IllegalArgumentException("null variable path");
        }
        if (result == null || result.contains(null)) {
            throw new IllegalArgumentException("null result variables");
        }
        try {
            Object referencedObj = this.findStackObject(objectPath);
            VMVariable variable = this.fTargetVar;
            if (variable != null) {
                result.add(variable);
                if (fetchChildVariables) {
                    this.collectChildVars(referencedObj, objectPath, this.fRootDeclaredType, result);
                }
            }
        }
        finally {
            this.fTargetVar = null;
        }
    }

    private Object findStackObject(String[] varTreePath) {
        String envVarName;
        QvtOperationalEvaluationEnv evalEnv = this.fFeatureAccessor.getEvalEnv();
        Object rootObj = evalEnv.getValueOf(envVarName = varTreePath[0]);
        if (rootObj == null && !evalEnv.getNames().contains(envVarName)) {
            rootObj = VariableFinder.getModelParameterVariables(evalEnv).get(envVarName);
        }
        this.fRootDeclaredType = evalEnv.getTypeOf(envVarName);
        if (rootObj != null && varTreePath.length == 1) {
            String[] uri = new String[]{envVarName};
            this.fTargetVar = this.createVariable(envVarName, 0, this.fRootDeclaredType, rootObj, VariableFinder.createURI(uri).toString());
            return rootObj;
        }
        if (rootObj == null) {
            return null;
        }
        return this.findChildObject(rootObj, this.fRootDeclaredType, varTreePath, 1);
    }

    private Object findChildObject(Object parentObj, EClassifier optParentDeclaredType, String[] varTreePath, int pathIndex) {
        int nextIndex;
        URI uri = VariableFinder.createURI(varTreePath, pathIndex);
        VMVariable childVar = null;
        Object nextObject = null;
        EClassifier nextDeclaredType = null;
        if (parentObj instanceof ModelInstance) {
            parentObj = ((ModelInstance)parentObj).getExtent().getRootObjects();
            nextDeclaredType = QvtOperationalStdLibrary.INSTANCE.getElementType();
        }
        if (parentObj instanceof EObject) {
            EObject eObject = (EObject)parentObj;
            EStructuralFeature eFeature = this.findFeature(varTreePath[pathIndex], eObject.eClass());
            if (eFeature != null) {
                Object value = this.fFeatureAccessor.getValue(eFeature, eObject);
                childVar = this.createFeatureVar(eFeature, value, uri.toString());
                nextObject = value;
                nextDeclaredType = this.fFeatureAccessor.getOCLType(eFeature);
            }
        } else if (parentObj instanceof Collection) {
            Collection collection = (Collection)parentObj;
            int elementIndex = -1;
            try {
                elementIndex = Integer.parseInt(varTreePath[pathIndex]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException();
            }
            if (elementIndex < 0 || elementIndex >= collection.size()) {
                throw new IllegalArgumentException();
            }
            if (optParentDeclaredType instanceof CollectionType) {
                CollectionType type = (CollectionType)optParentDeclaredType;
                nextDeclaredType = (EClassifier)type.getElementType();
            } else if (nextDeclaredType == null) {
                nextDeclaredType = (EClassifier)this.fFeatureAccessor.getStandardLibrary().getOclAny();
            }
            Object element = this.getElement(collection, elementIndex);
            childVar = this.createCollectionElementVar(elementIndex, element, nextDeclaredType, uri.toString());
            nextObject = element;
        }
        if ((nextIndex = pathIndex + 1) < varTreePath.length) {
            if (nextObject != null) {
                return this.findChildObject(nextObject, nextDeclaredType, varTreePath, nextIndex);
            }
            return null;
        }
        this.fTargetVar = childVar;
        return nextObject;
    }

    private VMVariable createFeatureVar(EStructuralFeature feature, Object value, String uri) {
        String varName = feature.getName();
        EClassifier declaredType = this.fFeatureAccessor.getOCLType(feature);
        int kind = 1;
        if (feature instanceof EReference) {
            kind = 2;
        }
        if (feature instanceof ContextualProperty) {
            kind = 5;
        }
        return this.createVariable(varName, kind, declaredType, value, uri);
    }

    private VMVariable createCollectionElementVar(int elementIndex, Object element, EClassifier elementType, String uri) {
        String varName = "[" + elementIndex + "]";
        int kind = 6;
        return this.createVariable(varName, kind, elementType, element, uri);
    }

    private VMVariable createDictionaryElementVar(Object key, Object value, EClassifier elementType, String uri) {
        String varName = String.valueOf(key);
        int kind = 6;
        return this.createVariable(varName, kind, elementType, value, uri);
    }

    private VMVariable createVariable(String varName, int kind, EClassifier declaredType, Object varObj, String uri) {
        VMVariable result = new VMVariable();
        result.name = String.valueOf(varName);
        result.kind = kind;
        result.variableURI = uri;
        VariableFinder.setValueAndType(result, varObj, declaredType, this.fFeatureAccessor.getEvalEnv());
        if (this.fIsStoreValues) {
            result.valueObject = varObj;
        }
        return result;
    }

    public static URI parseURI(String variableURI) throws IllegalArgumentException {
        return URI.createURI((String)variableURI);
    }

    public static String[] getVariablePath(URI variableURI) {
        String[] ids = new String[variableURI.segmentCount()];
        int i = 0;
        while (i < ids.length) {
            ids[i] = URI.decode((String)variableURI.segment(i));
            ++i;
        }
        return ids;
    }

    public static String getRootVarName(URI variableURI) {
        if (variableURI.segmentCount() == 0) {
            throw new IllegalArgumentException();
        }
        return URI.decode((String)variableURI.segment(0));
    }

    public static URI createURI(String[] varPath) {
        return VariableFinder.createURI(varPath, varPath.length - 1);
    }

    public static URI createURI(String[] varPath, int endIndex) {
        String[] segments = new String[endIndex + 1];
        int i = 0;
        while (i < segments.length) {
            segments[i] = URI.encodeSegment((String)varPath[i], (boolean)true);
            ++i;
        }
        return URI.createHierarchicalURI((String[])segments, null, null);
    }

    public void collectChildVars(Object root, String[] parentPath, EClassifier containerType, List<VMVariable> result) {
        block9: {
            String[] childPath;
            block8: {
                childPath = new String[parentPath.length + 1];
                System.arraycopy(parentPath, 0, childPath, 0, parentPath.length);
                if (root instanceof ModelInstance) {
                    ModelInstance model = (ModelInstance)root;
                    root = model.getExtent().getRootObjects();
                    containerType = (EClassifier)EcoreEnvironmentFactory.INSTANCE.createEnvironment().getOCLFactory().createSetType((Object)QvtOperationalStdLibrary.INSTANCE.getElementType());
                }
                if (!(root instanceof EObject)) break block8;
                EObject eObject = (EObject)root;
                EClass eClass = eObject.eClass();
                StringBuilder uriBuf = new StringBuilder();
                List<EStructuralFeature> eAllFeatures = this.fFeatureAccessor.getAllFeatures(eClass);
                EList superClasses = eClass.getEAllSuperTypes();
                for (EStructuralFeature feature : eAllFeatures) {
                    EClass owner;
                    if (feature.eClass() == ExpressionsPackage.eINSTANCE.getContextualProperty()) {
                        ContextualProperty ctxProperty = (ContextualProperty)feature;
                        owner = ctxProperty.getContext();
                        uriBuf.append('+');
                    } else {
                        owner = feature.getEContainingClass();
                    }
                    int index = superClasses.indexOf(owner);
                    uriBuf.append(index < 0 ? 0 : index);
                    uriBuf.append('.').append(feature.getName());
                    childPath[childPath.length - 1] = uriBuf.toString();
                    VMVariable elementVar = this.createFeatureVar(feature, this.fFeatureAccessor.getValue(feature, eObject), VariableFinder.createURI(childPath).toString());
                    result.add(elementVar);
                    uriBuf.setLength(0);
                }
                break block9;
            }
            if (!(root instanceof Collection)) break block9;
            Collection elements = (Collection)root;
            EClassifier elementType = containerType instanceof CollectionType ? (EClassifier)((CollectionType)containerType).getElementType() : (EClassifier)this.fFeatureAccessor.getStandardLibrary().getOclAny();
            Dictionary asDictionary = null;
            if (root instanceof Dictionary) {
                Dictionary dict;
                asDictionary = dict = (Dictionary)root;
                elements = asDictionary.keys();
            }
            int i = 0;
            for (Object element : elements) {
                VMVariable elementVar;
                childPath[childPath.length - 1] = String.valueOf(i);
                if (asDictionary == null) {
                    elementVar = this.createCollectionElementVar(i, element, elementType, VariableFinder.createURI(childPath).toString());
                } else {
                    Object key = element;
                    Object value = asDictionary.get(element);
                    elementVar = this.createDictionaryElementVar(key, value, elementType, VariableFinder.createURI(childPath).toString());
                }
                result.add(elementVar);
                ++i;
            }
        }
    }

    private static EClass selectEClass(EClass eClass, int index) {
        EList superClasses;
        if (index > 0 && index < (superClasses = eClass.getEAllSuperTypes()).size()) {
            return (EClass)superClasses.get(index);
        }
        return eClass;
    }

    private Object getElement(Collection<?> collection, int index) {
        if (collection instanceof EList) {
            EList eList = (EList)collection;
            return eList.get(index);
        }
        int curr = 0;
        for (Object object : collection) {
            if (curr++ != index) continue;
            return object;
        }
        return null;
    }

    private EStructuralFeature findFeature(String featureRef, EClass actualTarget) {
        String featureName;
        int classIndex;
        String actualRef = featureRef.startsWith("+") ? featureRef.substring(1) : featureRef;
        boolean isIntermediate = featureRef.length() != actualRef.length();
        try {
            int delimiterPos = actualRef.indexOf(46);
            if (delimiterPos <= 0 || delimiterPos >= actualRef.length() - 1) {
                throw new IllegalArgumentException("navigatin feature: " + actualRef);
            }
            classIndex = Integer.parseInt(actualRef.substring(0, delimiterPos));
            featureName = actualRef.substring(delimiterPos + 1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Illegal feature reference: " + featureRef);
        }
        EClass featureOwner = VariableFinder.selectEClass(actualTarget, classIndex);
        if (featureOwner == null) {
            return null;
        }
        if (!isIntermediate) {
            return featureOwner.getEStructuralFeature(featureName);
        }
        EClass contextualPropMetaClass = ExpressionsPackage.eINSTANCE.getContextualProperty();
        for (EStructuralFeature feature : actualTarget.getEAllStructuralFeatures()) {
            if (feature.eClass() != contextualPropMetaClass || !feature.equals(feature.getName())) continue;
            return feature;
        }
        return null;
    }

    static List<VMVariable> getVariables(QvtOperationalEvaluationEnv evalEnv) {
        ArrayList<VMVariable> result = new ArrayList<VMVariable>();
        for (String varName : evalEnv.getNames()) {
            VMVariable var = new VMVariable();
            var.name = varName;
            if (VariableFinder.isPredefinedVar(varName, evalEnv)) {
                var.kind = 3;
            }
            Object value = evalEnv.getValueOf(varName);
            EClassifier declaredType = evalEnv.getTypeOf(varName);
            VariableFinder.setValueAndType(var, value, declaredType, evalEnv);
            result.add(var);
        }
        Map<String, ModelInstance> modelParameterVariables = VariableFinder.getModelParameterVariables(evalEnv);
        for (String modelParam : modelParameterVariables.keySet()) {
            ModelInstance model = modelParameterVariables.get(modelParam);
            VMVariable var = new VMVariable();
            var.name = modelParam;
            VariableFinder.setValueAndType(var, model, (EClassifier)model.eClass(), evalEnv);
            var.kind = 4;
            result.add(var);
        }
        return result;
    }

    public static void setValueAndType(VMVariable variable, Object value, EClassifier optDeclaredType, QvtOperationalEvaluationEnv evalEnv) {
        Value vmValue;
        Value.Type vmType;
        String declaredTypeName;
        String string = declaredTypeName = optDeclaredType != null ? optDeclaredType.getName() : null;
        if (value == null) {
            vmType = new Value.Type(0, "OclVoid", declaredTypeName);
            vmValue = null;
        } else if (evalEnv.isOclInvalid(value)) {
            vmType = new Value.Type(0, "OclIvalid", declaredTypeName);
            vmValue = Value.invalid();
        } else if (value instanceof EObject) {
            EObject eObject = (EObject)value;
            EClass eClass = eObject.eClass();
            String strVal = String.valueOf(eClass.getName()) + " @" + Integer.toHexString(System.identityHashCode(value));
            boolean hasVariables = !eClass.getEAllStructuralFeatures().isEmpty() || value instanceof ModelInstance;
            vmValue = new Value(1, strVal, hasVariables);
            vmType = new Value.Type(1, eClass.getName(), declaredTypeName);
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            Class<?> javaType = value.getClass();
            StringBuilder strVal = new StringBuilder();
            if (optDeclaredType != null) {
                strVal.append(optDeclaredType.getName());
            } else {
                strVal.append(javaType.getSimpleName());
            }
            strVal.append('[').append(collection.size()).append(']');
            vmValue = new Value(2, strVal.toString(), !collection.isEmpty());
            vmType = new Value.Type(2, javaType.getSimpleName(), declaredTypeName);
        } else {
            String valueOf = String.valueOf(value);
            if (value.getClass().equals(String.class)) {
                valueOf = "\"" + valueOf + "\"";
            }
            vmValue = new Value(0, valueOf);
            vmType = new Value.Type(0, value.getClass().getSimpleName(), declaredTypeName);
        }
        variable.type = vmType;
        variable.value = vmValue;
    }

    private static Map<String, ModelInstance> getModelParameterVariables(QvtOperationalEvaluationEnv evalEnv) {
        InternalEvaluationEnv internEvalEnv = (InternalEvaluationEnv)evalEnv.getAdapter(InternalEvaluationEnv.class);
        ModuleInstance currentModule = internEvalEnv.getCurrentModule();
        if (!(currentModule instanceof TransformationInstance)) {
            return Collections.emptyMap();
        }
        HashMap<String, ModelInstance> result = new HashMap<String, ModelInstance>(2);
        TransformationInstance currentTransformation = (TransformationInstance)currentModule;
        for (ModelParameter modelParameter : currentTransformation.getTransformation().getModelParameter()) {
            ModelInstance modelInstance = currentTransformation.getModel(modelParameter);
            String name = modelParameter.getName();
            result.put(name, modelInstance);
        }
        ModelInstance intermModel = ((TransformationInstance.InternalTransformation)currentTransformation.getAdapter(TransformationInstance.InternalTransformation.class)).getIntermediateExtent();
        if (intermModel != null) {
            result.put("_intermediate", intermModel);
        }
        return result;
    }

    private static boolean isPredefinedVar(String name, QvtOperationalEvaluationEnv evalEnv) {
        if (("self".equals(name) || "result".equals(name)) && evalEnv.getOperation() != null) {
            return true;
        }
        return "this".equals(name);
    }
}

