/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.launch;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugTarget;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugUtil;
import org.eclipse.m2m.qvt.oml.debug.core.app.SocketUtil;
import org.eclipse.m2m.qvt.oml.debug.core.vm.QVTOVirtualMachineProxy;
import org.eclipse.pde.launching.EclipseApplicationLaunchConfiguration;

public class QVTOApplicationConfiguration
extends EclipseApplicationLaunchConfiguration {
    private int fPort = -1;
    private List<URI> fModels = new ArrayList<URI>();
    private URI fTraceURI;

    private int getPort() {
        if (this.fPort == -1) {
            this.fPort = SocketUtil.findFreePort();
        }
        return this.fPort;
    }

    public String[] getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String[] programArguments = super.getProgramArguments(configuration);
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(programArguments));
        result.add(QVTOApplicationConfiguration.createArgStr("-port", String.valueOf(this.getPort())));
        String transformationURI = QvtLaunchUtil.getTransformationURI((ILaunchConfiguration)configuration);
        if (transformationURI != null) {
            result.add(QVTOApplicationConfiguration.createArgStr("-transform", this.createTransformationURI(transformationURI).toString()));
        }
        String traceFileURI = QvtLaunchUtil.getTraceFileURI((ILaunchConfiguration)configuration);
        boolean shouldGenerateTraceFile = QvtLaunchUtil.shouldGenerateTraceFile((ILaunchConfiguration)configuration);
        if (traceFileURI != null && traceFileURI.trim().length() != 0 && shouldGenerateTraceFile) {
            this.fTraceURI = QVTODebugUtil.toFileURI(traceFileURI);
            result.add(QVTOApplicationConfiguration.createArgStr("-trace", this.fTraceURI.toString().toString()));
        }
        List modelURIs = QvtLaunchUtil.getTargetUris((ILaunchConfiguration)configuration);
        for (TargetUriData targetUriData : modelURIs) {
            String nextURI = targetUriData.getUriString();
            URI nextModelURI = QVTODebugUtil.toFileURI(nextURI);
            this.fModels.add(nextModelURI);
            result.add(QVTOApplicationConfiguration.createArgStr("-param", nextModelURI.toString()));
        }
        return result.toArray(new String[result.size()]);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.reset();
        int port = this.getPort();
        if (port == -1) {
            throw new CoreException(QVTODebugCore.createStatus(4, "Failed to find free debugging port"));
        }
        this.launchSeparateEclipse(configuration, mode, launch, monitor);
    }

    void launchSeparateEclipse(ILaunchConfiguration configuration, String mode, final ILaunch launch, IProgressMonitor monitor) throws CoreException {
        QVTOVirtualMachineProxy vm;
        ILaunchConfiguration launchConfiguration = configuration;
        super.launch(launchConfiguration, mode, launch, (IProgressMonitor)new NullProgressMonitor());
        if ("run".equals(mode)) {
            return;
        }
        try {
            BasicMonitor connectMonitor = new BasicMonitor(){

                public boolean isCanceled() {
                    IProcess p = QVTOApplicationConfiguration.this.getProcess(launch);
                    return p != null ? p.isTerminated() : false;
                }
            };
            vm = new QVTOVirtualMachineProxy("localhost", this.getPort(), (Monitor)connectMonitor);
        }
        catch (IOException e) {
            IProcess p = this.getProcess(launch);
            if (p != null && p.isTerminated() && p.getExitValue() != 0) {
                return;
            }
            throw new CoreException(QVTODebugCore.createStatus(4, "Failed to connect to QVTO VM", e));
        }
        try {
            IProcess[] launchedProcesses = launch.getProcesses();
            if (launchedProcesses.length == 0) {
                return;
            }
            IProcess pdeProcess = launchedProcesses[0];
            this.addTerminationHook(pdeProcess);
            QVTODebugTarget debugTarget = new QVTODebugTarget(pdeProcess, vm){

                protected URI computeBreakpointURI(URI sourceURI) {
                    return QVTODebugCore.getDefault().resolvePlatformPluginURI(sourceURI);
                }
            };
            launch.addDebugTarget((IDebugTarget)debugTarget);
        }
        finally {
            this.fPort = -1;
        }
    }

    private IProcess getProcess(ILaunch launch) {
        IProcess[] launchedProcesses = launch.getProcesses();
        if (launchedProcesses.length == 0) {
            return null;
        }
        return launchedProcesses[0];
    }

    private URI createTransformationURI(String uriStr) throws CoreException {
        URI platformPluginURI;
        URI uri = URI.createURI((String)uriStr, (boolean)true);
        IFile file = QVTODebugUtil.toFile(uri);
        if (file != null && file.exists() && (platformPluginURI = QVTODebugCore.getDefault().resolvePlatformPluginURI(file)) != null) {
            uri = platformPluginURI;
        }
        return uri;
    }

    private static String createArgStr(String argName, String argValue) {
        return String.valueOf(argName) + "=" + argValue;
    }

    private void addTerminationHook(final IProcess process) {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                DebugEvent[] debugEventArray = events;
                int n = events.length;
                int n2 = 0;
                while (n2 < n) {
                    DebugEvent event = debugEventArray[n2];
                    if (event.getSource() == process && event.getKind() == 8) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        QVTOApplicationConfiguration.this.onTerminate();
                    }
                    ++n2;
                }
            }
        });
        if (process.isTerminated()) {
            this.onTerminate();
        }
    }

    private void onTerminate() {
        QVTODebugUtil.refreshInWorkspace(this.fModels);
        if (this.fTraceURI != null) {
            QVTODebugUtil.refreshInWorkspace(Collections.singletonList(this.fTraceURI));
        }
    }

    private void reset() {
        this.fPort = -1;
        this.fModels.clear();
        this.fTraceURI = null;
    }
}

