/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.launch;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.StreamsProxy;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchConfigurationDelegate;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugTarget;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugUtil;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOVirtualProcess;
import org.eclipse.m2m.qvt.oml.debug.core.app.DebugRunnerFactory;
import org.eclipse.m2m.qvt.oml.debug.core.app.DebugTransformationRunner;
import org.eclipse.m2m.qvt.oml.debug.core.launch.SourceModificationListener;
import org.eclipse.m2m.qvt.oml.debug.core.vm.DebuggableExecutorAdapter;
import org.eclipse.m2m.qvt.oml.debug.core.vm.QVTOVirtualMachine;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;

public class QVTODebugConfiguration
extends QvtLaunchConfigurationDelegate {
    public static final IStatus MODIFIED_SOURCE_STATUS = QVTODebugCore.createError("", 300, null);

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        StreamsProxy streamsProxy = new StreamsProxy();
        ExecutionContext context = QvtLaunchUtil.createContext((ILaunchConfiguration)configuration, (Log)new WriterLog(streamsProxy.getOutputWriter(), true), (IProgressMonitor)monitor);
        DebugTransformationRunner runner = this.createRunner(configuration);
        runner.setErrorLog(new PrintWriter(streamsProxy.getErrWriter(), true));
        Diagnostic initDiagnostic = runner.initialize();
        if (initDiagnostic.getSeverity() == 4) {
            throw new CoreException(BasicDiagnostic.toIStatus((Diagnostic)initDiagnostic));
        }
        if (QvtLaunchUtil.shouldGenerateTraceFile((ILaunchConfiguration)configuration) || QvtLaunchUtil.isIncrementalUpdate((ILaunchConfiguration)configuration)) {
            IStatus showTraceViewStatus = QVTODebugCore.createError("", 400, null);
            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(showTraceViewStatus);
            if (handler != null) {
                try {
                    handler.handleStatus(showTraceViewStatus, null);
                }
                catch (CoreException e) {
                    QVTODebugCore.log(e.getStatus());
                }
            }
        }
        DebuggableExecutorAdapter executable = runner.createDebuggableAdapter(context);
        QVTOVirtualMachine vm = new QVTOVirtualMachine(executable);
        QVTOVirtualProcess process = new QVTOVirtualProcess(launch, vm);
        process.setStreamsProxy((IStreamsProxy)streamsProxy);
        List<IFile> transformationWsFile = QVTODebugUtil.toFiles(runner.getTransformationURI());
        if (!transformationWsFile.isEmpty()) {
            this.addSourceModificationListener(transformationWsFile.get(0), (ITerminate)process);
        }
        QVTODebugTarget debugTarget = new QVTODebugTarget(process, vm);
        launch.addDebugTarget((IDebugTarget)debugTarget);
    }

    private DebugTransformationRunner createRunner(ILaunchConfiguration configuration) throws CoreException {
        String moduleUri;
        DebugRunnerFactory runnerFactory = new DebugRunnerFactory();
        runnerFactory.transformationURI = moduleUri = QvtLaunchUtil.getTransformationURI((ILaunchConfiguration)configuration);
        ArrayList<String> modelURIs = new ArrayList<String>();
        for (TargetUriData uriData : QvtLaunchUtil.getTargetUris((ILaunchConfiguration)configuration)) {
            modelURIs.add(uriData.getUriString());
        }
        runnerFactory.modelParamURI = modelURIs;
        runnerFactory.isSaveTrace = QvtLaunchUtil.shouldGenerateTraceFile((ILaunchConfiguration)configuration);
        runnerFactory.isIncrementalUpdate = QvtLaunchUtil.isIncrementalUpdate((ILaunchConfiguration)configuration);
        String traceFileURI = QvtLaunchUtil.getTraceFileURI((ILaunchConfiguration)configuration);
        if (traceFileURI != null && traceFileURI.trim().length() != 0) {
            runnerFactory.traceFileURI = traceFileURI;
        }
        try {
            return runnerFactory.createRunner();
        }
        catch (DiagnosticException e) {
            throw new CoreException(BasicDiagnostic.toIStatus((Diagnostic)e.getDiagnostic()));
        }
    }

    private void addSourceModificationListener(final IFile unitFile, final ITerminate terminate) {
        final SourceModificationListener listener = new SourceModificationListener(unitFile, terminate);
        unitFile.getProject().getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    if (event.getKind() == 8 && event.getSource().equals(terminate)) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        unitFile.getProject().getWorkspace().removeResourceChangeListener((IResourceChangeListener)listener);
                    }
                    ++i;
                }
            }
        });
    }
}

