/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.ui.editor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.io.FileUtil;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDocumentProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtEditor;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.tests.qvt.oml.TestProject;
import org.eclipse.m2m.tests.qvt.oml.util.SourceAnnotationReader;
import org.eclipse.m2m.tests.qvt.oml.util.TestUtil;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class AbstractTestQvtEditorSupport
extends TestCase {
    protected String fTestFolder;
    protected QvtEditor fEditor;
    protected IContainer fSrcContainer;
    protected TestProject fTestProject;
    protected Map<IFile, List<SourceAnnotationReader.AnnotationData>> fAnnotationMap;

    public AbstractTestQvtEditorSupport(String name) {
        super(name);
        this.fTestFolder = name;
    }

    protected static String getSourceContents(ITextEditor editor) {
        return editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get();
    }

    protected List<SourceAnnotationReader.AnnotationData> readSourceAnnotations(ITextEditor editor) {
        AbstractTestQvtEditorSupport.assertTrue((String)"QVT Editor instance expected", (boolean)(editor instanceof QvtEditor));
        QvtEditor qvtEditor = (QvtEditor)editor;
        IFile file = AbstractTestQvtEditorSupport.getSourceFile(qvtEditor);
        return this.fAnnotationMap.get(file);
    }

    protected static QvtDocumentProvider getQVTDocumentProvider(ITextEditor editor) {
        AbstractTestQvtEditorSupport.assertTrue((String)"QVT Editor instance expected", (boolean)(editor instanceof QvtEditor));
        AbstractTestQvtEditorSupport.assertTrue((String)"Requires QVT document provider", (boolean)(editor.getDocumentProvider() instanceof QvtDocumentProvider));
        return (QvtDocumentProvider)editor.getDocumentProvider();
    }

    protected static QvtEditor openInEditor(IFile transformationFile) {
        QvtEditor editor = null;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            QvtEditor textEditor = (QvtEditor)IDE.openEditor((IWorkbenchPage)page, (IFile)transformationFile);
            AbstractTestQvtEditorSupport.assertTrue((String)"QVT Editor instance expected", (boolean)(textEditor instanceof QvtEditor));
            editor = textEditor;
            int WAIT_FOR_RECONCILE = 15000;
            editor.forceReconciling();
            CompiledUnit compiledModule = editor.getValidCompiledModule(15000L);
            AbstractTestQvtEditorSupport.assertNotNull((String)"Failed to aquire AST model in QVT Editor", (Object)compiledModule);
        }
        catch (PartInitException e) {
            AbstractTestQvtEditorSupport.fail((String)("Failed to open QVTEditor. " + (Object)((Object)e)));
        }
        return editor;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Set enabledActivityIds = PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getEnabledActivityIds();
        HashSet<String> copyEnabledActivityIds = new HashSet<String>(enabledActivityIds);
        copyEnabledActivityIds.add("com.borland.qvto");
        PlatformUI.getWorkbench().getActivitySupport().setEnabledActivityIds(copyEnabledActivityIds);
        this.initializeProject();
        IFile sourceFile = (IFile)this.fSrcContainer.findMember(String.valueOf(this.fTestFolder) + ".qvto");
        AbstractTestQvtEditorSupport.assertNotNull((Object)sourceFile);
        this.fEditor = AbstractTestQvtEditorSupport.openInEditor(sourceFile);
        AbstractTestQvtEditorSupport.assertNotNull((Object)this.fEditor);
    }

    protected void initializeProject() throws Exception {
        this.fTestProject = new TestProject("Editor", new String[]{"org.eclipse.m2m.qvt.oml.project.QVTONature"});
        File srcFolder = TestUtil.getPluginRelativeFile((String)"org.eclipse.m2m.tests.qvt.oml", (String)("parserTestData/editor/" + this.fTestFolder));
        this.fSrcContainer = QVTOBuilderConfig.getConfig((IProject)this.fTestProject.getProject()).getSourceContainer();
        File destFolder = this.fSrcContainer.getLocation().toFile();
        FileUtil.copyFolder((File)srcFolder, (File)destFolder);
        this.fTestProject.getProject().refreshLocal(2, null);
        this.processSourceAnnotations(destFolder);
    }

    protected IEditorPart getActiveEditor() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        return page.getActiveEditor();
    }

    private void processSourceAnnotations(File dest) throws Exception {
        IResource[] members;
        this.fAnnotationMap = new HashMap<IFile, List<SourceAnnotationReader.AnnotationData>>();
        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(dest.toURI());
        IContainer c = containers[0];
        IResource[] iResourceArray = members = c.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 1 && "qvto".equals(resource.getFileExtension())) {
                IFile file = (IFile)resource;
                String contents = FileUtil.getStreamContents((InputStream)file.getContents(), (String)file.getCharset());
                SourceAnnotationReader annotationReader = new SourceAnnotationReader(contents);
                String newContents = annotationReader.getSource();
                ByteArrayInputStream is = new ByteArrayInputStream(newContents.getBytes(file.getCharset()));
                file.setContents((InputStream)is, true, false, null);
                this.fAnnotationMap.put(file, annotationReader.getAnnotations());
            }
            ++n2;
        }
    }

    static IFile getSourceFile(QvtEditor editor) {
        FileEditorInput editorInput = (FileEditorInput)editor.getEditorInput();
        return editorInput.getFile();
    }
}

