/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugElement;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugTarget;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOThread;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOVariable;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMLocation;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMStackFrame;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMVariable;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMStackFrameRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMStackFrameResponse;

public class QVTOStackFrame
extends QVTODebugElement
implements IStackFrame {
    private final QVTOThread fThread;
    private VMStackFrame fUnderlyingFrame;
    private boolean fDeferredExecution;

    public QVTOStackFrame(QVTOThread thread, VMStackFrame frame) {
        super(thread.getQVTODebugTarget());
        if (thread == null || frame == null) {
            throw new IllegalArgumentException();
        }
        this.fThread = thread;
        this.fUnderlyingFrame = frame;
    }

    protected void setLocation(VMStackFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("null frame");
        }
        this.fUnderlyingFrame = frame;
    }

    public void setDeferredExecution(boolean isDeferred) {
        this.fDeferredExecution = isDeferred;
    }

    public boolean isDeferredExecution() {
        return this.fDeferredExecution;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public boolean hasVariables() throws DebugException {
        return !this.fUnderlyingFrame.getVisibleVariables().isEmpty();
    }

    public IVariable[] getVariables() throws DebugException {
        ArrayList<QVTOVariable> result = new ArrayList<QVTOVariable>();
        Iterator<VMVariable> iterator = this.fUnderlyingFrame.getVisibleVariables().iterator();
        while (iterator.hasNext()) {
            VMVariable next;
            VMVariable vmVar = next = iterator.next();
            result.add(new QVTOVariable(this.getQVTODebugTarget(), vmVar, this.fUnderlyingFrame.id));
        }
        IVariable[] allVars = result.toArray(new IVariable[result.size()]);
        Arrays.sort(allVars, new Comparator<IVariable>(){

            @Override
            public int compare(IVariable var1, IVariable var2) {
                try {
                    return var1.getName().compareTo(var2.getName());
                }
                catch (DebugException e) {
                    QVTODebugCore.log(e);
                    return 0;
                }
            }
        });
        return allVars;
    }

    public URI getUnitURI() {
        return URI.createURI((String)this.getLocation().getURI());
    }

    public VMLocation getLocation() {
        return this.fUnderlyingFrame.getLocation();
    }

    public int getLineNumber() {
        return this.getLocation().getLineNum();
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        int line = this.getLineNumber();
        String fileName = this.getUnitURI().lastSegment();
        return line < -1 ? fileName : String.valueOf(fileName) + "(" + line + ")";
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public IValue evaluate(String expressionText) throws CoreException {
        return ((QVTODebugTarget)this.getQVTODebugTarget()).evaluate(expressionText, this.fUnderlyingFrame.id);
    }

    VMStackFrame requestStackFrame() throws DebugException {
        VMStackFrame frame = null;
        VMStackFrameRequest frameRequest = new VMStackFrameRequest(this.fUnderlyingFrame.id);
        VMResponse response = this.getQVTODebugTarget().sendRequest(frameRequest);
        if (response instanceof VMStackFrameResponse) {
            VMStackFrameResponse stackFrameResponse = (VMStackFrameResponse)response;
            this.fDeferredExecution = stackFrameResponse.isDeferredExecution;
            frame = stackFrameResponse.getFrame();
        }
        if (frame == null) {
            throw new DebugException(QVTODebugCore.createStatus(4, "VMStackFrame request failure"));
        }
        return frame;
    }
}

