/**
* Essential OCL Lexer
* <copyright>
*
* Copyright (c) 2005, 2010 IBM Corporation and others.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   IBM - Initial API and implementation
*   E.D.Willink - Lexer and Parser refactoring to support extensibility and flexible error handling
*   Borland - Bug 242880
*   E.D.Willink - Bug 292112, 295166
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - LPG v 2.0.17 adoption (242153)
*   Adolfo Sanchez-Barbudo Herrera (Open Canarias) - Introducing new LPG templates (299396)
*
* </copyright>
*
* $Id: EssentialOCLLexer.gi,v 1.5 2010/02/11 15:40:41 sboyko Exp $
*/
/**
* <copyright>
*
* Copyright (c) 2006-2008 Borland Inc.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   Borland - Initial API and implementation
*
* </copyright>
*
*/
/**
* <copyright>
*
* Copyright (c) 2006-2008 Borland Inc.
* All rights reserved.   This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
*
* Contributors:
*   Borland - Initial API and implementation
*
* </copyright>
*
*/

package org.eclipse.m2m.internal.qvt.oml.cst.parser;

public class QVTOLexerprs implements lpg.runtime.ParseTable, QVTOLexersym {
    public final static int ERROR_SYMBOL = 0;
    public final int getErrorSymbol() { return ERROR_SYMBOL; }

    public final static int SCOPE_UBOUND = 0;
    public final int getScopeUbound() { return SCOPE_UBOUND; }

    public final static int SCOPE_SIZE = 0;
    public final int getScopeSize() { return SCOPE_SIZE; }

    public final static int MAX_NAME_LENGTH = 0;
    public final int getMaxNameLength() { return MAX_NAME_LENGTH; }

    public final static int NUM_STATES = 49;
    public final int getNumStates() { return NUM_STATES; }

    public final static int NT_OFFSET = 103;
    public final int getNtOffset() { return NT_OFFSET; }

    public final static int LA_STATE_OFFSET = 754;
    public final int getLaStateOffset() { return LA_STATE_OFFSET; }

    public final static int MAX_LA = 2;
    public final int getMaxLa() { return MAX_LA; }

    public final static int NUM_RULES = 284;
    public final int getNumRules() { return NUM_RULES; }

    public final static int NUM_NONTERMINALS = 36;
    public final int getNumNonterminals() { return NUM_NONTERMINALS; }

    public final static int NUM_SYMBOLS = 139;
    public final int getNumSymbols() { return NUM_SYMBOLS; }

    public final static int SEGMENT_SIZE = 8192;
    public final int getSegmentSize() { return SEGMENT_SIZE; }

    public final static int START_STATE = 285;
    public final int getStartState() { return START_STATE; }

    public final static int IDENTIFIER_SYMBOL = 0;
    public final int getIdentifier_SYMBOL() { return IDENTIFIER_SYMBOL; }

    public final static int EOFT_SYMBOL = 101;
    public final int getEoftSymbol() { return EOFT_SYMBOL; }

    public final static int EOLT_SYMBOL = 104;
    public final int getEoltSymbol() { return EOLT_SYMBOL; }

    public final static int ACCEPT_ACTION = 469;
    public final int getAcceptAction() { return ACCEPT_ACTION; }

    public final static int ERROR_ACTION = 470;
    public final int getErrorAction() { return ERROR_ACTION; }

    public final static boolean BACKTRACK = false;
    public final boolean getBacktrack() { return BACKTRACK; }

    public final int getStartSymbol() { return lhs(0); }
    public final boolean isValidForParser() { return QVTOLexersym.isValidForParser; }


    public interface IsNullable {
        public final static byte isNullable[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,1,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,1,0,
            0,0,0,0,0,0,0,1,0
        };
    };
    public final static byte isNullable[] = IsNullable.isNullable;
    public final boolean isNullable(int index) { return isNullable[index] != 0; }

    public interface ProsthesesIndex {
        public final static byte prosthesesIndex[] = {0,
            18,21,22,23,26,31,13,28,33,4,
            20,35,6,7,15,16,19,25,27,32,
            2,3,5,8,9,10,11,12,14,17,
            24,29,30,34,36,1
        };
    };
    public final static byte prosthesesIndex[] = ProsthesesIndex.prosthesesIndex;
    public final int prosthesesIndex(int index) { return prosthesesIndex[index]; }

    public interface IsKeyword {
        public final static byte isKeyword[] = {0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,0,0
        };
    };
    public final static byte isKeyword[] = IsKeyword.isKeyword;
    public final boolean isKeyword(int index) { return isKeyword[index] != 0; }

    public interface BaseCheck {
        public final static byte baseCheck[] = {0,
            1,4,3,3,3,1,2,2,1,1,
            5,1,1,1,1,1,1,1,1,1,
            1,2,2,2,1,1,1,1,2,1,
            1,1,2,1,1,1,1,2,1,1,
            2,2,3,2,2,0,1,2,2,2,
            1,2,3,2,3,3,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            2,1,2,2,2,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            2,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,1,1,
            1,1,1,1,1,1,1,1,2,1,
            2,0,1,2,2,1,3,1,1,1,
            1,1,1,1,3,0,1,2,2,2,
            3,1,2,1
        };
    };
    public final static byte baseCheck[] = BaseCheck.baseCheck;
    public final int baseCheck(int index) { return baseCheck[index]; }
    public final static byte rhs[] = baseCheck;
    public final int rhs(int index) { return rhs[index]; };

    public interface BaseAction {
        public final static char baseAction[] = {
            21,21,21,21,21,21,21,21,21,21,
            21,21,21,21,21,21,21,21,21,21,
            21,21,21,21,21,21,21,21,21,21,
            21,21,21,21,21,21,13,21,14,23,
            24,24,24,26,26,26,26,27,27,25,
            25,7,7,29,15,15,15,11,11,11,
            11,11,2,2,2,2,3,3,3,3,
            3,3,3,3,3,3,3,3,3,3,
            3,3,3,3,3,3,3,3,3,3,
            3,3,4,4,4,4,4,4,4,4,
            4,4,4,4,4,4,4,4,4,4,
            4,4,4,4,4,4,4,4,1,1,
            1,1,1,1,1,1,1,1,17,17,
            28,28,22,22,22,22,31,31,31,31,
            31,31,31,31,31,31,31,31,31,31,
            31,31,31,31,31,31,31,31,31,31,
            31,31,31,31,31,31,18,18,18,18,
            18,18,18,18,18,18,18,18,18,18,
            18,18,18,18,18,18,18,18,18,18,
            18,18,18,18,18,5,5,5,5,5,
            5,5,5,5,5,5,5,5,5,5,
            5,5,5,5,5,5,5,5,5,5,
            5,5,5,19,19,8,8,32,32,32,
            32,6,16,16,16,16,30,30,30,30,
            30,30,30,30,33,33,33,33,20,20,
            20,20,20,9,9,9,9,9,34,34,
            12,12,10,10,21,21,21,21,21,9,
            9,9,20,20,20,21,35,35,25,21,
            21,21,21,21,21,907,464,463,463,463,
            1097,293,422,1147,52,901,465,293,35,37,
            807,231,231,231,231,231,295,430,435,9,
            425,1158,52,347,436,307,466,466,466,466,
            466,466,607,261,261,261,261,261,261,1207,
            261,261,231,231,466,466,407,467,467,467,
            467,467,467,1206,467,467,458,1169,322,390,
            452,407,467,467,467,467,467,467,131,467,
            467,459,296,322,407,467,467,467,467,467,
            467,1204,467,467,460,1205,322,707,467,467,
            467,467,467,467,1210,467,467,462,397,322,
            507,259,259,259,259,259,259,1,45,45,
            45,45,1212,102,43,43,43,43,45,259,
            259,1114,311,45,43,45,1171,52,311,43,
            1005,43,1082,52,403,203,50,50,50,50,
            1010,134,133,133,133,1211,990,42,1006,290,
            1125,416,1208,1136,445,1182,52,416,7,8,
            445,41,1213,290,1214,50,50,1222,1008,1226,
            1227,1228,1229,1230,1231,1232,1233,1209,470,470
        };
    };
    public final static char baseAction[] = BaseAction.baseAction;
    public final int baseAction(int index) { return baseAction[index]; }
    public final static char lhs[] = baseAction;
    public final int lhs(int index) { return lhs[index]; };

    public interface TermCheck {
        public final static byte termCheck[] = {0,
            0,1,2,3,4,5,6,7,8,9,
            10,11,12,13,14,15,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,
            30,31,32,33,34,35,36,37,38,39,
            40,41,42,43,44,45,46,47,48,49,
            50,51,52,53,54,55,56,57,58,59,
            60,61,62,63,64,65,66,67,68,69,
            70,71,72,73,74,75,76,77,78,79,
            80,81,82,83,84,85,86,87,88,89,
            90,91,92,93,94,95,96,97,98,99,
            100,0,1,2,3,4,5,6,7,8,
            9,10,11,12,13,14,15,16,17,18,
            19,20,21,22,23,24,25,26,27,28,
            29,30,31,32,33,34,35,36,37,38,
            39,40,41,42,43,44,45,46,47,48,
            49,50,51,52,53,54,55,56,57,58,
            59,60,61,62,63,64,65,66,67,68,
            69,70,71,72,73,74,75,76,77,78,
            79,80,81,82,83,84,85,86,87,88,
            89,90,91,92,93,94,95,96,97,98,
            99,100,0,1,2,3,4,5,6,7,
            8,9,10,11,12,13,14,15,16,17,
            18,19,20,21,22,23,24,25,26,27,
            28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,
            48,49,50,51,52,53,54,55,56,57,
            58,59,60,61,62,63,64,65,66,67,
            68,69,70,71,72,73,74,75,76,77,
            78,79,80,81,82,83,84,85,86,87,
            88,89,90,91,92,0,0,95,96,97,
            98,99,100,0,0,103,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,0,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,93,
            94,95,96,97,98,99,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,0,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,93,
            94,95,96,97,98,99,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,0,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,93,
            94,95,96,97,98,99,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,0,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,93,
            94,95,96,97,98,99,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,0,71,72,73,
            74,75,76,77,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,93,
            94,95,96,97,98,99,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,0,77,78,79,80,81,82,83,
            84,85,86,87,88,89,90,91,92,0,
            0,95,96,97,98,99,0,1,2,3,
            4,5,6,7,8,9,10,11,12,13,
            14,15,16,17,18,19,20,21,22,23,
            24,25,26,27,28,29,30,31,32,33,
            34,35,36,37,38,39,40,41,42,43,
            44,45,46,47,48,49,50,51,52,53,
            54,55,56,57,58,59,60,61,62,63,
            64,65,66,67,68,69,70,71,72,73,
            74,75,76,77,78,79,80,81,82,0,
            84,85,86,87,88,89,90,91,92,93,
            94,101,13,14,0,0,100,0,102,0,
            1,2,3,4,5,6,7,8,9,10,
            15,16,13,14,0,0,17,18,19,20,
            21,22,23,24,25,26,27,28,29,30,
            31,32,33,34,35,36,37,38,39,40,
            41,42,43,44,45,46,47,48,49,50,
            51,52,53,54,55,56,57,58,59,60,
            61,62,63,64,65,66,67,68,74,75,
            0,0,1,2,3,4,5,6,7,8,
            9,10,83,12,13,14,0,1,2,3,
            4,5,6,7,8,9,10,0,0,102,
            0,0,16,0,1,2,3,4,5,6,
            7,8,9,10,0,1,2,3,4,5,
            6,7,8,9,10,0,1,2,3,4,
            5,6,7,8,9,10,0,1,2,3,
            4,5,6,7,8,9,10,0,1,2,
            3,4,5,6,7,8,9,10,0,73,
            0,1,2,3,4,5,6,7,8,9,
            10,0,1,2,3,4,5,6,7,8,
            9,10,0,1,2,3,4,5,6,7,
            8,9,10,0,0,0,0,0,0,0,
            0,0,0,0,11,11,11,11,15,15,
            11,0,12,12,11,0,0,0,0,0,
            0,0,0,12,0,0,0,69,0,12,
            0,0,0,0,76,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,
            0,93,94,0,0,0,0,0,100,0,
            0,0,0,0,0,72,71,70,70,0,
            0,0,0,0,0,0,0,0,0,77,
            0,0,0,0,0,0,70,0,70,0,
            0,0,0,0,0,0,0,0,101,77,
            102,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,102,0,0,
            101,101,101,0,0,0
        };
    };
    public final static byte termCheck[] = TermCheck.termCheck;
    public final int termCheck(int index) { return termCheck[index]; }

    public interface TermAction {
        public final static char termAction[] = {0,
            470,515,515,515,515,515,515,515,515,515,
            515,515,515,515,515,515,515,515,515,515,
            515,515,515,515,515,515,515,515,515,515,
            515,515,515,515,515,515,515,515,515,515,
            515,515,515,515,515,515,515,515,515,515,
            515,515,515,515,515,515,515,515,515,515,
            515,515,515,515,515,515,515,515,515,515,
            515,515,515,515,514,403,515,515,515,515,
            515,515,515,515,515,515,515,515,515,515,
            515,515,515,515,515,515,515,515,515,515,
            515,470,513,513,513,513,513,513,513,513,
            513,513,513,513,513,513,513,513,513,513,
            513,513,513,513,513,513,513,513,513,513,
            513,513,513,513,513,513,513,513,513,513,
            513,513,513,513,513,513,513,513,513,513,
            513,513,513,513,513,513,513,513,513,513,
            513,513,513,513,513,513,513,513,513,513,
            513,513,513,513,513,481,518,513,513,513,
            513,513,513,513,513,513,513,513,513,513,
            513,513,513,513,513,513,513,513,513,513,
            513,513,10,520,520,520,520,520,520,520,
            520,520,520,520,520,520,520,520,520,520,
            520,520,520,520,520,520,520,520,520,520,
            520,520,520,520,520,520,520,520,520,520,
            520,520,520,520,520,520,520,520,520,520,
            520,520,520,520,520,520,520,520,520,520,
            520,520,520,520,520,520,520,520,520,520,
            520,520,520,520,520,520,520,520,520,520,
            520,520,520,520,520,520,520,520,520,520,
            520,520,520,520,520,46,470,520,520,520,
            520,520,520,470,470,520,276,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,470,466,466,466,466,466,466,
            466,466,466,466,466,466,466,466,466,466,
            466,466,466,466,466,300,262,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,470,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,300,277,729,729,729,
            729,729,729,729,729,729,729,729,729,729,
            729,729,729,729,729,729,729,729,729,729,
            729,729,729,729,729,729,729,729,729,729,
            729,729,729,729,729,729,729,729,729,729,
            729,729,729,729,729,729,729,729,729,729,
            729,729,729,729,729,729,729,729,729,729,
            729,729,729,729,729,729,729,729,729,729,
            729,729,729,470,729,729,729,729,729,729,
            729,729,729,729,729,729,729,729,729,729,
            729,729,729,729,729,300,263,731,731,731,
            731,731,731,731,731,731,731,731,731,731,
            731,731,731,731,731,731,731,731,731,731,
            731,731,731,731,731,731,731,731,731,731,
            731,731,731,731,731,731,731,731,731,731,
            731,731,731,731,731,731,731,731,731,731,
            731,731,731,731,731,731,731,731,731,731,
            731,731,731,731,731,731,470,731,731,731,
            731,731,731,731,731,731,731,731,731,731,
            731,731,731,731,731,731,731,731,731,731,
            731,731,731,731,731,300,262,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,470,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,467,467,467,467,467,
            467,467,467,467,467,300,470,701,701,701,
            701,701,701,701,701,701,701,701,701,701,
            701,701,701,701,701,701,701,701,701,701,
            701,701,701,701,701,701,701,701,701,701,
            701,701,701,701,701,701,701,701,701,701,
            701,701,701,701,701,701,701,701,701,701,
            701,701,701,701,701,701,701,701,701,701,
            701,701,701,701,701,701,701,701,701,701,
            701,701,470,701,701,701,701,701,701,701,
            701,701,701,701,701,701,701,701,701,470,
            470,701,701,701,701,701,470,464,464,464,
            464,464,464,464,464,464,464,491,402,463,
            463,375,438,463,463,463,463,463,463,463,
            463,463,463,463,463,463,463,463,463,463,
            463,463,463,463,463,463,463,463,442,463,
            463,463,463,463,463,463,463,463,463,463,
            463,463,463,463,463,463,463,463,463,463,
            463,463,463,463,463,465,364,343,371,384,
            420,485,465,315,500,329,754,336,752,9,
            504,497,498,495,496,738,501,487,488,465,
            465,469,290,290,16,14,465,470,351,1,
            604,604,604,604,604,604,604,604,604,604,
            499,519,603,603,470,470,603,603,603,603,
            603,603,603,603,603,603,603,603,603,603,
            603,603,603,603,603,603,603,603,603,603,
            603,603,603,603,603,603,603,603,603,603,
            603,603,603,603,603,603,603,603,603,603,
            603,603,603,603,603,603,603,603,748,362,
            470,39,522,522,522,522,522,522,522,522,
            522,522,605,1947,290,290,470,293,293,293,
            293,293,293,293,293,293,293,470,470,475,
            470,470,443,470,311,311,311,311,311,311,
            311,311,311,311,470,416,416,416,416,416,
            416,416,416,416,416,470,445,445,445,445,
            445,445,445,445,445,445,54,522,522,522,
            522,522,522,522,522,522,522,53,522,522,
            522,522,522,522,522,522,522,522,12,440,
            56,522,522,522,522,522,522,522,522,522,
            522,55,522,522,522,522,522,522,522,522,
            522,522,39,411,411,411,411,411,411,411,
            411,411,411,20,19,32,266,132,260,13,
            6,36,470,33,493,492,734,753,494,750,
            735,36,457,461,737,470,470,38,470,132,
            51,130,258,508,470,470,470,601,470,751,
            470,470,470,470,601,470,470,470,470,470,
            470,470,470,470,470,470,470,470,470,470,
            470,601,601,470,470,470,470,470,601,470,
            470,470,470,470,470,749,454,377,263,470,
            470,470,470,470,470,470,470,470,470,745,
            470,470,470,470,470,470,473,470,472,470,
            470,470,470,470,470,470,470,470,1,277,
            263,470,470,470,470,470,470,470,470,470,
            470,470,470,470,470,470,470,474,470,470,
            1,39,12
        };
    };
    public final static char termAction[] = TermAction.termAction;
    public final int termAction(int index) { return termAction[index]; }
    public final int asb(int index) { return 0; }
    public final int asr(int index) { return 0; }
    public final int nasb(int index) { return 0; }
    public final int nasr(int index) { return 0; }
    public final int terminalIndex(int index) { return 0; }
    public final int nonterminalIndex(int index) { return 0; }
    public final int scopePrefix(int index) { return 0;}
    public final int scopeSuffix(int index) { return 0;}
    public final int scopeLhs(int index) { return 0;}
    public final int scopeLa(int index) { return 0;}
    public final int scopeStateSet(int index) { return 0;}
    public final int scopeRhs(int index) { return 0;}
    public final int scopeState(int index) { return 0;}
    public final int inSymb(int index) { return 0;}
    public final String name(int index) { return null; }
    public final int originalState(int state) { return 0; }
    public final int asi(int state) { return 0; }
    public final int nasi(int state) { return 0; }
    public final int inSymbol(int state) { return 0; }

    /**
     * assert(! goto_default);
     */
    public final int ntAction(int state, int sym) {
        return baseAction[state + sym];
    }

    /**
     * assert(! shift_default);
     */
    public final int tAction(int state, int sym) {
        int i = baseAction[state],
            k = i + sym;
        return termAction[termCheck[k] == sym ? k : i];
    }
    public final int lookAhead(int la_state, int sym) {
        int k = la_state + sym;
        return termAction[termCheck[k] == sym ? k : la_state];
    }
}
