/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.ExecutionDiagnosticImpl;
import org.eclipse.m2m.internal.qvt.oml.Messages;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtMessage;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEvaluationResult;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompilerUtils;
import org.eclipse.m2m.internal.qvt.oml.compiler.QVTOCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.evaluator.InternalEvaluator;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelParameterHelper;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QVTEvaluationOptions;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtInterruptedExecutionException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtStackOverFlowError;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.m2m.qvt.oml.util.ISessionData;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.SendSignalAction;

public class InternalTransformationExecutor {
    private URI fURI;
    private EPackage.Registry fPackageRegistry;
    private CompiledUnit fCompiledUnit;
    private ResourceSet fCompilationRs;
    private ExecutionDiagnostic fLoadDiagnostic;
    private OperationalTransformation fTransformation;
    private QvtOperationalEnvFactory fEnvFactory;

    public InternalTransformationExecutor(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException("null transformation URI");
        }
        this.fURI = uri;
    }

    public InternalTransformationExecutor(URI uri, EPackage.Registry registry) {
        this(uri);
        if (registry == null) {
            throw new IllegalArgumentException("null package registry");
        }
        this.fPackageRegistry = registry;
    }

    public URI getURI() {
        return this.fURI;
    }

    public ResourceSet getResourceSet() {
        return this.fCompilationRs;
    }

    public Diagnostic loadTransformation(IProgressMonitor monitor) {
        try {
            if (this.fLoadDiagnostic == null) {
                this.doLoad(monitor);
            }
            ExecutionDiagnostic executionDiagnostic = this.fLoadDiagnostic;
            return executionDiagnostic;
        }
        finally {
            monitor.done();
        }
    }

    public CompiledUnit getUnit() {
        this.loadTransformation((IProgressMonitor)new NullProgressMonitor());
        return this.fCompiledUnit;
    }

    public ExecutionDiagnostic execute(ExecutionContext executionContext, ModelExtent ... modelParameters) {
        if (executionContext == null) {
            throw new IllegalArgumentException();
        }
        IProgressMonitor monitor = executionContext.getProgressMonitor();
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)("Execute " + this.getURI().toString()), (int)2);
            this.checkLegalModelParams(modelParameters);
            this.loadTransformation((IProgressMonitor)progress.newChild(1));
            if (!EmfUtilPlugin.isSuccess((Diagnostic)this.fLoadDiagnostic)) {
                ExecutionDiagnostic executionDiagnostic = this.fLoadDiagnostic;
                return executionDiagnostic;
            }
            ExecutionDiagnostic executionDiagnostic = this.doExecute(modelParameters, InternalTransformationExecutor.createInternalContext(executionContext, (IProgressMonitor)progress.newChild(1)));
            return executionDiagnostic;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private ExecutionDiagnostic doExecute(ModelExtent[] args, IContext context) {
        QvtOperationalEnvFactory factory = this.getEnvironmentFactory();
        QvtOperationalEvaluationEnv evaluationEnv = factory.createEvaluationEnvironment(context, null);
        ExecutionDiagnostic modelParamsDiagnostic = this.initArguments(evaluationEnv, this.fTransformation, args);
        if (!EmfUtilPlugin.isSuccess((Diagnostic)modelParamsDiagnostic)) {
            return modelParamsDiagnostic;
        }
        QvtOperationalFileEnv rootEnv = factory.createEnvironment(this.fCompiledUnit.getURI());
        EvaluationVisitor<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> evaluator = factory.createEvaluationVisitor(rootEnv, (EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject>)evaluationEnv, null);
        assert (evaluator instanceof InternalEvaluator) : "expecting InternalEvaluator implementation";
        InternalEvaluator rawEvaluator = (InternalEvaluator)evaluator;
        Object evalResult = rawEvaluator.execute(this.fTransformation);
        if (evalResult instanceof QvtEvaluationResult) {
            int extentIndex = 0;
            int i = 0;
            while (i < this.fTransformation.getModelParameter().size()) {
                ModelParameter p = (ModelParameter)this.fTransformation.getModelParameter().get(i);
                if (p.getKind() != DirectionKind.IN) {
                    ModelExtentContents extent = ((QvtEvaluationResult)evalResult).getModelExtents().get(extentIndex++);
                    args[i].setContents(extent.getAllRootElements());
                }
                ++i;
            }
        } else {
            List<Object> resultArgs = evaluationEnv.getOperationArgs();
            int i = 0;
            for (Object nextResultArg : resultArgs) {
                ModelInstance modelInstance = (ModelInstance)nextResultArg;
                ModelParameterExtent extent = modelInstance.getExtent();
                List<EObject> allRootElements = extent.getContents().getAllRootElements();
                try {
                    args[i++].setContents(allRootElements);
                }
                catch (UnsupportedOperationException e) {
                    return new ExecutionDiagnosticImpl(4, 140, NLS.bind(Messages.ReadOnlyExtentModificationError, i - 1));
                }
            }
        }
        Trace traces = evaluationEnv.getAdapter(InternalEvaluationEnv.class).getTraces();
        this.handleExecutionTraces(traces);
        return ExecutionDiagnostic.OK_INSTANCE;
    }

    protected void handleExecutionTraces(Trace traces) {
    }

    private void doLoad(IProgressMonitor monitor) {
        this.fLoadDiagnostic = ExecutionDiagnostic.OK_INSTANCE;
        UnitProxy unit = UnitResolverFactory.Registry.INSTANCE.getUnit(this.fURI);
        if (unit == null) {
            this.fLoadDiagnostic = new ExecutionDiagnosticImpl(4, 200, NLS.bind(Messages.UnitNotFoundError, this.fURI));
            return;
        }
        QVTOCompiler compiler = this.createCompiler();
        try {
            this.fCompiledUnit = compiler.compile(unit, null, BasicMonitor.toMonitor((IProgressMonitor)monitor));
            this.fCompilationRs = compiler.getResourceSet();
            this.fLoadDiagnostic = InternalTransformationExecutor.createCompilationDiagnostic(this.fCompiledUnit);
        }
        catch (MdaException e) {
            this.fLoadDiagnostic = new ExecutionDiagnosticImpl(4, 200, NLS.bind(Messages.FailedToCompileUnitError, this.fURI));
            ((DiagnosticChain)this.fLoadDiagnostic).merge(BasicDiagnostic.toDiagnostic((Throwable)e));
        }
        if (this.fCompiledUnit != null && EmfUtilPlugin.isSuccess((Diagnostic)this.fLoadDiagnostic)) {
            this.fTransformation = this.getTransformation();
            if (this.fTransformation == null) {
                this.fLoadDiagnostic = new ExecutionDiagnosticImpl(4, 200, NLS.bind(Messages.NotTransformationInUnitError, this.fURI));
                return;
            }
            ExecutionDiagnostic validForExecution = InternalTransformationExecutor.checkIsExecutable(this.fTransformation);
            if (!EmfUtilPlugin.isSuccess((Diagnostic)validForExecution)) {
                this.fLoadDiagnostic = validForExecution;
            }
        }
    }

    private ExecutionDiagnostic initArguments(QvtOperationalEvaluationEnv evalEnv, OperationalTransformation transformationModel, ModelExtent[] args) {
        EList<ModelParameter> modelParameters = transformationModel.getModelParameter();
        if (modelParameters.size() > args.length) {
            return new ExecutionDiagnosticImpl(4, 140, NLS.bind(Messages.InvalidModelParameterCountError, args.length, modelParameters.size()));
        }
        ExecutionDiagnostic result = ExecutionDiagnostic.OK_INSTANCE;
        ArrayList<ModelParameterExtent> extents = new ArrayList<ModelParameterExtent>(modelParameters.size());
        int argCount = 0;
        for (ModelParameter modelParam : modelParameters) {
            ModelExtent nextArg = args[argCount++];
            ModelParameterExtent nextExtent = modelParam.getKind() != DirectionKind.OUT ? new ModelParameterExtent(nextArg.getContents(), this.getResourceSet(), modelParam) : new ModelParameterExtent(this.getResourceSet());
            evalEnv.addModelExtent(nextExtent);
            extents.add(nextExtent);
        }
        List<ModelInstance> modelArgs = ModelParameterHelper.createModelArguments(transformationModel, extents);
        evalEnv.getOperationArgs().addAll(modelArgs);
        return result;
    }

    private static ExecutionDiagnostic checkIsExecutable(OperationalTransformation transformation) {
        if (transformation.isIsBlackbox()) {
            return ExecutionDiagnostic.OK_INSTANCE;
        }
        EList operations = transformation.getEOperations();
        for (EOperation oper : operations) {
            if (!(oper instanceof ImperativeOperation) || !"main".equals(oper.getName())) continue;
            return ExecutionDiagnostic.OK_INSTANCE;
        }
        return new ExecutionDiagnosticImpl(4, 130, NLS.bind(Messages.NoTransformationEntryPointError, transformation.getName()));
    }

    public OperationalTransformation getTransformation() {
        if (this.fCompiledUnit == null) {
            return null;
        }
        List<Module> allModules = this.fCompiledUnit.getModules();
        for (Module module : allModules) {
            if (!(module instanceof OperationalTransformation)) continue;
            return (OperationalTransformation)module;
        }
        return null;
    }

    public void setEnvironmentFactory(QvtOperationalEnvFactory factory) {
        this.fEnvFactory = factory;
    }

    protected QvtOperationalEnvFactory getEnvironmentFactory() {
        return this.fEnvFactory != null ? this.fEnvFactory : new QvtOperationalEnvFactory();
    }

    public void cleanup() {
        this.setEnvironmentFactory(null);
        if (this.fCompilationRs != null) {
            EmfUtil.cleanupResourceSet((ResourceSet)this.fCompilationRs);
        }
    }

    private static ExecutionDiagnostic createExecutionFailure(QvtRuntimeException qvtRuntimeException) {
        int code = 0;
        int severity = 4;
        String message = qvtRuntimeException.getLocalizedMessage();
        Object[] data = null;
        if (qvtRuntimeException instanceof QvtException) {
            code = ((QvtException)qvtRuntimeException).getExceptionType() == QvtOperationalStdLibrary.INSTANCE.getAssertionFailedClass() ? 100 : 120;
        } else if (qvtRuntimeException instanceof QvtInterruptedExecutionException) {
            code = 110;
            severity = 8;
        } else {
            code = 120;
            if (!(qvtRuntimeException instanceof QvtStackOverFlowError)) {
                Throwable cause = qvtRuntimeException.getCause();
                data = new Object[]{cause != null ? cause : qvtRuntimeException};
            } else {
                message = Messages.StackTraceOverFlowError;
            }
        }
        if (message == null) {
            message = NLS.bind(Messages.QVTRuntimeExceptionCaught, ((Object)((Object)qvtRuntimeException)).getClass().getName());
        }
        ExecutionDiagnosticImpl diagnostic = new ExecutionDiagnosticImpl(severity, code, message, data);
        diagnostic.setStackTrace(qvtRuntimeException.getQvtStackTrace());
        return diagnostic;
    }

    private void checkLegalModelParams(ModelExtent[] extents) throws IllegalArgumentException {
        if (extents == null) {
            throw new IllegalArgumentException("Null model parameters");
        }
        int i = 0;
        while (i < extents.length) {
            if (extents[i] == null) {
                throw new IllegalArgumentException("Null model parameter[" + i + "]");
            }
            ++i;
        }
    }

    private static ExecutionDiagnostic createCompilationDiagnostic(CompiledUnit compiledUnit) {
        List<QvtMessage> errors = compiledUnit.getErrors();
        if (errors.isEmpty()) {
            return ExecutionDiagnostic.OK_INSTANCE;
        }
        URI uri = compiledUnit.getURI();
        ExecutionDiagnosticImpl mainDiagnostic = new ExecutionDiagnosticImpl(4, 130, NLS.bind(Messages.CompilationErrorsFoundInUnit, uri.toString()));
        for (QvtMessage message : errors) {
            mainDiagnostic.add(CompilerUtils.createProblemDiagnostic(uri, message));
        }
        return mainDiagnostic;
    }

    private static IContext createInternalContext(ExecutionContext executionContext, IProgressMonitor monitor) {
        Context ctx = new Context();
        ctx.setLog(executionContext.getLog());
        ctx.setProgressMonitor(monitor);
        for (String string : executionContext.getConfigPropertyNames()) {
            Object value = executionContext.getConfigProperty(string);
            ctx.setConfigProperty(string, value);
        }
        for (ISessionData.Entry entry : executionContext.getSessionDataEntries()) {
            ctx.getSessionData().setValue(entry, executionContext.getSessionData().getValue(entry));
        }
        org.eclipse.m2m.qvt.oml.util.Trace trace = executionContext.getSessionData().getValue(QVTEvaluationOptions.INCREMENTAL_UPDATE_TRACE);
        if (trace != null) {
            ctx.getTrace().setTraceContent(trace.getTraceContent());
        }
        return ctx;
    }

    public String toString() {
        return "QVTO-Executor: " + this.fURI;
    }

    protected QVTOCompiler createCompiler() {
        if (this.fPackageRegistry == null) {
            return CompilerUtils.createCompiler();
        }
        return QVTOCompiler.createCompiler(this.fPackageRegistry);
    }

    public static class TracesAwareExecutor
    extends InternalTransformationExecutor {
        private Trace fTraces;

        public TracesAwareExecutor(URI uri, EPackage.Registry registry) {
            super(uri, registry);
        }

        public TracesAwareExecutor(URI uri) {
            super(uri);
        }

        public Trace getTraces() {
            return this.fTraces;
        }

        protected void handleExecutionTraces(Trace traces) {
            super.handleExecutionTraces(traces);
            this.fTraces = traces;
        }

        public void cleanup() {
            super.cleanup();
            this.fTraces = null;
        }
    }
}

