/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io.eclipse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleModuleRegistry {
    private final Set<IPath> filePaths;
    private final Set<IPath> folderPaths;
    private final Set<IPath> defaultFolderItems;
    private final String bundleID;

    public BundleModuleRegistry(String bundleSymbolicName, Collection<IPath> paths) {
        if (bundleSymbolicName == null || bundleSymbolicName.length() == 0) {
            throw new IllegalArgumentException("Invalid bundle symbolic name");
        }
        for (IPath nextPath : paths) {
            if (nextPath != null && !nextPath.isEmpty() && nextPath.isValidPath(nextPath.toString())) continue;
            throw new IllegalArgumentException("Invalid resource path:" + nextPath);
        }
        this.bundleID = bundleSymbolicName;
        this.defaultFolderItems = new HashSet<IPath>();
        this.filePaths = new HashSet<IPath>();
        this.folderPaths = new HashSet<IPath>();
        for (IPath filePath : paths) {
            if (filePath.segmentCount() > 1) {
                BundleModuleRegistry.extractFolderPaths(this.folderPaths, filePath);
                this.filePaths.add(filePath);
                continue;
            }
            this.defaultFolderItems.add(filePath);
        }
    }

    public String getBundleSymbolicName() {
        return this.bundleID;
    }

    public boolean fileExists(IPath filePath) {
        return this.defaultFolderItems.contains(filePath) || this.filePaths.contains(filePath);
    }

    public Collection<IPath> getChildFiles(IPath parentPath) {
        ArrayList<IPath> children = new ArrayList<IPath>();
        for (IPath file : this.filePaths) {
            if (!parentPath.isPrefixOf(file) || file.segmentCount() - 1 != parentPath.segmentCount()) continue;
            children.add(file);
        }
        return children;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " : ID = " + this.bundleID;
    }

    private static void extractFolderPaths(Set<IPath> paths, IPath filePath) {
        if (filePath.segmentCount() == 1) {
            return;
        }
        IPath parent = filePath.removeLastSegments(1);
        paths.add(parent);
        BundleModuleRegistry.extractFolderPaths(paths, parent);
    }
}

