/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.ui.completion;

import java.util.LinkedHashSet;
import java.util.Set;
import junit.framework.TestCase;

public abstract class AbstractCompletionTest
extends TestCase {
    protected AbstractCompletionTest(String name) {
        super(name);
    }

    protected void runTest() throws Throwable {
        this.testCompletion();
    }

    public void testCompletion() throws Exception {
        Set<String> actualProposals = this.getActualProposalStrings();
        LinkedHashSet<String> actualProposalsTemp = new LinkedHashSet<String>(actualProposals);
        Set<String> expectedProposals = this.getExpectedProposalStrings();
        LinkedHashSet<String> expectedProposalsTemp = new LinkedHashSet<String>(expectedProposals);
        if (this.isStrict()) {
            actualProposalsTemp.removeAll(expectedProposals);
        } else {
            actualProposalsTemp.clear();
        }
        expectedProposalsTemp.removeAll(actualProposals);
        if (!actualProposalsTemp.isEmpty() || !expectedProposalsTemp.isEmpty()) {
            StringBuilder errors = new StringBuilder();
            for (String proposal : expectedProposalsTemp) {
                errors.append("Expected proposal not found: " + proposal + "\n");
            }
            if (this.isStrict()) {
                for (String proposal : actualProposalsTemp) {
                    errors.append("Unexpected proposal found: " + proposal + "\n");
                }
            }
            AbstractCompletionTest.assertTrue((String)errors.toString(), (boolean)false);
        }
    }

    protected abstract Set<String> getActualProposalStrings();

    protected abstract Set<String> getExpectedProposalStrings();

    protected abstract boolean isStrict();
}

