/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.keywordhandler.scopedvariablesextraction;

import lpg.runtime.IToken;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.LightweightParserUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.keywordhandler.scopedvariablesextraction.Result;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.keywordhandler.scopedvariablesextraction.Scope;

public class ScopedVariablesExtractor {
    private static final int NOT_A_TOKEN = -1;

    public String extractVariables(IToken startToken, QvtCompletionData data) {
        Scope scope = new Scope(null);
        IToken currentToken = startToken;
        if (QvtCompletionData.isKindOf(data.getParentImperativeOperation(), 89)) {
            while ((currentToken = ScopedVariablesExtractor.getNextToken(currentToken, data)) != null) {
                if (QvtCompletionData.isKindOf(currentToken, 61)) break;
            }
        }
        if (currentToken != null) {
            while ((currentToken = ScopedVariablesExtractor.getNextToken(currentToken, data)) != null) {
                Result innerScopeResult = null;
                if (QvtCompletionData.isKindOf(currentToken, 133, 88)) {
                    if ((currentToken = LightweightParserUtil.getNextToken(currentToken)) == null) break;
                    if (QvtCompletionData.isKindOf(currentToken, 61)) {
                        innerScopeResult = this.analyseScopedVarVariables(currentToken, data, scope, true);
                    }
                } else {
                    innerScopeResult = this.analyseVariableDeclaringExpressions(currentToken, data, scope);
                }
                if (innerScopeResult == null) continue;
                scope = innerScopeResult.getScope();
                currentToken = innerScopeResult.getEndToken();
            }
        }
        return scope.toString();
    }

    private Result analyseScopedVarVariables(IToken startToken, QvtCompletionData data, Scope scope, boolean isMandatoryScope) {
        IToken nextToken;
        IToken currentToken = startToken;
        Scope varScope = new Scope(scope);
        while ((nextToken = ScopedVariablesExtractor.getNextToken(currentToken, data)) != null) {
            if (QvtCompletionData.isKindOf(nextToken, 64)) {
                if (isMandatoryScope) {
                    return new Result(startToken, nextToken, null, varScope);
                }
                return new Result(startToken, nextToken, null, scope);
            }
            if (QvtCompletionData.isKindOf(nextToken, 49)) {
                if ((nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data)) == null) break;
                Result extractVarVariableResult = this.extractVariable(nextToken, null, data, varScope, new int[]{78}, -1, 51, 64);
                if (extractVarVariableResult.getScope() != varScope) {
                    return extractVarVariableResult;
                }
                nextToken = extractVarVariableResult.getEndToken();
                varScope.addVariable(extractVarVariableResult.getString());
            } else {
                Result innerScopeResult = this.analyseVariableDeclaringExpressions(nextToken, data, varScope);
                if (innerScopeResult != null) {
                    if (innerScopeResult.getScope() != varScope) {
                        return innerScopeResult;
                    }
                    nextToken = innerScopeResult.getEndToken();
                }
            }
            currentToken = nextToken;
        }
        return new Result(startToken, currentToken, null, varScope);
    }

    private Result analyseVariableDeclaringExpressions(IToken currentToken, QvtCompletionData data, Scope scope) {
        if (QvtCompletionData.isKindOf(currentToken, 40)) {
            return this.analyseLetExpression(currentToken, data, scope);
        }
        if (QvtCompletionData.isKindOf(currentToken, LightweightParserUtil.QVTO_ITERATOR_TERMINALS) || QvtCompletionData.isKindOf(currentToken, LightweightParserUtil.OCL_ITERATOR_TERMINALS) || QvtCompletionData.isKindOf(currentToken, "iterate")) {
            return this.analyseIteratorExpression(currentToken, data, scope);
        }
        if (QvtCompletionData.isKindOf(currentToken, LightweightParserUtil.RESOLVE_FAMILY_TERMINALS)) {
            return this.analyseResolveExpression(currentToken, data, scope);
        }
        if (QvtCompletionData.isKindOf(currentToken, 43)) {
            return this.analyseWhileExpression(currentToken, data, scope);
        }
        if (QvtCompletionData.isKindOf(currentToken, 38)) {
            return this.analyseSwitchExpression(currentToken, data, scope);
        }
        if (QvtCompletionData.isKindOf(currentToken, LightweightParserUtil.FOR_EXP_TERMINALS)) {
            return this.analyseForExpression(currentToken, data, scope);
        }
        if (QvtCompletionData.isKindOf(currentToken, 61)) {
            return this.analyseScopedVarVariables(currentToken, data, scope, false);
        }
        if (QvtCompletionData.isKindOf(currentToken, 42)) {
            return this.analyseComputeExpression(currentToken, data, scope);
        }
        return null;
    }

    private Result analyseWhileLikeBody(IToken startToken, IToken preParenToken, IToken lastKnownGoodToken, QvtCompletionData data, Scope whileLikeScope) {
        IToken nextToken = ScopedVariablesExtractor.getNextToken(preParenToken, data);
        if (nextToken != null) {
            lastKnownGoodToken = nextToken;
            if (!QvtCompletionData.isKindOf(nextToken, 4)) {
                return new Result(startToken, nextToken, null, whileLikeScope.getParent());
            }
            if ((nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data)) != null) {
                lastKnownGoodToken = nextToken;
                if (!QvtCompletionData.isKindOf(nextToken, 61)) {
                    return new Result(startToken, nextToken, null, whileLikeScope.getParent());
                }
                Result forBodyExpResult = this.analyseScopedVarVariables(nextToken, data, whileLikeScope, false);
                if (forBodyExpResult.getScope() != whileLikeScope) {
                    return forBodyExpResult;
                }
                return new Result(startToken, forBodyExpResult.getEndToken(), null, whileLikeScope.getParent());
            }
        }
        return new Result(startToken, lastKnownGoodToken, null, whileLikeScope);
    }

    private Result analyseComputeExpression(IToken startToken, QvtCompletionData data, Scope scope) {
        IToken nextToken = ScopedVariablesExtractor.getNextToken(startToken, data);
        if (nextToken == null) {
            return new Result(startToken, startToken, null, new Scope(null));
        }
        if (!QvtCompletionData.isKindOf(nextToken, 2)) {
            return null;
        }
        IToken currentToken = nextToken;
        if ((nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data)) == null) {
            return new Result(startToken, currentToken, null, new Scope(null));
        }
        Scope computeExpScope = new Scope(scope);
        Result extractVarVariableResult = this.extractVariable(nextToken, null, data, computeExpScope, new int[]{78, 62}, -1, 64);
        if (extractVarVariableResult.getScope() != computeExpScope) {
            return extractVarVariableResult;
        }
        computeExpScope.addVariable(extractVarVariableResult.getString());
        nextToken = extractVarVariableResult.getEndToken();
        return this.analyseWhileLikeBody(startToken, nextToken, nextToken, data, computeExpScope);
    }

    private Result analyseForExpression(IToken startToken, QvtCompletionData data, Scope scope) {
        IToken nextToken = ScopedVariablesExtractor.getNextToken(startToken, data);
        if (nextToken == null) {
            return new Result(startToken, startToken, null, new Scope(null));
        }
        if (!QvtCompletionData.isKindOf(nextToken, 2)) {
            return null;
        }
        Scope forExpScope = new Scope(scope);
        Result addVariableListResult = this.addVariableList(nextToken, startToken, data, forExpScope, new int[]{67, 4}, -1, 60, 67, 4);
        if (addVariableListResult.getScope() != forExpScope) {
            return addVariableListResult;
        }
        nextToken = addVariableListResult.getEndToken();
        if (QvtCompletionData.isKindOf(nextToken, 67)) {
            IToken currentToken = nextToken;
            if ((nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data)) == null) {
                return new Result(startToken, currentToken, null, forExpScope);
            }
            Result oclExpressionResult = this.extractOclExpression(nextToken, data, forExpScope);
            if (oclExpressionResult.getScope() != forExpScope) {
                return oclExpressionResult;
            }
            nextToken = oclExpressionResult.getEndToken();
        } else {
            nextToken = LightweightParserUtil.getPreviousToken(nextToken);
        }
        return this.analyseWhileLikeBody(startToken, nextToken, nextToken, data, forExpScope);
    }

    private Result analyseWhileExpression(IToken startToken, QvtCompletionData data, Scope scope) {
        Scope whileScope = new Scope(scope);
        IToken nextToken = ScopedVariablesExtractor.getNextToken(startToken, data);
        if (nextToken == null) {
            return new Result(startToken, startToken, null, new Scope(null));
        }
        if (!QvtCompletionData.isKindOf(nextToken, 2)) {
            return null;
        }
        if ((nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data)) == null) {
            return null;
        }
        if (!QvtCompletionData.isKindOf(nextToken, 3)) {
            return null;
        }
        Result variableResult = this.extractVariable(nextToken, null, data, whileScope, new int[]{62, 78}, -1, 51);
        if (variableResult == null) {
            return null;
        }
        if (variableResult.getScope() != whileScope) {
            return variableResult;
        }
        whileScope.addVariable(variableResult.getString());
        nextToken = variableResult.getEndToken();
        nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data);
        assert (QvtCompletionData.isKindOf(nextToken, 51));
        IToken lastKnownGoodToken = nextToken;
        if ((nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data)) != null) {
            Result whileConditionExpResult = this.extractOclExpression(nextToken, data, whileScope);
            if (whileConditionExpResult.getScope() != whileScope) {
                return whileConditionExpResult;
            }
            lastKnownGoodToken = nextToken = whileConditionExpResult.getEndToken();
            return this.analyseWhileLikeBody(startToken, nextToken, lastKnownGoodToken, data, whileScope);
        }
        return new Result(startToken, lastKnownGoodToken, null, whileScope);
    }

    private Result analyseSwitchExpression(IToken startToken, QvtCompletionData data, Scope scope) {
        Scope switchScope = new Scope(scope);
        IToken nextToken = ScopedVariablesExtractor.getNextToken(startToken, data);
        if (nextToken == null) {
            return new Result(startToken, startToken, null, new Scope(null));
        }
        if (!QvtCompletionData.isKindOf(nextToken, 2)) {
            return null;
        }
        if ((nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data)) == null) {
            return null;
        }
        if (!QvtCompletionData.isKindOf(nextToken, 3)) {
            return null;
        }
        Result variableResult = this.extractVariable(nextToken, startToken, data, switchScope, new int[]{62, 78}, -1, 4);
        if (variableResult == null) {
            return null;
        }
        if (variableResult.getScope() != switchScope) {
            return variableResult;
        }
        switchScope.addVariable(variableResult.getString());
        nextToken = variableResult.getEndToken();
        nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data);
        assert (QvtCompletionData.isKindOf(nextToken, 4));
        IToken lastKnownGoodToken = nextToken;
        if ((nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data)) != null) {
            lastKnownGoodToken = nextToken;
            if (!QvtCompletionData.isKindOf(nextToken, 61)) {
                return new Result(startToken, nextToken, null, scope);
            }
            Result switchBodyExpResult = this.analyseScopedVarVariables(nextToken, data, switchScope, false);
            if (switchBodyExpResult.getScope() != switchScope) {
                return switchBodyExpResult;
            }
            return new Result(startToken, switchBodyExpResult.getEndToken(), null, scope);
        }
        return new Result(startToken, lastKnownGoodToken, null, switchScope);
    }

    private Result analyseLetExpression(IToken startToken, QvtCompletionData data, Scope scope) {
        return this.analyseLetLikeExpression(startToken, null, data, scope, new int[]{85}, -1, 60, 85);
    }

    private Result analyseIteratorExpression(IToken startToken, QvtCompletionData data, Scope scope) {
        IToken nextToken = ScopedVariablesExtractor.getNextToken(startToken, data);
        if (nextToken == null) {
            return new Result(startToken, startToken, null, new Scope(null));
        }
        if (!QvtCompletionData.isKindOf(nextToken, 2)) {
            return null;
        }
        Result letLikeExpressionResult = this.analyseLetLikeExpression(nextToken, startToken, data, scope, new int[]{67, 4}, -1, 60, 51, 67);
        if (letLikeExpressionResult.getScope() != scope) {
            return letLikeExpressionResult;
        }
        nextToken = ScopedVariablesExtractor.getNextToken(letLikeExpressionResult.getEndToken(), data);
        if (nextToken == null) {
            return new Result(startToken, letLikeExpressionResult.getEndToken(), null, new Scope(null));
        }
        if (!QvtCompletionData.isKindOf(nextToken, 4)) {
            return new Result(startToken, letLikeExpressionResult.getEndToken(), null, scope);
        }
        return new Result(startToken, nextToken, null, scope);
    }

    private Result analyseResolveExpression(IToken startToken, QvtCompletionData data, Scope scope) {
        IToken nextToken = ScopedVariablesExtractor.getNextToken(startToken, data);
        if (nextToken == null) {
            return new Result(startToken, startToken, null, new Scope(null));
        }
        if (!QvtCompletionData.isKindOf(nextToken, 2)) {
            return null;
        }
        if (QvtCompletionData.isKindOf(startToken, LightweightParserUtil.RESOLVEIN_FAMILY_TERMINALS)) {
            while ((nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data)) != null) {
                if (QvtCompletionData.isKindOf(nextToken, 60)) break;
                if (!QvtCompletionData.isKindOf(nextToken, 4)) continue;
                return new Result(startToken, nextToken, null, scope);
            }
        }
        if (nextToken == null) {
            return null;
        }
        Result letLikeExpressionResult = this.analyseLetLikeExpression(nextToken, null, data, scope, new int[]{67}, 4, 67);
        if (letLikeExpressionResult.getScope() != scope) {
            return letLikeExpressionResult;
        }
        nextToken = ScopedVariablesExtractor.getNextToken(letLikeExpressionResult.getEndToken(), data);
        if (nextToken == null) {
            return new Result(startToken, letLikeExpressionResult.getEndToken(), null, new Scope(scope));
        }
        if (!QvtCompletionData.isKindOf(nextToken, 4)) {
            return new Result(startToken, letLikeExpressionResult.getEndToken(), null, scope);
        }
        return new Result(startToken, nextToken, null, scope);
    }

    private Result addVariableList(IToken startToken, IToken iteratorExpressionStart, QvtCompletionData data, Scope updatedScope, int[] varDeclTerminators, int unexpectedTerminator, int ... delimiters) {
        IToken nextToken = startToken;
        IToken lastKnownGoodToken = startToken;
        do {
            if ((nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data)) == null) continue;
            Result variableResult = this.extractVariable(nextToken, iteratorExpressionStart, data, updatedScope, new int[]{62}, unexpectedTerminator, delimiters);
            if (variableResult == null) {
                IToken followToken = ScopedVariablesExtractor.getNextToken(nextToken, data);
                return new Result(startToken, followToken != null ? followToken : nextToken, null, updatedScope.getParent());
            }
            if (variableResult.getScope() != updatedScope) {
                return variableResult;
            }
            updatedScope.addVariable(variableResult.getString());
            lastKnownGoodToken = nextToken = variableResult.getEndToken();
            nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data);
        } while (nextToken != null && !QvtCompletionData.isKindOf(nextToken, varDeclTerminators) && QvtCompletionData.isKindOf(nextToken, delimiters));
        if (nextToken == null) {
            return new Result(startToken, nextToken, null, new Scope(updatedScope), lastKnownGoodToken);
        }
        return new Result(startToken, nextToken, null, updatedScope, lastKnownGoodToken);
    }

    private Result analyseLetLikeExpression(IToken startToken, IToken iteratorExpressionStart, QvtCompletionData data, Scope scope, int[] varDeclTerminators, int unexpectedTerminator, int ... delimiters) {
        Scope letLikeScope = new Scope(scope);
        Result addVariableListResult = this.addVariableList(startToken, iteratorExpressionStart, data, letLikeScope, varDeclTerminators, unexpectedTerminator, delimiters);
        if (addVariableListResult.getScope() != letLikeScope) {
            return addVariableListResult;
        }
        IToken nextToken = addVariableListResult.getEndToken();
        if (nextToken != null && QvtCompletionData.isKindOf(nextToken, varDeclTerminators) && (nextToken = ScopedVariablesExtractor.getNextToken(nextToken, data)) != null) {
            Result oclExpressionResult = this.extractOclExpression(nextToken, data, letLikeScope);
            if (oclExpressionResult.getScope() != letLikeScope) {
                return oclExpressionResult;
            }
            return new Result(startToken, oclExpressionResult.getEndToken(), null, scope);
        }
        return new Result(startToken, addVariableListResult.getLastKnownGoodToken(), null, letLikeScope);
    }

    private Result extractVariable(IToken startToken, IToken iteratorExpressionStart, QvtCompletionData data, Scope scope, int[] initializers, int unexpectedTerminator, int ... delimiters) {
        IToken nextToken;
        int parenCount = 0;
        boolean isTypeDefined = false;
        IToken currentToken = startToken;
        while ((nextToken = ScopedVariablesExtractor.getNextToken(currentToken, data)) != null) {
            if (QvtCompletionData.isKindOf(nextToken, unexpectedTerminator)) {
                return null;
            }
            if (QvtCompletionData.isKindOf(nextToken, 63)) {
                isTypeDefined = true;
            }
            if (QvtCompletionData.isKindOf(nextToken, delimiters)) {
                if (isTypeDefined) {
                    return new Result(startToken, currentToken, "var " + LightweightParserUtil.getText(startToken, currentToken) + ';', scope);
                }
                String deducedType = this.deduceImplicitCollectionElementType(iteratorExpressionStart, data);
                if (deducedType == null) {
                    return new Result(startToken, currentToken, "", scope);
                }
                String varText = "var " + LightweightParserUtil.getText(startToken, currentToken) + " := " + deducedType + ';';
                return new Result(startToken, currentToken, varText, scope);
            }
            if (QvtCompletionData.isKindOf(currentToken, initializers)) {
                isTypeDefined = true;
                Result oclExpressionResult = this.extractOclExpression(nextToken, data, scope);
                if (oclExpressionResult.getScope() != scope) {
                    return oclExpressionResult;
                }
                IToken previousToken = LightweightParserUtil.getPreviousToken(currentToken);
                String identifierAndOrType = previousToken != null && startToken.getTokenIndex() <= previousToken.getTokenIndex() ? LightweightParserUtil.getText(startToken, previousToken) : "";
                return new Result(startToken, oclExpressionResult.getEndToken(), "var " + identifierAndOrType + " := " + oclExpressionResult.getString() + ';', scope);
            }
            if (QvtCompletionData.isKindOf(nextToken, 2)) {
                ++parenCount;
            }
            if (QvtCompletionData.isKindOf(nextToken, 4) && --parenCount < 0) {
                return new Result(startToken, startToken, "", scope);
            }
            currentToken = nextToken;
        }
        return new Result(startToken, currentToken, null, new Scope(scope));
    }

    private String deduceImplicitCollectionElementType(IToken iteratorExpressionStart, QvtCompletionData data) {
        IToken[] oclExpressionCSTokens;
        if (iteratorExpressionStart == null) {
            return null;
        }
        IToken accessorToken = LightweightParserUtil.getPreviousToken(iteratorExpressionStart);
        if (accessorToken != null && QvtCompletionData.isKindOf(accessorToken, 66, 71) && (oclExpressionCSTokens = LightweightParserUtil.extractOclExpressionCSTokens(accessorToken, data)) != null) {
            String collectionType = LightweightParserUtil.getText(oclExpressionCSTokens);
            return String.valueOf(collectionType) + "->any(true)";
        }
        return null;
    }

    private Result extractOclExpression(IToken startToken, QvtCompletionData data, Scope scope) {
        IToken nextToken;
        IToken currentToken = startToken;
        int bracingMode = -1;
        int depth = 0;
        while ((nextToken = ScopedVariablesExtractor.getNextToken(currentToken, data)) != null) {
            Result innerScopeResult = this.analyseVariableDeclaringExpressions(currentToken, data, scope);
            if (innerScopeResult != null) {
                if (innerScopeResult.getScope() != scope) {
                    return innerScopeResult;
                }
                currentToken = innerScopeResult.getEndToken();
                nextToken = ScopedVariablesExtractor.getNextToken(currentToken, data);
                if (nextToken == null) {
                    return new Result(startToken, currentToken, null, new Scope(scope));
                }
            } else {
                int bracingPairKind = LightweightParserUtil.getBracingPairKind(currentToken, true);
                if (depth == 0) {
                    if (bracingPairKind >= 0) {
                        bracingMode = bracingPairKind;
                        ++depth;
                    }
                } else if (bracingPairKind == bracingMode) {
                    ++depth;
                } else if (bracingMode == LightweightParserUtil.getBracingPairKind(currentToken, false)) {
                    --depth;
                }
            }
            if (depth == 0 && QvtCompletionData.isKindOf(nextToken, LightweightParserUtil.OCLEXPRESSION_END_TOKENS)) {
                return new Result(startToken, currentToken, LightweightParserUtil.getText(startToken, currentToken), scope);
            }
            currentToken = nextToken;
        }
        return new Result(startToken, currentToken, null, new Scope(scope));
    }

    private static IToken getNextToken(IToken token, QvtCompletionData data) {
        if (token == null) {
            return null;
        }
        if (token == data.getLeftToken()) {
            return null;
        }
        IToken nextToken = LightweightParserUtil.getNextToken(token);
        if (nextToken == null) {
            return null;
        }
        return nextToken;
    }
}

