/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ocl.transformations;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractBlackboxProvider;
import org.eclipse.m2m.internal.qvt.oml.blackbox.AbstractCompilationUnitDescriptor;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxException;
import org.eclipse.m2m.internal.qvt.oml.blackbox.CompilationUnit;
import org.eclipse.m2m.internal.qvt.oml.blackbox.LoadContext;
import org.eclipse.m2m.internal.qvt.oml.blackbox.OperationMatcher;
import org.eclipse.m2m.internal.qvt.oml.blackbox.ResolutionContext;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.ocl.OclQvtoPlugin;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LegacyNativeLibSupport;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibrariesRegistry;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.Library;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.LibraryCreationException;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyNativeLibraryProviderAdapter
extends AbstractBlackboxProvider {
    private Map<String, AbstractCompilationUnitDescriptor> fDescriptorMap;
    private final Map<LibraryDescriptor, CompilationUnit> fBlackboxUnits = new LinkedHashMap<LibraryDescriptor, CompilationUnit>();

    public Collection<AbstractCompilationUnitDescriptor> getModuleDescriptors(ResolutionContext loadContext) {
        return this.getDescriptorMap().values();
    }

    public AbstractCompilationUnitDescriptor getModuleDescriptor(String qualifiedName, ResolutionContext resolutionContext) {
        return this.getDescriptorMap().get(qualifiedName);
    }

    public CompilationUnit loadCompilationUnit(AbstractCompilationUnitDescriptor descriptor, LoadContext loadContext) throws BlackboxException {
        if (!(descriptor instanceof LibraryDescriptor)) {
            throw new IllegalArgumentException("Descriptor not recognized by provider");
        }
        LibraryDescriptor libDescriptor = (LibraryDescriptor)descriptor;
        if (this.fBlackboxUnits.containsKey((Object)libDescriptor)) {
            return this.fBlackboxUnits.get((Object)libDescriptor);
        }
        try {
            CompilationUnit compilationUnit = this.createCompilationUnit(LegacyNativeLibSupport.INSTANCE.defineLibrary(libDescriptor.fLibrary, libDescriptor.fDefinedOperations));
            this.fBlackboxUnits.put(libDescriptor, compilationUnit);
            return compilationUnit;
        }
        catch (LibraryCreationException e) {
            this.fBlackboxUnits.put(libDescriptor, null);
            throw new BlackboxException(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, AbstractCompilationUnitDescriptor> getDescriptorMap() {
        if (this.fDescriptorMap != null) {
            return this.fDescriptorMap;
        }
        LibrariesRegistry registry = OclQvtoPlugin.getDefault().getLibrariesRegistry();
        this.fDescriptorMap = new LinkedHashMap<String, AbstractCompilationUnitDescriptor>(registry.getLibraries().size());
        for (Library lib : registry.getLibraries()) {
            this.fDescriptorMap.put(lib.getId(), new LibraryDescriptor(lib));
        }
        return this.fDescriptorMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LibraryDescriptor
    extends AbstractCompilationUnitDescriptor {
        private final Library fLibrary;
        private final Map<String, List<EOperation>> fDefinedOperations;

        protected LibraryDescriptor(Library library) {
            super((AbstractBlackboxProvider)LegacyNativeLibraryProviderAdapter.this, library.getId());
            this.fLibrary = library;
            this.fDefinedOperations = new LinkedHashMap<String, List<EOperation>>();
        }

        public String getDescription() {
            return this.fLibrary.getLibraryClassName();
        }

        public Collection<CallHandler> getBlackboxCallHandler(ImperativeOperation imperativeOp, QvtOperationalModuleEnv env) {
            Set importedLibs;
            if (!env.getImportedNativeLibs().isEmpty() && !(importedLibs = (Set)env.getImportedNativeLibs().get(this.getURI())).contains(this.fLibrary.getId())) {
                return Collections.emptyList();
            }
            List<EOperation> listOp = this.fDefinedOperations.get(imperativeOp.getName());
            if (listOp == null) {
                return Collections.emptyList();
            }
            List<CallHandler> result = Collections.emptyList();
            for (EOperation libraryOp : listOp) {
                if (!OperationMatcher.matchOperation((QvtOperationalEnv)env, (ImperativeOperation)imperativeOp, (EOperation)libraryOp)) continue;
                if (result.isEmpty()) {
                    result = new LinkedList<CallHandler>();
                }
                result.add(CallHandlerAdapter.getDispatcher((EOperation)libraryOp));
            }
            return result;
        }

        public Collection<CallHandler> getBlackboxCallHandler(OperationalTransformation operationalTrans, QvtOperationalModuleEnv env) {
            Set importedLibs;
            if (!env.getImportedNativeLibs().isEmpty() && !(importedLibs = (Set)env.getImportedNativeLibs().get(this.getURI())).contains(this.fLibrary.getId())) {
                return Collections.emptyList();
            }
            List<EOperation> listOp = this.fDefinedOperations.get(operationalTrans.getName());
            if (listOp == null) {
                return Collections.emptyList();
            }
            List<CallHandler> result = Collections.emptyList();
            for (EOperation libraryOp : listOp) {
                if (!OperationMatcher.matchOperation((QvtOperationalEnv)env, (OperationalTransformation)operationalTrans, (EOperation)libraryOp)) continue;
                if (result.isEmpty()) {
                    result = new LinkedList<CallHandler>();
                }
                result.add(CallHandlerAdapter.getDispatcher((EOperation)libraryOp));
            }
            return result;
        }
    }
}

