/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions;

import java.util.ArrayList;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.Messages;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.ui.tools.api.dialog.RenameDialog;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class RenameRepresentationAction
extends BaseSelectionListenerAction {
    public RenameRepresentationAction() {
        super("Rename");
        this.setActionDefinitionId("org.eclipse.ui.edit.rename");
        this.setAccelerator(RenameRepresentationAction.findKeyCode((String)"F2"));
    }

    public void run() {
        ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>();
        IStructuredSelection structuredSelection = this.getStructuredSelection();
        for (Object selectedObject : structuredSelection) {
            if (!(selectedObject instanceof DRepresentationDescriptor)) continue;
            DRepresentation representation = ((DRepresentationDescriptor)selectedObject).getRepresentation();
            representations.add(representation);
        }
        for (DRepresentation representation : representations) {
            String newName;
            final String oldName = representation.getName() != null ? representation.getName() : "";
            RenameDialog dialog = new RenameDialog(Display.getDefault().getActiveShell(), oldName){

                public int open() {
                    this.create();
                    return super.open();
                }

                public void create() {
                    super.create();
                    this.setTitle(Messages.RenameRepresentationAction_0);
                    this.setOldName(oldName);
                    this.getShell().setSize(this.getShell().computeSize(-1, -1));
                }
            };
            if (dialog.open() != 0 || oldName.equals(newName = dialog.getNewName())) continue;
            TransactionUtil.getEditingDomain((EObject)representation).getCommandStack().execute((Command)new RenameRepresentationCommand(representation, newName));
        }
    }

    private class RenameRepresentationCommand
    extends RecordingCommand {
        private String _name;
        private DRepresentation _representation;

        public RenameRepresentationCommand(DRepresentation representation_p, String name_p) {
            super(TransactionUtil.getEditingDomain((EObject)representation_p));
            this._name = name_p;
            this._representation = representation_p;
        }

        protected void doExecute() {
            this._representation.setName(this._name);
        }
    }
}

