/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.input;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.OpenSessionAction;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.Messages;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.EObjectLabelProviderHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.SessionHelper;
import org.eclipse.amalgam.explorer.activity.ui.internal.ActivityExplorerEditorInputFactory;
import org.eclipse.amalgam.explorer.activity.ui.internal.util.ActivityExplorerLoggerService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.part.FileEditorInput;

public class ActivityExplorerEditorInput
extends FileEditorInput
implements IEditorInput,
IPersistableElement {
    private static final String ACTIVITY_EXPLORER_FILE = "activityExplorerFile";
    @Deprecated
    private IStatus _status;

    public ActivityExplorerEditorInput(IFile file) {
        super(file);
        this.loadState(this.getFile());
    }

    @Deprecated
    public ActivityExplorerEditorInput(Session session, EObject eObject) {
        this(SessionHelper.getFirstAnalysisFile((DAnalysisSession)session));
    }

    public void dispose() {
    }

    public boolean exists() {
        Session session = this.getSession();
        return super.exists() && session != null && session.isOpen();
    }

    public Object getAdapter(Class adapter_p) {
        if (adapter_p == Session.class) {
            IPath path = this.getFile().getFullPath();
            URI uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
            Session session = SessionManager.INSTANCE.getExistingSession(uri);
            return session;
        }
        if (this._status != null && adapter_p == IStatus.class) {
            return this._status;
        }
        return super.getAdapter(adapter_p);
    }

    public String getFactoryId() {
        return ActivityExplorerEditorInputFactory.ID;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Deprecated
    public String getModelUiName() {
        String result = "";
        EObject project = this.getRootSemanticElement();
        if (project != null) {
            result = EObjectLabelProviderHelper.getText(project);
        } else if (this.getFile() != null) {
            String fileExtension = this.getFile().getFileExtension();
            String fileName = this.getFile().getName();
            result = fileName.substring(0, fileName.indexOf(fileExtension) - 1);
        }
        return result;
    }

    @Deprecated
    public EObject getRootSemanticElement() {
        EObject result = null;
        String path = null;
        try {
            IFile file = this.getFile();
            path = file.getFullPath().toString();
            String defaultCharset = null;
            defaultCharset = System.getProperty("file.encoding");
            defaultCharset = defaultCharset != null && defaultCharset.isEmpty() ? defaultCharset : "UTF-8";
            path = URLDecoder.decode(path, defaultCharset);
            URI uri = URI.createPlatformResourceURI((String)path, (boolean)true);
            Session session = SessionManager.INSTANCE.getExistingSession(uri);
            result = this.getRootSemanticElement(session);
        }
        catch (UnsupportedEncodingException e) {
            ActivityExplorerLoggerService.getInstance().log((IStatus)new Status(4, ActivityExplorerActivator.ID, "Could not find the resource " + path + ". See the error log for more details", (Throwable)e));
        }
        return result;
    }

    public String getName() {
        return this.getModelUiName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    @Deprecated
    public Session getSession() {
        return (Session)this.getAdapter(Session.class);
    }

    @Deprecated
    public IStatus getStatus() {
        return (IStatus)this.getAdapter(IStatus.class);
    }

    public String getToolTipText() {
        return this.getModelUiName();
    }

    private void loadState(IFile file) {
        try {
            Session session = SessionHelper.getSession(file);
            if (session == null) {
                OpenSessionAction openSessionAction = new OpenSessionAction();
                openSessionAction.setRunInProgressService(false);
                openSessionAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)file));
                openSessionAction.run();
                this._status = openSessionAction.getStatus();
                if (this._status == null) {
                    this._status = Status.OK_STATUS;
                }
                if (this._status.isOK()) {
                    session = SessionHelper.getSession(file);
                }
            }
            if (this.getRootSemanticElement() == null) {
                this._status = new Status(2, ActivityExplorerActivator.ID, Messages.ActivityExplorerEditor_1);
            }
        }
        catch (Exception e) {
            this._status = new Status(4, ActivityExplorerActivator.ID, e.getMessage(), (Throwable)e);
        }
    }

    public void saveState(IMemento memento_p) {
        memento_p.putString(ACTIVITY_EXPLORER_FILE, this.getFile().getFullPath().toString());
    }

    @Deprecated
    public EObject getRootSemanticElement(Session session_p) {
        return SessionHelper.getRootSemanticModel(session_p);
    }
}

