/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.sirius.ui.focus;

import java.util.Iterator;
import java.util.List;
import org.eclipse.amalgam.explorer.contextual.view.focus.IFocusInEditor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.api.part.IDiagramDialectGraphicalViewer;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class FocusInDiagramEditor
implements IFocusInEditor {
    private SiriusDiagramEditor _diagramEditor = null;
    private IDiagramGraphicalViewer _diagramGraphicalViewer;

    public boolean accept(IEditorPart activeEditor_p, ISelection selection_p) {
        boolean selectableElement;
        Object firstElement = ((IStructuredSelection)selection_p).getFirstElement();
        boolean bl = selectableElement = firstElement instanceof EObject && !(firstElement instanceof DRepresentation);
        return activeEditor_p instanceof DDiagramEditor && selectableElement;
    }

    public boolean focusInEditor(IEditorPart activeEditor_p, ISelection selection_p) {
        this.initdiagramEditor();
        Object firstElement = ((IStructuredSelection)selection_p).getFirstElement();
        DSemanticDecorator views = this.getView((EObject)firstElement);
        boolean result = true;
        result = views != null ? this.selectViewsInEditor(views) : false;
        this._diagramEditor = null;
        this._diagramGraphicalViewer = null;
        return result;
    }

    protected DSemanticDecorator getView(EObject semantic_p) {
        if (this._diagramEditor != null) {
            DSemanticDiagram diagram = (DSemanticDiagram)this._diagramEditor.getDiagram().getElement();
            EList representationElements = diagram.getRepresentationElements();
            for (DRepresentationElement dRepresentationElement : representationElements) {
                EObject target = dRepresentationElement.getTarget();
                if (!EcoreUtil.equals((EObject)target, (EObject)semantic_p)) continue;
                return dRepresentationElement;
            }
        }
        return null;
    }

    protected boolean selectViewsInEditor(DSemanticDecorator view_p) {
        if (view_p == null) {
            return false;
        }
        if (view_p instanceof DDiagramElement) {
            DDiagramElementQuery query = new DDiagramElementQuery((DDiagramElement)view_p);
            if (query.isFolded() || query.isHidden() || query.isCollapsed() || query.isFiltered()) {
                return false;
            }
            IGraphicalEditPart selectedPart = this.getGraphicalPart(view_p);
            if (selectedPart == null) {
                return false;
            }
            this._diagramGraphicalViewer.select((EditPart)selectedPart);
            this._diagramGraphicalViewer.reveal((EditPart)selectedPart);
            return true;
        }
        boolean cfr_ignored_0 = view_p instanceof DDiagram;
        return false;
    }

    protected IGraphicalEditPart getGraphicalPart(DSemanticDecorator view_p) {
        IGraphicalEditPart graphicalEditPart = null;
        if (this._diagramEditor != null && this._diagramGraphicalViewer instanceof IDiagramDialectGraphicalViewer) {
            IDiagramDialectGraphicalViewer dialectViewer = (IDiagramDialectGraphicalViewer)this._diagramGraphicalViewer;
            List editParts = dialectViewer.findEditPartsForElement(view_p.getTarget(), IGraphicalEditPart.class);
            Iterator iterator = editParts.iterator();
            while (iterator.hasNext()) {
                IGraphicalEditPart editPart = (IGraphicalEditPart)iterator.next();
                if (editPart.isSelectable()) continue;
                iterator.remove();
            }
            if (editParts.size() == 1) {
                graphicalEditPart = (IGraphicalEditPart)editParts.get(0);
            } else {
                for (IGraphicalEditPart currentGraphicalEditPart : editParts) {
                    if (currentGraphicalEditPart instanceof IDiagramEdgeEditPart) continue;
                    graphicalEditPart = currentGraphicalEditPart;
                    break;
                }
            }
        }
        return graphicalEditPart;
    }

    private void initdiagramEditor() {
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (activeEditor != null && activeEditor instanceof SiriusDiagramEditor) {
            this._diagramEditor = (SiriusDiagramEditor)activeEditor;
            this._diagramGraphicalViewer = this._diagramEditor.getDiagramGraphicalViewer();
        }
    }
}

