/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.viewers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.amalgam.explorer.activity.ui.api.actions.LocateInExplorerAction;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.activities.ExplorerActivity;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.BasicSessionActivityExplorerPage;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.Messages;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.SelectionHelper;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.viewers.AbstractActivityExplorerViewer;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.sections.ActivityExplorerSection;
import org.eclipse.amalgam.explorer.activity.ui.api.hyperlinkadapter.IRepresentationProvider;
import org.eclipse.amalgam.explorer.activity.ui.internal.util.ActivityExplorerLoggerService;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.CloneAction;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.DeleteRepresentationAction;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.MoveRepresentationAction;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.OpenRepresentationsAction;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.actions.RenameRepresentationAction;
import org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.providers.DiagramViewerContentProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointItem;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.SiriusCommonLabelProvider;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.forms.events.IHyperlinkListener;

public class DiagramViewer
extends AbstractActivityExplorerViewer {
    private static final String GROUP_MOVE = "Move";
    private MoveRepresentationAction moveDiagramAction;
    private OpenRepresentationsAction openRepresentation;
    private RenameRepresentationAction renameRepresentationAction;
    private BaseSelectionListenerAction showInModelExplorerAction;
    private CloneAction cloneAction;
    private DeleteRepresentationAction deleteRepresentationAction;

    public DiagramViewer(BasicSessionActivityExplorerPage page) {
        super(page);
    }

    @Override
    protected String getViewerSectionTitle() {
        return Messages.BasicSessionActivityExplorerPage_0;
    }

    @Override
    protected Object getInput() {
        return this.page.getEditorInput().getSession();
    }

    @Override
    protected ILabelProvider getLabelProvider() {
        return new SiriusCommonLabelProvider();
    }

    @Override
    protected IContentProvider getContentProvider() {
        return new DiagramViewerContentProvider(this.page.getHandledViewpoint());
    }

    @Override
    protected void addListenersOnViewer(TreeViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                OpenRepresentationsAction action = new OpenRepresentationsAction();
                action.selectionChanged(selection);
                action.run();
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        ISelectionProvider selectionProvider = this.page.getEditorSite().getSelectionProvider();
        if (this.renameRepresentationAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.renameRepresentationAction);
            this.renameRepresentationAction = null;
        }
        if (this.deleteRepresentationAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteRepresentationAction);
            this.deleteRepresentationAction = null;
        }
        if (this.openRepresentation != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.openRepresentation);
            this.openRepresentation = null;
        }
        if (this.moveDiagramAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.moveDiagramAction);
            this.moveDiagramAction.dispose();
            this.moveDiagramAction = null;
        }
        if (this.cloneAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.cloneAction);
            this.cloneAction = null;
        }
        if (this.showInModelExplorerAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.showInModelExplorerAction);
            this.showInModelExplorerAction = null;
        }
    }

    @Override
    protected MenuManager initMenuToViewer(final TreeViewer treeViewer) {
        MenuManager contextMenuManager = super.initMenuToViewer(treeViewer);
        contextMenuManager.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToHide(IMenuManager manager) {
                manager.remove("MoveDiagrams.Menu.ID");
                DiagramViewer.this.moveDiagramAction.dispose();
            }

            public void menuAboutToShow(IMenuManager manager) {
                manager.appendToGroup(DiagramViewer.GROUP_MOVE, (IContributionItem)DiagramViewer.this.moveDiagramAction.fillContextMenu((IStructuredSelection)treeViewer.getSelection()));
            }
        });
        return contextMenuManager;
    }

    @Override
    protected void declareViewerActions(MenuManager contextMenuManager, TreeViewer treeViewer) {
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ISelectionProvider selectionProvider = this.page.getEditorSite().getSelectionProvider();
        this.showInModelExplorerAction = new BaseSelectionListenerAction(Messages.BasicSessionActivityExplorerPage_1){

            public void run() {
                LocateInExplorerAction callback = new LocateInExplorerAction();
                callback.setSite((IWorkbenchPartSite)DiagramViewer.this.page.getEditorSite());
                callback.run((IAction)DiagramViewer.this.showInModelExplorerAction);
            }

            protected boolean updateSelection(IStructuredSelection selection) {
                return DiagramViewer.this.containsOnlyRepresentations(selection);
            }
        };
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.showInModelExplorerAction, selectionProvider);
        contextMenuManager.add((IAction)this.showInModelExplorerAction);
        contextMenuManager.add((IContributionItem)new Separator());
        this.openRepresentation = new OpenRepresentationsAction(){

            protected boolean updateSelection(IStructuredSelection selection) {
                return DiagramViewer.this.containsOnlyRepresentations(selection);
            }
        };
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.openRepresentation, selectionProvider);
        contextMenuManager.add((IAction)this.openRepresentation);
        contextMenuManager.add((IContributionItem)new Separator());
        this.cloneAction = new CloneAction(treeViewer);
        this.cloneAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.cloneAction, selectionProvider);
        contextMenuManager.add((IAction)this.cloneAction);
        this.deleteRepresentationAction = new DeleteRepresentationAction(){

            protected boolean updateSelection(IStructuredSelection selection) {
                return DiagramViewer.this.containsOnlyRepresentations(selection);
            }
        };
        this.deleteRepresentationAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteRepresentationAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.deleteRepresentationAction, selectionProvider);
        contextMenuManager.add((IAction)this.deleteRepresentationAction);
        contextMenuManager.add((IContributionItem)new Separator(GROUP_MOVE));
        this.moveDiagramAction = new MoveRepresentationAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.moveDiagramAction, selectionProvider);
        this.renameRepresentationAction = new RenameRepresentationAction(){

            protected boolean updateSelection(IStructuredSelection selection) {
                return DiagramViewer.this.containsOnlyRepresentations(selection);
            }
        };
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.renameRepresentationAction, selectionProvider);
        contextMenuManager.add((IAction)this.renameRepresentationAction);
        this.updateActionBars();
    }

    private void updateActionBars() {
        IActionBars editorActionBars = this.page.getEditorSite().getActionBars();
        editorActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteRepresentationAction);
        editorActionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameRepresentationAction);
        editorActionBars.updateActionBars();
    }

    protected boolean containsOnlyRepresentations(IStructuredSelection selection) {
        boolean result = true;
        for (Object representation : selection.toList()) {
            if (representation instanceof ItemWrapper) {
                representation = ((ItemWrapper)representation).getWrappedObject();
            }
            if (representation instanceof DRepresentation || representation instanceof DRepresentationDescriptor) continue;
            result = false;
            break;
        }
        return result;
    }

    @Override
    protected ViewerFilter getViewerFilter(final ActivityExplorerSection section) {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean selected = true;
                if (element instanceof ViewpointItem) {
                    ViewpointItem viewpointItem = (ViewpointItem)element;
                    Viewpoint viewpoint = (Viewpoint)viewpointItem.getWrappedObject();
                    if (viewpoint.getName().equals(this.getFilteredViewpoint())) {
                        selected = false;
                    }
                } else if (element instanceof RepresentationDescriptionItem) {
                    selected = this.isRepresentationDescriptionItemTypeSelected((RepresentationDescriptionItem)element, this.getRetainedRepresentationDescriptions());
                } else if (element instanceof DSemanticDiagram) {
                    DSemanticDiagram semanticDiagram = (DSemanticDiagram)element;
                    selected = this.isDiagramSelected(semanticDiagram.getTarget(), semanticDiagram.getDescription());
                }
                return selected;
            }

            private Object getFilteredViewpoint() {
                return null;
            }

            protected Set<String> getRetainedRepresentationDescriptions() {
                HashSet<String> representations = new HashSet<String>();
                for (ExplorerActivity activity : section.getActivities()) {
                    IHyperlinkListener listener = activity.getListener();
                    if (!(listener instanceof IRepresentationProvider)) continue;
                    try {
                        representations.addAll(((IRepresentationProvider)listener).getRepresentationNames());
                    }
                    catch (Throwable e) {
                        StringBuilder message = new StringBuilder();
                        message.append("DiagramViewer.getRetainedRepresentationDescriptions() _ ");
                        message.append("Could not retrieve a representation name from contribution ");
                        message.append(activity.getId());
                        message.append(" See the error stack for more details.");
                        ActivityExplorerLoggerService.getInstance().log(4, message.toString(), e);
                    }
                }
                return representations;
            }

            protected boolean isDiagramSelected(EObject semanticElement, DiagramDescription diagramDescription) {
                return true;
            }

            protected boolean isRepresentationDescriptionItemTypeSelected(RepresentationDescriptionItem representationDescriptionItem, Set<String> retainedDiagramTypeNames) {
                boolean selected = true;
                if (retainedDiagramTypeNames != null) {
                    RepresentationDescription representationDescription = (RepresentationDescription)representationDescriptionItem.getWrappedObject();
                    String diagramTypeName = representationDescription.getName();
                    selected = retainedDiagramTypeNames.contains(diagramTypeName);
                }
                return selected;
            }
        };
    }
}

