/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.discovery.impl;

import org.eclipse.amalgam.discovery.Category;
import org.eclipse.amalgam.discovery.DiscoveryDefinition;
import org.eclipse.amalgam.discovery.DiscoveryFactory;
import org.eclipse.amalgam.discovery.DiscoveryPackage;
import org.eclipse.amalgam.discovery.Group;
import org.eclipse.amalgam.discovery.InstallableComponent;
import org.eclipse.amalgam.discovery.Message;
import org.eclipse.amalgam.discovery.Overview;
import org.eclipse.amalgam.discovery.Severity;
import org.eclipse.amalgam.discovery.impl.CategoryImpl;
import org.eclipse.amalgam.discovery.impl.DiscoveryDefinitionImpl;
import org.eclipse.amalgam.discovery.impl.GroupImpl;
import org.eclipse.amalgam.discovery.impl.InstallableComponentImpl;
import org.eclipse.amalgam.discovery.impl.MessageImpl;
import org.eclipse.amalgam.discovery.impl.OverviewImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class DiscoveryFactoryImpl
extends EFactoryImpl
implements DiscoveryFactory {
    public static DiscoveryFactory init() {
        try {
            DiscoveryFactory theDiscoveryFactory = (DiscoveryFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/amalgamation/discovery/1.0");
            if (theDiscoveryFactory != null) {
                return theDiscoveryFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new DiscoveryFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createInstallableComponent();
            }
            case 1: {
                return this.createOverview();
            }
            case 2: {
                return this.createCategory();
            }
            case 3: {
                return this.createDiscoveryDefinition();
            }
            case 4: {
                return this.createGroup();
            }
            case 5: {
                return this.createMessage();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createSeverityFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertSeverityToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public InstallableComponent createInstallableComponent() {
        InstallableComponentImpl installableComponent = new InstallableComponentImpl();
        return installableComponent;
    }

    @Override
    public Overview createOverview() {
        OverviewImpl overview = new OverviewImpl();
        return overview;
    }

    @Override
    public Category createCategory() {
        CategoryImpl category = new CategoryImpl();
        return category;
    }

    @Override
    public DiscoveryDefinition createDiscoveryDefinition() {
        DiscoveryDefinitionImpl discoveryDefinition = new DiscoveryDefinitionImpl();
        return discoveryDefinition;
    }

    @Override
    public Group createGroup() {
        GroupImpl group = new GroupImpl();
        return group;
    }

    @Override
    public Message createMessage() {
        MessageImpl message = new MessageImpl();
        return message;
    }

    public Severity createSeverityFromString(EDataType eDataType, String initialValue) {
        Severity result = Severity.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertSeverityToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public DiscoveryPackage getDiscoveryPackage() {
        return (DiscoveryPackage)this.getEPackage();
    }

    @Deprecated
    public static DiscoveryPackage getPackage() {
        return DiscoveryPackage.eINSTANCE;
    }
}

