/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.util;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.commands.CopyAllNonConflictingCommand;
import org.eclipse.emf.compare.commands.CopyCommand;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompareEditingDomain {
    private final ChangeRecorder fChangeRecorder;
    private final ImmutableCollection<Notifier> fNotifiers;
    private final BasicCommandStack fCommandStack;

    public EMFCompareEditingDomain(Comparison comparison, Notifier left, Notifier right, Notifier ancestor) {
        this.fNotifiers = ancestor == null ? ImmutableList.of((Object)comparison, (Object)left, (Object)right) : ImmutableList.of((Object)comparison, (Object)left, (Object)right, (Object)ancestor);
        this.fCommandStack = new BasicCommandStack();
        this.fChangeRecorder = new ChangeRecorder();
        this.fChangeRecorder.setResolveProxies(false);
    }

    public void dispose() {
        this.fChangeRecorder.dispose();
    }

    public BasicCommandStack getCommandStack() {
        return this.fCommandStack;
    }

    public Command createCopyCommand(Diff diff, boolean leftToRight) {
        return new CopyCommand(this.fChangeRecorder, this.fNotifiers, Collections.singletonList(diff), leftToRight);
    }

    public Command createCopyAllNonConflictingCommand(List<? extends Diff> differences, boolean leftToRight) {
        return new CopyAllNonConflictingCommand(this.fChangeRecorder, this.fNotifiers, differences, leftToRight);
    }
}

