/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.AbstractEDiffNode;
import org.eclipse.emf.ecore.EObject;

public class MatchNode
extends AbstractEDiffNode {
    private static final Predicate<Diff> CONFLICTUAL_DIFF = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input != null && input.getConflict() != null;
        }
    };
    private static final Predicate<Diff> PSEUDO_CONFLICT = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input != null && input.getConflict().getKind() == ConflictKind.REAL;
        }
    };
    private static final Predicate<Diff> LEFT_DIFF = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input != null && input.getSource() == DifferenceSource.LEFT;
        }
    };
    private static final Predicate<Diff> RIGHT_DIFF = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input != null && input.getSource() == DifferenceSource.RIGHT;
        }
    };

    public MatchNode(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Match getTarget() {
        return (Match)super.getTarget();
    }

    public int getKind() {
        int ret = super.getKind();
        EObject ancestor = this.getTarget().getOrigin();
        EObject left = this.getTarget().getLeft();
        EObject right = this.getTarget().getRight();
        Iterable differences = this.getTarget().getAllDifferences();
        if (this.getTarget().getComparison().isThreeWay()) {
            Iterable conflictualDiffs = Iterables.filter((Iterable)differences, CONFLICTUAL_DIFF);
            if (ancestor == null) {
                if (left == null) {
                    if (right == null) {
                        Assert.isTrue((boolean)false);
                    } else {
                        ret = 9;
                    }
                } else if (right == null) {
                    ret = 5;
                } else if (!Iterables.isEmpty((Iterable)conflictualDiffs)) {
                    ret = 13;
                    if (Iterables.all((Iterable)conflictualDiffs, PSEUDO_CONFLICT)) {
                        ret |= 0x10;
                    }
                }
            } else if (left == null) {
                if (right == null) {
                    ret = 30;
                } else if (Iterables.isEmpty((Iterable)conflictualDiffs)) {
                    ret = 6;
                } else if (!Iterables.isEmpty((Iterable)conflictualDiffs)) {
                    ret = 14;
                    if (Iterables.all((Iterable)conflictualDiffs, PSEUDO_CONFLICT)) {
                        ret |= 0x10;
                    }
                }
            } else if (right == null) {
                if (Iterables.isEmpty((Iterable)conflictualDiffs)) {
                    ret = 10;
                } else if (!Iterables.isEmpty((Iterable)conflictualDiffs)) {
                    ret = 15;
                    if (Iterables.all((Iterable)conflictualDiffs, PSEUDO_CONFLICT)) {
                        ret |= 0x10;
                    }
                }
            } else {
                boolean ay = Iterables.isEmpty((Iterable)Iterables.filter((Iterable)differences, LEFT_DIFF));
                boolean am = Iterables.isEmpty((Iterable)Iterables.filter((Iterable)differences, RIGHT_DIFF));
                if (!Iterables.isEmpty((Iterable)differences)) {
                    if (ay && !am) {
                        ret = 11;
                    } else if (!ay && am) {
                        ret = 7;
                    } else if (!Iterables.isEmpty((Iterable)conflictualDiffs)) {
                        ret = 15;
                        if (Iterables.all((Iterable)conflictualDiffs, PSEUDO_CONFLICT)) {
                            ret |= 0x10;
                        }
                    }
                }
            }
        } else if (left == null) {
            if (right == null) {
                Assert.isTrue((boolean)false);
            } else {
                ret = 1;
            }
        } else if (right == null) {
            ret = 2;
        } else if (!Iterables.isEmpty((Iterable)differences)) {
            ret = 3;
        }
        return ret;
    }
}

