/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;

public class OverlayImageProvider {
    private final boolean fLeftIsLocal;
    private final ResourceLocator fResourceLocator;
    private static final Predicate<Diff> LEFT_DIFF = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input != null && input.getSource() == DifferenceSource.LEFT;
        }
    };
    private static final Predicate<Diff> RIGHT_DIFF = new Predicate<Diff>(){

        public boolean apply(Diff input) {
            return input != null && input.getSource() == DifferenceSource.RIGHT;
        }
    };

    public OverlayImageProvider(ResourceLocator resourceLocator, boolean leftIsLocal) {
        this.fResourceLocator = resourceLocator;
        this.fLeftIsLocal = leftIsLocal;
    }

    public Object getComposedImage(Diff diff, Object imageToCompose) {
        String overlay = this.getImageOverlay(diff);
        return this.getComposedImage(imageToCompose, overlay);
    }

    public Object getComposedImage(Match match, Object imageToCompose) {
        String overlay = this.getImageOverlay(match);
        return this.getComposedImage(imageToCompose, overlay);
    }

    private Object getComposedImage(Object imageToCompose, String overlay) {
        ArrayList images = Lists.newArrayList();
        images.add(imageToCompose);
        if (overlay != null) {
            Object image = this.fResourceLocator.getImage(overlay);
            images.add(image);
        }
        return new ComposedImageExtension(images);
    }

    private String getImageOverlay(Diff diff) {
        DifferenceSource source = diff.getSource();
        Match match = diff.getMatch();
        Conflict conflict = diff.getConflict();
        DifferenceKind diffKind = diff.getKind();
        Comparison c = match.getComparison();
        String path = "full/ovr16/";
        if (diff.getState() == DifferenceState.MERGED) {
            path = String.valueOf(path) + "merged_ov";
        } else if (diff.getState() == DifferenceState.DISCARDED) {
            path = String.valueOf(path) + "removed_ov";
        } else if (c.isThreeWay()) {
            String filext = "";
            if (conflict != null) {
                if (conflict.getKind() == ConflictKind.REAL) {
                    filext = ".png";
                    path = String.valueOf(path) + "conf";
                    path = String.valueOf(path) + this.getConflictWay(source);
                }
            } else {
                switch (source) {
                    case LEFT: {
                        if (this.fLeftIsLocal) {
                            path = String.valueOf(path) + "r_out";
                            break;
                        }
                        path = String.valueOf(path) + "out";
                        break;
                    }
                    case RIGHT: {
                        if (this.fLeftIsLocal) {
                            path = String.valueOf(path) + "r_in";
                            break;
                        }
                        path = String.valueOf(path) + "in";
                        break;
                    }
                }
            }
            switch (diffKind) {
                case ADD: {
                    path = String.valueOf(path) + "add_ov";
                    break;
                }
                case DELETE: {
                    path = String.valueOf(path) + "del_ov";
                    break;
                }
                case CHANGE: 
                case MOVE: {
                    path = String.valueOf(path) + "chg_ov";
                    break;
                }
            }
            path = String.valueOf(path) + filext;
        } else {
            path = String.valueOf(path) + this.getPathForTwoWayDiff(diffKind);
        }
        return path;
    }

    private String getPathForTwoWayDiff(DifferenceKind diffKind) {
        String path;
        switch (diffKind) {
            case ADD: {
                if (this.fLeftIsLocal) {
                    path = "add_ov";
                    break;
                }
                path = "del_ov";
                break;
            }
            case DELETE: {
                if (this.fLeftIsLocal) {
                    path = "del_ov";
                    break;
                }
                path = "add_ov";
                break;
            }
            case CHANGE: 
            case MOVE: {
                path = "chg_ov";
                break;
            }
            default: {
                path = "";
            }
        }
        return path;
    }

    private String getConflictWay(DifferenceSource source) {
        String path = source == DifferenceSource.LEFT && !this.fLeftIsLocal ? "r_" : (source == DifferenceSource.RIGHT && this.fLeftIsLocal ? "r_" : "");
        return path;
    }

    private String getImageOverlay(Match match) {
        String path = null;
        EObject ancestor = match.getOrigin();
        EObject left = match.getLeft();
        EObject right = match.getRight();
        Iterable differences = match.getAllDifferences();
        if (match.getComparison().isThreeWay()) {
            boolean hasConflicts = Iterables.any((Iterable)differences, (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL, ConflictKind.PSEUDO}));
            if (ancestor == null) {
                if (left == null) {
                    if (right != null) {
                        path = this.fLeftIsLocal ? "r_inadd_ov" : "inadd_ov";
                    }
                } else if (right == null) {
                    path = this.fLeftIsLocal ? "r_outadd_ov" : "outadd_ov";
                } else if (hasConflicts && Iterables.any((Iterable)differences, (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}))) {
                    path = "confadd_ov.png";
                }
            } else if (left == null) {
                if (right != null) {
                    if (!hasConflicts) {
                        path = this.fLeftIsLocal ? "r_outdel_ov" : "outdel_ov";
                    } else if (Iterables.any((Iterable)differences, (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}))) {
                        path = "confdel_ov.png";
                    }
                }
            } else if (right == null) {
                if (!hasConflicts) {
                    path = this.fLeftIsLocal ? "r_indel_ov" : "indel_ov";
                } else if (Iterables.any((Iterable)differences, (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL}))) {
                    path = "confchg_ov.png";
                }
            } else {
                boolean ay = Iterables.isEmpty((Iterable)Iterables.filter((Iterable)differences, LEFT_DIFF));
                boolean am = Iterables.isEmpty((Iterable)Iterables.filter((Iterable)differences, RIGHT_DIFF));
                if (!Iterables.isEmpty((Iterable)differences)) {
                    path = ay && !am ? (this.fLeftIsLocal ? "r_inchg_ov" : "inchg_ov") : (!ay && am ? (this.fLeftIsLocal ? "r_outchg_ov" : "outchg_ov") : (hasConflicts && Iterables.any((Iterable)differences, (Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.REAL})) ? "confchg_ov.png" : "r_inoutchg_ov.gif"));
                }
            }
        } else if (left == null) {
            if (right != null) {
                path = this.fLeftIsLocal ? "add_ov" : "del_ov";
            }
        } else if (right == null) {
            path = this.fLeftIsLocal ? "del_ov" : "add_ov";
        } else if (!Iterables.isEmpty((Iterable)differences)) {
            path = "chg_ov";
        }
        String ret = null;
        if (path != null) {
            ret = "full/ovr16/" + path;
        }
        return ret;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ComposedImageExtension
    extends ComposedImage {
        ComposedImageExtension(Collection<?> images) {
            super(images);
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            List result = super.getDrawPoints(size);
            if (result.size() > 1) {
                ((ComposedImage.Point)result.get((int)1)).x = 12;
                ((ComposedImage.Point)result.get((int)1)).y = 2;
            }
            return result;
        }

        public ComposedImage.Size getSize(Collection<? extends ComposedImage.Size> imageSizes) {
            this.imageSizes = Lists.newArrayList(imageSizes);
            List<ComposedImage.Point> drawPoints = this.getDrawPoints(null);
            ComposedImage.Size result = new ComposedImage.Size();
            int i = 0;
            while (i < imageSizes.size()) {
                ComposedImage.Size size = (ComposedImage.Size)this.imageSizes.get(i);
                ComposedImage.Point point = drawPoints.get(i);
                result.width = Math.max(result.width, size.width + Math.abs(point.x));
                result.height = Math.max(result.height, size.height + Math.abs(point.y));
                ++i;
            }
            return result;
        }
    }
}

