/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.accessor.IResourceContentsAccessor;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicResourceContentsAccessorImpl
implements IResourceContentsAccessor {
    private final Diff fDiff;
    private final IMergeViewer.MergeViewerSide fSide;
    private final Match fOwnerMatch;
    private final ImmutableList<Diff> fDifferences;

    public BasicResourceContentsAccessorImpl(Diff diff, IMergeViewer.MergeViewerSide side) {
        this.fDiff = diff;
        this.fSide = side;
        this.fOwnerMatch = diff.getMatch();
        this.fDifferences = this.computeDifferences();
    }

    @Override
    public Comparison getComparison() {
        return this.fOwnerMatch.getComparison();
    }

    @Override
    public IMergeViewerItem getInitialItem() {
        IMergeViewerItem ret = null;
        ImmutableList<? extends IMergeViewerItem> items = this.getItems();
        for (IMergeViewerItem item : items) {
            Diff diff = item.getDiff();
            if (diff != this.fDiff) continue;
            ret = item;
        }
        return ret;
    }

    @Override
    public Resource getResource(IMergeViewer.MergeViewerSide side) {
        Resource resource = null;
        EList matchResources = this.fOwnerMatch.getComparison().getMatchedResources();
        Iterator it = matchResources.iterator();
        if (it.hasNext()) {
            MatchResource matchResource = (MatchResource)it.next();
            switch (side) {
                case ANCESTOR: {
                    resource = matchResource.getOrigin();
                    break;
                }
                case LEFT: {
                    resource = matchResource.getLeft();
                    break;
                }
                case RIGHT: {
                    resource = matchResource.getRight();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return resource;
    }

    public List<EObject> getResourceContents(IMergeViewer.MergeViewerSide side) {
        Resource resource = this.getResource(side);
        if (resource != null) {
            return resource.getContents();
        }
        return Collections.emptyList();
    }

    protected final IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    protected final ImmutableList<Diff> getDifferences() {
        return this.fDifferences;
    }

    protected ImmutableList<Diff> computeDifferences() {
        Iterable concat = Iterables.concat(this.getResourceContents(IMergeViewer.MergeViewerSide.LEFT), this.getResourceContents(IMergeViewer.MergeViewerSide.RIGHT), this.getResourceContents(IMergeViewer.MergeViewerSide.ANCESTOR));
        final Comparison comparison = this.fOwnerMatch.getComparison();
        Iterable matches = Iterables.transform((Iterable)concat, (Function)new Function<EObject, Match>(){

            public Match apply(EObject eObject) {
                return comparison.getMatch(eObject);
            }
        });
        Iterable siblingDifferences = Iterables.concat((Iterable)Iterables.transform((Iterable)matches, (Function)new Function<Match, List<Diff>>(){

            public List<Diff> apply(Match match) {
                return match.getDifferences();
            }
        }));
        Predicate diffFilter = Predicates.and((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
        return ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)siblingDifferences, (Predicate)diffFilter)).asList();
    }
}

