/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.diagram.DiagramDiff;
import org.eclipse.emf.compare.diagram.EdgeChange;
import org.eclipse.emf.compare.diagram.Hide;
import org.eclipse.emf.compare.diagram.LabelChange;
import org.eclipse.emf.compare.diagram.NodeChange;
import org.eclipse.emf.compare.diagram.Show;
import org.eclipse.emf.compare.diagram.ide.ui.AbstractGraphicalMergeViewer;
import org.eclipse.emf.compare.diagram.ide.ui.decoration.DiffDecorationEditPolicy;
import org.eclipse.emf.compare.diagram.ide.ui.decoration.provider.SelectedDiffAdapter;
import org.eclipse.emf.compare.diagram.ide.ui.internal.accessor.IDiagramNodeAccessor;
import org.eclipse.emf.compare.diagram.util.DiagramCompareSwitch;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.IMergeViewer;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.MouseWheelZoomHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class DiagramMergeViewer
extends AbstractGraphicalMergeViewer {
    private IDiagramNodeAccessor fInput;
    private DiagramGraphicalViewer fGraphicalViewer;
    private static final double ZOOM_FACTOR = 1.0;
    private Diagram currentDiag;

    public DiagramMergeViewer(Composite parent, IMergeViewer.MergeViewerSide side) {
        super(parent, side);
    }

    public Control createControl(Composite parent) {
        this.createDiagramGraphicalViewer(parent);
        return this.fGraphicalViewer.getControl();
    }

    private void createDiagramGraphicalViewer(Composite composite) {
        this.fGraphicalViewer = new DiagramGraphicalViewer();
        this.fGraphicalViewer.createControl(composite);
        this.fGraphicalViewer.setEditDomain((EditDomain)this.editDomain);
        this.fGraphicalViewer.setEditPartFactory((EditPartFactory)EditPartService.getInstance());
        this.fGraphicalViewer.getControl().setBackground(ColorConstants.listBackground);
        this.fGraphicalViewer.setProperty(MouseWheelHandler.KeyGenerator.getKey((int)262144), (Object)MouseWheelZoomHandler.SINGLETON);
    }

    public DiagramGraphicalViewer getGraphicalViewer() {
        return this.fGraphicalViewer;
    }

    private void installDecoratorPolicy(EditPart editPart) {
        editPart.removeEditPolicy((Object)"DecorationPolicy");
        editPart.installEditPolicy((Object)"DecorationPolicy", (EditPolicy)new DiffDecorationEditPolicy());
    }

    public void setInput(Object input) {
        if (input instanceof IDiagramNodeAccessor) {
            EditPart viewPart;
            this.fInput = (IDiagramNodeAccessor)input;
            Diagram diagram = ((IDiagramNodeAccessor)input).getOwnedDiagram();
            View view = ((IDiagramNodeAccessor)input).getOwnedView();
            this.initEditingDomain(diagram);
            if (diagram != null) {
                TreeIterator contents = diagram.eAllContents();
                while (contents.hasNext()) {
                    EObject obj = (EObject)contents.next();
                    if (!(obj instanceof View)) continue;
                    for (Diff diff : ((IDiagramNodeAccessor)input).getComparison().getDifferences(obj)) {
                        if (!(diff instanceof DiagramDiff) || diff.getKind() == DifferenceKind.DELETE) continue;
                        obj.eAdapters().add((Object)new SelectedDiffAdapter((DiagramDiff)diff));
                        EditPart editPart = this.getEditPart((View)obj);
                        if (editPart == null) continue;
                        this.installDecoratorPolicy(editPart);
                        editPart.refresh();
                    }
                }
            }
            this.fGraphicalViewer.deselectAll();
            if (view != null && (viewPart = this.getEditPart(view)) != null) {
                while (!viewPart.isSelectable()) {
                    viewPart = viewPart.getParent();
                }
                this.setSelection((ISelection)new StructuredSelection((Object)viewPart));
                this.getGraphicalViewer().reveal(viewPart);
            }
        }
    }

    private void initEditingDomain(Diagram diagram) {
        ResourceSet resourceSet = null;
        if (diagram != null) {
            resourceSet = diagram.eResource().getResourceSet();
        }
        if (resourceSet != null && TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(resourceSet) == null) {
            TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(resourceSet);
        }
    }

    public Object getInput() {
        return this.fInput;
    }

    public EditPart findObjectAtExcluding(Point location, Collection exclusionSet, EditPartViewer.Conditional conditional) {
        return null;
    }

    public EditPart getEditPart(View view) {
        EditPart editPart = (EditPart)this.fGraphicalViewer.getEditPartRegistry().get(view);
        if (editPart == null) {
            Diagram diagram = null;
            diagram = view instanceof Diagram ? (Diagram)view : view.getDiagram();
            if (diagram != null && !diagram.equals(this.currentDiag)) {
                this.currentDiag = diagram;
                this.fGraphicalViewer.getEditPartRegistry().clear();
                DiagramRootEditPart rootEditPart = new DiagramRootEditPart(diagram.getMeasurementUnit());
                this.fGraphicalViewer.setRootEditPart((RootEditPart)rootEditPart);
                this.fGraphicalViewer.setContents((Object)diagram);
                this.disableEditMode((DiagramEditPart)this.fGraphicalViewer.getContents());
                rootEditPart.getZoomManager().setZoomAnimationStyle(0);
                rootEditPart.getZoomManager().setZoom(1.0);
            }
        }
        return (EditPart)this.fGraphicalViewer.getEditPartRegistry().get(view);
    }

    public EditPart findEditPart(EObject eobj) {
        if (eobj instanceof View) {
            Diagram d = ((View)eobj).getDiagram();
            this.checkAndDisplayDiagram(d);
        }
        return (EditPart)this.fGraphicalViewer.getEditPartRegistry().get(eobj);
    }

    private void checkAndDisplayDiagram(Diagram d) {
        if (d != null && !d.equals(this.currentDiag)) {
            this.currentDiag = d;
            this.displayDiagram(d);
        }
    }

    protected final void displayDiagram(Diagram diag) {
        if (diag == null) {
            return;
        }
        this.currentDiag = diag;
        this.fGraphicalViewer.getEditPartRegistry().clear();
        DiagramRootEditPart rootEditPart = new DiagramRootEditPart(diag.getMeasurementUnit());
        this.fGraphicalViewer.setRootEditPart((RootEditPart)rootEditPart);
        this.fGraphicalViewer.setContents((Object)diag);
        this.disableEditMode((DiagramEditPart)this.fGraphicalViewer.getContents());
        rootEditPart.getZoomManager().setZoomAnimationStyle(0);
        rootEditPart.getZoomManager().setZoom(1.0);
    }

    private void disableEditMode(DiagramEditPart diagEditPart) {
        diagEditPart.disableEditMode();
        for (Object obj : diagEditPart.getPrimaryEditParts()) {
            if (!(obj instanceof IGraphicalEditPart)) continue;
            this.disableEditMode((IGraphicalEditPart)obj);
        }
    }

    private void disableEditMode(IGraphicalEditPart obj) {
        obj.disableEditMode();
        obj.removeEditPolicy((Object)"OpenPolicy");
        for (Object child : obj.getChildren()) {
            if (!(child instanceof IGraphicalEditPart)) continue;
            this.disableEditMode((IGraphicalEditPart)child);
        }
    }

    private boolean hasSelectedDiffAdapter(View view) {
        for (Adapter adapter : view.eAdapters()) {
            if (!adapter.isAdapterForType(DiagramDiff.class)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiagramdiffSwitchVisitor
    extends DiagramCompareSwitch<IStatus> {
        private View view;
        private boolean annotate;

        public DiagramdiffSwitchVisitor(View view, boolean annotate) {
            this.view = view;
            this.annotate = annotate;
        }

        public IStatus caseLabelChange(LabelChange diff) {
            return this.checkResult(this.annotateNotation(this.view, "diff-label-modified"));
        }

        public IStatus caseShow(Show diff) {
            return this.checkResult(this.annotateNotation(this.view, "diff-showed"));
        }

        public IStatus caseHide(Hide diff) {
            return this.checkResult(this.annotateNotation(this.view, "diff-showed"));
        }

        public IStatus caseNodeChange(NodeChange diff) {
            boolean result = true;
            if (diff.getKind() == DifferenceKind.MOVE) {
                return this.checkResult(this.annotateNotation(this.view, "diff-moved"));
            }
            if (diff.getKind() == DifferenceKind.ADD) {
                return this.checkResult(this.annotateNotation(this.view, "diff-added"));
            }
            if (diff.getKind() == DifferenceKind.DELETE) {
                return this.checkResult(this.annotateNotation(this.view, "diff-removed"));
            }
            return this.checkResult(result);
        }

        public IStatus caseEdgeChange(EdgeChange diff) {
            return this.checkResult(this.annotateNotation(this.view, "diff-moved"));
        }

        public IStatus defaultCase(EObject diff) {
            return Status.OK_STATUS;
        }

        protected boolean annotateNotation(View element, String annotation) {
            boolean result = false;
            if (this.annotate) {
                EAnnotation diffAnnotation = null;
                if (element.getEAnnotation("diff-marker") == null) {
                    diffAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    diffAnnotation.setSource("diff-marker");
                    result = element.getEAnnotations().add((Object)diffAnnotation);
                } else {
                    diffAnnotation = element.getEAnnotation("diff-marker");
                }
                diffAnnotation.getDetails().put((Object)annotation, (Object)"diffDetail");
                result = true;
            } else if (element.getEAnnotation("diff-marker") != null) {
                EAnnotation diffAnnotation = element.getEAnnotation("diff-marker");
                result = element.getEAnnotations().remove((Object)diffAnnotation);
            }
            return result;
        }

        protected IStatus checkResult(boolean ok) {
            if (ok) {
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }
}

