/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.EditionDistance;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.IdentifierEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.resource.IResourceMatcher;
import org.eclipse.emf.compare.match.resource.StrategyResourceMatcher;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class DefaultMatchEngine
implements IMatchEngine {
    public static final int DEFAULT_EOBJECT_URI_CACHE_MAX_SIZE = 1024;
    private final IEObjectMatcher eObjectMatcher;
    private final IComparisonFactory comparisonFactory;

    public DefaultMatchEngine(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
        this.eObjectMatcher = (IEObjectMatcher)Preconditions.checkNotNull((Object)matcher);
        this.comparisonFactory = (IComparisonFactory)Preconditions.checkNotNull((Object)comparisonFactory);
    }

    public Comparison match(IComparisonScope scope, Monitor monitor) {
        Comparison comparison = this.comparisonFactory.createComparison();
        Notifier left = scope.getLeft();
        Notifier right = scope.getRight();
        Notifier origin = scope.getOrigin();
        comparison.setThreeWay(origin != null);
        this.match(comparison, scope, left, right, origin, monitor);
        return comparison;
    }

    protected void match(Comparison comparison, IComparisonScope scope, Notifier left, Notifier right, Notifier origin, Monitor monitor) {
        if (left instanceof ResourceSet || right instanceof ResourceSet) {
            this.match(comparison, scope, (ResourceSet)left, (ResourceSet)right, (ResourceSet)origin, monitor);
        } else if (left instanceof Resource || right instanceof Resource) {
            this.match(comparison, scope, (Resource)left, (Resource)right, (Resource)origin, monitor);
        } else if (left instanceof EObject || right instanceof EObject) {
            this.match(comparison, scope, (EObject)left, (EObject)right, (EObject)origin, monitor);
        }
    }

    protected void match(Comparison comparison, IComparisonScope scope, ResourceSet left, ResourceSet right, ResourceSet origin, Monitor monitor) {
        Iterator<? extends Resource> leftChildren = scope.getCoveredResources(left);
        Iterator<? extends Resource> rightChildren = scope.getCoveredResources(right);
        Object originChildren = origin != null ? scope.getCoveredResources(origin) : Iterators.emptyIterator();
        IResourceMatcher resourceMatcher = this.createResourceMatcher();
        Iterable<MatchResource> mappings = resourceMatcher.createMappings(leftChildren, rightChildren, (Iterator<? extends Resource>)originChildren);
        LinkedList leftIterators = Lists.newLinkedList();
        LinkedList rightIterators = Lists.newLinkedList();
        LinkedList originIterators = Lists.newLinkedList();
        for (MatchResource mapping : mappings) {
            comparison.getMatchedResources().add((Object)mapping);
            Resource leftRes = mapping.getLeft();
            Resource rightRes = mapping.getRight();
            Resource originRes = mapping.getOrigin();
            if (leftRes != null) {
                leftIterators.add(scope.getCoveredEObjects(leftRes));
            }
            if (rightRes != null) {
                rightIterators.add(scope.getCoveredEObjects(rightRes));
            }
            if (originRes == null) continue;
            originIterators.add(scope.getCoveredEObjects(originRes));
        }
        Iterator leftEObjects = Iterators.concat(leftIterators.iterator());
        Iterator rightEObjects = Iterators.concat(rightIterators.iterator());
        Iterator originEObjects = Iterators.concat(originIterators.iterator());
        Iterable<Match> matches = this.getEObjectMatcher().createMatches(leftEObjects, rightEObjects, originEObjects);
        Iterables.addAll(comparison.getMatches(), matches);
    }

    protected void match(Comparison comparison, IComparisonScope scope, Resource left, Resource right, Resource origin, Monitor monitor) {
        URI uri;
        MatchResource match = CompareFactory.eINSTANCE.createMatchResource();
        match.setLeft(left);
        match.setRight(right);
        match.setOrigin(origin);
        if (left != null && (uri = left.getURI()) != null) {
            match.setLeftURI(uri.toString());
        }
        if (right != null && (uri = right.getURI()) != null) {
            match.setRightURI(uri.toString());
        }
        if (origin != null && (uri = origin.getURI()) != null) {
            match.setOriginURI(uri.toString());
        }
        comparison.getMatchedResources().add((Object)match);
        if (DefaultMatchEngine.atLeastTwo(left == null, right == null, origin == null)) {
            return;
        }
        Object leftEObjects = left != null ? scope.getCoveredEObjects(left) : Iterators.emptyIterator();
        Object rightEObjects = right != null ? scope.getCoveredEObjects(right) : Iterators.emptyIterator();
        Object originEObjects = origin != null ? scope.getCoveredEObjects(origin) : Iterators.emptyIterator();
        Iterable<Match> matches = this.getEObjectMatcher().createMatches((Iterator<? extends EObject>)leftEObjects, (Iterator<? extends EObject>)rightEObjects, (Iterator<? extends EObject>)originEObjects);
        Iterables.addAll(comparison.getMatches(), matches);
    }

    protected void match(Comparison comparison, IComparisonScope scope, EObject left, EObject right, EObject origin, Monitor monitor) {
        if (left == null || right == null) {
            throw new IllegalArgumentException();
        }
        Iterator leftEObjects = Iterators.concat((Iterator)Iterators.singletonIterator((Object)left), scope.getChildren(left));
        Iterator rightEObjects = Iterators.concat((Iterator)Iterators.singletonIterator((Object)right), scope.getChildren(right));
        Object originEObjects = origin != null ? Iterators.concat((Iterator)Iterators.singletonIterator((Object)origin), scope.getChildren(origin)) : Iterators.emptyIterator();
        Iterable<Match> matches = this.getEObjectMatcher().createMatches(leftEObjects, rightEObjects, (Iterator<? extends EObject>)originEObjects);
        Iterables.addAll(comparison.getMatches(), matches);
    }

    protected IResourceMatcher createResourceMatcher() {
        return new StrategyResourceMatcher();
    }

    protected final IEObjectMatcher getEObjectMatcher() {
        return this.eObjectMatcher;
    }

    private static boolean atLeastTwo(boolean condition1, boolean condition2, boolean condition3) {
        return condition1 && (condition2 || condition3) || condition2 && condition3;
    }

    public static IMatchEngine create(UseIdentifiers useIDs) {
        DefaultComparisonFactory comparisonFactory = new DefaultComparisonFactory(new DefaultEqualityHelperFactory());
        IEObjectMatcher matcher = DefaultMatchEngine.createDefaultEObjectMatcher(useIDs);
        DefaultMatchEngine matchEngine = new DefaultMatchEngine(matcher, comparisonFactory);
        return matchEngine;
    }

    public static IEObjectMatcher createDefaultEObjectMatcher(UseIdentifiers useIDs) {
        IEObjectMatcher matcher;
        EditionDistance editionDistance = EditionDistance.builder().build();
        switch (useIDs) {
            case NEVER: {
                matcher = new ProximityEObjectMatcher(editionDistance);
                break;
            }
            case ONLY: {
                matcher = new IdentifierEObjectMatcher();
                break;
            }
            default: {
                ProximityEObjectMatcher contentMatcher = new ProximityEObjectMatcher(editionDistance);
                matcher = new IdentifierEObjectMatcher(contentMatcher);
            }
        }
        return matcher;
    }
}

