/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.CompareHandlerService;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.command.ICompareCommandStack;
import org.eclipse.emf.compare.command.ICompareCopyCommand;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text.DelayedExecutor;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.text.EMFCompareTextMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.DynamicObject;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.RedoAction;
import org.eclipse.emf.compare.ide.ui.internal.contentmergeviewer.util.UndoAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.provider.AttributeChangeNode;
import org.eclipse.emf.compare.ide.ui.internal.util.SWTUtil;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;

public class EMFCompareTextMergeViewer
extends TextMergeViewer
implements IPropertyChangeListener,
CommandStackListener {
    private static final String BUNDLE_NAME = EMFCompareTextMergeViewer.class.getName();
    private DynamicObject fDynamicObject;
    private ActionContributionItem fCopyDiffLeftToRightItem;
    private ActionContributionItem fCopyDiffRightToLeftItem;
    private final UndoAction fUndoAction;
    private final RedoAction fRedoAction;
    private final DelayedExecutor fDelayedExecutor;
    private final ScheduledExecutorService fExecutorService;

    public EMFCompareTextMergeViewer(Composite parent, CompareConfiguration configuration) {
        super(parent, configuration);
        this.setContentProvider((IContentProvider)new EMFCompareTextMergeViewerContentProvider(configuration));
        this.fRedoAction = new RedoAction();
        this.fUndoAction = new UndoAction();
        this.fExecutorService = Executors.newSingleThreadScheduledExecutor();
        this.fDelayedExecutor = new DelayedExecutor(this.fExecutorService);
        this.editingDomainChange(null, this.getEditingDomain());
        configuration.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN".equals(event.getProperty())) {
            this.editingDomainChange((ICompareEditingDomain)event.getOldValue(), (ICompareEditingDomain)event.getNewValue());
        }
    }

    protected void flushContent(Object oldInput, IProgressMonitor monitor) {
        try {
            this.fExecutorService.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            EMFCompareIDEUIPlugin.getDefault().log(e);
        }
        super.flushContent(oldInput, monitor);
    }

    protected void editingDomainChange(ICompareEditingDomain oldValue, ICompareEditingDomain newValue) {
        if (oldValue != null) {
            oldValue.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        }
        if (newValue != oldValue) {
            if (newValue != null) {
                ICompareCommandStack commandStack = newValue.getCommandStack();
                commandStack.addCommandStackListener((CommandStackListener)this);
                this.setLeftDirty(commandStack.isLeftSaveNeeded());
                this.setRightDirty(commandStack.isRightSaveNeeded());
            }
            this.fUndoAction.setEditingDomain(newValue);
            this.fRedoAction.setEditingDomain(newValue);
        }
    }

    public void commandStackChanged(EventObject event) {
        if (this.fUndoAction != null) {
            this.fUndoAction.update();
        }
        if (this.fRedoAction != null) {
            this.fRedoAction.update();
        }
        if (this.getEditingDomain() != null) {
            ICompareCommandStack commandStack = this.getEditingDomain().getCommandStack();
            this.setLeftDirty(commandStack.isLeftSaveNeeded());
            this.setRightDirty(commandStack.isRightSaveNeeded());
        }
        IMergeViewerContentProvider contentProvider = (IMergeViewerContentProvider)this.getContentProvider();
        final String leftValueFromModel = this.getString((IStreamContentAccessor)contentProvider.getLeftContent(this.getInput()));
        final String rightValueFromModel = this.getString((IStreamContentAccessor)contentProvider.getRightContent(this.getInput()));
        SWTUtil.safeAsyncExec(new Runnable(){

            public void run() {
                String leftValueFromWidget = EMFCompareTextMergeViewer.this.getContents(true, Charsets.UTF_8.name());
                String rightValueFromWidget = EMFCompareTextMergeViewer.this.getContents(false, Charsets.UTF_8.name());
                IEqualityHelper equalityHelper = EMFCompareTextMergeViewer.this.getComparison().getEqualityHelper();
                if (!equalityHelper.matchingAttributeValues((Object)leftValueFromModel, (Object)leftValueFromWidget) || !equalityHelper.matchingAttributeValues((Object)rightValueFromModel, (Object)rightValueFromWidget)) {
                    EMFCompareTextMergeViewer.this.refresh();
                }
            }
        });
    }

    /*
     * Exception decompiling
     */
    private String getString(IStreamContentAccessor contentAccessor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
         *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
         *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final ICompareEditingDomain getEditingDomain() {
        return (ICompareEditingDomain)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
    }

    protected final Comparison getComparison() {
        return (Comparison)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.COMPARE.RESULT");
    }

    protected void copy(final boolean leftToRight) {
        ImmutableList differences = this.getComparison().isThreeWay() ? ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.getComparison().getDifferences(), (Predicate)new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                boolean fromRightToLeft;
                boolean unresolved = diff.getState() == DifferenceState.UNRESOLVED;
                boolean nonConflictual = diff.getConflict() == null;
                boolean fromLeftToRight = leftToRight && diff.getSource() == DifferenceSource.LEFT;
                boolean bl = fromRightToLeft = !leftToRight && diff.getSource() == DifferenceSource.RIGHT;
                return unresolved && nonConflictual && (fromLeftToRight || fromRightToLeft);
            }
        })) : ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)this.getComparison().getDifferences(), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})));
        if (differences.size() > 0) {
            Command copyCommand = this.getEditingDomain().createCopyCommand((List)differences, leftToRight, EMFCompareRCPPlugin.getDefault().getMergerRegistry());
            this.getEditingDomain().getCommandStack().execute(copyCommand);
            this.refresh();
        }
    }

    protected void copyDiff(boolean leftToRight) {
        Object input = this.getInput();
        if (input instanceof AttributeChangeNode) {
            AttributeChange attributeChange = ((AttributeChangeNode)((Object)input)).getTarget();
            Command copyCommand = this.getEditingDomain().createCopyCommand(Collections.singletonList(attributeChange), leftToRight, EMFCompareRCPPlugin.getDefault().getMergerRegistry());
            this.getEditingDomain().getCommandStack().execute(copyCommand);
            this.refresh();
        }
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        return false;
    }

    protected String getContents(boolean isLeft, String charsetName) {
        try {
            return new String(this.getContents(isLeft), Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private void updateModel(AttributeChange diff, EAttribute eAttribute, IEqualityHelper equalityHelper, EObject eObject, boolean isLeft) {
        String oldValue = this.getStringValue(eObject, eAttribute);
        String newValue = this.getContents(isLeft, Charsets.UTF_8.name());
        boolean oldAndNewEquals = equalityHelper.matchingAttributeValues((Object)newValue, (Object)oldValue);
        if (eObject != null && !oldAndNewEquals && this.getCompareConfiguration().isLeftEditable()) {
            this.getEditingDomain().getCommandStack().execute((Command)new UpdateModelAndRejectDiffCommand(this.getEditingDomain().getChangeRecorder(), eObject, (EStructuralFeature)eAttribute, newValue, (Diff)diff, isLeft));
        }
    }

    private String getStringValue(EObject eObject, EAttribute eAttribute) {
        EDataType eAttributeType = eAttribute.getEAttributeType();
        Object value = eObject == null ? null : ReferenceUtil.safeEGet((EObject)eObject, (EStructuralFeature)eAttribute);
        return EcoreUtil.convertToString((EDataType)eAttributeType, (Object)value);
    }

    public DynamicObject getDynamicObject() {
        if (this.fDynamicObject == null) {
            this.fDynamicObject = new DynamicObject((Object)this);
        }
        return this.fDynamicObject;
    }

    protected final MergeSourceViewer getAncestorSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fAncestor");
    }

    protected final MergeSourceViewer getLeftSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fLeft");
    }

    protected final MergeSourceViewer getRightSourceViewer() {
        return (MergeSourceViewer)this.getDynamicObject().get("fRight");
    }

    protected final CompareHandlerService getHandlerService() {
        return (CompareHandlerService)this.getDynamicObject().get("fHandlerService");
    }

    protected final void setHandlerService(CompareHandlerService service) {
        this.getDynamicObject().set("fHandlerService", service);
    }

    protected void createControls(Composite composite) {
        super.createControls(composite);
        this.attachListeners(this.getAncestorSourceViewer());
        this.attachListeners(this.getLeftSourceViewer());
        this.attachListeners(this.getRightSourceViewer());
    }

    protected void attachListeners(final MergeSourceViewer viewer) {
        StyledText textWidget = viewer.getSourceViewer().getTextWidget();
        textWidget.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                EMFCompareTextMergeViewer.this.setActiveViewer(viewer, false);
            }

            public void focusGained(FocusEvent e) {
                EMFCompareTextMergeViewer.this.setActiveViewer(viewer, true);
            }
        });
        textWidget.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                EMFCompareTextMergeViewer.this.fDelayedExecutor.schedule(new Runnable(){

                    public void run() {
                        Object oldInput = EMFCompareTextMergeViewer.this.getInput();
                        if (oldInput instanceof AttributeChangeNode) {
                            AttributeChange diff = ((AttributeChangeNode)((Object)oldInput)).getTarget();
                            EAttribute eAttribute = diff.getAttribute();
                            Match match = diff.getMatch();
                            IEqualityHelper equalityHelper = match.getComparison().getEqualityHelper();
                            EMFCompareTextMergeViewer.this.updateModel(diff, eAttribute, equalityHelper, match.getLeft(), true);
                            EMFCompareTextMergeViewer.this.updateModel(diff, eAttribute, equalityHelper, match.getRight(), false);
                        }
                    }
                });
            }
        });
    }

    private void setActiveViewer(MergeSourceViewer viewer, boolean activate) {
        if (activate) {
            this.connectGlobalActions(viewer);
        } else {
            this.connectGlobalActions(null);
        }
    }

    private void connectGlobalActions(final MergeSourceViewer part) {
        if (this.getHandlerService() != null) {
            if (part != null) {
                part.updateActions();
            }
            this.getHandlerService().updatePaneActionHandlers(new Runnable(){

                public void run() {
                    if (part == null) {
                        EMFCompareTextMergeViewer.this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
                        EMFCompareTextMergeViewer.this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), null);
                    } else {
                        EMFCompareTextMergeViewer.this.getHandlerService().setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)EMFCompareTextMergeViewer.this.fUndoAction);
                        EMFCompareTextMergeViewer.this.getHandlerService().setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)EMFCompareTextMergeViewer.this.fRedoAction);
                    }
                }
            });
        }
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        CompareHandlerService handlerService = CompareHandlerService.createFor((ICompareContainer)this.getCompareConfiguration().getContainer(), (Shell)this.getLeftSourceViewer().getSourceViewer().getControl().getShell());
        this.setHandlerService(handlerService);
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc.isRightEditable()) {
            Action copyLeftToRight = new Action(){

                public void run() {
                    EMFCompareTextMergeViewer.this.copyDiff(true);
                    EMFCompareTextMergeViewer.this.navigate(true);
                }
            };
            Utilities.initAction((IAction)copyLeftToRight, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffLeftToRight.");
            this.fCopyDiffLeftToRightItem = new ActionContributionItem((IAction)copyLeftToRight);
            this.fCopyDiffLeftToRightItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffLeftToRightItem);
            handlerService.registerAction((IAction)copyLeftToRight, "org.eclipse.compare.copyLeftToRight");
        }
        if (cc.isLeftEditable()) {
            Action copyRightToLeft = new Action(){

                public void run() {
                    EMFCompareTextMergeViewer.this.copyDiff(false);
                    EMFCompareTextMergeViewer.this.navigate(true);
                }
            };
            Utilities.initAction((IAction)copyRightToLeft, (ResourceBundle)this.getResourceBundle(), (String)"action.CopyDiffRightToLeft.");
            this.fCopyDiffRightToLeftItem = new ActionContributionItem((IAction)copyRightToLeft);
            this.fCopyDiffRightToLeftItem.setVisible(true);
            toolBarManager.appendToGroup("merge", (IContributionItem)this.fCopyDiffRightToLeftItem);
            handlerService.registerAction((IAction)copyRightToLeft, "org.eclipse.compare.copyRightToLeft");
        }
        Action nextDiff = new Action(){

            public void run() {
                EMFCompareTextMergeViewer.this.endOfContentReached(true);
            }
        };
        Utilities.initAction((IAction)nextDiff, (ResourceBundle)this.getResourceBundle(), (String)"action.NextDiff.");
        ActionContributionItem contributionNextDiff = new ActionContributionItem((IAction)nextDiff);
        contributionNextDiff.setVisible(true);
        toolBarManager.appendToGroup("navigation", (IContributionItem)contributionNextDiff);
        Action previousDiff = new Action(){

            public void run() {
                EMFCompareTextMergeViewer.this.endOfContentReached(false);
            }
        };
        Utilities.initAction((IAction)previousDiff, (ResourceBundle)this.getResourceBundle(), (String)"action.PrevDiff.");
        ActionContributionItem contributionPreviousDiff = new ActionContributionItem((IAction)previousDiff);
        contributionPreviousDiff.setVisible(true);
        toolBarManager.appendToGroup("navigation", (IContributionItem)contributionPreviousDiff);
    }

    protected void endOfContentReached(boolean next) {
        ICompareNavigator navigator;
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && (navigator = this.getCompareConfiguration().getContainer().getNavigator()) instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    protected void navigate(boolean next) {
        ICompareNavigator navigator;
        Control control = this.getControl();
        if (control != null && !control.isDisposed() && (navigator = this.getCompareConfiguration().getContainer().getNavigator()) instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    protected ResourceBundle getResourceBundle() {
        return ResourceBundle.getBundle(BUNDLE_NAME);
    }

    protected void handleDispose(DisposeEvent event) {
        try {
            this.fExecutorService.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            EMFCompareIDEUIPlugin.getDefault().log(e);
        }
        this.fExecutorService.shutdown();
        this.getCompareConfiguration().removePropertyChangeListener((IPropertyChangeListener)this);
        this.editingDomainChange(this.getEditingDomain(), null);
        super.handleDispose(event);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UpdateModelAndRejectDiffCommand
    extends ChangeCommand
    implements ICompareCopyCommand {
        private boolean isLeft;
        private Diff difference;
        private Object value;
        private EStructuralFeature feature;
        private EObject owner;

        public UpdateModelAndRejectDiffCommand(ChangeRecorder changeRecorder, EObject owner, EStructuralFeature feature, Object value, Diff difference, boolean isLeft) {
            super(changeRecorder, (Collection)ImmutableSet.builder().add((Object)owner).addAll(UpdateModelAndRejectDiffCommand.getAffectedDiff(difference)).build());
            this.owner = owner;
            this.feature = feature;
            this.value = value;
            this.difference = difference;
            this.isLeft = isLeft;
        }

        public void doExecute() {
            this.owner.eSet(this.feature, this.value);
            for (Diff affectedDiff : UpdateModelAndRejectDiffCommand.getAffectedDiff(this.difference)) {
                affectedDiff.setState(DifferenceState.DISCARDED);
            }
        }

        private static Set<Diff> getAffectedDiff(Diff diff) {
            EList conflicts = diff.getMatch().getComparison().getConflicts();
            for (Conflict conflict : conflicts) {
                EList conflictualDifferences = conflict.getDifferences();
                if (!conflictualDifferences.contains((Object)diff)) continue;
                return ImmutableSet.copyOf((Collection)conflictualDifferences);
            }
            return ImmutableSet.of((Object)diff);
        }

        public boolean isLeftToRight() {
            return !this.isLeft;
        }
    }
}

