/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions;

import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.ui.EMFCompareRCPUIPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.GroupAction;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class GroupActionMenu
extends Action
implements IMenuCreator {
    private final StructureMergeViewerGrouper structureMergeViewerGrouper;
    private MenuManager menuManager;
    private DefaultGroupProvider defaultGroupProvider;

    public GroupActionMenu(StructureMergeViewerGrouper structureMergeViewerGrouper, MenuManager menuManager, DefaultGroupProvider defaultGroupProvider) {
        super("", 4);
        this.menuManager = menuManager;
        this.structureMergeViewerGrouper = structureMergeViewerGrouper;
        this.defaultGroupProvider = defaultGroupProvider;
        this.setToolTipText("Groups");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.rcp.ui", (String)"icons/full/toolb16/group.gif"));
        this.setMenuCreator(this);
    }

    public void createActions(IComparisonScope scope, Comparison comparison) {
        if (this.menuManager.isEmpty()) {
            GroupAction defaultAction = new GroupAction(this.defaultGroupProvider.getLabel(), this.structureMergeViewerGrouper, this.defaultGroupProvider);
            defaultAction.setChecked(true);
            this.menuManager.add((IAction)defaultAction);
            IDifferenceGroupProvider.Registry registry = EMFCompareRCPUIPlugin.getDefault().getDifferenceGroupProviderRegistry();
            boolean alreadyChecked = false;
            for (IDifferenceGroupProvider dgp : registry.getGroupProviders(scope, comparison)) {
                GroupAction action = new GroupAction(dgp.getLabel(), this.structureMergeViewerGrouper, dgp);
                this.menuManager.add((IAction)action);
                if (!dgp.defaultSelected() || alreadyChecked) continue;
                defaultAction.setChecked(false);
                action.setChecked(true);
                alreadyChecked = true;
                action.run();
            }
        }
    }

    public void dispose() {
        this.menuManager.dispose();
    }

    public Menu getMenu(Control parent) {
        return this.menuManager.createContextMenu(parent);
    }

    public Menu getMenu(Menu parent) {
        return this.menuManager.getMenu();
    }
}

